/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crash;

import android.content.Context;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.Keep;
import android.util.Log;
import com.google.android.gms.dynamic.zze;
import com.google.firebase.FirebaseApp;
import com.google.firebase.crash.internal.FirebaseCrashOptions;
import com.google.firebase.crash.internal.config.flag.Flags;
import com.google.firebase.crash.internal.zza;
import com.google.firebase.crash.internal.zzb;
import com.google.firebase.crash.internal.zzd;
import com.google.firebase.crash.internal.zzg;
import com.google.firebase.crash.internal.zzh;
import com.google.firebase.iid.zzc;

public class FirebaseCrash {
    private static final String LOG_TAG = FirebaseCrash.class.getSimpleName();
    private boolean aol;
    private zzd aUY;
    private zza aUZ;
    private static volatile FirebaseCrash aVa;

    FirebaseCrash(FirebaseApp firebaseApp, boolean bl) {
        this.aol = bl;
        Context context = firebaseApp.getApplicationContext();
        if (context == null) {
            Log.w((String)LOG_TAG, (String)"Application context is missing, disabling api");
            this.aol = false;
        }
        if (this.aol) {
            try {
                String string = firebaseApp.getOptions().getApiKey();
                String string2 = firebaseApp.getOptions().getApplicationId();
                FirebaseCrashOptions firebaseCrashOptions = new FirebaseCrashOptions(string2, string);
                zzg.zzcqp().zzbr(context);
                this.aUY = zzg.zzcqp().zzcqq();
                this.aUY.zza(zze.zzac((Object)context), firebaseCrashOptions);
                this.aUZ = new zza(context);
                this.zzcqm();
                String string3 = String.valueOf(zzg.zzcqp().toString());
                Log.i((String)LOG_TAG, (String)(string3.length() != 0 ? "FirebaseCrash reporting initialized ".concat(string3) : new String("FirebaseCrash reporting initialized ")));
            }
            catch (Exception exception) {
                Log.e((String)LOG_TAG, (String)"Failed to initialize crash reporting", (Throwable)exception);
                this.aol = false;
            }
        } else {
            Log.i((String)LOG_TAG, (String)"Crash reporting is disabled");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FirebaseCrash zzcqj() {
        if (aVa != null) return aVa;
        Class<FirebaseCrash> clazz = FirebaseCrash.class;
        synchronized (FirebaseCrash.class) {
            if (aVa != null) return aVa;
            aVa = FirebaseCrash.getInstance(FirebaseApp.getInstance());
            // ** MonitorExit[var0] (shouldn't be in output)
            return aVa;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Keep
    public static FirebaseCrash getInstance(FirebaseApp firebaseApp) {
        Flags.initialize(firebaseApp.getApplicationContext());
        boolean bl = (Boolean)Flags.aVh.get();
        FirebaseCrash firebaseCrash = new FirebaseCrash(firebaseApp, bl);
        Class<FirebaseCrash> clazz = FirebaseCrash.class;
        synchronized (FirebaseCrash.class) {
            if (aVa == null) {
                aVa = firebaseCrash;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return firebaseCrash;
        }
    }

    private zzd zzcqk() {
        return this.aUY;
    }

    private boolean isEnabled() {
        return this.aol;
    }

    public static void log(String string) {
        try {
            FirebaseCrash.zzcqj().zzrz(string);
        }
        catch (zzb zzb2) {
            Log.v((String)LOG_TAG, (String)zzb2.getMessage());
        }
    }

    public static void logcat(int n, String string, String string2) {
        try {
            FirebaseCrash.zzcqj().zze(n, string, string2);
        }
        catch (zzb zzb2) {
            Log.v((String)LOG_TAG, (String)zzb2.getMessage());
        }
    }

    public static void report(Throwable throwable) {
        try {
            FirebaseCrash.zzcqj().zzh(throwable);
        }
        catch (zzb zzb2) {
            Log.v((String)LOG_TAG, (String)zzb2.getMessage());
        }
    }

    public void zze(int n, String string, String string2) throws zzb {
        if (string2 != null) {
            if (string == null) {
                string = "";
            }
            Log.println((int)n, (String)string, (String)string2);
            this.zzrz(string2);
        }
    }

    public void zzrz(String string) throws zzb {
        if (!this.isEnabled()) {
            throw new zzb("Firebase Crash Reporting is disabled.");
        }
        zzd zzd2 = this.zzcqk();
        if (zzd2 != null && string != null) {
            try {
                zzd2.log(string);
            }
            catch (RemoteException remoteException) {
                Log.e((String)LOG_TAG, (String)"log remoting failed", (Throwable)remoteException);
            }
        }
    }

    public void zzh(Throwable throwable) throws zzb {
        if (!this.isEnabled()) {
            throw new zzb("Firebase Crash Reporting is disabled.");
        }
        zzd zzd2 = this.zzcqk();
        if (zzd2 != null && throwable != null) {
            this.aUZ.zza(false, System.currentTimeMillis());
            try {
                zzd2.zzsa(this.zzcqn());
                zzd2.zzan(zze.zzac((Object)throwable));
            }
            catch (RemoteException remoteException) {
                Log.e((String)LOG_TAG, (String)"report remoting failed", (Throwable)remoteException);
            }
        }
    }

    public void zzi(Throwable throwable) throws zzb {
        if (!this.isEnabled()) {
            throw new zzb("Firebase Crash Reporting is disabled.");
        }
        zzd zzd2 = this.zzcqk();
        if (zzd2 != null && throwable != null) {
            try {
                this.aUZ.zza(true, System.currentTimeMillis());
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                zzd2.zzsa(this.zzcqn());
                zzd2.zzao(zze.zzac((Object)throwable));
            }
            catch (RemoteException remoteException) {
                Log.e((String)LOG_TAG, (String)"report remoting failed", (Throwable)remoteException);
            }
        }
    }

    public static boolean isSingletonInitialized() {
        return aVa != null;
    }

    private static boolean zzcql() {
        long l;
        long l2 = Looper.getMainLooper().getThread().getId();
        return l2 == (l = Thread.currentThread().getId());
    }

    private void zzcqm() {
        if (!FirebaseCrash.zzcql()) {
            throw new RuntimeException("FirebaseCrash reporting may only be initialized on the main thread (preferably in your app's Application.onCreate)");
        }
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        zzh zzh2 = new zzh(uncaughtExceptionHandler, this);
        Thread.setDefaultUncaughtExceptionHandler(zzh2);
    }

    private String zzcqn() {
        return zzc.A().getId();
    }
}

