/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crash;

import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.Keep;
import android.util.Log;
import com.google.android.gms.internal.zzaib;
import com.google.firebase.FirebaseApp;
import com.google.firebase.crash.internal.FirebaseCrashOptions;
import com.google.firebase.crash.internal.zza;
import com.google.firebase.crash.internal.zzb;
import com.google.firebase.crash.internal.zzd;
import com.google.firebase.crash.internal.zze;
import com.google.firebase.crash.internal.zzf;
import com.google.firebase.iid.zzc;

public class FirebaseCrash {
    private static final String LOG_TAG = FirebaseCrash.class.getSimpleName();
    private boolean arv;
    private zzd aYn;
    private zza aYo;
    private static volatile FirebaseCrash aYp;

    FirebaseCrash(FirebaseApp firebaseApp, boolean bl) {
        this.arv = bl;
        Context context = firebaseApp.getApplicationContext();
        if (context == null) {
            Log.w((String)LOG_TAG, (String)"Application context is missing, disabling api");
            this.arv = false;
        }
        if (this.arv) {
            try {
                String string = firebaseApp.getOptions().getApiKey();
                String string2 = firebaseApp.getOptions().getApplicationId();
                FirebaseCrashOptions firebaseCrashOptions = new FirebaseCrashOptions(string2, string);
                zze.zzcqt().zzbo(context);
                this.aYn = zze.zzcqt().zzcqu();
                this.aYn.zza(com.google.android.gms.dynamic.zze.zzac((Object)context), firebaseCrashOptions);
                this.aYo = new zza(context);
                this.zzcqp();
                String string3 = String.valueOf(zze.zzcqt().toString());
                Log.i((String)LOG_TAG, (String)(string3.length() != 0 ? "FirebaseCrash reporting initialized ".concat(string3) : new String("FirebaseCrash reporting initialized ")));
            }
            catch (Exception exception) {
                String string = String.valueOf(exception.getMessage());
                Log.e((String)LOG_TAG, (String)(string.length() != 0 ? "Failed to initialize crash reporting: ".concat(string) : new String("Failed to initialize crash reporting: ")));
                this.arv = false;
            }
        } else {
            Log.i((String)LOG_TAG, (String)"Crash reporting is disabled");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FirebaseCrash zzcql() {
        if (aYp != null) return aYp;
        Class<FirebaseCrash> clazz = FirebaseCrash.class;
        synchronized (FirebaseCrash.class) {
            if (aYp != null) return aYp;
            aYp = FirebaseCrash.getInstance(FirebaseApp.getInstance());
            // ** MonitorExit[var0] (shouldn't be in output)
            return aYp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @Keep
    public static FirebaseCrash getInstance(FirebaseApp firebaseApp) {
        zzaib.initialize(firebaseApp.getApplicationContext());
        boolean bl = (Boolean)zzaib.aYz.get();
        FirebaseCrash firebaseCrash = new FirebaseCrash(firebaseApp, bl);
        Class<FirebaseCrash> clazz = FirebaseCrash.class;
        synchronized (FirebaseCrash.class) {
            if (aYp == null) {
                aYp = firebaseCrash;
                try {
                    aYp.zzcqm();
                }
                catch (zzb zzb2) {
                    Log.d((String)LOG_TAG, (String)"Cannot register Firebase Analytics listener since Firebase Crash Reporting is not enabled");
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return firebaseCrash;
        }
    }

    private void zzcqm() throws zzb {
        if (!this.isEnabled()) {
            throw new zzb("Firebase Crash Reporting is disabled.");
        }
        this.aYo.zzcqr();
    }

    private zzd zzcqn() {
        return this.aYn;
    }

    private boolean isEnabled() {
        return this.arv;
    }

    public static void log(String string) {
        try {
            FirebaseCrash.zzcql().zzry(string);
        }
        catch (zzb zzb2) {
            Log.v((String)LOG_TAG, (String)zzb2.getMessage());
        }
    }

    public static void logcat(int n, String string, String string2) {
        try {
            FirebaseCrash.zzcql().zze(n, string, string2);
        }
        catch (zzb zzb2) {
            Log.v((String)LOG_TAG, (String)zzb2.getMessage());
        }
    }

    public static void zza(String string, long l, Bundle bundle) {
        try {
            FirebaseCrash.zzcql().zzb(string, l, bundle);
        }
        catch (zzb zzb2) {
            Log.v((String)LOG_TAG, (String)zzb2.getMessage());
        }
    }

    public static void report(Throwable throwable) {
        try {
            FirebaseCrash.zzcql().zzh(throwable);
        }
        catch (zzb zzb2) {
            Log.v((String)LOG_TAG, (String)zzb2.getMessage());
        }
    }

    public void zze(int n, String string, String string2) throws zzb {
        if (string2 != null) {
            if (string == null) {
                string = "";
            }
            Log.println((int)n, (String)string, (String)string2);
            this.zzry(string2);
        }
    }

    public void zzry(String string) throws zzb {
        if (!this.isEnabled()) {
            throw new zzb("Firebase Crash Reporting is disabled.");
        }
        zzd zzd2 = this.zzcqn();
        if (zzd2 != null && string != null) {
            try {
                zzd2.log(string);
            }
            catch (RemoteException remoteException) {
                Log.e((String)LOG_TAG, (String)"log remoting failed", (Throwable)remoteException);
            }
        }
    }

    public void zzb(String string, long l, Bundle bundle) throws zzb {
        if (!this.isEnabled()) {
            throw new zzb("Firebase Crash Reporting is disabled.");
        }
        zzd zzd2 = this.zzcqn();
        if (zzd2 != null && string != null) {
            try {
                zzd2.zzb(string, l, bundle);
            }
            catch (RemoteException remoteException) {
                Log.e((String)LOG_TAG, (String)"log remoting failed", (Throwable)remoteException);
            }
        }
    }

    public void zzh(Throwable throwable) throws zzb {
        if (!this.isEnabled()) {
            throw new zzb("Firebase Crash Reporting is disabled.");
        }
        zzd zzd2 = this.zzcqn();
        if (zzd2 != null && throwable != null) {
            this.aYo.zza(false, System.currentTimeMillis());
            try {
                zzd2.zzrz(this.zzcqq());
                zzd2.zzan(com.google.android.gms.dynamic.zze.zzac((Object)throwable));
            }
            catch (RemoteException remoteException) {
                Log.e((String)LOG_TAG, (String)"report remoting failed", (Throwable)remoteException);
            }
        }
    }

    public void zzi(Throwable throwable) throws zzb {
        if (!this.isEnabled()) {
            throw new zzb("Firebase Crash Reporting is disabled.");
        }
        zzd zzd2 = this.zzcqn();
        if (zzd2 != null && throwable != null) {
            try {
                this.aYo.zza(true, System.currentTimeMillis());
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                zzd2.zzrz(this.zzcqq());
                zzd2.zzao(com.google.android.gms.dynamic.zze.zzac((Object)throwable));
            }
            catch (RemoteException remoteException) {
                Log.e((String)LOG_TAG, (String)"report remoting failed", (Throwable)remoteException);
            }
        }
    }

    private static boolean zzcqo() {
        long l;
        long l2 = Looper.getMainLooper().getThread().getId();
        return l2 == (l = Thread.currentThread().getId());
    }

    private void zzcqp() {
        if (!FirebaseCrash.zzcqo()) {
            throw new RuntimeException("FirebaseCrash reporting may only be initialized on the main thread (preferably in your app's Application.onCreate)");
        }
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        zzf zzf2 = new zzf(uncaughtExceptionHandler, this);
        Thread.setDefaultUncaughtExceptionHandler(zzf2);
    }

    private String zzcqq() {
        return zzc.C().getId();
    }
}

