/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.api.net.proxy;

import com.google.firebase.crashlytics.buildtools.api.net.proxy.ProtocolScheme;
import com.google.firebase.crashlytics.buildtools.api.net.proxy.ProxyFactory;
import com.google.firebase.crashlytics.buildtools.api.net.proxy.ProxySettings;
import java.io.IOException;

public class DefaultProxyFactory
implements ProxyFactory {
    @Override
    public ProxySettings create(ProtocolScheme scheme) throws IOException {
        String proxyHost = null;
        String proxyUser = null;
        String proxyPassword = null;
        String proxyPortString = null;
        switch (scheme) {
            case HTTP: {
                proxyHost = System.getProperty("http.proxyHost");
                proxyUser = System.getProperty("http.proxyUser");
                proxyPassword = System.getProperty("http.proxyPassword");
                proxyPortString = System.getProperty("http.proxyPort");
                break;
            }
            case HTTPS: {
                proxyHost = System.getProperty("https.proxyHost");
                proxyUser = System.getProperty("https.proxyUser");
                proxyPassword = System.getProperty("https.proxyPassword");
                proxyPortString = System.getProperty("https.proxyPort");
                break;
            }
            case Other: {
                break;
            }
        }
        Integer proxyPort = null;
        if (proxyPortString != null) {
            try {
                proxyPort = Integer.parseInt(proxyPortString);
            }
            catch (NumberFormatException e) {
                throw new IOException("Crashlytics could not read proxy port string.");
            }
        }
        return new ProxySettings(proxyHost, proxyPort, proxyUser, proxyPassword);
    }
}

