/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.ndk.internal.csym;

import com.google.common.base.Optional;
import com.google.firebase.crashlytics.buildtools.ndk.internal.SimpleSymbolNameProvider;
import com.google.firebase.crashlytics.buildtools.ndk.internal.SymbolNameProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public final class CSym {
    private final LinkedList<Range> _ranges;
    private final List<String> _files;
    private final List<String> _symbols;
    private final String _uuid;
    private final String _type;
    private final String _architecture;

    private CSym(Builder builder) {
        ArrayList builderRanges = new ArrayList(builder._ranges);
        Collections.sort(builderRanges);
        this._ranges = new LinkedList();
        HashSet<String> fileSet = new HashSet<String>();
        HashSet<Object> symbolSet = new HashSet<Object>();
        long prevOffset = -1L;
        for (Builder.BuilderRange builderRange : builderRanges) {
            Optional<String> symbol;
            if (builderRange.file != null) {
                fileSet.add(builderRange.file);
            }
            if ((symbol = builderRange.symbolNameProvider.getSymbolName()).isPresent()) {
                symbolSet.add(symbol.get());
            }
            Range range = new Range(builderRange.offset, builderRange.size, (String)symbol.orNull(), builderRange.file, builderRange.lineNumber);
            if (range.offset == prevOffset) {
                this._ranges.pollLast();
            }
            this._ranges.add(range);
            prevOffset = range.offset;
        }
        this._files = Collections.unmodifiableList(new ArrayList(fileSet));
        this._symbols = Collections.unmodifiableList(new ArrayList(symbolSet));
        this._uuid = builder._uuid;
        this._type = builder._type;
        this._architecture = builder._architecture;
    }

    public String getArchitecture() {
        return this._architecture;
    }

    public String getUUID() {
        return this._uuid;
    }

    public String getType() {
        return this._type;
    }

    public List<String> getFiles() {
        return this._files;
    }

    public List<String> getSymbols() {
        return this._symbols;
    }

    public List<Range> getRanges() {
        return this._ranges;
    }

    public static final class Builder {
        private final List<BuilderRange> _ranges = new ArrayList<BuilderRange>();
        private final String _uuid;
        private final String _type;
        private final String _architecture;
        private int insertionIndex = 0;

        public Builder(String uuid, String type, String architecture) {
            this._uuid = uuid;
            this._type = type;
            this._architecture = architecture;
        }

        public Builder addRange(long offset, long size, String symbol) {
            return this.addRange(offset, size, SimpleSymbolNameProvider.of(symbol));
        }

        public Builder addRange(long offset, long size, String symbol, String file) {
            return this.addRange(offset, size, SimpleSymbolNameProvider.of(symbol), file);
        }

        public Builder addRange(long offset, long size, String symbol, String file, long lineNumber) {
            return this.addRange(offset, size, SimpleSymbolNameProvider.of(symbol), file, lineNumber);
        }

        public Builder addRange(long offset, long size, SymbolNameProvider symbolProvider) {
            return this.addRange(offset, size, symbolProvider, null);
        }

        public Builder addRange(long offset, long size, SymbolNameProvider symbolProvider, String file) {
            return this.addRange(offset, size, symbolProvider, file, -1L);
        }

        public Builder addRange(long offset, long size, SymbolNameProvider symbolProvider, String file, long lineNumber) {
            this._ranges.add(new BuilderRange(this.insertionIndex++, offset, size, symbolProvider, file, lineNumber));
            return this;
        }

        public CSym build() {
            return new CSym(this);
        }

        static class BuilderRange
        implements Comparable<BuilderRange> {
            public final int insertionIndex;
            public final long offset;
            public final long size;
            public final SymbolNameProvider symbolNameProvider;
            public final String file;
            public final long lineNumber;

            public BuilderRange(int insertionIndex, long offset, long size, SymbolNameProvider symbolNameProvider, String file, long lineNumber) {
                this.insertionIndex = insertionIndex;
                this.offset = offset;
                this.size = size;
                this.symbolNameProvider = symbolNameProvider;
                this.file = file;
                this.lineNumber = lineNumber;
            }

            @Override
            public int compareTo(BuilderRange other) {
                int value = Long.valueOf(this.offset).compareTo(other.offset);
                return value != 0 ? value : Integer.valueOf(this.insertionIndex).compareTo(other.insertionIndex);
            }
        }
    }

    public static final class Range
    implements Comparable<Range> {
        public final long offset;
        public final long size;
        public final String symbol;
        public final String file;
        public final long lineNumber;

        public Range(long offset, long size, String symbol, String file, long lineNumber) {
            this.offset = offset;
            this.size = size;
            this.symbol = symbol;
            this.file = file;
            this.lineNumber = lineNumber;
        }

        @Override
        public int compareTo(Range other) {
            return (int)(this.offset - other.offset);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Range range = (Range)o;
            if (this.lineNumber != range.lineNumber) {
                return false;
            }
            if (this.offset != range.offset) {
                return false;
            }
            if (this.size != range.size) {
                return false;
            }
            if (this.file != null ? !this.file.equals(range.file) : range.file != null) {
                return false;
            }
            return !(this.symbol != null ? !this.symbol.equals(range.symbol) : range.symbol != null);
        }

        public int hashCode() {
            int result = (int)(this.offset ^ this.offset >>> 32);
            result = 31 * result + (int)(this.size ^ this.size >>> 32);
            result = 31 * result + (this.symbol != null ? this.symbol.hashCode() : 0);
            result = 31 * result + (this.file != null ? this.file.hashCode() : 0);
            result = 31 * result + (int)(this.lineNumber ^ this.lineNumber >>> 32);
            return result;
        }

        public String toString() {
            return "{ file:" + this.file + ", symbol:" + this.symbol + ", offset:" + this.offset + ", size:" + this.size + ", line:" + this.lineNumber + " }";
        }
    }
}

