/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.ndk.internal.csym;

import com.google.common.base.Charsets;
import com.google.firebase.crashlytics.buildtools.ndk.internal.csym.CSym;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;

public class CSymWriter {
    private static final int CSYM_VERSION = 1;
    private static final String NO_INDEX = "-1";
    private static final String HEADER_FORMAT = "code_mapping\t%d\t%s\t%s\t%s\t%d\t%d\t%d\n";

    public static void writeToOutputStream(CSym cSym, OutputStream os) throws IOException {
        CSymWriter.write(cSym, new OutputStreamWriter(os, Charsets.UTF_8));
    }

    public static void writeToTextFile(CSym cSym, File file) throws IOException {
        try (FileOutputStream fileOs = null;){
            fileOs = new FileOutputStream(file);
            CSymWriter.writeToOutputStream(cSym, fileOs);
        }
    }

    private static void write(CSym cSym, Writer writer) throws IOException {
        BufferedWriter out = new BufferedWriter(writer);
        CSymWriter.writeHeader(cSym, out);
        CSymWriter.writeFiles(cSym, out);
        CSymWriter.writeSymbols(cSym, out);
        CSymWriter.writeRanges(cSym, out);
        out.flush();
    }

    private static void writeHeader(CSym cSym, BufferedWriter out) throws IOException {
        out.append(String.format(HEADER_FORMAT, 1, cSym.getType(), cSym.getUUID(), cSym.getArchitecture(), cSym.getFiles().size(), cSym.getSymbols().size(), cSym.getRanges().size()));
    }

    private static void writeFiles(CSym cSym, BufferedWriter out) throws IOException {
        List<String> files = cSym.getFiles();
        out.append("files\t" + files.size() + "\n");
        for (String file : files) {
            out.append(file + "\n");
        }
    }

    private static void writeSymbols(CSym cSym, BufferedWriter out) throws IOException {
        List<String> symbols = cSym.getSymbols();
        out.append("symbols\t" + symbols.size() + "\n");
        for (String symbol : symbols) {
            out.append(symbol + "\n");
        }
    }

    private static void writeRanges(CSym cSym, BufferedWriter out) throws IOException {
        int i;
        List<String> files = cSym.getFiles();
        List<String> symbols = cSym.getSymbols();
        List<CSym.Range> ranges = cSym.getRanges();
        HashMap<String, String> fileMap = new HashMap<String, String>();
        HashMap<String, String> symbolMap = new HashMap<String, String>();
        for (i = 0; i < symbols.size(); ++i) {
            symbolMap.put(symbols.get(i), String.valueOf(i));
        }
        for (i = 0; i < files.size(); ++i) {
            fileMap.put(files.get(i), String.valueOf(i));
        }
        out.append("ranges\t" + ranges.size() + "\n");
        for (CSym.Range range : ranges) {
            out.append(range.offset + "\t" + range.size + "\t" + CSymWriter.nullSafeIndex((String)symbolMap.get(range.symbol)) + "\t" + CSymWriter.nullSafeIndex((String)fileMap.get(range.file)) + "\t" + range.lineNumber + "\n");
        }
    }

    private static String nullSafeIndex(String indexString) {
        return indexString != null ? indexString : NO_INDEX;
    }
}

