/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.utils.io;

import com.google.firebase.crashlytics.buildtools.utils.io.SeekableInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class RandomAccessFileInputStream
extends SeekableInputStream {
    private static final int BUFFER_SIZE = 8192;
    private RandomAccessFile _file;
    private byte[] _buffer;
    private long _filePointer;
    private int _bufferPos = 0;
    private int _bufferCount = 0;

    public RandomAccessFileInputStream(File file) throws IOException {
        this._file = new RandomAccessFile(file, "r");
        this._buffer = new byte[8192];
        this._filePointer = this._file.getFilePointer();
    }

    @Override
    public void seek(long offset) throws IOException {
        this.validateOpen();
        if (offset < 0L) {
            throw new IOException("Seek offset must be greater than 0");
        }
        long beginOffset = this._filePointer - (long)this._bufferCount;
        if (offset >= beginOffset && offset < this._filePointer) {
            this._bufferPos = (int)(offset - beginOffset);
            return;
        }
        this._file.seek(offset);
        this._bufferCount = 0;
        this._filePointer = this._file.getFilePointer();
    }

    @Override
    public long getCurrentOffset() throws IOException {
        this.validateOpen();
        int remaining = this._bufferCount - this._bufferPos;
        return this._filePointer - (long)Math.max(remaining, 0);
    }

    @Override
    public void readFully(byte[] buffer, int offset, int length) throws IOException {
        int bytesRead;
        this.validateOpen();
        int totalBytes = 0;
        do {
            if ((bytesRead = this.read(buffer, offset + totalBytes, length - totalBytes)) >= 0) continue;
            throw new EOFException();
        } while ((totalBytes += bytesRead) < length);
    }

    @Override
    public int read() throws IOException {
        this.validateOpen();
        if (this._bufferPos >= this._bufferCount) {
            this.fillBuffer();
            if (this._bufferPos >= this._bufferCount) {
                return -1;
            }
        }
        return this._buffer[this._bufferPos++] & 0xFF;
    }

    @Override
    public int read(byte[] bytes) throws IOException {
        this.validateOpen();
        return this.read(bytes, 0, bytes.length);
    }

    @Override
    public int read(byte[] bytes, int off, int len) throws IOException {
        int bytesRead;
        if (off < 0 || off > bytes.length || len < 0 || off + len > bytes.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return len;
        }
        this.validateOpen();
        int totalBytes = 0;
        do {
            if ((bytesRead = this.readOnce(bytes, off + totalBytes, len - totalBytes)) > 0) continue;
            return totalBytes == 0 ? bytesRead : totalBytes;
        } while ((totalBytes += bytesRead) < len);
        return totalBytes;
    }

    @Override
    public long skip(long n) throws IOException {
        long fileLen;
        if (n <= 0L) {
            return 0L;
        }
        this.validateOpen();
        int remaining = this._bufferCount - this._bufferPos;
        if (n <= (long)remaining) {
            this._bufferPos = (int)((long)this._bufferPos + n);
            return n;
        }
        long pos = this.getCurrentOffset();
        long newPos = pos + n;
        if (newPos > (fileLen = this._file.length())) {
            newPos = fileLen;
        }
        this.seek(newPos);
        return newPos - pos;
    }

    @Override
    public void close() throws IOException {
        this._file.close();
        this._file = null;
        this._buffer = null;
    }

    private int readOnce(byte[] bytes, int offset, int len) throws IOException {
        int remaining = this._bufferCount - this._bufferPos;
        if (remaining <= 0) {
            if (len >= this._buffer.length) {
                return this.readFromFile(bytes, offset, len);
            }
            this.fillBuffer();
            remaining = this._bufferCount - this._bufferPos;
            if (remaining <= 0) {
                return -1;
            }
        }
        int numBytesRead = remaining < len ? remaining : len;
        System.arraycopy(this._buffer, this._bufferPos, bytes, offset, numBytesRead);
        this._bufferPos += numBytesRead;
        return numBytesRead;
    }

    private void fillBuffer() throws IOException {
        this._bufferPos = 0;
        this._bufferCount = 0;
        int numRead = this.readFromFile(this._buffer, 0, this._buffer.length);
        if (numRead > 0) {
            this._bufferCount = numRead;
        }
    }

    private int readFromFile(byte[] bytes, int offset, int len) throws IOException {
        int bytesRead = this._file.read(bytes, offset, len);
        this._filePointer = this._file.getFilePointer();
        return bytesRead;
    }

    private void validateOpen() throws IOException {
        if (this._file == null || this._buffer == null) {
            throw new IOException("Stream closed.");
        }
    }
}

