/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase;

import com.google.common.io.MoreFiles;
import com.google.firebase.ClassNameConstantsGenerator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public abstract class AsmStringGeneratorTask
extends DefaultTask {
    private static final String TEMPLATE_INPUT_FILE = "AsmString.java.template";

    @OutputDirectory
    public abstract DirectoryProperty getGeneratedJavaOutputDir();

    @TaskAction
    public void applyTemplate() throws IOException, NoSuchMethodException {
        Path generatedJavaOutputDir = ((Directory)this.getGeneratedJavaOutputDir().get()).getAsFile().toPath();
        FileUtils.deleteDirectory((File)((Directory)this.getGeneratedJavaOutputDir().get()).getAsFile());
        File generatedJavaOutputFile = generatedJavaOutputDir.resolve(MoreFiles.getNameWithoutExtension((Path)Paths.get(TEMPLATE_INPUT_FILE, new String[0]))).toFile();
        String templateFileContent = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(TEMPLATE_INPUT_FILE), (Charset)StandardCharsets.UTF_8);
        FileUtils.writeStringToFile((File)generatedJavaOutputFile, (String)new ClassNameConstantsGenerator().replacePlaceHolders(templateFileContent));
    }
}

