/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.gradle;

import com.android.build.api.variant.Variant;
import com.google.firebase.crashlytics.buildtools.gradle.AppIdFetcher;
import com.google.firebase.crashlytics.buildtools.gradle.extensions.StringExtensionsKt;
import com.google.gms.googleservices.GoogleServicesTask;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.UnknownTaskException;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.kotlin.dsl.TaskContainerExtensionsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/google/firebase/crashlytics/buildtools/gradle/AppIdFetcher;", "", "()V", "getGoogleServicesAppId", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/RegularFile;", "project", "Lorg/gradle/api/Project;", "variant", "Lcom/android/build/api/variant/Variant;", "crashlytics-gradle"})
@SourceDebugExtension(value={"SMAP\nAppIdFetcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppIdFetcher.kt\ncom/google/firebase/crashlytics/buildtools/gradle/AppIdFetcher\n+ 2 TaskContainerExtensions.kt\norg/gradle/kotlin/dsl/TaskContainerExtensionsKt\n*L\n1#1,52:1\n212#2:53\n*S KotlinDebug\n*F\n+ 1 AppIdFetcher.kt\ncom/google/firebase/crashlytics/buildtools/gradle/AppIdFetcher\n*L\n35#1:53\n*E\n"})
public final class AppIdFetcher {
    @NotNull
    public static final AppIdFetcher INSTANCE = new AppIdFetcher();

    private AppIdFetcher() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Provider<RegularFile> getGoogleServicesAppId(@NotNull Project project, @NotNull Variant variant) {
        Provider provider2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        try {
            void $this$named$iv;
            TaskContainer taskContainer = project.getTasks();
            Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
            TaskCollection taskCollection = (TaskCollection)taskContainer;
            String name$iv = "process" + StringExtensionsKt.capitalized(variant.getName()) + "GoogleServices";
            boolean $i$f$named = false;
            provider2 = TaskContainerExtensionsKt.named((TaskCollection)$this$named$iv, (String)name$iv, (KClass)Reflection.getOrCreateKotlinClass(GoogleServicesTask.class)).flatMap(arg_0 -> AppIdFetcher.getGoogleServicesAppId$lambda$0(getGoogleServicesAppId.1.INSTANCE, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"{\n      project.tasks\n  \u2026        }\n        }\n    }");
        }
        catch (NoClassDefFoundError ex) {
            throw new GradleException("Google-Services plugin not found.");
        }
        catch (UnknownTaskException ex) {
            throw new GradleException("Google-Services plugin not configured properly.");
        }
        return provider2;
    }

    private static final Provider getGoogleServicesAppId$lambda$0(Function1 $tmp0, Object in) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Provider)$tmp0.invoke(in);
    }
}

