/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal;

import android.os.Build;
import android.os.Looper;
import com.google.firebase.crashlytics.internal.CrashlyticsPreconditions;
import com.google.firebase.crashlytics.internal.Logger;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u001bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0007J\b\u0010\u0011\u001a\u00020\u0010H\u0007J\b\u0010\u0012\u001a\u00020\u0010H\u0007J$\u0010\u0013\u001a\u00020\u00102\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0015H\u0002J\b\u0010\u0018\u001a\u00020\u0016H\u0002J\b\u0010\u0019\u001a\u00020\u0016H\u0002J\b\u0010\u001a\u001a\u00020\u0016H\u0002R$\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lcom/google/firebase/crashlytics/internal/CrashlyticsPreconditions;", "", "()V", "strictLevel", "Lcom/google/firebase/crashlytics/internal/CrashlyticsPreconditions$StrictLevel;", "getStrictLevel$annotations", "getStrictLevel", "()Lcom/google/firebase/crashlytics/internal/CrashlyticsPreconditions$StrictLevel;", "setStrictLevel", "(Lcom/google/firebase/crashlytics/internal/CrashlyticsPreconditions$StrictLevel;)V", "threadName", "", "kotlin.jvm.PlatformType", "getThreadName", "()Ljava/lang/String;", "checkBackgroundThread", "", "checkBlockingThread", "checkMainThread", "checkThread", "isCorrectThread", "Lkotlin/Function0;", "", "failureMessage", "isBackgroundThread", "isBlockingThread", "isMainThread", "StrictLevel", "com.google.firebase-firebase-crashlytics"})
public final class CrashlyticsPreconditions {
    @NotNull
    public static final CrashlyticsPreconditions INSTANCE = new CrashlyticsPreconditions();
    @NotNull
    private static StrictLevel strictLevel = StrictLevel.NONE;

    private CrashlyticsPreconditions() {
    }

    private final String getThreadName() {
        return Thread.currentThread().getName();
    }

    @NotNull
    public static final StrictLevel getStrictLevel() {
        return strictLevel;
    }

    public static final void setStrictLevel(@NotNull StrictLevel strictLevel) {
        Intrinsics.checkNotNullParameter((Object)strictLevel, (String)"<set-?>");
        CrashlyticsPreconditions.strictLevel = strictLevel;
    }

    @JvmStatic
    public static /* synthetic */ void getStrictLevel$annotations() {
    }

    @JvmStatic
    public static final void checkMainThread() {
        INSTANCE.checkThread((Function0<Boolean>)((Function0)new Function0<Boolean>((Object)INSTANCE){

            @NotNull
            public final Boolean invoke() {
                return CrashlyticsPreconditions.access$isMainThread((CrashlyticsPreconditions)this.receiver);
            }
        }), (Function0<String>)((Function0)checkMainThread.2.INSTANCE));
    }

    @JvmStatic
    public static final void checkBlockingThread() {
        INSTANCE.checkThread((Function0<Boolean>)((Function0)new Function0<Boolean>((Object)INSTANCE){

            @NotNull
            public final Boolean invoke() {
                return CrashlyticsPreconditions.access$isBlockingThread((CrashlyticsPreconditions)this.receiver);
            }
        }), (Function0<String>)((Function0)checkBlockingThread.2.INSTANCE));
    }

    @JvmStatic
    public static final void checkBackgroundThread() {
        INSTANCE.checkThread((Function0<Boolean>)((Function0)new Function0<Boolean>((Object)INSTANCE){

            @NotNull
            public final Boolean invoke() {
                return CrashlyticsPreconditions.access$isBackgroundThread((CrashlyticsPreconditions)this.receiver);
            }
        }), (Function0<String>)((Function0)checkBackgroundThread.2.INSTANCE));
    }

    private final boolean isMainThread() {
        return Build.VERSION.SDK_INT >= 23 ? Looper.getMainLooper().isCurrentThread() : Intrinsics.areEqual((Object)Looper.getMainLooper(), (Object)Looper.myLooper());
    }

    private final boolean isBlockingThread() {
        String string = this.getThreadName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"threadName");
        return StringsKt.contains$default((CharSequence)string, (CharSequence)"Firebase Blocking Thread #", (boolean)false, (int)2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isBackgroundThread() {
        String string = this.getThreadName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"threadName");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"Firebase Background Thread #", (boolean)false, (int)2, null)) return true;
        String string2 = this.getThreadName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"threadName");
        if (!StringsKt.contains$default((CharSequence)string2, (CharSequence)"Crashlytics Exception Handler", (boolean)false, (int)2, null)) return false;
        return true;
    }

    private final void checkThread(Function0<Boolean> isCorrectThread, Function0<String> failureMessage) {
        if (strictLevel.getLevel() >= StrictLevel.WARN.getLevel() && !((Boolean)isCorrectThread.invoke()).booleanValue()) {
            boolean bl;
            Logger.getLogger().w((String)failureMessage.invoke());
            boolean bl2 = bl = strictLevel.getLevel() < StrictLevel.ASSERT.getLevel();
            if (_Assertions.ENABLED && !bl) {
                Object object = failureMessage.invoke();
                throw new AssertionError(object);
            }
            if (!(strictLevel.getLevel() < StrictLevel.THROW.getLevel())) {
                Object object = failureMessage.invoke();
                throw new IllegalStateException(object.toString());
            }
        }
    }

    public static final /* synthetic */ boolean access$isMainThread(CrashlyticsPreconditions $this) {
        return $this.isMainThread();
    }

    public static final /* synthetic */ String access$getThreadName(CrashlyticsPreconditions $this) {
        return $this.getThreadName();
    }

    public static final /* synthetic */ boolean access$isBlockingThread(CrashlyticsPreconditions $this) {
        return $this.isBlockingThread();
    }

    public static final /* synthetic */ boolean access$isBackgroundThread(CrashlyticsPreconditions $this) {
        return $this.isBackgroundThread();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B\u000f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lcom/google/firebase/crashlytics/internal/CrashlyticsPreconditions$StrictLevel;", "", "", "level", "", "(Ljava/lang/String;II)V", "getLevel", "()I", "NONE", "WARN", "THROW", "ASSERT", "com.google.firebase-firebase-crashlytics"})
    public static final class StrictLevel
    extends Enum<StrictLevel>
    implements Comparable<StrictLevel> {
        private final int level;
        public static final /* enum */ StrictLevel NONE = new StrictLevel(0);
        public static final /* enum */ StrictLevel WARN = new StrictLevel(1);
        public static final /* enum */ StrictLevel THROW = new StrictLevel(2);
        public static final /* enum */ StrictLevel ASSERT = new StrictLevel(3);
        private static final /* synthetic */ StrictLevel[] $VALUES;

        private StrictLevel(int level) {
            this.level = level;
        }

        public final int getLevel() {
            return this.level;
        }

        public static StrictLevel[] values() {
            return (StrictLevel[])$VALUES.clone();
        }

        public static StrictLevel valueOf(String value) {
            return Enum.valueOf(StrictLevel.class, value);
        }

        static {
            $VALUES = strictLevelArray = new StrictLevel[]{StrictLevel.NONE, StrictLevel.WARN, StrictLevel.THROW, StrictLevel.ASSERT};
        }
    }
}

