/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.settings;

import android.text.TextUtils;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.common.CrashlyticsCore;
import com.google.firebase.crashlytics.internal.network.HttpGetRequest;
import com.google.firebase.crashlytics.internal.network.HttpRequestFactory;
import com.google.firebase.crashlytics.internal.network.HttpResponse;
import com.google.firebase.crashlytics.internal.settings.SettingsRequest;
import com.google.firebase.crashlytics.internal.settings.SettingsSpiCall;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

class DefaultSettingsSpiCall
implements SettingsSpiCall {
    static final String HEADER_GOOGLE_APP_ID = "X-CRASHLYTICS-GOOGLE-APP-ID";
    static final String HEADER_CLIENT_TYPE = "X-CRASHLYTICS-API-CLIENT-TYPE";
    static final String HEADER_CLIENT_VERSION = "X-CRASHLYTICS-API-CLIENT-VERSION";
    static final String HEADER_USER_AGENT = "User-Agent";
    static final String HEADER_ACCEPT = "Accept";
    static final String CRASHLYTICS_USER_AGENT = "Crashlytics Android SDK/";
    static final String ACCEPT_JSON_VALUE = "application/json";
    static final String ANDROID_CLIENT_TYPE = "android";
    static final String BUILD_VERSION_PARAM = "build_version";
    static final String DISPLAY_VERSION_PARAM = "display_version";
    static final String INSTANCE_PARAM = "instance";
    static final String SOURCE_PARAM = "source";
    static final String HEADER_DEVICE_MODEL = "X-CRASHLYTICS-DEVICE-MODEL";
    static final String HEADER_OS_BUILD_VERSION = "X-CRASHLYTICS-OS-BUILD-VERSION";
    static final String HEADER_OS_DISPLAY_VERSION = "X-CRASHLYTICS-OS-DISPLAY-VERSION";
    static final String HEADER_INSTALLATION_ID = "X-CRASHLYTICS-INSTALLATION-ID";
    private final String url;
    private final HttpRequestFactory requestFactory;
    private final Logger logger;

    public DefaultSettingsSpiCall(String url, HttpRequestFactory requestFactory) {
        this(url, requestFactory, Logger.getLogger());
    }

    DefaultSettingsSpiCall(String url, HttpRequestFactory requestFactory, Logger logger) {
        if (url == null) {
            throw new IllegalArgumentException("url must not be null.");
        }
        this.logger = logger;
        this.requestFactory = requestFactory;
        this.url = url;
    }

    protected HttpGetRequest createHttpGetRequest(Map<String, String> queryParams) {
        HttpGetRequest httpRequest = this.requestFactory.buildHttpGetRequest(this.url, queryParams);
        return httpRequest.header(HEADER_USER_AGENT, CRASHLYTICS_USER_AGENT + CrashlyticsCore.getVersion()).header("X-CRASHLYTICS-DEVELOPER-TOKEN", "470fa2b4ae81cd56ecbcda9735803434cec591fa");
    }

    @Override
    public JSONObject invoke(SettingsRequest requestData, boolean dataCollectionToken) {
        if (!dataCollectionToken) {
            throw new RuntimeException("An invalid data collection token was used.");
        }
        JSONObject toReturn = null;
        try {
            Map<String, String> queryParams = this.getQueryParamsFor(requestData);
            HttpGetRequest httpRequest = this.createHttpGetRequest(queryParams);
            httpRequest = this.applyHeadersTo(httpRequest, requestData);
            this.logger.d("Requesting settings from " + this.url);
            this.logger.v("Settings query params were: " + queryParams);
            HttpResponse httpResponse = httpRequest.execute();
            toReturn = this.handleResponse(httpResponse);
        }
        catch (IOException e) {
            this.logger.e("Settings request failed.", e);
            toReturn = null;
        }
        return toReturn;
    }

    JSONObject handleResponse(HttpResponse httpResponse) {
        JSONObject toReturn;
        int statusCode = httpResponse.code();
        this.logger.v("Settings response code was: " + statusCode);
        if (this.requestWasSuccessful(statusCode)) {
            toReturn = this.getJsonObjectFrom(httpResponse.body());
        } else {
            this.logger.e("Settings request failed; (status: " + statusCode + ") from " + this.url);
            toReturn = null;
        }
        return toReturn;
    }

    boolean requestWasSuccessful(int httpStatusCode) {
        return httpStatusCode == 200 || httpStatusCode == 201 || httpStatusCode == 202 || httpStatusCode == 203;
    }

    private JSONObject getJsonObjectFrom(String httpRequestBody) {
        try {
            return new JSONObject(httpRequestBody);
        }
        catch (Exception e) {
            this.logger.w("Failed to parse settings JSON from " + this.url, e);
            this.logger.w("Settings response " + httpRequestBody);
            return null;
        }
    }

    private Map<String, String> getQueryParamsFor(SettingsRequest requestData) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put(BUILD_VERSION_PARAM, requestData.buildVersion);
        queryParams.put(DISPLAY_VERSION_PARAM, requestData.displayVersion);
        queryParams.put(SOURCE_PARAM, Integer.toString(requestData.source));
        String instanceId = requestData.instanceId;
        if (!TextUtils.isEmpty((CharSequence)instanceId)) {
            queryParams.put(INSTANCE_PARAM, instanceId);
        }
        return queryParams;
    }

    private HttpGetRequest applyHeadersTo(HttpGetRequest request, SettingsRequest requestData) {
        this.applyNonNullHeader(request, HEADER_GOOGLE_APP_ID, requestData.googleAppId);
        this.applyNonNullHeader(request, HEADER_CLIENT_TYPE, ANDROID_CLIENT_TYPE);
        this.applyNonNullHeader(request, HEADER_CLIENT_VERSION, CrashlyticsCore.getVersion());
        this.applyNonNullHeader(request, HEADER_ACCEPT, ACCEPT_JSON_VALUE);
        this.applyNonNullHeader(request, HEADER_DEVICE_MODEL, requestData.deviceModel);
        this.applyNonNullHeader(request, HEADER_OS_BUILD_VERSION, requestData.osBuildVersion);
        this.applyNonNullHeader(request, HEADER_OS_DISPLAY_VERSION, requestData.osDisplayVersion);
        this.applyNonNullHeader(request, HEADER_INSTALLATION_ID, requestData.installIdProvider.getInstallIds().getCrashlyticsInstallId());
        return request;
    }

    private void applyNonNullHeader(HttpGetRequest request, String key, String value) {
        if (value != null) {
            request.header(key, value);
        }
    }
}

