/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.metadata;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.common.CommonUtils;
import com.google.firebase.crashlytics.internal.metadata.RolloutAssignment;
import com.google.firebase.crashlytics.internal.persistence.FileStore;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class MetaDataStore {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final String KEY_USER_ID = "userId";
    private final FileStore fileStore;

    public MetaDataStore(FileStore fileStore) {
        this.fileStore = fileStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeUserData(String sessionId, String userId) {
        File f = this.getUserDataFileForSession(sessionId);
        BufferedWriter writer = null;
        try {
            String userIdJson = MetaDataStore.userIdToJson(userId);
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), UTF_8));
            writer.write(userIdJson);
            ((Writer)writer).flush();
            CommonUtils.closeOrLog(writer, "Failed to close user metadata file.");
        }
        catch (Exception e) {
            Logger.getLogger().w("Error serializing user metadata.", e);
        }
        finally {
            CommonUtils.closeOrLog(writer, "Failed to close user metadata file.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String readUserId(String sessionId) {
        File f = this.getUserDataFileForSession(sessionId);
        if (!f.exists() || f.length() == 0L) {
            Logger.getLogger().d("No userId set for session " + sessionId);
            MetaDataStore.safeDeleteCorruptFile(f);
            return null;
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(f);
            String userId = this.jsonToUserId(CommonUtils.streamToString(is));
            Logger.getLogger().d("Loaded userId " + userId + " for session " + sessionId);
            String string = userId;
            return string;
        }
        catch (Exception e) {
            Logger.getLogger().w("Error deserializing user metadata.", e);
            MetaDataStore.safeDeleteCorruptFile(f);
        }
        finally {
            CommonUtils.closeOrLog(is, "Failed to close user metadata file.");
        }
        return null;
    }

    public void writeKeyData(String sessionId, Map<String, String> keyData) {
        this.writeKeyData(sessionId, keyData, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeKeyData(String sessionId, Map<String, String> keyData, boolean isInternal) {
        File f = isInternal ? this.getInternalKeysFileForSession(sessionId) : this.getKeysFileForSession(sessionId);
        BufferedWriter writer = null;
        try {
            String keyDataString = MetaDataStore.keysDataToJson(keyData);
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), UTF_8));
            writer.write(keyDataString);
            ((Writer)writer).flush();
            CommonUtils.closeOrLog(writer, "Failed to close key/value metadata file.");
        }
        catch (Exception e) {
            Logger.getLogger().w("Error serializing key/value metadata.", e);
            MetaDataStore.safeDeleteCorruptFile(f);
        }
        finally {
            CommonUtils.closeOrLog(writer, "Failed to close key/value metadata file.");
        }
    }

    public Map<String, String> readKeyData(String sessionId) {
        return this.readKeyData(sessionId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, String> readKeyData(String sessionId, boolean isInternal) {
        File f;
        File file = f = isInternal ? this.getInternalKeysFileForSession(sessionId) : this.getKeysFileForSession(sessionId);
        if (!f.exists() || f.length() == 0L) {
            MetaDataStore.safeDeleteCorruptFile(f, "The file has a length of zero for session: " + sessionId);
            return Collections.emptyMap();
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(f);
            Map<String, String> map = MetaDataStore.jsonToKeysData(CommonUtils.streamToString(is));
            return map;
        }
        catch (Exception e) {
            Logger.getLogger().w("Error deserializing user metadata.", e);
            MetaDataStore.safeDeleteCorruptFile(f);
        }
        finally {
            CommonUtils.closeOrLog(is, "Failed to close user metadata file.");
        }
        return Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RolloutAssignment> readRolloutsState(String sessionId) {
        File f = this.getRolloutsStateForSession(sessionId);
        if (!f.exists() || f.length() == 0L) {
            MetaDataStore.safeDeleteCorruptFile(f, "The file has a length of zero for session: " + sessionId);
            return Collections.emptyList();
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(f);
            List<RolloutAssignment> rolloutsState = MetaDataStore.jsonToRolloutsState(CommonUtils.streamToString(is));
            Logger.getLogger().d("Loaded rollouts state:\n" + rolloutsState + "\nfor session " + sessionId);
            List<RolloutAssignment> list = rolloutsState;
            return list;
        }
        catch (Exception e) {
            Logger.getLogger().w("Error deserializing rollouts state.", e);
            MetaDataStore.safeDeleteCorruptFile(f);
        }
        finally {
            CommonUtils.closeOrLog(is, "Failed to close rollouts state file.");
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeRolloutState(String sessionId, List<RolloutAssignment> rolloutsState) {
        File f = this.getRolloutsStateForSession(sessionId);
        if (rolloutsState.isEmpty()) {
            MetaDataStore.safeDeleteCorruptFile(f, "Rollout state is empty for session: " + sessionId);
            return;
        }
        BufferedWriter writer = null;
        try {
            String rolloutsStateString = MetaDataStore.rolloutsStateToJson(rolloutsState);
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), UTF_8));
            writer.write(rolloutsStateString);
            ((Writer)writer).flush();
            CommonUtils.closeOrLog(writer, "Failed to close rollouts state file.");
        }
        catch (Exception e) {
            Logger.getLogger().w("Error serializing rollouts state.", e);
            MetaDataStore.safeDeleteCorruptFile(f);
        }
        finally {
            CommonUtils.closeOrLog(writer, "Failed to close rollouts state file.");
        }
    }

    @NonNull
    public File getUserDataFileForSession(String sessionId) {
        return this.fileStore.getSessionFile(sessionId, "user-data");
    }

    @NonNull
    public File getKeysFileForSession(String sessionId) {
        return this.fileStore.getSessionFile(sessionId, "keys");
    }

    @NonNull
    public File getInternalKeysFileForSession(String sessionId) {
        return this.fileStore.getSessionFile(sessionId, "internal-keys");
    }

    @NonNull
    public File getRolloutsStateForSession(String sessionId) {
        return this.fileStore.getSessionFile(sessionId, "rollouts-state");
    }

    @Nullable
    private String jsonToUserId(String json) throws JSONException {
        JSONObject dataObj = new JSONObject(json);
        return MetaDataStore.valueOrNull(dataObj, KEY_USER_ID);
    }

    private static String userIdToJson(final String userId) throws JSONException {
        return new JSONObject(){
            {
                this.put(MetaDataStore.KEY_USER_ID, userId);
            }
        }.toString();
    }

    private static Map<String, String> jsonToKeysData(String json) throws JSONException {
        JSONObject dataObj = new JSONObject(json);
        HashMap<String, String> keyData = new HashMap<String, String>();
        Iterator keyIter = dataObj.keys();
        while (keyIter.hasNext()) {
            String key = (String)keyIter.next();
            keyData.put(key, MetaDataStore.valueOrNull(dataObj, key));
        }
        return keyData;
    }

    private static String keysDataToJson(Map<String, String> keyData) {
        return new JSONObject(keyData).toString();
    }

    private static List<RolloutAssignment> jsonToRolloutsState(String json) throws JSONException {
        JSONObject object = new JSONObject(json);
        JSONArray dataArray = object.getJSONArray("rolloutsState");
        ArrayList<RolloutAssignment> rolloutsState = new ArrayList<RolloutAssignment>();
        for (int i = 0; i < dataArray.length(); ++i) {
            String dataObjectString = dataArray.getString(i);
            try {
                RolloutAssignment rolloutAssignment = RolloutAssignment.create(dataObjectString);
                rolloutsState.add(rolloutAssignment);
                continue;
            }
            catch (Exception e) {
                Logger.getLogger().w("Failed de-serializing rollouts state. " + dataObjectString, e);
            }
        }
        return rolloutsState;
    }

    private static String rolloutsStateToJson(List<RolloutAssignment> rolloutsState) {
        HashMap<String, JSONArray> jsonObject = new HashMap<String, JSONArray>();
        JSONArray rolloutsStateJsonArray = new JSONArray();
        for (int i = 0; i < rolloutsState.size(); ++i) {
            String rolloutAssignmentJson = RolloutAssignment.ROLLOUT_ASSIGNMENT_JSON_ENCODER.encode((Object)rolloutsState.get(i));
            try {
                rolloutsStateJsonArray.put((Object)new JSONObject(rolloutAssignmentJson));
                continue;
            }
            catch (JSONException e) {
                Logger.getLogger().w("Exception parsing rollout assignment!", e);
            }
        }
        jsonObject.put("rolloutsState", rolloutsStateJsonArray);
        return new JSONObject(jsonObject).toString();
    }

    private static String valueOrNull(JSONObject json, String key) {
        return !json.isNull(key) ? json.optString(key, null) : null;
    }

    private static void safeDeleteCorruptFile(File file) {
        if (file.exists() && file.delete()) {
            Logger.getLogger().i("Deleted corrupt file: " + file.getAbsolutePath());
        }
    }

    private static void safeDeleteCorruptFile(File file, String reason) {
        if (file.exists() && file.delete()) {
            Logger.getLogger().i(String.format("Deleted corrupt file: %s\nReason: %s", file.getAbsolutePath(), reason));
        }
    }
}

