/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.collection;

import com.google.firebase.database.collection.LLRBNode;
import com.google.firebase.database.collection.LLRBValueNode;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class ImmutableSortedMapIterator<K, V>
implements Iterator<Map.Entry<K, V>> {
    private final ArrayDeque<LLRBValueNode<K, V>> nodeStack = new ArrayDeque();
    private final boolean isReverse;

    ImmutableSortedMapIterator(LLRBNode<K, V> root, K startKey, Comparator<K> comparator, boolean isReverse) {
        this.isReverse = isReverse;
        LLRBNode<K, V> node = root;
        while (!node.isEmpty()) {
            int cmp = startKey != null ? (isReverse ? comparator.compare(startKey, node.getKey()) : comparator.compare(node.getKey(), startKey)) : 1;
            if (cmp < 0) {
                if (isReverse) {
                    node = node.getLeft();
                    continue;
                }
                node = node.getRight();
                continue;
            }
            if (cmp == 0) {
                this.nodeStack.push((LLRBValueNode)node);
                break;
            }
            this.nodeStack.push((LLRBValueNode)node);
            if (isReverse) {
                node = node.getRight();
                continue;
            }
            node = node.getLeft();
        }
    }

    @Override
    public boolean hasNext() {
        return this.nodeStack.size() > 0;
    }

    @Override
    public Map.Entry<K, V> next() {
        try {
            LLRBValueNode<K, V> node = this.nodeStack.pop();
            AbstractMap.SimpleEntry<K, V> entry = new AbstractMap.SimpleEntry<K, V>(node.getKey(), node.getValue());
            if (this.isReverse) {
                LLRBNode<K, V> next = node.getLeft();
                while (!next.isEmpty()) {
                    this.nodeStack.push((LLRBValueNode)next);
                    next = next.getRight();
                }
            } else {
                LLRBNode<K, V> next = node.getRight();
                while (!next.isEmpty()) {
                    this.nodeStack.push((LLRBValueNode)next);
                    next = next.getLeft();
                }
            }
            return entry;
        }
        catch (EmptyStackException e) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove called on immutable collection");
    }
}

