/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.act;
import com.google.android.gms.internal.acv;
import com.google.android.gms.internal.acw;
import com.google.android.gms.internal.acx;
import com.google.android.gms.internal.acy;
import com.google.android.gms.internal.acz;
import com.google.android.gms.internal.ada;
import com.google.android.gms.internal.adc;
import com.google.android.gms.internal.add;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public final class acu {
    private static final AtomicInteger zzclG = new AtomicInteger(0);
    private static final Charset zzclH = Charset.forName("UTF-8");
    private volatile int zzclI = acx.zzclS;
    private volatile Socket socket = null;
    private acy zzclJ = null;
    private final URI zzclK;
    private final adc zzclL;
    private final add zzclM;
    private final ada zzclN;
    private final int zzaBE = zzclG.incrementAndGet();
    private final Thread zzclO = zzclP.newThread(new acw(this));
    private static ThreadFactory zzclP = Executors.defaultThreadFactory();
    private static act zzclQ = new acv();

    static ThreadFactory getThreadFactory() {
        return zzclP;
    }

    static act zzJE() {
        return zzclQ;
    }

    public static void zza(ThreadFactory threadFactory, act act2) {
        zzclP = threadFactory;
        zzclQ = act2;
    }

    public acu(URI uRI, String string, Map<String, String> map) {
        this.zzclK = uRI;
        this.zzclN = new ada(uRI, null, map);
        this.zzclL = new adc(this);
        this.zzclM = new add(this, "TubeSock", this.zzaBE);
    }

    public final void zza(acy acy2) {
        this.zzclJ = acy2;
    }

    final acy zzJF() {
        return this.zzclJ;
    }

    public final synchronized void connect() {
        if (this.zzclI != acx.zzclS) {
            this.zzclJ.zza(new acz("connect() already called"));
            this.close();
            return;
        }
        String string = String.valueOf("TubeSockReader-");
        int n = this.zzaBE;
        zzclQ.zza(this.zzclO, new StringBuilder(11 + String.valueOf(string).length()).append(string).append(n).toString());
        this.zzclI = acx.zzclT;
        this.zzclO.start();
    }

    public final synchronized void zzhl(String string) {
        this.zza((byte)1, string.getBytes(zzclH));
    }

    final synchronized void zzF(byte[] byArray) {
        this.zza((byte)10, byArray);
    }

    private final synchronized void zza(byte by, byte[] byArray) {
        if (this.zzclI != acx.zzclU) {
            this.zzclJ.zza(new acz("error while sending data: not connected"));
            return;
        }
        try {
            this.zzclM.zza(by, true, byArray);
            return;
        }
        catch (IOException iOException) {
            this.zzclJ.zza(new acz("Failed to send frame", iOException));
            this.close();
            return;
        }
    }

    final void zzb(acz acz2) {
        this.zzclJ.zza(acz2);
        if (this.zzclI == acx.zzclU) {
            this.close();
        }
        this.zzJH();
    }

    public final synchronized void close() {
        switch (this.zzclI - 1) {
            case 0: {
                this.zzclI = acx.zzclW;
                return;
            }
            case 1: {
                this.zzJH();
                return;
            }
            case 2: {
                acu acu2 = this;
                try {
                    acu2.zzclI = acx.zzclV;
                    acu2.zzclM.zzJO();
                    acu2.zzclM.zza((byte)8, true, new byte[0]);
                    return;
                }
                catch (IOException iOException) {
                    acu2.zzclJ.zza(new acz("Failed to send close frame", iOException));
                    return;
                }
            }
            case 3: {
                return;
            }
            case 4: {
                return;
            }
        }
    }

    final void zzJG() {
        this.zzJH();
    }

    private final synchronized void zzJH() {
        if (this.zzclI == acx.zzclW) {
            return;
        }
        this.zzclL.zzJM();
        this.zzclM.zzJO();
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        this.zzclI = acx.zzclW;
        this.zzclJ.onClose();
    }

    private final Socket createSocket() {
        Socket socket;
        String string = this.zzclK.getScheme();
        String string2 = this.zzclK.getHost();
        int n = this.zzclK.getPort();
        if (string != null && string.equals("ws")) {
            if (n == -1) {
                n = 80;
            }
            try {
                socket = new Socket(string2, n);
            }
            catch (UnknownHostException unknownHostException) {
                String string3 = String.valueOf(string2);
                throw new acz(string3.length() != 0 ? "unknown host: ".concat(string3) : new String("unknown host: "), unknownHostException);
            }
            catch (IOException iOException) {
                String string4 = String.valueOf(this.zzclK);
                throw new acz(new StringBuilder(31 + String.valueOf(string4).length()).append("error while creating socket to ").append(string4).toString(), iOException);
            }
        } else if (string != null && string.equals("wss")) {
            if (n == -1) {
                n = 443;
            }
            try {
                SSLSocket sSLSocket = (SSLSocket)SSLSocketFactory.getDefault().createSocket(string2, n);
                HostnameVerifier hostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
                SSLSession sSLSession = sSLSocket.getSession();
                if (!hostnameVerifier.verify(string2, sSLSession)) {
                    String string5 = String.valueOf(this.zzclK);
                    throw new acz(new StringBuilder(39 + String.valueOf(string5).length()).append("Error while verifying secure socket to ").append(string5).toString());
                }
                socket = sSLSocket;
            }
            catch (UnknownHostException unknownHostException) {
                String string6 = String.valueOf(string2);
                throw new acz(string6.length() != 0 ? "unknown host: ".concat(string6) : new String("unknown host: "), unknownHostException);
            }
            catch (IOException iOException) {
                String string7 = String.valueOf(this.zzclK);
                throw new acz(new StringBuilder(38 + String.valueOf(string7).length()).append("error while creating secure socket to ").append(string7).toString(), iOException);
            }
        } else {
            String string8 = String.valueOf(string);
            throw new acz(string8.length() != 0 ? "unsupported protocol: ".concat(string8) : new String("unsupported protocol: "));
        }
        return socket;
    }

    public final void zzJI() throws InterruptedException {
        if (this.zzclM.zzJQ().getState() != Thread.State.NEW) {
            this.zzclM.zzJQ().join();
        }
        this.zzclO.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzJJ() {
        try {
            Socket socket = this.createSocket();
            Object object = this;
            synchronized (object) {
                this.socket = socket;
                if (this.zzclI == acx.zzclW) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException);
                    }
                    this.socket = null;
                    return;
                }
            }
            object = new DataInputStream(socket.getInputStream());
            OutputStream outputStream = socket.getOutputStream();
            outputStream.write(this.zzclN.zzJK());
            boolean bl = false;
            byte[] byArray = new byte[1000];
            int n = 0;
            ArrayList<String> arrayList = new ArrayList<String>();
            while (!bl) {
                String string;
                String string2;
                int n2 = ((FilterInputStream)object).read();
                if (n2 == -1) {
                    throw new acz("Connection closed before handshake was complete");
                }
                byArray[n] = (byte)n2;
                if (byArray[++n - 1] == 10 && byArray[n - 2] == 13) {
                    string2 = new String(byArray, zzclH);
                    if (string2.trim().equals("")) {
                        bl = true;
                    } else {
                        arrayList.add(string2.trim());
                    }
                    byArray = new byte[1000];
                    n = 0;
                    continue;
                }
                if (n != 1000) continue;
                string2 = new String(byArray, zzclH);
                String string3 = String.valueOf(string2);
                if (string3.length() != 0) {
                    string = "Unexpected long line in handshake: ".concat(string3);
                    throw new acz(string);
                }
                string = new String("Unexpected long line in handshake: ");
                throw new acz(string);
            }
            int n3 = Integer.valueOf(((String)arrayList.get(0)).substring(9, 12));
            if (n3 == 407) {
                throw new acz("connection failed: proxy authentication not supported");
            }
            if (n3 == 404) {
                throw new acz("connection failed: 404 not found");
            }
            if (n3 != 101) {
                throw new acz(new StringBuilder(50).append("connection failed: unknown status code ").append(n3).toString());
            }
            arrayList.remove(0);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            ArrayList<String> arrayList2 = arrayList;
            int n4 = arrayList2.size();
            for (int i = 0; i < n4; ++i) {
                Object e = arrayList2.get(i);
                String[] stringArray = ((String)e).split(": ", 2);
                hashMap.put(stringArray[0], stringArray[1]);
            }
            HashMap<String, String> hashMap2 = hashMap;
            if (!((String)hashMap2.get("Upgrade")).toLowerCase(Locale.US).equals("websocket")) {
                throw new acz("connection failed: missing header field in server handshake: Upgrade");
            }
            if (!((String)hashMap2.get("Connection")).toLowerCase(Locale.US).equals("upgrade")) {
                throw new acz("connection failed: missing header field in server handshake: Connection");
            }
            this.zzclM.zzb(outputStream);
            this.zzclL.zza((DataInputStream)object);
            this.zzclI = acx.zzclU;
            this.zzclM.zzJQ().start();
            this.zzclJ.zzGP();
            this.zzclL.run();
            return;
        }
        catch (acz acz2) {
            this.zzclJ.zza(acz2);
            return;
        }
        catch (IOException iOException) {
            String string = String.valueOf(iOException.getMessage());
            this.zzclJ.zza(new acz(string.length() != 0 ? "error while connecting: ".concat(string) : new String("error while connecting: "), iOException));
            return;
        }
        finally {
            this.close();
        }
    }

    static /* synthetic */ void zza(acu acu2) {
        acu2.zzJJ();
    }
}

