/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzdyh;
import com.google.android.gms.internal.zzdyj;
import com.google.android.gms.internal.zzdyk;
import com.google.android.gms.internal.zzdyl;
import com.google.android.gms.internal.zzdym;
import com.google.android.gms.internal.zzdyn;
import com.google.android.gms.internal.zzdyo;
import com.google.android.gms.internal.zzdyp;
import com.google.android.gms.internal.zzdyr;
import com.google.android.gms.internal.zzdys;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public final class zzdyi {
    private static final AtomicInteger zzmfm = new AtomicInteger(0);
    private static final Charset zzmfn = Charset.forName("UTF-8");
    private volatile int zzmfo = zzdym.zzmfz;
    private volatile Socket socket = null;
    private zzdyn zzmfp = null;
    private final URI zzmfq;
    private final zzdyr zzmfr;
    private final zzdys zzmfs;
    private final zzdyp zzmft;
    private final int zzfif = zzmfm.incrementAndGet();
    private final Thread zzmfu = zzmfv.newThread(new zzdyk(this));
    private static ThreadFactory zzmfv = Executors.defaultThreadFactory();
    private static zzdyh zzmfw = new zzdyj();

    static ThreadFactory getThreadFactory() {
        return zzmfv;
    }

    static zzdyh zzbxh() {
        return zzmfw;
    }

    public static void zza(ThreadFactory threadFactory, zzdyh zzdyh2) {
        zzmfv = threadFactory;
        zzmfw = zzdyh2;
    }

    public zzdyi(URI uRI, String string, Map<String, String> map) {
        this.zzmfq = uRI;
        this.zzmft = new zzdyp(uRI, null, map);
        this.zzmfr = new zzdyr(this);
        this.zzmfs = new zzdys(this, "TubeSock", this.zzfif);
    }

    public final void zza(zzdyn zzdyn2) {
        this.zzmfp = zzdyn2;
    }

    final zzdyn zzbxi() {
        return this.zzmfp;
    }

    public final synchronized void connect() {
        if (this.zzmfo != zzdym.zzmfz) {
            this.zzmfp.zza(new zzdyo("connect() already called"));
            this.close();
            return;
        }
        String string = "TubeSockReader-";
        int n = this.zzfif;
        zzmfw.zza(this.zzmfu, new StringBuilder(11 + String.valueOf(string).length()).append(string).append(n).toString());
        this.zzmfo = zzdym.zzmga;
        this.zzmfu.start();
    }

    public final synchronized void zzox(String string) {
        this.zza((byte)1, string.getBytes(zzmfn));
    }

    final synchronized void zzan(byte[] byArray) {
        this.zza((byte)10, byArray);
    }

    private final synchronized void zza(byte by, byte[] byArray) {
        if (this.zzmfo != zzdym.zzmgb) {
            this.zzmfp.zza(new zzdyo("error while sending data: not connected"));
            return;
        }
        try {
            this.zzmfs.zza(by, true, byArray);
            return;
        }
        catch (IOException iOException) {
            this.zzmfp.zza(new zzdyo("Failed to send frame", iOException));
            this.close();
            return;
        }
    }

    final void zzb(zzdyo zzdyo2) {
        this.zzmfp.zza(zzdyo2);
        if (this.zzmfo == zzdym.zzmgb) {
            this.close();
        }
        this.zzbxk();
    }

    public final synchronized void close() {
        switch (zzdyl.zzmfy[this.zzmfo - 1]) {
            case 1: {
                this.zzmfo = zzdym.zzmgd;
                return;
            }
            case 2: {
                this.zzbxk();
                return;
            }
            case 3: {
                zzdyi zzdyi2 = this;
                try {
                    zzdyi2.zzmfo = zzdym.zzmgc;
                    zzdyi2.zzmfs.zzbxr();
                    zzdyi2.zzmfs.zza((byte)8, true, new byte[0]);
                    return;
                }
                catch (IOException iOException) {
                    zzdyi2.zzmfp.zza(new zzdyo("Failed to send close frame", iOException));
                    return;
                }
            }
            case 4: {
                return;
            }
            case 5: {
                return;
            }
        }
    }

    final void zzbxj() {
        this.zzbxk();
    }

    private final synchronized void zzbxk() {
        if (this.zzmfo == zzdym.zzmgd) {
            return;
        }
        this.zzmfr.zzbxp();
        this.zzmfs.zzbxr();
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        this.zzmfo = zzdym.zzmgd;
        this.zzmfp.onClose();
    }

    private final Socket createSocket() {
        Socket socket;
        String string = this.zzmfq.getScheme();
        String string2 = this.zzmfq.getHost();
        int n = this.zzmfq.getPort();
        if (string != null && string.equals("ws")) {
            if (n == -1) {
                n = 80;
            }
            try {
                socket = new Socket(string2, n);
            }
            catch (UnknownHostException unknownHostException) {
                String string3 = String.valueOf(string2);
                throw new zzdyo(string3.length() != 0 ? "unknown host: ".concat(string3) : new String("unknown host: "), unknownHostException);
            }
            catch (IOException iOException) {
                String string4 = String.valueOf(this.zzmfq);
                throw new zzdyo(new StringBuilder(31 + String.valueOf(string4).length()).append("error while creating socket to ").append(string4).toString(), iOException);
            }
        } else if (string != null && string.equals("wss")) {
            if (n == -1) {
                n = 443;
            }
            try {
                SSLSocket sSLSocket = (SSLSocket)SSLSocketFactory.getDefault().createSocket(string2, n);
                HostnameVerifier hostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
                SSLSession sSLSession = sSLSocket.getSession();
                if (!hostnameVerifier.verify(string2, sSLSession)) {
                    String string5 = String.valueOf(this.zzmfq);
                    throw new zzdyo(new StringBuilder(39 + String.valueOf(string5).length()).append("Error while verifying secure socket to ").append(string5).toString());
                }
                socket = sSLSocket;
            }
            catch (UnknownHostException unknownHostException) {
                String string6 = String.valueOf(string2);
                throw new zzdyo(string6.length() != 0 ? "unknown host: ".concat(string6) : new String("unknown host: "), unknownHostException);
            }
            catch (IOException iOException) {
                String string7 = String.valueOf(this.zzmfq);
                throw new zzdyo(new StringBuilder(38 + String.valueOf(string7).length()).append("error while creating secure socket to ").append(string7).toString(), iOException);
            }
        } else {
            String string8 = String.valueOf(string);
            throw new zzdyo(string8.length() != 0 ? "unsupported protocol: ".concat(string8) : new String("unsupported protocol: "));
        }
        return socket;
    }

    public final void zzbxl() throws InterruptedException {
        if (this.zzmfs.zzbxt().getState() != Thread.State.NEW) {
            this.zzmfs.zzbxt().join();
        }
        this.zzmfu.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzbxm() {
        try {
            Socket socket = this.createSocket();
            Object object = this;
            synchronized (object) {
                this.socket = socket;
                if (this.zzmfo == zzdym.zzmgd) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException);
                    }
                    this.socket = null;
                    return;
                }
            }
            object = new DataInputStream(socket.getInputStream());
            OutputStream outputStream = socket.getOutputStream();
            outputStream.write(this.zzmft.zzbxn());
            boolean bl = false;
            byte[] byArray = new byte[1000];
            int n = 0;
            ArrayList<String> arrayList = new ArrayList<String>();
            while (!bl) {
                String string;
                String string2;
                int n2 = ((FilterInputStream)object).read();
                if (n2 == -1) {
                    throw new zzdyo("Connection closed before handshake was complete");
                }
                byArray[n] = (byte)n2;
                if (byArray[++n - 1] == 10 && byArray[n - 2] == 13) {
                    string2 = new String(byArray, zzmfn);
                    if (string2.trim().equals("")) {
                        bl = true;
                    } else {
                        arrayList.add(string2.trim());
                    }
                    byArray = new byte[1000];
                    n = 0;
                    continue;
                }
                if (n != 1000) continue;
                string2 = new String(byArray, zzmfn);
                String string3 = String.valueOf(string2);
                if (string3.length() != 0) {
                    string = "Unexpected long line in handshake: ".concat(string3);
                    throw new zzdyo(string);
                }
                string = new String("Unexpected long line in handshake: ");
                throw new zzdyo(string);
            }
            int n3 = Integer.valueOf(((String)arrayList.get(0)).substring(9, 12));
            if (n3 == 407) {
                throw new zzdyo("connection failed: proxy authentication not supported");
            }
            if (n3 == 404) {
                throw new zzdyo("connection failed: 404 not found");
            }
            if (n3 != 101) {
                throw new zzdyo(new StringBuilder(50).append("connection failed: unknown status code ").append(n3).toString());
            }
            arrayList.remove(0);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            ArrayList<String> arrayList2 = arrayList;
            int n4 = arrayList2.size();
            for (int i = 0; i < n4; ++i) {
                Object e = arrayList2.get(i);
                String[] stringArray = ((String)e).split(": ", 2);
                hashMap.put(stringArray[0], stringArray[1]);
            }
            HashMap<String, String> hashMap2 = hashMap;
            if (!((String)hashMap2.get("Upgrade")).toLowerCase(Locale.US).equals("websocket")) {
                throw new zzdyo("connection failed: missing header field in server handshake: Upgrade");
            }
            if (!((String)hashMap2.get("Connection")).toLowerCase(Locale.US).equals("upgrade")) {
                throw new zzdyo("connection failed: missing header field in server handshake: Connection");
            }
            this.zzmfs.zzb(outputStream);
            this.zzmfr.zza((DataInputStream)object);
            this.zzmfo = zzdym.zzmgb;
            this.zzmfs.zzbxt().start();
            this.zzmfp.zzbrs();
            this.zzmfr.run();
            return;
        }
        catch (zzdyo zzdyo2) {
            this.zzmfp.zza(zzdyo2);
            return;
        }
        catch (IOException iOException) {
            String string = String.valueOf(iOException.getMessage());
            this.zzmfp.zza(new zzdyo(string.length() != 0 ? "error while connecting: ".concat(string) : new String("error while connecting: "), iOException));
            return;
        }
        finally {
            this.close();
        }
    }

    static /* synthetic */ void zza(zzdyi zzdyi2) {
        zzdyi2.zzbxm();
    }
}

