/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzdzn;
import com.google.android.gms.internal.zzdzp;
import com.google.android.gms.internal.zzdzq;
import com.google.android.gms.internal.zzdzr;
import com.google.android.gms.internal.zzdzs;
import com.google.android.gms.internal.zzdzt;
import com.google.android.gms.internal.zzdzu;
import com.google.android.gms.internal.zzdzv;
import com.google.android.gms.internal.zzdzx;
import com.google.android.gms.internal.zzdzy;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public final class zzdzo {
    private static final AtomicInteger zzmkb = new AtomicInteger(0);
    private static final Charset zzmkc = Charset.forName("UTF-8");
    private volatile int zzmkd = zzdzs.zzmko;
    private volatile Socket socket = null;
    private zzdzt zzmke = null;
    private final URI zzmkf;
    private final zzdzx zzmkg;
    private final zzdzy zzmkh;
    private final zzdzv zzmki;
    private final int zzfil = zzmkb.incrementAndGet();
    private final Thread zzmkj = zzmkk.newThread(new zzdzq(this));
    private static ThreadFactory zzmkk = Executors.defaultThreadFactory();
    private static zzdzn zzmkl = new zzdzp();

    static ThreadFactory getThreadFactory() {
        return zzmkk;
    }

    static zzdzn zzbxr() {
        return zzmkl;
    }

    public static void zza(ThreadFactory threadFactory, zzdzn zzdzn2) {
        zzmkk = threadFactory;
        zzmkl = zzdzn2;
    }

    public zzdzo(URI uRI, String string, Map<String, String> map) {
        this.zzmkf = uRI;
        this.zzmki = new zzdzv(uRI, null, map);
        this.zzmkg = new zzdzx(this);
        this.zzmkh = new zzdzy(this, "TubeSock", this.zzfil);
    }

    public final void zza(zzdzt zzdzt2) {
        this.zzmke = zzdzt2;
    }

    final zzdzt zzbxs() {
        return this.zzmke;
    }

    public final synchronized void connect() {
        if (this.zzmkd != zzdzs.zzmko) {
            this.zzmke.zza(new zzdzu("connect() already called"));
            this.close();
            return;
        }
        String string = "TubeSockReader-";
        int n = this.zzfil;
        zzmkl.zza(this.zzmkj, new StringBuilder(11 + String.valueOf(string).length()).append(string).append(n).toString());
        this.zzmkd = zzdzs.zzmkp;
        this.zzmkj.start();
    }

    public final synchronized void zzpj(String string) {
        this.zza((byte)1, string.getBytes(zzmkc));
    }

    final synchronized void zzap(byte[] byArray) {
        this.zza((byte)10, byArray);
    }

    private final synchronized void zza(byte by, byte[] byArray) {
        if (this.zzmkd != zzdzs.zzmkq) {
            this.zzmke.zza(new zzdzu("error while sending data: not connected"));
            return;
        }
        try {
            this.zzmkh.zza(by, true, byArray);
            return;
        }
        catch (IOException iOException) {
            this.zzmke.zza(new zzdzu("Failed to send frame", iOException));
            this.close();
            return;
        }
    }

    final void zzb(zzdzu zzdzu2) {
        this.zzmke.zza(zzdzu2);
        if (this.zzmkd == zzdzs.zzmkq) {
            this.close();
        }
        this.zzbxu();
    }

    public final synchronized void close() {
        switch (zzdzr.zzmkn[this.zzmkd - 1]) {
            case 1: {
                this.zzmkd = zzdzs.zzmks;
                return;
            }
            case 2: {
                this.zzbxu();
                return;
            }
            case 3: {
                zzdzo zzdzo2 = this;
                try {
                    zzdzo2.zzmkd = zzdzs.zzmkr;
                    zzdzo2.zzmkh.zzbyb();
                    zzdzo2.zzmkh.zza((byte)8, true, new byte[0]);
                    return;
                }
                catch (IOException iOException) {
                    zzdzo2.zzmke.zza(new zzdzu("Failed to send close frame", iOException));
                    return;
                }
            }
            case 4: {
                return;
            }
            case 5: {
                return;
            }
        }
    }

    final void zzbxt() {
        this.zzbxu();
    }

    private final synchronized void zzbxu() {
        if (this.zzmkd == zzdzs.zzmks) {
            return;
        }
        this.zzmkg.zzbxz();
        this.zzmkh.zzbyb();
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        this.zzmkd = zzdzs.zzmks;
        this.zzmke.onClose();
    }

    private final Socket createSocket() {
        Socket socket;
        String string = this.zzmkf.getScheme();
        String string2 = this.zzmkf.getHost();
        int n = this.zzmkf.getPort();
        if (string != null && string.equals("ws")) {
            if (n == -1) {
                n = 80;
            }
            try {
                socket = new Socket(string2, n);
            }
            catch (UnknownHostException unknownHostException) {
                String string3 = String.valueOf(string2);
                throw new zzdzu(string3.length() != 0 ? "unknown host: ".concat(string3) : new String("unknown host: "), unknownHostException);
            }
            catch (IOException iOException) {
                String string4 = String.valueOf(this.zzmkf);
                throw new zzdzu(new StringBuilder(31 + String.valueOf(string4).length()).append("error while creating socket to ").append(string4).toString(), iOException);
            }
        } else if (string != null && string.equals("wss")) {
            if (n == -1) {
                n = 443;
            }
            try {
                SSLSocket sSLSocket = (SSLSocket)SSLSocketFactory.getDefault().createSocket(string2, n);
                HostnameVerifier hostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
                SSLSession sSLSession = sSLSocket.getSession();
                if (!hostnameVerifier.verify(string2, sSLSession)) {
                    String string5 = String.valueOf(this.zzmkf);
                    throw new zzdzu(new StringBuilder(39 + String.valueOf(string5).length()).append("Error while verifying secure socket to ").append(string5).toString());
                }
                socket = sSLSocket;
            }
            catch (UnknownHostException unknownHostException) {
                String string6 = String.valueOf(string2);
                throw new zzdzu(string6.length() != 0 ? "unknown host: ".concat(string6) : new String("unknown host: "), unknownHostException);
            }
            catch (IOException iOException) {
                String string7 = String.valueOf(this.zzmkf);
                throw new zzdzu(new StringBuilder(38 + String.valueOf(string7).length()).append("error while creating secure socket to ").append(string7).toString(), iOException);
            }
        } else {
            String string8 = String.valueOf(string);
            throw new zzdzu(string8.length() != 0 ? "unsupported protocol: ".concat(string8) : new String("unsupported protocol: "));
        }
        return socket;
    }

    public final void zzbxv() throws InterruptedException {
        if (this.zzmkh.zzbyd().getState() != Thread.State.NEW) {
            this.zzmkh.zzbyd().join();
        }
        this.zzmkj.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzbxw() {
        try {
            Socket socket = this.createSocket();
            Object object = this;
            synchronized (object) {
                this.socket = socket;
                if (this.zzmkd == zzdzs.zzmks) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException);
                    }
                    this.socket = null;
                    return;
                }
            }
            object = new DataInputStream(socket.getInputStream());
            OutputStream outputStream = socket.getOutputStream();
            outputStream.write(this.zzmki.zzbxx());
            boolean bl = false;
            byte[] byArray = new byte[1000];
            int n = 0;
            ArrayList<String> arrayList = new ArrayList<String>();
            while (!bl) {
                String string;
                String string2;
                int n2 = ((FilterInputStream)object).read();
                if (n2 == -1) {
                    throw new zzdzu("Connection closed before handshake was complete");
                }
                byArray[n] = (byte)n2;
                if (byArray[++n - 1] == 10 && byArray[n - 2] == 13) {
                    string2 = new String(byArray, zzmkc);
                    if (string2.trim().equals("")) {
                        bl = true;
                    } else {
                        arrayList.add(string2.trim());
                    }
                    byArray = new byte[1000];
                    n = 0;
                    continue;
                }
                if (n != 1000) continue;
                string2 = new String(byArray, zzmkc);
                String string3 = String.valueOf(string2);
                if (string3.length() != 0) {
                    string = "Unexpected long line in handshake: ".concat(string3);
                    throw new zzdzu(string);
                }
                string = new String("Unexpected long line in handshake: ");
                throw new zzdzu(string);
            }
            int n3 = Integer.valueOf(((String)arrayList.get(0)).substring(9, 12));
            if (n3 == 407) {
                throw new zzdzu("connection failed: proxy authentication not supported");
            }
            if (n3 == 404) {
                throw new zzdzu("connection failed: 404 not found");
            }
            if (n3 != 101) {
                throw new zzdzu(new StringBuilder(50).append("connection failed: unknown status code ").append(n3).toString());
            }
            arrayList.remove(0);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            ArrayList<String> arrayList2 = arrayList;
            int n4 = arrayList2.size();
            for (int i = 0; i < n4; ++i) {
                Object e = arrayList2.get(i);
                String[] stringArray = ((String)e).split(": ", 2);
                hashMap.put(stringArray[0], stringArray[1]);
            }
            HashMap<String, String> hashMap2 = hashMap;
            if (!((String)hashMap2.get("Upgrade")).toLowerCase(Locale.US).equals("websocket")) {
                throw new zzdzu("connection failed: missing header field in server handshake: Upgrade");
            }
            if (!((String)hashMap2.get("Connection")).toLowerCase(Locale.US).equals("upgrade")) {
                throw new zzdzu("connection failed: missing header field in server handshake: Connection");
            }
            this.zzmkh.zzb(outputStream);
            this.zzmkg.zza((DataInputStream)object);
            this.zzmkd = zzdzs.zzmkq;
            this.zzmkh.zzbyd().start();
            this.zzmke.zzbsc();
            this.zzmkg.run();
            return;
        }
        catch (zzdzu zzdzu2) {
            this.zzmke.zza(zzdzu2);
            return;
        }
        catch (IOException iOException) {
            String string = String.valueOf(iOException.getMessage());
            this.zzmke.zza(new zzdzu(string.length() != 0 ? "error while connecting: ".concat(string) : new String("error while connecting: "), iOException));
            return;
        }
        finally {
            this.close();
        }
    }

    static /* synthetic */ void zza(zzdzo zzdzo2) {
        zzdzo2.zzbxw();
    }
}

