/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzaid;
import com.google.android.gms.internal.zzaif;
import com.google.android.gms.internal.zzaig;
import com.google.android.gms.internal.zzaih;
import com.google.android.gms.internal.zzaij;
import com.google.android.gms.internal.zzaik;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class zzaie {
    private static final AtomicInteger zzbRx = new AtomicInteger(0);
    private static final Charset zzbRy = Charset.forName("UTF-8");
    private volatile zza zzbRz = zza.zzbRL;
    private volatile Socket zzbRA = null;
    private zzaif zzbRB = null;
    private final URI zzbRC;
    private final zzaij zzbRD;
    private final zzaik zzbRE;
    private final zzaih zzbRF;
    private final int zzalI = zzbRx.incrementAndGet();
    private final Thread zzbRG = zzaie.getThreadFactory().newThread(new Runnable(){

        @Override
        public void run() {
            zzaie.this.zzTX();
        }
    });
    private static ThreadFactory zzbRH = Executors.defaultThreadFactory();
    private static zzaid zzbRI = new zzaid(){

        @Override
        public void zza(Thread thread, String string) {
            thread.setName(string);
        }
    };

    static ThreadFactory getThreadFactory() {
        return zzbRH;
    }

    static zzaid zzTR() {
        return zzbRI;
    }

    public static void zza(ThreadFactory threadFactory, zzaid zzaid2) {
        zzbRH = threadFactory;
        zzbRI = zzaid2;
    }

    public zzaie(URI uRI, String string, Map<String, String> map) {
        this.zzbRC = uRI;
        this.zzbRF = new zzaih(uRI, string, map);
        this.zzbRD = new zzaij(this);
        this.zzbRE = new zzaik(this, "TubeSock", this.zzalI);
    }

    public void zza(zzaif zzaif2) {
        this.zzbRB = zzaif2;
    }

    zzaif zzTS() {
        return this.zzbRB;
    }

    public synchronized void connect() {
        if (this.zzbRz != zza.zzbRL) {
            this.zzbRB.zza(new zzaig("connect() already called"));
            this.close();
            return;
        }
        String string = String.valueOf("TubeSockReader-");
        int n = this.zzalI;
        zzaie.zzTR().zza(this.zzTY(), new StringBuilder(11 + String.valueOf(string).length()).append(string).append(n).toString());
        this.zzbRz = zza.zzbRM;
        this.zzTY().start();
    }

    public synchronized void zzhZ(String string) {
        this.zza((byte)1, string.getBytes(zzbRy));
    }

    synchronized void zzK(byte[] byArray) {
        this.zza((byte)10, byArray);
    }

    private synchronized void zza(byte by, byte[] byArray) {
        if (this.zzbRz != zza.zzbRN) {
            this.zzbRB.zza(new zzaig("error while sending data: not connected"));
        } else {
            try {
                this.zzbRE.zzb(by, true, byArray);
            }
            catch (IOException iOException) {
                this.zzbRB.zza(new zzaig("Failed to send frame", iOException));
                this.close();
            }
        }
    }

    void zzb(zzaig zzaig2) {
        this.zzbRB.zza(zzaig2);
        if (this.zzbRz == zza.zzbRN) {
            this.close();
        }
        this.zzTU();
    }

    public synchronized void close() {
        switch (this.zzbRz) {
            case zzbRL: {
                this.zzbRz = zza.zzbRP;
                return;
            }
            case zzbRM: {
                this.zzTU();
                return;
            }
            case zzbRN: {
                this.zzTV();
                return;
            }
            case zzbRO: {
                return;
            }
            case zzbRP: {
                return;
            }
        }
    }

    void zzTT() {
        this.zzTU();
    }

    private synchronized void zzTU() {
        if (this.zzbRz == zza.zzbRP) {
            return;
        }
        this.zzbRD.zzUb();
        this.zzbRE.zzUe();
        if (this.zzbRA != null) {
            try {
                this.zzbRA.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        this.zzbRz = zza.zzbRP;
        this.zzbRB.onClose();
    }

    private void zzTV() {
        try {
            this.zzbRz = zza.zzbRO;
            this.zzbRE.zzUe();
            this.zzbRE.zzb((byte)8, true, new byte[0]);
        }
        catch (IOException iOException) {
            this.zzbRB.zza(new zzaig("Failed to send close frame", iOException));
        }
    }

    private Socket createSocket() {
        Socket socket;
        String string = this.zzbRC.getScheme();
        String string2 = this.zzbRC.getHost();
        int n = this.zzbRC.getPort();
        if (string != null && string.equals("ws")) {
            if (n == -1) {
                n = 80;
            }
            try {
                socket = new Socket(string2, n);
            }
            catch (UnknownHostException unknownHostException) {
                String string3 = String.valueOf(string2);
                throw new zzaig(string3.length() != 0 ? "unknown host: ".concat(string3) : new String("unknown host: "), unknownHostException);
            }
            catch (IOException iOException) {
                String string4 = String.valueOf(this.zzbRC);
                throw new zzaig(new StringBuilder(31 + String.valueOf(string4).length()).append("error while creating socket to ").append(string4).toString(), iOException);
            }
        } else if (string != null && string.equals("wss")) {
            if (n == -1) {
                n = 443;
            }
            try {
                SocketFactory socketFactory = SSLSocketFactory.getDefault();
                SSLSocket sSLSocket = (SSLSocket)socketFactory.createSocket(string2, n);
                HostnameVerifier hostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
                SSLSession sSLSession = sSLSocket.getSession();
                if (!hostnameVerifier.verify(string2, sSLSession)) {
                    String string5 = String.valueOf(this.zzbRC);
                    throw new zzaig(new StringBuilder(39 + String.valueOf(string5).length()).append("Error while verifying secure socket to ").append(string5).toString());
                }
                socket = sSLSocket;
            }
            catch (UnknownHostException unknownHostException) {
                String string6 = String.valueOf(string2);
                throw new zzaig(string6.length() != 0 ? "unknown host: ".concat(string6) : new String("unknown host: "), unknownHostException);
            }
            catch (IOException iOException) {
                String string7 = String.valueOf(this.zzbRC);
                throw new zzaig(new StringBuilder(38 + String.valueOf(string7).length()).append("error while creating secure socket to ").append(string7).toString(), iOException);
            }
        } else {
            String string8 = String.valueOf(string);
            throw new zzaig(string8.length() != 0 ? "unsupported protocol: ".concat(string8) : new String("unsupported protocol: "));
        }
        return socket;
    }

    public void zzTW() throws InterruptedException {
        if (this.zzbRE.zzTY().getState() != Thread.State.NEW) {
            this.zzbRE.zzTY().join();
        }
        this.zzTY().join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void zzTX() {
        try {
            Socket socket = this.createSocket();
            Object object = this;
            synchronized (object) {
                this.zzbRA = socket;
                if (this.zzbRz == zza.zzbRP) {
                    try {
                        this.zzbRA.close();
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException);
                    }
                    this.zzbRA = null;
                    return;
                }
            }
            object = new DataInputStream(socket.getInputStream());
            OutputStream outputStream = socket.getOutputStream();
            outputStream.write(this.zzbRF.zzTZ());
            boolean bl = false;
            int n = 1000;
            byte[] byArray = new byte[1000];
            int n2 = 0;
            ArrayList<String> arrayList = new ArrayList<String>();
            while (!bl) {
                String string;
                Object object2;
                int n3 = ((FilterInputStream)object).read();
                if (n3 == -1) {
                    throw new zzaig("Connection closed before handshake was complete");
                }
                byArray[n2] = (byte)n3;
                if (byArray[++n2 - 1] == 10 && byArray[n2 - 2] == 13) {
                    object2 = new String(byArray, zzbRy);
                    if (((String)object2).trim().equals("")) {
                        bl = true;
                    } else {
                        arrayList.add(((String)object2).trim());
                    }
                    byArray = new byte[1000];
                    n2 = 0;
                    continue;
                }
                if (n2 != 1000) continue;
                object2 = new String(byArray, zzbRy);
                String string2 = String.valueOf(object2);
                if (string2.length() != 0) {
                    string = "Unexpected long line in handshake: ".concat(string2);
                    throw new zzaig(string);
                }
                string = new String("Unexpected long line in handshake: ");
                throw new zzaig(string);
            }
            this.zzbRF.zzii((String)arrayList.get(0));
            arrayList.remove(0);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (String string : arrayList) {
                String[] stringArray = string.split(": ", 2);
                hashMap.put(stringArray[0], stringArray[1]);
            }
            this.zzbRF.zzc(hashMap);
            this.zzbRE.zzb(outputStream);
            this.zzbRD.zza((DataInputStream)object);
            this.zzbRz = zza.zzbRN;
            this.zzbRE.zzTY().start();
            this.zzbRB.zzQC();
            this.zzbRD.run();
            return;
        }
        catch (zzaig zzaig2) {
            this.zzbRB.zza(zzaig2);
            return;
        }
        catch (IOException iOException) {
            String string = String.valueOf(iOException.getMessage());
            this.zzbRB.zza(new zzaig(string.length() != 0 ? "error while connecting: ".concat(string) : new String("error while connecting: "), iOException));
            return;
        }
        finally {
            this.close();
        }
    }

    Thread zzTY() {
        return this.zzbRG;
    }

    private static final class zza
    extends Enum<zza> {
        public static final /* enum */ zza zzbRL = new zza();
        public static final /* enum */ zza zzbRM = new zza();
        public static final /* enum */ zza zzbRN = new zza();
        public static final /* enum */ zza zzbRO = new zza();
        public static final /* enum */ zza zzbRP = new zza();
        private static final /* synthetic */ zza[] zzbRQ;

        public static zza[] values() {
            return (zza[])zzbRQ.clone();
        }

        static {
            zzbRQ = new zza[]{zzbRL, zzbRM, zzbRN, zzbRO, zzbRP};
        }
    }
}

