/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzagv;
import com.google.android.gms.internal.zzagx;
import com.google.android.gms.internal.zzahf;
import com.google.android.gms.internal.zzajx;
import com.google.android.gms.internal.zzakw;
import com.google.android.gms.internal.zzakx;
import com.google.android.gms.internal.zzaky;
import com.google.android.gms.internal.zzala;
import com.google.android.gms.internal.zzalf;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

class zzahd {
    private static long aSc = 0L;
    private zzb aSd;
    private boolean aSe = false;
    private boolean aSf = false;
    private long aSg = 0L;
    private zzahf aSh;
    private zza aSi;
    private ScheduledFuture<?> aSj;
    private ScheduledFuture<?> aSk;
    private final zzagv aSl;
    private final ScheduledExecutorService aPL;
    private final zzajx aPY;

    public zzahd(zzagv zzagv2, zzagx zzagx2, String string, zza zza2, String string2) {
        this.aSl = zzagv2;
        this.aPL = zzagv2.zzcoc();
        this.aSi = zza2;
        long l = aSc++;
        this.aPY = new zzajx(zzagv2.zzcoa(), "WebSocket", new StringBuilder(23).append("ws_").append(l).toString());
        this.aSd = this.zza(zzagx2, string, string2);
    }

    private zzb zza(zzagx zzagx2, String string, String string2) {
        String string3 = string != null ? string : zzagx2.getHost();
        URI uRI = zzagx.zza(string3, zzagx2.isSecure(), zzagx2.getNamespace(), string2);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("User-Agent", this.aSl.zzsp());
        zzakw zzakw2 = new zzakw(uRI, null, hashMap);
        zzc zzc2 = new zzc(zzakw2);
        return zzc2;
    }

    public void open() {
        this.aSd.connect();
        this.aSk = this.aPL.schedule(new Runnable(){

            @Override
            public void run() {
                zzahd.this.zzcpj();
            }
        }, 30000L, TimeUnit.MILLISECONDS);
    }

    public void start() {
    }

    public void close() {
        if (this.aPY.zzcum()) {
            this.aPY.zzh("websocket is being closed", new Object[0]);
        }
        this.aSf = true;
        this.aSd.close();
        if (this.aSk != null) {
            this.aSk.cancel(true);
        }
        if (this.aSj != null) {
            this.aSj.cancel(true);
        }
    }

    public void send(Map<String, Object> map) {
        this.zzcpg();
        try {
            int n;
            String string = zzalf.zzcb(map);
            String[] stringArray = zzahd.zzad(string, 16384);
            if (stringArray.length > 1) {
                n = stringArray.length;
                this.aSd.zzrf(new StringBuilder(11).append(n).toString());
            }
            for (n = 0; n < stringArray.length; ++n) {
                this.aSd.zzrf(stringArray[n]);
            }
        }
        catch (IOException iOException) {
            String string = String.valueOf(map.toString());
            this.aPY.zze(string.length() != 0 ? "Failed to serialize message: ".concat(string) : new String("Failed to serialize message: "), iOException);
            this.shutdown();
        }
    }

    private void zzrc(String string) {
        this.aSh.zzrg(string);
        --this.aSg;
        if (this.aSg == 0L) {
            try {
                this.aSh.zzcpp();
                Map<String, Object> map = zzalf.zzrq(this.aSh.toString());
                this.aSh = null;
                if (this.aPY.zzcum()) {
                    String string2 = String.valueOf(map);
                    this.aPY.zzh(new StringBuilder(36 + String.valueOf(string2).length()).append("handleIncomingFrame complete frame: ").append(string2).toString(), new Object[0]);
                }
                this.aSi.zzbp(map);
            }
            catch (IOException iOException) {
                String string3 = String.valueOf(this.aSh.toString());
                this.aPY.zze(string3.length() != 0 ? "Error parsing frame: ".concat(string3) : new String("Error parsing frame: "), iOException);
                this.close();
                this.shutdown();
            }
            catch (ClassCastException classCastException) {
                String string4 = String.valueOf(this.aSh.toString());
                this.aPY.zze(string4.length() != 0 ? "Error parsing frame (cast error): ".concat(string4) : new String("Error parsing frame (cast error): "), classCastException);
                this.close();
                this.shutdown();
            }
        }
    }

    private void zzadj(int n) {
        this.aSg = n;
        this.aSh = new zzahf();
        if (this.aPY.zzcum()) {
            long l = this.aSg;
            this.aPY.zzh(new StringBuilder(41).append("HandleNewFrameCount: ").append(l).toString(), new Object[0]);
        }
    }

    private String zzrd(String string) {
        if (string.length() <= 6) {
            try {
                int n = Integer.parseInt(string);
                if (n > 0) {
                    this.zzadj(n);
                }
                return null;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.zzadj(1);
        return string;
    }

    private void zzre(String string) {
        if (!this.aSf) {
            this.zzcpg();
            if (this.isBuffering()) {
                this.zzrc(string);
            } else {
                String string2 = this.zzrd(string);
                if (string2 != null) {
                    this.zzrc(string2);
                }
            }
        }
    }

    private void zzcpg() {
        if (!this.aSf) {
            if (this.aSj != null) {
                this.aSj.cancel(false);
                if (this.aPY.zzcum()) {
                    long l = this.aSj.getDelay(TimeUnit.MILLISECONDS);
                    this.aPY.zzh(new StringBuilder(48).append("Reset keepAlive. Remaining: ").append(l).toString(), new Object[0]);
                }
            } else if (this.aPY.zzcum()) {
                this.aPY.zzh("Reset keepAlive", new Object[0]);
            }
            this.aSj = this.aPL.schedule(this.zzcph(), 45000L, TimeUnit.MILLISECONDS);
        }
    }

    private Runnable zzcph() {
        return new Runnable(){

            @Override
            public void run() {
                if (zzahd.this.aSd != null) {
                    zzahd.this.aSd.zzrf("0");
                    zzahd.this.zzcpg();
                }
            }
        };
    }

    private boolean isBuffering() {
        return this.aSh != null;
    }

    private void zzcpi() {
        if (!this.aSf) {
            if (this.aPY.zzcum()) {
                this.aPY.zzh("closing itself", new Object[0]);
            }
            this.shutdown();
        }
        this.aSd = null;
        if (this.aSj != null) {
            this.aSj.cancel(false);
        }
    }

    private void shutdown() {
        this.aSf = true;
        this.aSi.zzco(this.aSe);
    }

    private void zzcpj() {
        if (!this.aSe && !this.aSf) {
            if (this.aPY.zzcum()) {
                this.aPY.zzh("timed out on connect", new Object[0]);
            }
            this.aSd.close();
        }
    }

    private static String[] zzad(String string, int n) {
        if (string.length() <= n) {
            return new String[]{string};
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < string.length(); i += n) {
            int n2 = Math.min(i + n, string.length());
            String string2 = string.substring(i, n2);
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private class zzc
    implements zzb,
    zzakx {
        private zzakw aSn;

        private zzc(zzakw zzakw2) {
            this.aSn = zzakw2;
            this.aSn.zza(this);
        }

        @Override
        public void zzcpk() {
            zzahd.this.aPL.execute(new Runnable(){

                @Override
                public void run() {
                    zzahd.this.aSk.cancel(false);
                    zzahd.this.aSe = true;
                    if (zzahd.this.aPY.zzcum()) {
                        zzahd.this.aPY.zzh("websocket opened", new Object[0]);
                    }
                    zzahd.this.zzcpg();
                }
            });
        }

        @Override
        public void zza(zzala zzala2) {
            final String string = zzala2.getText();
            if (zzahd.this.aPY.zzcum()) {
                String string2 = String.valueOf(string);
                zzahd.this.aPY.zzh(string2.length() != 0 ? "ws message: ".concat(string2) : new String("ws message: "), new Object[0]);
            }
            zzahd.this.aPL.execute(new Runnable(){

                @Override
                public void run() {
                    zzahd.this.zzre(string);
                }
            });
        }

        @Override
        public void onClose() {
            String string = "closed";
            zzahd.this.aPL.execute(new Runnable(){

                @Override
                public void run() {
                    if (zzahd.this.aPY.zzcum()) {
                        zzahd.this.aPY.zzh("closed", new Object[0]);
                    }
                    zzahd.this.zzcpi();
                }
            });
        }

        @Override
        public void zza(final zzaky zzaky2) {
            zzahd.this.aPL.execute(new Runnable(){

                @Override
                public void run() {
                    String string = "had an error";
                    if (zzahd.this.aPY.zzcum()) {
                        zzahd.this.aPY.zza(string, zzaky2, new Object[0]);
                    }
                    if (zzaky2.getMessage().startsWith("unknown host")) {
                        if (zzahd.this.aPY.zzcum()) {
                            zzahd.this.aPY.zzh("If you are running on Android, have you added <uses-permission android:name=\"android.permission.INTERNET\" /> under <manifest> in AndroidManifest.xml?", new Object[0]);
                        }
                    } else if (zzahd.this.aPY.zzcum()) {
                        String string2 = String.valueOf(zzaky2.getMessage());
                        zzahd.this.aPY.zzh(new StringBuilder(2 + String.valueOf(string2).length()).append("|").append(string2).append("|").toString(), new Object[0]);
                    }
                    zzahd.this.zzcpi();
                }
            });
        }

        @Override
        public void zzrf(String string) {
            this.aSn.zzrf(string);
        }

        @Override
        public void close() {
            this.aSn.close();
        }

        private void shutdown() {
            this.aSn.close();
            try {
                this.aSn.zzcwe();
            }
            catch (InterruptedException interruptedException) {
                zzahd.this.aPY.zze("Interrupted while shutting down websocket threads", interruptedException);
            }
        }

        @Override
        public void connect() {
            try {
                this.aSn.connect();
            }
            catch (zzaky zzaky2) {
                if (zzahd.this.aPY.zzcum()) {
                    zzahd.this.aPY.zza("Error connecting", zzaky2, new Object[0]);
                }
                this.shutdown();
            }
        }
    }

    private static interface zzb {
        public void connect();

        public void close();

        public void zzrf(String var1);
    }

    public static interface zza {
        public void zzbp(Map<String, Object> var1);

        public void zzco(boolean var1);
    }
}

