/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzakv;
import com.google.android.gms.internal.zzakx;
import com.google.android.gms.internal.zzaky;
import com.google.android.gms.internal.zzakz;
import com.google.android.gms.internal.zzalb;
import com.google.android.gms.internal.zzalc;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class zzakw {
    private static final AtomicInteger aZz = new AtomicInteger(0);
    private static final Charset aZA = Charset.forName("UTF-8");
    private volatile zza aZB = zza.aZN;
    private volatile Socket aZC = null;
    private zzakx aZD = null;
    private final URI aZE;
    private final zzalb aZF;
    private final zzalc aZG;
    private final zzakz aZH;
    private final int st = aZz.incrementAndGet();
    private final Thread aZI = zzakw.getThreadFactory().newThread(new Runnable(){

        @Override
        public void run() {
            zzakw.this.zzcwf();
        }
    });
    private static ThreadFactory aZJ = Executors.defaultThreadFactory();
    private static zzakv aZK = new zzakv(){

        @Override
        public void zza(Thread thread, String string) {
            thread.setName(string);
        }
    };

    static ThreadFactory getThreadFactory() {
        return aZJ;
    }

    static zzakv zzcvz() {
        return aZK;
    }

    public static void zza(ThreadFactory threadFactory, zzakv zzakv2) {
        aZJ = threadFactory;
        aZK = zzakv2;
    }

    public zzakw(URI uRI, String string, Map<String, String> map) {
        this.aZE = uRI;
        this.aZH = new zzakz(uRI, string, map);
        this.aZF = new zzalb(this);
        this.aZG = new zzalc(this, "TubeSock", this.st);
    }

    public void zza(zzakx zzakx2) {
        this.aZD = zzakx2;
    }

    zzakx zzcwa() {
        return this.aZD;
    }

    public synchronized void connect() {
        if (this.aZB != zza.aZN) {
            this.aZD.zza(new zzaky("connect() already called"));
            this.close();
            return;
        }
        String string = String.valueOf("TubeSockReader-");
        int n = this.st;
        zzakw.zzcvz().zza(this.zzcwg(), new StringBuilder(11 + String.valueOf(string).length()).append(string).append(n).toString());
        this.aZB = zza.aZO;
        this.zzcwg().start();
    }

    public synchronized void zzrf(String string) {
        this.zza((byte)1, string.getBytes(aZA));
    }

    synchronized void zzaw(byte[] byArray) {
        this.zza((byte)10, byArray);
    }

    private synchronized void zza(byte by, byte[] byArray) {
        if (this.aZB != zza.aZP) {
            this.aZD.zza(new zzaky("error while sending data: not connected"));
        } else {
            try {
                this.aZG.zzb(by, true, byArray);
            }
            catch (IOException iOException) {
                this.aZD.zza(new zzaky("Failed to send frame", iOException));
                this.close();
            }
        }
    }

    void zzb(zzaky zzaky2) {
        this.aZD.zza(zzaky2);
        if (this.aZB == zza.aZP) {
            this.close();
        }
        this.zzcwc();
    }

    public synchronized void close() {
        switch (this.aZB) {
            case aZN: {
                this.aZB = zza.aZR;
                return;
            }
            case aZO: {
                this.zzcwc();
                return;
            }
            case aZP: {
                this.zzcwd();
                return;
            }
            case aZQ: {
                return;
            }
            case aZR: {
                return;
            }
        }
    }

    void zzcwb() {
        this.zzcwc();
    }

    private synchronized void zzcwc() {
        if (this.aZB == zza.aZR) {
            return;
        }
        this.aZF.zzcwj();
        this.aZG.zzcwm();
        if (this.aZC != null) {
            try {
                this.aZC.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        this.aZB = zza.aZR;
        this.aZD.onClose();
    }

    private void zzcwd() {
        try {
            this.aZB = zza.aZQ;
            this.aZG.zzcwm();
            this.aZG.zzb((byte)8, true, new byte[0]);
        }
        catch (IOException iOException) {
            this.aZD.zza(new zzaky("Failed to send close frame", iOException));
        }
    }

    private Socket createSocket() {
        Socket socket;
        String string = this.aZE.getScheme();
        String string2 = this.aZE.getHost();
        int n = this.aZE.getPort();
        if (string != null && string.equals("ws")) {
            if (n == -1) {
                n = 80;
            }
            try {
                socket = new Socket(string2, n);
            }
            catch (UnknownHostException unknownHostException) {
                String string3 = String.valueOf(string2);
                throw new zzaky(string3.length() != 0 ? "unknown host: ".concat(string3) : new String("unknown host: "), unknownHostException);
            }
            catch (IOException iOException) {
                String string4 = String.valueOf(this.aZE);
                throw new zzaky(new StringBuilder(31 + String.valueOf(string4).length()).append("error while creating socket to ").append(string4).toString(), iOException);
            }
        } else if (string != null && string.equals("wss")) {
            if (n == -1) {
                n = 443;
            }
            try {
                SocketFactory socketFactory = SSLSocketFactory.getDefault();
                SSLSocket sSLSocket = (SSLSocket)socketFactory.createSocket(string2, n);
                HostnameVerifier hostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
                SSLSession sSLSession = sSLSocket.getSession();
                if (!hostnameVerifier.verify(string2, sSLSession)) {
                    String string5 = String.valueOf(this.aZE);
                    throw new zzaky(new StringBuilder(39 + String.valueOf(string5).length()).append("Error while verifying secure socket to ").append(string5).toString());
                }
                socket = sSLSocket;
            }
            catch (UnknownHostException unknownHostException) {
                String string6 = String.valueOf(string2);
                throw new zzaky(string6.length() != 0 ? "unknown host: ".concat(string6) : new String("unknown host: "), unknownHostException);
            }
            catch (IOException iOException) {
                String string7 = String.valueOf(this.aZE);
                throw new zzaky(new StringBuilder(38 + String.valueOf(string7).length()).append("error while creating secure socket to ").append(string7).toString(), iOException);
            }
        } else {
            String string8 = String.valueOf(string);
            throw new zzaky(string8.length() != 0 ? "unsupported protocol: ".concat(string8) : new String("unsupported protocol: "));
        }
        return socket;
    }

    public void zzcwe() throws InterruptedException {
        if (this.aZG.zzcwg().getState() != Thread.State.NEW) {
            this.aZG.zzcwg().join();
        }
        this.zzcwg().join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void zzcwf() {
        try {
            Socket socket = this.createSocket();
            Object object = this;
            synchronized (object) {
                this.aZC = socket;
                if (this.aZB == zza.aZR) {
                    try {
                        this.aZC.close();
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException);
                    }
                    this.aZC = null;
                    return;
                }
            }
            object = new DataInputStream(socket.getInputStream());
            OutputStream outputStream = socket.getOutputStream();
            outputStream.write(this.aZH.zzcwh());
            boolean bl = false;
            int n = 1000;
            byte[] byArray = new byte[1000];
            int n2 = 0;
            ArrayList<String> arrayList = new ArrayList<String>();
            while (!bl) {
                String string;
                Object object2;
                int n3 = ((FilterInputStream)object).read();
                if (n3 == -1) {
                    throw new zzaky("Connection closed before handshake was complete");
                }
                byArray[n2] = (byte)n3;
                if (byArray[++n2 - 1] == 10 && byArray[n2 - 2] == 13) {
                    object2 = new String(byArray, aZA);
                    if (((String)object2).trim().equals("")) {
                        bl = true;
                    } else {
                        arrayList.add(((String)object2).trim());
                    }
                    byArray = new byte[1000];
                    n2 = 0;
                    continue;
                }
                if (n2 != 1000) continue;
                object2 = new String(byArray, aZA);
                String string2 = String.valueOf(object2);
                if (string2.length() != 0) {
                    string = "Unexpected long line in handshake: ".concat(string2);
                    throw new zzaky(string);
                }
                string = new String("Unexpected long line in handshake: ");
                throw new zzaky(string);
            }
            this.aZH.zzro((String)arrayList.get(0));
            arrayList.remove(0);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (String string : arrayList) {
                String[] stringArray = string.split(": ", 2);
                hashMap.put(stringArray[0], stringArray[1]);
            }
            this.aZH.zzc(hashMap);
            this.aZG.zzb(outputStream);
            this.aZF.zza((DataInputStream)object);
            this.aZB = zza.aZP;
            this.aZG.zzcwg().start();
            this.aZD.zzcpk();
            this.aZF.run();
            return;
        }
        catch (zzaky zzaky2) {
            this.aZD.zza(zzaky2);
            return;
        }
        catch (IOException iOException) {
            String string = String.valueOf(iOException.getMessage());
            this.aZD.zza(new zzaky(string.length() != 0 ? "error while connecting: ".concat(string) : new String("error while connecting: "), iOException));
            return;
        }
        finally {
            this.close();
        }
    }

    Thread zzcwg() {
        return this.aZI;
    }

    private static final class zza
    extends Enum<zza> {
        public static final /* enum */ zza aZN = new zza();
        public static final /* enum */ zza aZO = new zza();
        public static final /* enum */ zza aZP = new zza();
        public static final /* enum */ zza aZQ = new zza();
        public static final /* enum */ zza aZR = new zza();
        private static final /* synthetic */ zza[] aZS;

        public static zza[] values() {
            return (zza[])aZS.clone();
        }

        static {
            aZS = new zza[]{aZN, aZO, aZP, aZQ, aZR};
        }
    }
}

