/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzaiu;
import com.google.android.gms.internal.zzaiw;
import com.google.android.gms.internal.zzaje;
import com.google.android.gms.internal.zzalw;
import com.google.android.gms.internal.zzamv;
import com.google.android.gms.internal.zzamw;
import com.google.android.gms.internal.zzamx;
import com.google.android.gms.internal.zzamz;
import com.google.android.gms.internal.zzane;
import java.io.EOFException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

class zzajc {
    private static long bbW = 0L;
    private zzb bbX;
    private boolean bbY = false;
    private boolean bbZ = false;
    private long bca = 0L;
    private zzaje bcb;
    private zza bcc;
    private ScheduledFuture<?> bcd;
    private ScheduledFuture<?> bce;
    private final zzaiu bcf;
    private final ScheduledExecutorService aZE;
    private final zzalw aZR;

    public zzajc(zzaiu zzaiu2, zzaiw zzaiw2, String string, zza zza2, String string2) {
        this.bcf = zzaiu2;
        this.aZE = zzaiu2.zzcsj();
        this.bcc = zza2;
        long l = bbW++;
        this.aZR = new zzalw(zzaiu2.zzcsh(), "WebSocket", new StringBuilder(23).append("ws_").append(l).toString());
        this.bbX = this.zza(zzaiw2, string, string2);
    }

    private zzb zza(zzaiw zzaiw2, String string, String string2) {
        String string3 = string != null ? string : zzaiw2.getHost();
        URI uRI = zzaiw.zza(string3, zzaiw2.isSecure(), zzaiw2.getNamespace(), string2);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("User-Agent", this.bcf.zzux());
        zzamv zzamv2 = new zzamv(uRI, null, hashMap);
        zzc zzc2 = new zzc(zzamv2);
        return zzc2;
    }

    public void open() {
        this.bbX.connect();
        this.bce = this.aZE.schedule(new Runnable(){

            @Override
            public void run() {
                zzajc.this.zzcts();
            }
        }, 30000L, TimeUnit.MILLISECONDS);
    }

    public void start() {
    }

    public void close() {
        if (this.aZR.zzcyu()) {
            this.aZR.zzi("websocket is being closed", new Object[0]);
        }
        this.bbZ = true;
        this.bbX.close();
        if (this.bce != null) {
            this.bce.cancel(true);
        }
        if (this.bcd != null) {
            this.bcd.cancel(true);
        }
    }

    public void send(Map<String, Object> map) {
        this.zzctp();
        try {
            int n;
            String string = zzane.zzce(map);
            String[] stringArray = zzajc.zzae(string, 16384);
            if (stringArray.length > 1) {
                n = stringArray.length;
                this.bbX.zzsp(new StringBuilder(11).append(n).toString());
            }
            for (n = 0; n < stringArray.length; ++n) {
                this.bbX.zzsp(stringArray[n]);
            }
        }
        catch (IOException iOException) {
            String string = String.valueOf(map.toString());
            this.aZR.zzd(string.length() != 0 ? "Failed to serialize message: ".concat(string) : new String("Failed to serialize message: "), iOException);
            this.shutdown();
        }
    }

    private void zzsm(String string) {
        this.bcb.zzsq(string);
        --this.bca;
        if (this.bca == 0L) {
            try {
                this.bcb.zzctz();
                Map<String, Object> map = zzane.zztb(this.bcb.toString());
                this.bcb = null;
                if (this.aZR.zzcyu()) {
                    String string2 = String.valueOf(map);
                    this.aZR.zzi(new StringBuilder(36 + String.valueOf(string2).length()).append("handleIncomingFrame complete frame: ").append(string2).toString(), new Object[0]);
                }
                this.bcc.zzbs(map);
            }
            catch (IOException iOException) {
                String string3 = String.valueOf(this.bcb.toString());
                this.aZR.zzd(string3.length() != 0 ? "Error parsing frame: ".concat(string3) : new String("Error parsing frame: "), iOException);
                this.close();
                this.shutdown();
            }
            catch (ClassCastException classCastException) {
                String string4 = String.valueOf(this.bcb.toString());
                this.aZR.zzd(string4.length() != 0 ? "Error parsing frame (cast error): ".concat(string4) : new String("Error parsing frame (cast error): "), classCastException);
                this.close();
                this.shutdown();
            }
        }
    }

    private void zzaft(int n) {
        this.bca = n;
        this.bcb = new zzaje();
        if (this.aZR.zzcyu()) {
            long l = this.bca;
            this.aZR.zzi(new StringBuilder(41).append("HandleNewFrameCount: ").append(l).toString(), new Object[0]);
        }
    }

    private String zzsn(String string) {
        if (string.length() <= 6) {
            try {
                int n = Integer.parseInt(string);
                if (n > 0) {
                    this.zzaft(n);
                }
                return null;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.zzaft(1);
        return string;
    }

    private void zzso(String string) {
        if (!this.bbZ) {
            this.zzctp();
            if (this.isBuffering()) {
                this.zzsm(string);
            } else {
                String string2 = this.zzsn(string);
                if (string2 != null) {
                    this.zzsm(string2);
                }
            }
        }
    }

    private void zzctp() {
        if (!this.bbZ) {
            if (this.bcd != null) {
                this.bcd.cancel(false);
                if (this.aZR.zzcyu()) {
                    long l = this.bcd.getDelay(TimeUnit.MILLISECONDS);
                    this.aZR.zzi(new StringBuilder(48).append("Reset keepAlive. Remaining: ").append(l).toString(), new Object[0]);
                }
            } else if (this.aZR.zzcyu()) {
                this.aZR.zzi("Reset keepAlive", new Object[0]);
            }
            this.bcd = this.aZE.schedule(this.zzctq(), 45000L, TimeUnit.MILLISECONDS);
        }
    }

    private Runnable zzctq() {
        return new Runnable(){

            @Override
            public void run() {
                if (zzajc.this.bbX != null) {
                    zzajc.this.bbX.zzsp("0");
                    zzajc.this.zzctp();
                }
            }
        };
    }

    private boolean isBuffering() {
        return this.bcb != null;
    }

    private void zzctr() {
        if (!this.bbZ) {
            if (this.aZR.zzcyu()) {
                this.aZR.zzi("closing itself", new Object[0]);
            }
            this.shutdown();
        }
        this.bbX = null;
        if (this.bcd != null) {
            this.bcd.cancel(false);
        }
    }

    private void shutdown() {
        this.bbZ = true;
        this.bcc.zzcw(this.bbY);
    }

    private void zzcts() {
        if (!this.bbY && !this.bbZ) {
            if (this.aZR.zzcyu()) {
                this.aZR.zzi("timed out on connect", new Object[0]);
            }
            this.bbX.close();
        }
    }

    private static String[] zzae(String string, int n) {
        if (string.length() <= n) {
            return new String[]{string};
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < string.length(); i += n) {
            int n2 = Math.min(i + n, string.length());
            String string2 = string.substring(i, n2);
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private class zzc
    implements zzb,
    zzamw {
        private zzamv bch;

        private zzc(zzamv zzamv2) {
            this.bch = zzamv2;
            this.bch.zza(this);
        }

        @Override
        public void zzctt() {
            zzajc.this.aZE.execute(new Runnable(){

                @Override
                public void run() {
                    zzajc.this.bce.cancel(false);
                    zzajc.this.bbY = true;
                    if (zzajc.this.aZR.zzcyu()) {
                        zzajc.this.aZR.zzi("websocket opened", new Object[0]);
                    }
                    zzajc.this.zzctp();
                }
            });
        }

        @Override
        public void zza(zzamz zzamz2) {
            final String string = zzamz2.getText();
            if (zzajc.this.aZR.zzcyu()) {
                String string2 = String.valueOf(string);
                zzajc.this.aZR.zzi(string2.length() != 0 ? "ws message: ".concat(string2) : new String("ws message: "), new Object[0]);
            }
            zzajc.this.aZE.execute(new Runnable(){

                @Override
                public void run() {
                    zzajc.this.zzso(string);
                }
            });
        }

        @Override
        public void onClose() {
            String string = "closed";
            zzajc.this.aZE.execute(new Runnable(){

                @Override
                public void run() {
                    if (zzajc.this.aZR.zzcyu()) {
                        zzajc.this.aZR.zzi("closed", new Object[0]);
                    }
                    zzajc.this.zzctr();
                }
            });
        }

        @Override
        public void zza(final zzamx zzamx2) {
            zzajc.this.aZE.execute(new Runnable(){

                @Override
                public void run() {
                    if (zzamx2.getCause() != null && zzamx2.getCause() instanceof EOFException) {
                        zzajc.this.aZR.zzi("WebSocket reached EOF.", new Object[0]);
                    } else {
                        zzajc.this.aZR.zza("WebSocket error.", zzamx2, new Object[0]);
                    }
                    zzajc.this.zzctr();
                }
            });
        }

        @Override
        public void zzsp(String string) {
            this.bch.zzsp(string);
        }

        @Override
        public void close() {
            this.bch.close();
        }

        private void shutdown() {
            this.bch.close();
            try {
                this.bch.m();
            }
            catch (InterruptedException interruptedException) {
                zzajc.this.aZR.zzd("Interrupted while shutting down websocket threads", interruptedException);
            }
        }

        @Override
        public void connect() {
            try {
                this.bch.connect();
            }
            catch (zzamx zzamx2) {
                if (zzajc.this.aZR.zzcyu()) {
                    zzajc.this.aZR.zza("Error connecting", zzamx2, new Object[0]);
                }
                this.shutdown();
            }
        }
    }

    private static interface zzb {
        public void connect();

        public void close();

        public void zzsp(String var1);
    }

    public static interface zza {
        public void zzbs(Map<String, Object> var1);

        public void zzcw(boolean var1);
    }
}

