/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import com.google.android.gms.internal.zzblz;
import com.google.android.gms.internal.zzbme;
import com.google.android.gms.internal.zzbmj;
import com.google.android.gms.internal.zzbml;
import com.google.android.gms.internal.zzbmz;
import com.google.android.gms.internal.zzbnc;
import com.google.android.gms.internal.zzbod;
import com.google.android.gms.internal.zzboe;
import com.google.android.gms.internal.zzbor;
import com.google.android.gms.internal.zzbos;
import com.google.android.gms.internal.zzbow;
import com.google.android.gms.internal.zzbox;
import com.google.android.gms.internal.zzbpa;
import com.google.android.gms.internal.zzbpe;
import com.google.android.gms.internal.zzbpg;
import com.google.android.gms.internal.zzbph;
import com.google.android.gms.internal.zzbpi;
import com.google.android.gms.internal.zzbpk;
import com.google.android.gms.internal.zzbpl;
import com.google.android.gms.internal.zzbqg;
import com.google.android.gms.internal.zzbqh;
import com.google.firebase.database.ChildEventListener;
import com.google.firebase.database.DataSnapshot;
import com.google.firebase.database.DatabaseError;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.ValueEventListener;

public class Query {
    protected final zzbml zzbXR;
    protected final zzbmj zzbXY;
    protected final zzbod zzbYc;
    private final boolean zzbYd;

    Query(zzbml zzbml2, zzbmj zzbmj2, zzbod zzbod2, boolean bl) throws DatabaseException {
        this.zzbXR = zzbml2;
        this.zzbXY = zzbmj2;
        this.zzbYc = zzbod2;
        this.zzbYd = bl;
        zzbqg.zzb(zzbod2.isValid(), "Validation of queries failed.");
    }

    Query(zzbml zzbml2, zzbmj zzbmj2) {
        this.zzbXR = zzbml2;
        this.zzbXY = zzbmj2;
        this.zzbYc = zzbod.zzcfX;
        this.zzbYd = false;
    }

    private void zza(zzbod zzbod2) {
        if (zzbod2.zzYz().equals(zzbpa.zzZw())) {
            zzbos zzbos2;
            zzbpe zzbpe2;
            String string = "You must use startAt(String value), endAt(String value) or equalTo(String value) in combination with orderByKey(). Other type of values or using the version with 2 parameters is not supported";
            if (zzbod2.zzYr()) {
                zzbpe2 = zzbod2.zzYs();
                zzbos2 = zzbod2.zzYt();
                if (zzbos2 != zzbos.zzYW() || !(zzbpe2 instanceof zzbpk)) {
                    throw new IllegalArgumentException(string);
                }
            }
            if (zzbod2.zzYu()) {
                zzbpe2 = zzbod2.zzYv();
                zzbos2 = zzbod2.zzYw();
                if (zzbos2 != zzbos.zzYX() || !(zzbpe2 instanceof zzbpk)) {
                    throw new IllegalArgumentException(string);
                }
            }
        } else if (zzbod2.zzYz().equals(zzbph.zzZA()) && (zzbod2.zzYr() && !zzbpi.zzq(zzbod2.zzYs()) || zzbod2.zzYu() && !zzbpi.zzq(zzbod2.zzYv()))) {
            throw new IllegalArgumentException("When using orderByPriority(), values provided to startAt(), endAt(), or equalTo() must be valid priorities.");
        }
    }

    private void zzb(zzbod zzbod2) {
        if (zzbod2.zzYr() && zzbod2.zzYu() && zzbod2.zzYx() && !zzbod2.zzYy()) {
            throw new IllegalArgumentException("Can't combine startAt(), endAt() and limit(). Use limitToFirst() or limitToLast() instead");
        }
    }

    private void zzVa() {
        if (this.zzbYc.zzYr()) {
            throw new IllegalArgumentException("Can't call equalTo() and startAt() combined");
        }
        if (this.zzbYc.zzYu()) {
            throw new IllegalArgumentException("Can't call equalTo() and endAt() combined");
        }
    }

    private void zzVb() {
        if (this.zzbYd) {
            throw new IllegalArgumentException("You can't combine multiple orderBy calls!");
        }
    }

    public ValueEventListener addValueEventListener(ValueEventListener valueEventListener) {
        this.zzb(new zzbmz(this.zzbXR, valueEventListener, this.zzVd()));
        return valueEventListener;
    }

    public ChildEventListener addChildEventListener(ChildEventListener childEventListener) {
        this.zzb(new zzblz(this.zzbXR, childEventListener, this.zzVd()));
        return childEventListener;
    }

    public void addListenerForSingleValueEvent(final ValueEventListener valueEventListener) {
        this.zzb(new zzbmz(this.zzbXR, new ValueEventListener(){

            @Override
            public void onDataChange(DataSnapshot dataSnapshot) {
                Query.this.removeEventListener(this);
                valueEventListener.onDataChange(dataSnapshot);
            }

            @Override
            public void onCancelled(DatabaseError databaseError) {
                valueEventListener.onCancelled(databaseError);
            }
        }, this.zzVd()));
    }

    public void removeEventListener(ValueEventListener valueEventListener) {
        if (valueEventListener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.zza(new zzbmz(this.zzbXR, valueEventListener, this.zzVd()));
    }

    public void removeEventListener(ChildEventListener childEventListener) {
        if (childEventListener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.zza(new zzblz(this.zzbXR, childEventListener, this.zzVd()));
    }

    private void zza(final zzbme zzbme2) {
        zzbnc.zzXK().zzk(zzbme2);
        this.zzbXR.zzs(new Runnable(){

            @Override
            public void run() {
                Query.this.zzbXR.zze(zzbme2);
            }
        });
    }

    private void zzb(final zzbme zzbme2) {
        zzbnc.zzXK().zzi(zzbme2);
        this.zzbXR.zzs(new Runnable(){

            @Override
            public void run() {
                Query.this.zzbXR.zzf(zzbme2);
            }
        });
    }

    public void keepSynced(final boolean bl) {
        if (!this.zzbXY.isEmpty() && this.zzbXY.zzXi().equals(zzbos.zzYZ())) {
            throw new DatabaseException("Can't call keepSynced() on .info paths.");
        }
        this.zzbXR.zzs(new Runnable(){

            @Override
            public void run() {
                Query.this.zzbXR.zza(Query.this.zzVd(), bl);
            }
        });
    }

    public Query startAt(String string) {
        return this.startAt(string, null);
    }

    public Query startAt(double d) {
        return this.startAt(d, null);
    }

    public Query startAt(boolean bl) {
        return this.startAt(bl, null);
    }

    public Query startAt(String string, String string2) {
        zzbpe zzbpe2 = string != null ? new zzbpk(string, zzbpi.zzZB()) : zzbox.zzZp();
        return this.zza(zzbpe2, string2);
    }

    public Query startAt(double d, String string) {
        return this.zza(new zzbow(d, zzbpi.zzZB()), string);
    }

    public Query startAt(boolean bl, String string) {
        return this.zza(new zzbor(bl, zzbpi.zzZB()), string);
    }

    private Query zza(zzbpe zzbpe2, String string) {
        zzbqh.zzjq(string);
        if (!zzbpe2.zzZd() && !zzbpe2.isEmpty()) {
            throw new IllegalArgumentException("Can only use simple values for startAt()");
        }
        if (this.zzbYc.zzYr()) {
            throw new IllegalArgumentException("Can't call startAt() or equalTo() multiple times");
        }
        zzbos zzbos2 = string != null ? zzbos.zzjb(string) : null;
        zzbod zzbod2 = this.zzbYc.zza(zzbpe2, zzbos2);
        this.zzb(zzbod2);
        this.zza(zzbod2);
        assert (zzbod2.isValid());
        return new Query(this.zzbXR, this.zzbXY, zzbod2, this.zzbYd);
    }

    public Query endAt(String string) {
        return this.endAt(string, null);
    }

    public Query endAt(double d) {
        return this.endAt(d, null);
    }

    public Query endAt(boolean bl) {
        return this.endAt(bl, null);
    }

    public Query endAt(String string, String string2) {
        zzbpe zzbpe2 = string != null ? new zzbpk(string, zzbpi.zzZB()) : zzbox.zzZp();
        return this.zzb(zzbpe2, string2);
    }

    public Query endAt(double d, String string) {
        return this.zzb(new zzbow(d, zzbpi.zzZB()), string);
    }

    public Query endAt(boolean bl, String string) {
        return this.zzb(new zzbor(bl, zzbpi.zzZB()), string);
    }

    private Query zzb(zzbpe zzbpe2, String string) {
        zzbos zzbos2;
        zzbqh.zzjq(string);
        if (!zzbpe2.zzZd() && !zzbpe2.isEmpty()) {
            throw new IllegalArgumentException("Can only use simple values for endAt()");
        }
        zzbos zzbos3 = zzbos2 = string != null ? zzbos.zzjb(string) : null;
        if (this.zzbYc.zzYu()) {
            throw new IllegalArgumentException("Can't call endAt() or equalTo() multiple times");
        }
        zzbod zzbod2 = this.zzbYc.zzb(zzbpe2, zzbos2);
        this.zzb(zzbod2);
        this.zza(zzbod2);
        assert (zzbod2.isValid());
        return new Query(this.zzbXR, this.zzbXY, zzbod2, this.zzbYd);
    }

    public Query equalTo(String string) {
        this.zzVa();
        return this.startAt(string).endAt(string);
    }

    public Query equalTo(double d) {
        this.zzVa();
        return this.startAt(d).endAt(d);
    }

    public Query equalTo(boolean bl) {
        this.zzVa();
        return this.startAt(bl).endAt(bl);
    }

    public Query equalTo(String string, String string2) {
        this.zzVa();
        return this.startAt(string, string2).endAt(string, string2);
    }

    public Query equalTo(double d, String string) {
        this.zzVa();
        return this.startAt(d, string).endAt(d, string);
    }

    public Query equalTo(boolean bl, String string) {
        this.zzVa();
        return this.startAt(bl, string).endAt(bl, string);
    }

    public Query limitToFirst(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Limit must be a positive integer!");
        }
        if (this.zzbYc.zzYx()) {
            throw new IllegalArgumentException("Can't call limitToLast on query with previously set limit!");
        }
        return new Query(this.zzbXR, this.zzbXY, this.zzbYc.zzpO(n), this.zzbYd);
    }

    public Query limitToLast(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Limit must be a positive integer!");
        }
        if (this.zzbYc.zzYx()) {
            throw new IllegalArgumentException("Can't call limitToLast on query with previously set limit!");
        }
        return new Query(this.zzbXR, this.zzbXY, this.zzbYc.zzpP(n), this.zzbYd);
    }

    public Query orderByChild(String string) {
        if (string == null) {
            throw new NullPointerException("Key can't be null");
        }
        if (string.equals("$key") || string.equals(".key")) {
            throw new IllegalArgumentException(new StringBuilder(54 + String.valueOf(string).length()).append("Can't use '").append(string).append("' as path, please use orderByKey() instead!").toString());
        }
        if (string.equals("$priority") || string.equals(".priority")) {
            throw new IllegalArgumentException(new StringBuilder(59 + String.valueOf(string).length()).append("Can't use '").append(string).append("' as path, please use orderByPriority() instead!").toString());
        }
        if (string.equals("$value") || string.equals(".value")) {
            throw new IllegalArgumentException(new StringBuilder(56 + String.valueOf(string).length()).append("Can't use '").append(string).append("' as path, please use orderByValue() instead!").toString());
        }
        zzbqh.zzjm(string);
        this.zzVb();
        zzbmj zzbmj2 = new zzbmj(string);
        if (zzbmj2.size() == 0) {
            throw new IllegalArgumentException("Can't use empty path, use orderByValue() instead!");
        }
        zzbpg zzbpg2 = new zzbpg(zzbmj2);
        return new Query(this.zzbXR, this.zzbXY, this.zzbYc.zza(zzbpg2), true);
    }

    public Query orderByPriority() {
        this.zzVb();
        zzbod zzbod2 = this.zzbYc.zza(zzbph.zzZA());
        this.zza(zzbod2);
        return new Query(this.zzbXR, this.zzbXY, zzbod2, true);
    }

    public Query orderByKey() {
        this.zzVb();
        zzbod zzbod2 = this.zzbYc.zza(zzbpa.zzZw());
        this.zza(zzbod2);
        return new Query(this.zzbXR, this.zzbXY, zzbod2, true);
    }

    public Query orderByValue() {
        this.zzVb();
        return new Query(this.zzbXR, this.zzbXY, this.zzbYc.zza(zzbpl.zzZC()), true);
    }

    public DatabaseReference getRef() {
        return new DatabaseReference(this.zzbXR, this.zzVc());
    }

    public zzbmj zzVc() {
        return this.zzbXY;
    }

    public zzboe zzVd() {
        return new zzboe(this.zzbXY, this.zzbYc);
    }
}

