/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabaseLockedException;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import com.google.android.gms.internal.zzbma;
import com.google.android.gms.internal.zzbmc;
import com.google.android.gms.internal.zzbmj;
import com.google.android.gms.internal.zzbmx;
import com.google.android.gms.internal.zzbno;
import com.google.android.gms.internal.zzbnp;
import com.google.android.gms.internal.zzbnq;
import com.google.android.gms.internal.zzbns;
import com.google.android.gms.internal.zzboe;
import com.google.android.gms.internal.zzbop;
import com.google.android.gms.internal.zzbos;
import com.google.android.gms.internal.zzbot;
import com.google.android.gms.internal.zzbox;
import com.google.android.gms.internal.zzbpd;
import com.google.android.gms.internal.zzbpe;
import com.google.android.gms.internal.zzbpf;
import com.google.android.gms.internal.zzbpx;
import com.google.android.gms.internal.zzbqb;
import com.google.android.gms.internal.zzbqd;
import com.google.android.gms.internal.zzbqg;
import com.google.firebase.database.DatabaseException;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class zzbky
implements zzbno {
    private static final Charset zzavy = Charset.forName("UTF-8");
    private final SQLiteDatabase zzbYw;
    private final zzbop zzbYx;
    private boolean zzbYy;
    private long zzbYz = 0L;

    public zzbky(Context context, zzbmc zzbmc2, String string) {
        String string2;
        try {
            string2 = URLEncoder.encode(string, "utf-8");
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.zzbYx = zzbmc2.zziW("Persistence");
        this.zzbYw = this.zzJ(context, string2);
    }

    @Override
    public void zza(zzbmj zzbmj2, zzbpe zzbpe2, long l) {
        this.zzVi();
        long l2 = System.currentTimeMillis();
        byte[] byArray = this.zzad(zzbpe2.getValue(true));
        this.zza(zzbmj2, l, "o", byArray);
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzbYx.zzYT()) {
            this.zzbYx.zzi(String.format("Persisted user overwrite in %dms", l3), new Object[0]);
        }
    }

    @Override
    public void zza(zzbmj zzbmj2, zzbma zzbma2, long l) {
        this.zzVi();
        long l2 = System.currentTimeMillis();
        byte[] byArray = this.zzad(zzbma2.zzaZ(true));
        this.zza(zzbmj2, l, "m", byArray);
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzbYx.zzYT()) {
            this.zzbYx.zzi(String.format("Persisted user merge in %dms", l3), new Object[0]);
        }
    }

    @Override
    public void zzaA(long l) {
        this.zzVi();
        long l2 = System.currentTimeMillis();
        int n = this.zzbYw.delete("writes", "id = ?", new String[]{String.valueOf(l)});
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzbYx.zzYT()) {
            this.zzbYx.zzi(String.format("Deleted %d write(s) with writeId %d in %dms", n, l, l3), new Object[0]);
        }
    }

    @Override
    public List<zzbmx> zzVe() {
        String[] stringArray = new String[]{"id", "path", "type", "part", "node"};
        long l = System.currentTimeMillis();
        ArrayList<zzbmx> arrayList = new ArrayList<zzbmx>();
        try (Cursor cursor = this.zzbYw.query("writes", stringArray, null, null, null, null, "id, part");){
            ArrayList<zzbmx> arrayList2;
            long l2;
            while (cursor.moveToNext()) {
                zzbmx zzbmx2;
                Iterable<zzbpd> iterable;
                Object object;
                byte[] byArray;
                l2 = cursor.getLong(0);
                arrayList2 = new zzbmj(cursor.getString(1));
                String string = cursor.getString(2);
                if (cursor.isNull(3)) {
                    byArray = cursor.getBlob(4);
                } else {
                    object = new ArrayList<byte[]>();
                    do {
                        object.add(cursor.getBlob(4));
                    } while (cursor.moveToNext() && cursor.getLong(0) == l2);
                    cursor.moveToPrevious();
                    byArray = this.zzS((List<byte[]>)object);
                }
                object = new String(byArray, zzavy);
                Object object2 = zzbpx.zzjg((String)object);
                if ("o".equals(string)) {
                    iterable = zzbpf.zzar(object2);
                    zzbmx2 = new zzbmx(l2, (zzbmj)((Object)arrayList2), (zzbpe)iterable, true);
                } else if ("m".equals(string)) {
                    iterable = zzbma.zzaA((Map)object2);
                    zzbmx2 = new zzbmx(l2, (zzbmj)((Object)arrayList2), (zzbma)iterable);
                } else {
                    String string2 = String.valueOf(string);
                    throw new IllegalStateException(string2.length() != 0 ? "Got invalid write type: ".concat(string2) : new String("Got invalid write type: "));
                }
                arrayList.add(zzbmx2);
            }
            l2 = System.currentTimeMillis() - l;
            if (this.zzbYx.zzYT()) {
                this.zzbYx.zzi(String.format("Loaded %d writes in %dms", arrayList.size(), l2), new Object[0]);
            }
            arrayList2 = arrayList;
            return arrayList2;
        }
    }

    private void zza(zzbmj zzbmj2, long l, String string, byte[] byArray) {
        this.zzVi();
        this.zzbYw.delete("writes", "id = ?", new String[]{String.valueOf(l)});
        if (byArray.length >= 262144) {
            List<byte[]> list = zzbky.zzd(byArray, 262144);
            for (int i = 0; i < list.size(); ++i) {
                ContentValues contentValues = new ContentValues();
                contentValues.put("id", Long.valueOf(l));
                contentValues.put("path", zzbky.zzc(zzbmj2));
                contentValues.put("type", string);
                contentValues.put("part", Integer.valueOf(i));
                contentValues.put("node", list.get(i));
                this.zzbYw.insertWithOnConflict("writes", null, contentValues, 5);
            }
        } else {
            ContentValues contentValues = new ContentValues();
            contentValues.put("id", Long.valueOf(l));
            contentValues.put("path", zzbky.zzc(zzbmj2));
            contentValues.put("type", string);
            contentValues.put("part", null);
            contentValues.put("node", byArray);
            this.zzbYw.insertWithOnConflict("writes", null, contentValues, 5);
        }
    }

    @Override
    public zzbpe zza(zzbmj zzbmj2) {
        return this.zzb(zzbmj2);
    }

    @Override
    public void zza(zzbmj zzbmj2, zzbpe zzbpe2) {
        this.zzVi();
        this.zza(zzbmj2, zzbpe2, false);
    }

    @Override
    public void zzb(zzbmj zzbmj2, zzbpe zzbpe2) {
        this.zzVi();
        this.zza(zzbmj2, zzbpe2, true);
    }

    private void zza(zzbmj zzbmj2, zzbpe zzbpe2, boolean bl) {
        int n;
        int n2;
        long l = System.currentTimeMillis();
        if (!bl) {
            n2 = this.zza("serverCache", zzbmj2);
            n = this.zzc(zzbmj2, zzbpe2);
        } else {
            n2 = 0;
            n = 0;
            for (zzbpd zzbpd2 : zzbpe2) {
                n2 += this.zza("serverCache", zzbmj2.zza(zzbpd2.zzZz()));
                n += this.zzc(zzbmj2.zza(zzbpd2.zzZz()), zzbpd2.zzUY());
            }
        }
        long l2 = System.currentTimeMillis() - l;
        if (this.zzbYx.zzYT()) {
            this.zzbYx.zzi(String.format("Persisted a total of %d rows and deleted %d rows for a set at %s in %dms", n, n2, zzbmj2.toString(), l2), new Object[0]);
        }
    }

    @Override
    public void zza(zzbmj zzbmj2, zzbma zzbma2) {
        this.zzVi();
        long l = System.currentTimeMillis();
        int n = 0;
        int n2 = 0;
        for (Map.Entry<zzbmj, zzbpe> entry : zzbma2) {
            n2 += this.zza("serverCache", zzbmj2.zzh(entry.getKey()));
            n += this.zzc(zzbmj2.zzh(entry.getKey()), entry.getValue());
        }
        long l2 = System.currentTimeMillis() - l;
        if (this.zzbYx.zzYT()) {
            this.zzbYx.zzi(String.format("Persisted a total of %d rows and deleted %d rows for a merge at %s in %dms", n, n2, zzbmj2.toString(), l2), new Object[0]);
        }
    }

    @Override
    public long zzVf() {
        String string = String.format("SELECT sum(length(%s) + length(%s)) FROM %s", "value", "path", "serverCache");
        try (Cursor cursor = this.zzbYw.rawQuery(string, null);){
            if (cursor.moveToFirst()) {
                long l = cursor.getLong(0);
                return l;
            }
            throw new IllegalStateException("Couldn't read database result!");
        }
    }

    @Override
    public void zza(zzbnq zzbnq2) {
        this.zzVi();
        long l = System.currentTimeMillis();
        ContentValues contentValues = new ContentValues();
        contentValues.put("id", Long.valueOf(zzbnq2.id));
        contentValues.put("path", zzbky.zzc(zzbnq2.zzcfe.zzVc()));
        contentValues.put("queryParams", zzbnq2.zzcfe.zzYG().zzYE());
        contentValues.put("lastUse", Long.valueOf(zzbnq2.zzcff));
        contentValues.put("complete", Boolean.valueOf(zzbnq2.zzcfg));
        contentValues.put("active", Boolean.valueOf(zzbnq2.zzcfh));
        this.zzbYw.insertWithOnConflict("trackedQueries", null, contentValues, 5);
        long l2 = System.currentTimeMillis() - l;
        if (this.zzbYx.zzYT()) {
            this.zzbYx.zzi(String.format("Saved new tracked query in %dms", l2), new Object[0]);
        }
    }

    @Override
    public void zzaB(long l) {
        this.zzVi();
        String string = String.valueOf(l);
        String string2 = "id = ?";
        this.zzbYw.delete("trackedQueries", string2, new String[]{string});
        String string3 = "id = ?";
        this.zzbYw.delete("trackedKeys", string3, new String[]{string});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<zzbnq> zzVg() {
        String[] stringArray = new String[]{"id", "path", "queryParams", "lastUse", "complete", "active"};
        long l = System.currentTimeMillis();
        ArrayList<zzbnq> arrayList = new ArrayList<zzbnq>();
        try (Cursor cursor = this.zzbYw.query("trackedQueries", stringArray, null, null, null, null, "id");){
            ArrayList<zzbnq> arrayList2;
            long l2;
            while (cursor.moveToNext()) {
                Map map;
                l2 = cursor.getLong(0);
                arrayList2 = new zzbmj(cursor.getString(1));
                String string = cursor.getString(2);
                try {
                    map = zzbpx.zzjf((String)string);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
                zzboe zzboe2 = zzboe.zzb(arrayList2, map);
                long l3 = cursor.getLong(3);
                boolean bl = cursor.getInt(4) != 0;
                boolean bl2 = cursor.getInt(5) != 0;
                zzbnq zzbnq2 = new zzbnq(l2, zzboe2, l3, bl, bl2);
                arrayList.add(zzbnq2);
            }
            l2 = System.currentTimeMillis() - l;
            if (this.zzbYx.zzYT()) {
                this.zzbYx.zzi(String.format("Loaded %d tracked queries in %dms", arrayList.size(), l2), new Object[0]);
            }
            arrayList2 = arrayList;
            return arrayList2;
        }
    }

    @Override
    public void zzaC(long l) {
        this.zzVi();
        long l2 = System.currentTimeMillis();
        String string = "active = 1";
        ContentValues contentValues = new ContentValues();
        contentValues.put("active", Boolean.valueOf(false));
        contentValues.put("lastUse", Long.valueOf(l));
        this.zzbYw.updateWithOnConflict("trackedQueries", contentValues, string, new String[0], 5);
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzbYx.zzYT()) {
            this.zzbYx.zzi(String.format("Reset active tracked queries in %dms", l3), new Object[0]);
        }
    }

    @Override
    public void zza(long l, Set<zzbos> set) {
        this.zzVi();
        long l2 = System.currentTimeMillis();
        String string = String.valueOf(l);
        String string2 = "id = ?";
        this.zzbYw.delete("trackedKeys", string2, new String[]{string});
        for (zzbos zzbos2 : set) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("id", Long.valueOf(l));
            contentValues.put("key", zzbos2.asString());
            this.zzbYw.insertWithOnConflict("trackedKeys", null, contentValues, 5);
        }
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzbYx.zzYT()) {
            this.zzbYx.zzi(String.format("Set %d tracked query keys for tracked query %d in %dms", set.size(), l, l3), new Object[0]);
        }
    }

    @Override
    public void zza(long l, Set<zzbos> set, Set<zzbos> set2) {
        this.zzVi();
        long l2 = System.currentTimeMillis();
        String string = "id = ? AND key = ?";
        String string2 = String.valueOf(l);
        for (zzbos zzbos2 : set2) {
            this.zzbYw.delete("trackedKeys", string, new String[]{string2, zzbos2.asString()});
        }
        for (zzbos zzbos2 : set) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("id", Long.valueOf(l));
            contentValues.put("key", zzbos2.asString());
            this.zzbYw.insertWithOnConflict("trackedKeys", null, contentValues, 5);
        }
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzbYx.zzYT()) {
            this.zzbYx.zzi(String.format("Updated tracked query keys (%d added, %d removed) for tracked query id %d in %dms", set.size(), set2.size(), l, l3), new Object[0]);
        }
    }

    @Override
    public Set<zzbos> zzaD(long l) {
        return this.zzg(Collections.singleton(l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<zzbos> zzg(Set<Long> set) {
        String[] stringArray = new String[]{"key"};
        long l = System.currentTimeMillis();
        String string = String.valueOf("id IN (");
        Object object = String.valueOf(this.zzp(set));
        String string2 = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(object).length()).append(string).append((String)object).append(")").toString();
        string = this.zzbYw.query(true, "trackedKeys", stringArray, string2, null, null, null, null, null);
        object = new HashSet();
        try {
            while (string.moveToNext()) {
                String string3 = string.getString(0);
                object.add(zzbos.zzjb(string3));
            }
            long l2 = System.currentTimeMillis() - l;
            if (this.zzbYx.zzYT()) {
                this.zzbYx.zzi(String.format("Loaded %d tracked queries keys for tracked queries %s in %dms", object.size(), set.toString(), l2), new Object[0]);
            }
            Object object2 = object;
            return object2;
        }
        finally {
            string.close();
        }
    }

    @Override
    public void zza(zzbmj zzbmj2, zzbnp zzbnp2) {
        Object object;
        String string;
        Iterable<Object> iterable;
        Iterable<zzbos> iterable2;
        if (!zzbnp2.zzXY()) {
            return;
        }
        this.zzVi();
        long l = System.currentTimeMillis();
        Cursor cursor = this.zza(zzbmj2, new String[]{"rowid", "path"});
        zzbns<Object> zzbns2 = new zzbns<Object>(null);
        zzbns<Object> zzbns3 = new zzbns<Object>(null);
        while (cursor.moveToNext()) {
            long l2 = cursor.getLong(0);
            iterable2 = new zzbmj(cursor.getString(1));
            if (!zzbmj2.zzi((zzbmj)iterable2)) {
                iterable = String.valueOf(zzbmj2);
                string = String.valueOf(iterable2);
                this.zzbYx.warn(new StringBuilder(67 + String.valueOf(iterable).length() + String.valueOf(string).length()).append("We are pruning at ").append((String)((Object)iterable)).append(" but we have data stored higher up at ").append(string).append(". Ignoring.").toString());
                continue;
            }
            iterable = zzbmj.zza(zzbmj2, (zzbmj)iterable2);
            if (zzbnp2.zzw((zzbmj)iterable)) {
                zzbns2 = zzbns2.zzb((zzbmj)iterable, l2);
                continue;
            }
            if (zzbnp2.zzx((zzbmj)iterable)) {
                zzbns3 = zzbns3.zzb((zzbmj)iterable, l2);
                continue;
            }
            string = String.valueOf(zzbmj2);
            object = String.valueOf(iterable2);
            this.zzbYx.warn(new StringBuilder(88 + String.valueOf(string).length() + String.valueOf(object).length()).append("We are pruning at ").append(string).append(" and have data at ").append((String)object).append(" that isn't marked for pruning or keeping. Ignoring.").toString());
        }
        int n = 0;
        int n2 = 0;
        if (!zzbns2.isEmpty()) {
            iterable2 = new ArrayList();
            this.zza(zzbmj2, zzbmj.zzXf(), zzbns2, zzbns3, zzbnp2, (List<zzbqd<zzbmj, zzbpe>>)iterable2);
            iterable = zzbns2.values();
            object = String.valueOf(this.zzp((Collection<Long>)iterable));
            string = new StringBuilder(11 + String.valueOf(object).length()).append("rowid IN (").append((String)object).append(")").toString();
            this.zzbYw.delete("serverCache", string, null);
            for (zzbqd zzbqd2 : iterable2) {
                this.zzc(zzbmj2.zzh((zzbmj)zzbqd2.getFirst()), (zzbpe)zzbqd2.zzZZ());
            }
            n = iterable.size();
            n2 = iterable2.size();
        }
        long l3 = System.currentTimeMillis() - l;
        if (this.zzbYx.zzYT()) {
            this.zzbYx.zzi(String.format("Pruned %d rows with %d nodes resaved in %dms", n, n2, l3), new Object[0]);
        }
    }

    private void zza(zzbmj zzbmj2, final zzbmj zzbmj3, zzbns<Long> zzbns2, final zzbns<Long> zzbns3, zzbnp zzbnp2, final List<zzbqd<zzbmj, zzbpe>> list) {
        if (zzbns2.getValue() != null) {
            int n = zzbnp2.zza(0, new zzbns.zza<Void, Integer>(this){

                @Override
                public Integer zza(zzbmj zzbmj2, Void void_, Integer n) {
                    return zzbns3.zzK(zzbmj2) == null ? n + 1 : n;
                }
            });
            if (n > 0) {
                zzbmj zzbmj4 = zzbmj2.zzh(zzbmj3);
                if (this.zzbYx.zzYT()) {
                    this.zzbYx.zzi(String.format("Need to rewrite %d nodes below path %s", n, zzbmj4), new Object[0]);
                }
                final zzbpe zzbpe2 = this.zzb(zzbmj4);
                zzbnp2.zza(null, new zzbns.zza<Void, Void>(this){

                    @Override
                    public Void zza(zzbmj zzbmj2, Void void_, Void void_2) {
                        if (zzbns3.zzK(zzbmj2) == null) {
                            list.add(new zzbqd<zzbmj, zzbpe>(zzbmj3.zzh(zzbmj2), zzbpe2.zzO(zzbmj2)));
                        }
                        return null;
                    }
                });
            }
        } else {
            for (Map.Entry<zzbos, zzbns<Long>> entry : zzbns2.zzYe()) {
                zzbos zzbos2 = entry.getKey();
                zzbnp zzbnp3 = zzbnp2.zzd(entry.getKey());
                this.zza(zzbmj2, zzbmj3.zza(zzbos2), entry.getValue(), zzbns3.zze(zzbos2), zzbnp3, list);
            }
        }
    }

    @Override
    public void zzVh() {
        this.zzVi();
        long l = System.currentTimeMillis();
        int n = this.zzbYw.delete("writes", null, null);
        long l2 = System.currentTimeMillis() - l;
        if (this.zzbYx.zzYT()) {
            this.zzbYx.zzi(String.format("Deleted %d (all) write(s) in %dms", n, l2), new Object[0]);
        }
    }

    @Override
    public void beginTransaction() {
        zzbqg.zzb(!this.zzbYy, "runInTransaction called when an existing transaction is already in progress.");
        if (this.zzbYx.zzYT()) {
            this.zzbYx.zzi("Starting transaction.", new Object[0]);
        }
        this.zzbYw.beginTransaction();
        this.zzbYy = true;
        this.zzbYz = System.currentTimeMillis();
    }

    @Override
    public void endTransaction() {
        this.zzbYw.endTransaction();
        this.zzbYy = false;
        long l = System.currentTimeMillis() - this.zzbYz;
        if (this.zzbYx.zzYT()) {
            this.zzbYx.zzi(String.format("Transaction completed. Elapsed: %dms", l), new Object[0]);
        }
    }

    @Override
    public void setTransactionSuccessful() {
        this.zzbYw.setTransactionSuccessful();
    }

    private SQLiteDatabase zzJ(Context context, String string) {
        zza zza2 = new zza(context, string);
        try {
            SQLiteDatabase sQLiteDatabase = zza2.getWritableDatabase();
            sQLiteDatabase.rawQuery("PRAGMA locking_mode = EXCLUSIVE", null).close();
            sQLiteDatabase.beginTransaction();
            sQLiteDatabase.endTransaction();
            return sQLiteDatabase;
        }
        catch (SQLiteException sQLiteException) {
            if (sQLiteException instanceof SQLiteDatabaseLockedException) {
                String string2 = "Failed to gain exclusive lock to Firebase Database's offline persistence. This generally means you are using Firebase Database from multiple processes in your app. Keep in mind that multi-process Android apps execute the code in your Application class in all processes, so you may need to avoid initializing FirebaseDatabase in your Application class. If you are intentionally using Firebase Database from multiple processes, you can only enable offline persistence (i.e. call setPersistenceEnabled(true)) in one of them.";
                throw new DatabaseException(string2, sQLiteException);
            }
            throw sQLiteException;
        }
    }

    private void zzVi() {
        zzbqg.zzb(this.zzbYy, "Transaction expected to already be in progress.");
    }

    private int zzc(zzbmj zzbmj2, zzbpe zzbpe2) {
        long l = zzbqb.zzt(zzbpe2);
        if (zzbpe2 instanceof zzbot && l > 16384L) {
            if (this.zzbYx.zzYT()) {
                this.zzbYx.zzi(String.format("Node estimated serialized size at path %s of %d bytes exceeds limit of %d bytes. Splitting up.", zzbmj2, l, 16384), new Object[0]);
            }
            int n = 0;
            for (zzbpd zzbpd2 : zzbpe2) {
                n += this.zzc(zzbmj2.zza(zzbpd2.zzZz()), zzbpd2.zzUY());
            }
            if (!zzbpe2.zzZe().isEmpty()) {
                this.zzd(zzbmj2.zza(zzbos.zzYY()), zzbpe2.zzZe());
                ++n;
            }
            this.zzd(zzbmj2, zzbox.zzZp());
            return ++n;
        }
        this.zzd(zzbmj2, zzbpe2);
        return 1;
    }

    private String zza(zzbmj zzbmj2, int n) {
        String string = String.valueOf(zzbky.zzc(zzbmj2));
        String string2 = String.valueOf(String.format(".part-%04d", n));
        return string2.length() != 0 ? string.concat(string2) : new String(string);
    }

    private void zzd(zzbmj zzbmj2, zzbpe zzbpe2) {
        byte[] byArray = this.zzad(zzbpe2.getValue(true));
        if (byArray.length >= 262144) {
            int n;
            List<byte[]> list = zzbky.zzd(byArray, 262144);
            if (this.zzbYx.zzYT()) {
                n = list.size();
                this.zzbYx.zzi(new StringBuilder(45).append("Saving huge leaf node with ").append(n).append(" parts.").toString(), new Object[0]);
            }
            for (n = 0; n < list.size(); ++n) {
                ContentValues contentValues = new ContentValues();
                contentValues.put("path", this.zza(zzbmj2, n));
                contentValues.put("value", list.get(n));
                this.zzbYw.insertWithOnConflict("serverCache", null, contentValues, 5);
            }
        } else {
            ContentValues contentValues = new ContentValues();
            contentValues.put("path", zzbky.zzc(zzbmj2));
            contentValues.put("value", byArray);
            this.zzbYw.insertWithOnConflict("serverCache", null, contentValues, 5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private zzbpe zzb(zzbmj zzbmj2) {
        zzbmj zzbmj3;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<byte[]> arrayList2 = new ArrayList<byte[]>();
        long l = System.currentTimeMillis();
        Cursor cursor = this.zza(zzbmj2, new String[]{"path", "value"});
        long l2 = System.currentTimeMillis() - l;
        long l3 = System.currentTimeMillis();
        try {
            while (cursor.moveToNext()) {
                arrayList.add(cursor.getString(0));
                arrayList2.add(cursor.getBlob(1));
            }
        }
        finally {
            cursor.close();
        }
        long l4 = System.currentTimeMillis() - l3;
        long l5 = System.currentTimeMillis();
        zzbpe zzbpe2 = zzbox.zzZp();
        boolean bl = false;
        HashMap<zzbmj, void> hashMap = new HashMap<zzbmj, void>();
        for (int i = 0; i < arrayList2.size(); ++i) {
            void object;
            Object object2;
            if (((String)arrayList.get(i)).endsWith(".part-0000")) {
                object2 = (String)arrayList.get(i);
                zzbmj3 = new zzbmj(((String)object2).substring(0, ((String)object2).length() - ".part-0000".length()));
                int n = this.zza(zzbmj3, arrayList, i);
                if (this.zzbYx.zzYT()) {
                    this.zzbYx.zzi(new StringBuilder(42).append("Loading split node with ").append(n).append(" parts.").toString(), new Object[0]);
                }
                zzbpe zzbpe3 = this.zzT(this.zzS(arrayList2.subList(i, i + n)));
                i = i + n - 1;
            } else {
                zzbpe zzbpe4 = this.zzT((byte[])arrayList2.get(i));
                zzbmj3 = new zzbmj((String)arrayList.get(i));
            }
            if (zzbmj3.zzXl() != null && zzbmj3.zzXl().zzZa()) {
                hashMap.put(zzbmj3, object);
                continue;
            }
            if (zzbmj3.zzi(zzbmj2)) {
                zzbqg.zzb(!bl, "Descendants of path must come after ancestors.");
                zzbpe2 = object.zzO(zzbmj.zza(zzbmj3, zzbmj2));
                continue;
            }
            if (zzbmj2.zzi(zzbmj3)) {
                bl = true;
                object2 = zzbmj.zza(zzbmj2, zzbmj3);
                zzbpe2 = zzbpe2.zzl((zzbmj)object2, (zzbpe)object);
                continue;
            }
            throw new IllegalStateException(String.format("Loading an unrelated row with path %s for %s", zzbmj3, zzbmj2));
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            zzbmj3 = (zzbmj)entry.getKey();
            zzbpe2 = zzbpe2.zzl(zzbmj.zza(zzbmj2, zzbmj3), (zzbpe)entry.getValue());
        }
        long l6 = System.currentTimeMillis() - l5;
        long l7 = System.currentTimeMillis() - l;
        if (this.zzbYx.zzYT()) {
            this.zzbYx.zzi(String.format("Loaded a total of %d rows for a total of %d nodes at %s in %dms (Query: %dms, Loading: %dms, Serializing: %dms)", arrayList2.size(), zzbqb.zzu(zzbpe2), zzbmj2, l7, l2, l4, l6), new Object[0]);
        }
        return zzbpe2;
    }

    private int zza(zzbmj zzbmj2, List<String> list, int n) {
        int n2;
        String string = zzbky.zzc(zzbmj2);
        if (!list.get(n).startsWith(string)) {
            throw new IllegalStateException("Extracting split nodes needs to start with path prefix");
        }
        for (n2 = n + 1; n2 < list.size() && list.get(n2).equals(this.zza(zzbmj2, n2 - n)); ++n2) {
        }
        if (n2 < list.size()) {
            String string2 = String.valueOf(string);
            String string3 = String.valueOf(".part-");
            if (list.get(n2).startsWith(string3.length() != 0 ? string2.concat(string3) : new String(string2))) {
                throw new IllegalStateException("Run did not finish with all parts");
            }
        }
        return n2 - n;
    }

    private Cursor zza(zzbmj zzbmj2, String[] stringArray) {
        String string = zzbky.zzc(zzbmj2);
        String string2 = zzbky.zziH(string);
        String[] stringArray2 = new String[zzbmj2.size() + 3];
        String string3 = zzbky.zzb(zzbmj2, stringArray2);
        String string4 = String.valueOf(string3);
        String string5 = String.valueOf(" OR (path > ? AND path < ?)");
        string3 = string5.length() != 0 ? string4.concat(string5) : new String(string4);
        stringArray2[zzbmj2.size() + 1] = string;
        stringArray2[zzbmj2.size() + 2] = string2;
        String string6 = "path";
        return this.zzbYw.query("serverCache", stringArray, string3, stringArray2, null, null, string6);
    }

    private static String zzc(zzbmj zzbmj2) {
        if (zzbmj2.isEmpty()) {
            return "/";
        }
        return String.valueOf(zzbmj2.toString()).concat("/");
    }

    private static String zziH(String string) {
        assert (string.endsWith("/")) : "Path keys must end with a '/'";
        String string2 = String.valueOf(string.substring(0, string.length() - 1));
        return new StringBuilder(1 + String.valueOf(string2).length()).append(string2).append('0').toString();
    }

    private static String zzb(zzbmj zzbmj2, String[] stringArray) {
        assert (stringArray.length >= zzbmj2.size() + 1);
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder("(");
        while (!zzbmj2.isEmpty()) {
            stringBuilder.append("path");
            stringBuilder.append(" = ? OR ");
            stringArray[n] = zzbky.zzc(zzbmj2);
            zzbmj2 = zzbmj2.zzXk();
            ++n;
        }
        stringBuilder.append("path");
        stringBuilder.append(" = ?)");
        stringArray[n] = zzbky.zzc(zzbmj.zzXf());
        return stringBuilder.toString();
    }

    private int zza(String string, zzbmj zzbmj2) {
        String string2 = "path >= ? AND path < ?";
        String string3 = zzbky.zzc(zzbmj2);
        String string4 = zzbky.zziH(string3);
        return this.zzbYw.delete(string, string2, new String[]{string3, string4});
    }

    private static List<byte[]> zzd(byte[] byArray, int n) {
        int n2 = (byArray.length - 1) / n + 1;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(n2);
        for (int i = 0; i < n2; ++i) {
            int n3 = Math.min(n, byArray.length - i * n);
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, i * n, byArray2, 0, n3);
            arrayList.add(byArray2);
        }
        return arrayList;
    }

    private byte[] zzS(List<byte[]> list) {
        int n = 0;
        for (byte[] byArray : list) {
            n += byArray.length;
        }
        Object object = new byte[n];
        int n2 = 0;
        for (byte[] byArray : list) {
            System.arraycopy(byArray, 0, object, n2, byArray.length);
            n2 += byArray.length;
        }
        return object;
    }

    private byte[] zzad(Object object) {
        try {
            return zzbpx.zzat((Object)object).getBytes(zzavy);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Could not serialize leaf node", iOException);
        }
    }

    private zzbpe zzT(byte[] byArray) {
        try {
            Object object = zzbpx.zzjg((String)new String(byArray, zzavy));
            return zzbpf.zzar(object);
        }
        catch (IOException iOException) {
            String string = new String(byArray, zzavy);
            String string2 = String.valueOf(string);
            throw new RuntimeException(string2.length() != 0 ? "Could not deserialize node: ".concat(string2) : new String("Could not deserialize node: "), iOException);
        }
    }

    private String zzp(Collection<Long> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (long l : collection) {
            if (!bl) {
                stringBuilder.append(",");
            }
            bl = false;
            stringBuilder.append(l);
        }
        return stringBuilder.toString();
    }

    private static class zza
    extends SQLiteOpenHelper {
        public zza(Context context, String string) {
            super(context, string, null, 2);
        }

        public void onCreate(SQLiteDatabase sQLiteDatabase) {
            sQLiteDatabase.execSQL("CREATE TABLE serverCache (path TEXT PRIMARY KEY, value BLOB);");
            sQLiteDatabase.execSQL("CREATE TABLE writes (id INTEGER, path TEXT, type TEXT, part INTEGER, node BLOB, UNIQUE (id, part));");
            sQLiteDatabase.execSQL("CREATE TABLE trackedQueries (id INTEGER PRIMARY KEY, path TEXT, queryParams TEXT, lastUse INTEGER, complete INTEGER, active INTEGER);");
            sQLiteDatabase.execSQL("CREATE TABLE trackedKeys (id INTEGER, key TEXT);");
        }

        public void onUpgrade(SQLiteDatabase sQLiteDatabase, int n, int n2) {
            assert (n2 == 2) : "Why is onUpgrade() called with a different version?";
            if (n > 1) {
                throw new AssertionError((Object)new StringBuilder(40).append("We don't handle upgrading to ").append(n2).toString());
            }
            this.zzc(sQLiteDatabase, "serverCache");
            sQLiteDatabase.execSQL("CREATE TABLE serverCache (path TEXT PRIMARY KEY, value BLOB);");
            this.zzc(sQLiteDatabase, "complete");
            sQLiteDatabase.execSQL("CREATE TABLE trackedKeys (id INTEGER, key TEXT);");
            sQLiteDatabase.execSQL("CREATE TABLE trackedQueries (id INTEGER PRIMARY KEY, path TEXT, queryParams TEXT, lastUse INTEGER, complete INTEGER, active INTEGER);");
        }

        private void zzc(SQLiteDatabase sQLiteDatabase, String string) {
            String string2 = String.valueOf(string);
            sQLiteDatabase.execSQL(string2.length() != 0 ? "DROP TABLE IF EXISTS ".concat(string2) : new String("DROP TABLE IF EXISTS "));
        }
    }
}

