/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabaseLockedException;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import com.google.android.gms.internal.zzboy;
import com.google.android.gms.internal.zzbpa;
import com.google.android.gms.internal.zzbph;
import com.google.android.gms.internal.zzbpv;
import com.google.android.gms.internal.zzbqm;
import com.google.android.gms.internal.zzbqn;
import com.google.android.gms.internal.zzbqo;
import com.google.android.gms.internal.zzbqq;
import com.google.android.gms.internal.zzbrc;
import com.google.android.gms.internal.zzbrn;
import com.google.android.gms.internal.zzbrq;
import com.google.android.gms.internal.zzbrr;
import com.google.android.gms.internal.zzbrv;
import com.google.android.gms.internal.zzbsb;
import com.google.android.gms.internal.zzbsc;
import com.google.android.gms.internal.zzbsd;
import com.google.android.gms.internal.zzbsv;
import com.google.android.gms.internal.zzbsz;
import com.google.android.gms.internal.zzbtb;
import com.google.android.gms.internal.zzbte;
import com.google.firebase.database.DatabaseException;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class zzbnw
implements zzbqm {
    private static final Charset zzawC = Charset.forName("UTF-8");
    private final SQLiteDatabase zzcaI;
    private final zzbrn zzcaJ;
    private boolean zzcaK;
    private long zzcaL = 0L;

    public zzbnw(Context context, zzbpa zzbpa2, String string) {
        String string2;
        try {
            string2 = URLEncoder.encode(string, "utf-8");
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.zzcaJ = zzbpa2.zziV("Persistence");
        this.zzcaI = this.zzP(context, string2);
    }

    @Override
    public void zza(zzbph zzbph2, zzbsc zzbsc2, long l) {
        this.zzWR();
        long l2 = System.currentTimeMillis();
        byte[] byArray = this.zzaf(zzbsc2.getValue(true));
        this.zza(zzbph2, l, "o", byArray);
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzcaJ.zzaaC()) {
            this.zzcaJ.zzi(String.format("Persisted user overwrite in %dms", l3), new Object[0]);
        }
    }

    @Override
    public void zza(zzbph zzbph2, zzboy zzboy2, long l) {
        this.zzWR();
        long l2 = System.currentTimeMillis();
        byte[] byArray = this.zzaf(zzboy2.zzbe(true));
        this.zza(zzbph2, l, "m", byArray);
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzcaJ.zzaaC()) {
            this.zzcaJ.zzi(String.format("Persisted user merge in %dms", l3), new Object[0]);
        }
    }

    @Override
    public void zzaD(long l) {
        this.zzWR();
        long l2 = System.currentTimeMillis();
        int n = this.zzcaI.delete("writes", "id = ?", new String[]{String.valueOf(l)});
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzcaJ.zzaaC()) {
            this.zzcaJ.zzi(String.format("Deleted %d write(s) with writeId %d in %dms", n, l, l3), new Object[0]);
        }
    }

    @Override
    public List<zzbpv> zzWN() {
        String[] stringArray = new String[]{"id", "path", "type", "part", "node"};
        long l = System.currentTimeMillis();
        ArrayList<zzbpv> arrayList = new ArrayList<zzbpv>();
        try (Cursor cursor = this.zzcaI.query("writes", stringArray, null, null, null, null, "id, part");){
            ArrayList<zzbpv> arrayList2;
            long l2;
            while (cursor.moveToNext()) {
                zzbpv zzbpv2;
                Iterable<zzbsb> iterable;
                Object object;
                byte[] byArray;
                l2 = cursor.getLong(0);
                arrayList2 = new zzbph(cursor.getString(1));
                String string = cursor.getString(2);
                if (cursor.isNull(3)) {
                    byArray = cursor.getBlob(4);
                } else {
                    object = new ArrayList<byte[]>();
                    do {
                        object.add(cursor.getBlob(4));
                    } while (cursor.moveToNext() && cursor.getLong(0) == l2);
                    cursor.moveToPrevious();
                    byArray = this.zzV((List<byte[]>)object);
                }
                object = new String(byArray, zzawC);
                Object object2 = zzbsv.zzjf((String)object);
                if ("o".equals(string)) {
                    iterable = zzbsd.zzat(object2);
                    zzbpv2 = new zzbpv(l2, (zzbph)((Object)arrayList2), (zzbsc)iterable, true);
                } else if ("m".equals(string)) {
                    iterable = zzboy.zzaB((Map)object2);
                    zzbpv2 = new zzbpv(l2, (zzbph)((Object)arrayList2), (zzboy)iterable);
                } else {
                    String string2 = String.valueOf(string);
                    throw new IllegalStateException(string2.length() != 0 ? "Got invalid write type: ".concat(string2) : new String("Got invalid write type: "));
                }
                arrayList.add(zzbpv2);
            }
            l2 = System.currentTimeMillis() - l;
            if (this.zzcaJ.zzaaC()) {
                this.zzcaJ.zzi(String.format("Loaded %d writes in %dms", arrayList.size(), l2), new Object[0]);
            }
            arrayList2 = arrayList;
            return arrayList2;
        }
    }

    private void zza(zzbph zzbph2, long l, String string, byte[] byArray) {
        this.zzWR();
        this.zzcaI.delete("writes", "id = ?", new String[]{String.valueOf(l)});
        if (byArray.length >= 262144) {
            List<byte[]> list = zzbnw.zzd(byArray, 262144);
            for (int i = 0; i < list.size(); ++i) {
                ContentValues contentValues = new ContentValues();
                contentValues.put("id", Long.valueOf(l));
                contentValues.put("path", zzbnw.zzc(zzbph2));
                contentValues.put("type", string);
                contentValues.put("part", Integer.valueOf(i));
                contentValues.put("node", list.get(i));
                this.zzcaI.insertWithOnConflict("writes", null, contentValues, 5);
            }
        } else {
            ContentValues contentValues = new ContentValues();
            contentValues.put("id", Long.valueOf(l));
            contentValues.put("path", zzbnw.zzc(zzbph2));
            contentValues.put("type", string);
            contentValues.put("part", null);
            contentValues.put("node", byArray);
            this.zzcaI.insertWithOnConflict("writes", null, contentValues, 5);
        }
    }

    @Override
    public zzbsc zza(zzbph zzbph2) {
        return this.zzb(zzbph2);
    }

    @Override
    public void zza(zzbph zzbph2, zzbsc zzbsc2) {
        this.zzWR();
        this.zza(zzbph2, zzbsc2, false);
    }

    @Override
    public void zzb(zzbph zzbph2, zzbsc zzbsc2) {
        this.zzWR();
        this.zza(zzbph2, zzbsc2, true);
    }

    private void zza(zzbph zzbph2, zzbsc zzbsc2, boolean bl) {
        int n;
        int n2;
        long l = System.currentTimeMillis();
        if (!bl) {
            n2 = this.zza("serverCache", zzbph2);
            n = this.zzc(zzbph2, zzbsc2);
        } else {
            n2 = 0;
            n = 0;
            for (zzbsb zzbsb2 : zzbsc2) {
                n2 += this.zza("serverCache", zzbph2.zza(zzbsb2.zzabi()));
                n += this.zzc(zzbph2.zza(zzbsb2.zzabi()), zzbsb2.zzWH());
            }
        }
        long l2 = System.currentTimeMillis() - l;
        if (this.zzcaJ.zzaaC()) {
            this.zzcaJ.zzi(String.format("Persisted a total of %d rows and deleted %d rows for a set at %s in %dms", n, n2, zzbph2.toString(), l2), new Object[0]);
        }
    }

    @Override
    public void zza(zzbph zzbph2, zzboy zzboy2) {
        this.zzWR();
        long l = System.currentTimeMillis();
        int n = 0;
        int n2 = 0;
        for (Map.Entry<zzbph, zzbsc> entry : zzboy2) {
            n2 += this.zza("serverCache", zzbph2.zzh(entry.getKey()));
            n += this.zzc(zzbph2.zzh(entry.getKey()), entry.getValue());
        }
        long l2 = System.currentTimeMillis() - l;
        if (this.zzcaJ.zzaaC()) {
            this.zzcaJ.zzi(String.format("Persisted a total of %d rows and deleted %d rows for a merge at %s in %dms", n, n2, zzbph2.toString(), l2), new Object[0]);
        }
    }

    @Override
    public long zzWO() {
        String string = String.format("SELECT sum(length(%s) + length(%s)) FROM %s", "value", "path", "serverCache");
        try (Cursor cursor = this.zzcaI.rawQuery(string, null);){
            if (cursor.moveToFirst()) {
                long l = cursor.getLong(0);
                return l;
            }
            throw new IllegalStateException("Couldn't read database result!");
        }
    }

    @Override
    public void zza(zzbqo zzbqo2) {
        this.zzWR();
        long l = System.currentTimeMillis();
        ContentValues contentValues = new ContentValues();
        contentValues.put("id", Long.valueOf(zzbqo2.id));
        contentValues.put("path", zzbnw.zzc(zzbqo2.zzchq.zzWL()));
        contentValues.put("queryParams", zzbqo2.zzchq.zzaap().zzaan());
        contentValues.put("lastUse", Long.valueOf(zzbqo2.zzchr));
        contentValues.put("complete", Boolean.valueOf(zzbqo2.zzchs));
        contentValues.put("active", Boolean.valueOf(zzbqo2.zzbrc));
        this.zzcaI.insertWithOnConflict("trackedQueries", null, contentValues, 5);
        long l2 = System.currentTimeMillis() - l;
        if (this.zzcaJ.zzaaC()) {
            this.zzcaJ.zzi(String.format("Saved new tracked query in %dms", l2), new Object[0]);
        }
    }

    @Override
    public void zzaE(long l) {
        this.zzWR();
        String string = String.valueOf(l);
        String string2 = "id = ?";
        this.zzcaI.delete("trackedQueries", string2, new String[]{string});
        String string3 = "id = ?";
        this.zzcaI.delete("trackedKeys", string3, new String[]{string});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<zzbqo> zzWP() {
        String[] stringArray = new String[]{"id", "path", "queryParams", "lastUse", "complete", "active"};
        long l = System.currentTimeMillis();
        ArrayList<zzbqo> arrayList = new ArrayList<zzbqo>();
        try (Cursor cursor = this.zzcaI.query("trackedQueries", stringArray, null, null, null, null, "id");){
            ArrayList<zzbqo> arrayList2;
            long l2;
            while (cursor.moveToNext()) {
                Map map;
                l2 = cursor.getLong(0);
                arrayList2 = new zzbph(cursor.getString(1));
                String string = cursor.getString(2);
                try {
                    map = zzbsv.zzje((String)string);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
                zzbrc zzbrc2 = zzbrc.zzb(arrayList2, map);
                long l3 = cursor.getLong(3);
                boolean bl = cursor.getInt(4) != 0;
                boolean bl2 = cursor.getInt(5) != 0;
                zzbqo zzbqo2 = new zzbqo(l2, zzbrc2, l3, bl, bl2);
                arrayList.add(zzbqo2);
            }
            l2 = System.currentTimeMillis() - l;
            if (this.zzcaJ.zzaaC()) {
                this.zzcaJ.zzi(String.format("Loaded %d tracked queries in %dms", arrayList.size(), l2), new Object[0]);
            }
            arrayList2 = arrayList;
            return arrayList2;
        }
    }

    @Override
    public void zzaF(long l) {
        this.zzWR();
        long l2 = System.currentTimeMillis();
        String string = "active = 1";
        ContentValues contentValues = new ContentValues();
        contentValues.put("active", Boolean.valueOf(false));
        contentValues.put("lastUse", Long.valueOf(l));
        this.zzcaI.updateWithOnConflict("trackedQueries", contentValues, string, new String[0], 5);
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzcaJ.zzaaC()) {
            this.zzcaJ.zzi(String.format("Reset active tracked queries in %dms", l3), new Object[0]);
        }
    }

    @Override
    public void zza(long l, Set<zzbrq> set) {
        this.zzWR();
        long l2 = System.currentTimeMillis();
        String string = String.valueOf(l);
        String string2 = "id = ?";
        this.zzcaI.delete("trackedKeys", string2, new String[]{string});
        for (zzbrq zzbrq2 : set) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("id", Long.valueOf(l));
            contentValues.put("key", zzbrq2.asString());
            this.zzcaI.insertWithOnConflict("trackedKeys", null, contentValues, 5);
        }
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzcaJ.zzaaC()) {
            this.zzcaJ.zzi(String.format("Set %d tracked query keys for tracked query %d in %dms", set.size(), l, l3), new Object[0]);
        }
    }

    @Override
    public void zza(long l, Set<zzbrq> set, Set<zzbrq> set2) {
        this.zzWR();
        long l2 = System.currentTimeMillis();
        String string = "id = ? AND key = ?";
        String string2 = String.valueOf(l);
        for (zzbrq zzbrq2 : set2) {
            this.zzcaI.delete("trackedKeys", string, new String[]{string2, zzbrq2.asString()});
        }
        for (zzbrq zzbrq2 : set) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("id", Long.valueOf(l));
            contentValues.put("key", zzbrq2.asString());
            this.zzcaI.insertWithOnConflict("trackedKeys", null, contentValues, 5);
        }
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzcaJ.zzaaC()) {
            this.zzcaJ.zzi(String.format("Updated tracked query keys (%d added, %d removed) for tracked query id %d in %dms", set.size(), set2.size(), l, l3), new Object[0]);
        }
    }

    @Override
    public Set<zzbrq> zzaG(long l) {
        return this.zzg(Collections.singleton(l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<zzbrq> zzg(Set<Long> set) {
        String[] stringArray = new String[]{"key"};
        long l = System.currentTimeMillis();
        String string = String.valueOf("id IN (");
        Object object = String.valueOf(this.zzp(set));
        String string2 = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(object).length()).append(string).append((String)object).append(")").toString();
        string = this.zzcaI.query(true, "trackedKeys", stringArray, string2, null, null, null, null, null);
        object = new HashSet();
        try {
            while (string.moveToNext()) {
                String string3 = string.getString(0);
                object.add(zzbrq.zzja(string3));
            }
            long l2 = System.currentTimeMillis() - l;
            if (this.zzcaJ.zzaaC()) {
                this.zzcaJ.zzi(String.format("Loaded %d tracked queries keys for tracked queries %s in %dms", object.size(), set.toString(), l2), new Object[0]);
            }
            Object object2 = object;
            return object2;
        }
        finally {
            string.close();
        }
    }

    @Override
    public void zza(zzbph zzbph2, zzbqn zzbqn2) {
        Object object;
        String string;
        Iterable<Object> iterable;
        Iterable<zzbrq> iterable2;
        if (!zzbqn2.zzZH()) {
            return;
        }
        this.zzWR();
        long l = System.currentTimeMillis();
        Cursor cursor = this.zza(zzbph2, new String[]{"rowid", "path"});
        zzbqq<Object> zzbqq2 = new zzbqq<Object>(null);
        zzbqq<Object> zzbqq3 = new zzbqq<Object>(null);
        while (cursor.moveToNext()) {
            long l2 = cursor.getLong(0);
            iterable2 = new zzbph(cursor.getString(1));
            if (!zzbph2.zzi((zzbph)iterable2)) {
                iterable = String.valueOf(zzbph2);
                string = String.valueOf(iterable2);
                this.zzcaJ.warn(new StringBuilder(67 + String.valueOf(iterable).length() + String.valueOf(string).length()).append("We are pruning at ").append((String)((Object)iterable)).append(" but we have data stored higher up at ").append(string).append(". Ignoring.").toString());
                continue;
            }
            iterable = zzbph.zza(zzbph2, (zzbph)iterable2);
            if (zzbqn2.zzw((zzbph)iterable)) {
                zzbqq2 = zzbqq2.zzb((zzbph)iterable, l2);
                continue;
            }
            if (zzbqn2.zzx((zzbph)iterable)) {
                zzbqq3 = zzbqq3.zzb((zzbph)iterable, l2);
                continue;
            }
            string = String.valueOf(zzbph2);
            object = String.valueOf(iterable2);
            this.zzcaJ.warn(new StringBuilder(88 + String.valueOf(string).length() + String.valueOf(object).length()).append("We are pruning at ").append(string).append(" and have data at ").append((String)object).append(" that isn't marked for pruning or keeping. Ignoring.").toString());
        }
        int n = 0;
        int n2 = 0;
        if (!zzbqq2.isEmpty()) {
            iterable2 = new ArrayList();
            this.zza(zzbph2, zzbph.zzYO(), zzbqq2, zzbqq3, zzbqn2, (List<zzbtb<zzbph, zzbsc>>)iterable2);
            iterable = zzbqq2.values();
            object = String.valueOf(this.zzp((Collection<Long>)iterable));
            string = new StringBuilder(11 + String.valueOf(object).length()).append("rowid IN (").append((String)object).append(")").toString();
            this.zzcaI.delete("serverCache", string, null);
            for (zzbtb zzbtb2 : iterable2) {
                this.zzc(zzbph2.zzh((zzbph)zzbtb2.getFirst()), (zzbsc)zzbtb2.zzabI());
            }
            n = iterable.size();
            n2 = iterable2.size();
        }
        long l3 = System.currentTimeMillis() - l;
        if (this.zzcaJ.zzaaC()) {
            this.zzcaJ.zzi(String.format("Pruned %d rows with %d nodes resaved in %dms", n, n2, l3), new Object[0]);
        }
    }

    private void zza(zzbph zzbph2, final zzbph zzbph3, zzbqq<Long> zzbqq2, final zzbqq<Long> zzbqq3, zzbqn zzbqn2, final List<zzbtb<zzbph, zzbsc>> list) {
        if (zzbqq2.getValue() != null) {
            int n = zzbqn2.zza(0, new zzbqq.zza<Void, Integer>(this){

                @Override
                public Integer zza(zzbph zzbph2, Void void_, Integer n) {
                    return zzbqq3.zzK(zzbph2) == null ? n + 1 : n;
                }
            });
            if (n > 0) {
                zzbph zzbph4 = zzbph2.zzh(zzbph3);
                if (this.zzcaJ.zzaaC()) {
                    this.zzcaJ.zzi(String.format("Need to rewrite %d nodes below path %s", n, zzbph4), new Object[0]);
                }
                final zzbsc zzbsc2 = this.zzb(zzbph4);
                zzbqn2.zza(null, new zzbqq.zza<Void, Void>(this){

                    @Override
                    public Void zza(zzbph zzbph2, Void void_, Void void_2) {
                        if (zzbqq3.zzK(zzbph2) == null) {
                            list.add(new zzbtb<zzbph, zzbsc>(zzbph3.zzh(zzbph2), zzbsc2.zzO(zzbph2)));
                        }
                        return null;
                    }
                });
            }
        } else {
            for (Map.Entry<zzbrq, zzbqq<Long>> entry : zzbqq2.zzZN()) {
                zzbrq zzbrq2 = entry.getKey();
                zzbqn zzbqn3 = zzbqn2.zzd(entry.getKey());
                this.zza(zzbph2, zzbph3.zza(zzbrq2), entry.getValue(), zzbqq3.zze(zzbrq2), zzbqn3, list);
            }
        }
    }

    @Override
    public void zzWQ() {
        this.zzWR();
        long l = System.currentTimeMillis();
        int n = this.zzcaI.delete("writes", null, null);
        long l2 = System.currentTimeMillis() - l;
        if (this.zzcaJ.zzaaC()) {
            this.zzcaJ.zzi(String.format("Deleted %d (all) write(s) in %dms", n, l2), new Object[0]);
        }
    }

    @Override
    public void beginTransaction() {
        zzbte.zzb(!this.zzcaK, "runInTransaction called when an existing transaction is already in progress.");
        if (this.zzcaJ.zzaaC()) {
            this.zzcaJ.zzi("Starting transaction.", new Object[0]);
        }
        this.zzcaI.beginTransaction();
        this.zzcaK = true;
        this.zzcaL = System.currentTimeMillis();
    }

    @Override
    public void endTransaction() {
        this.zzcaI.endTransaction();
        this.zzcaK = false;
        long l = System.currentTimeMillis() - this.zzcaL;
        if (this.zzcaJ.zzaaC()) {
            this.zzcaJ.zzi(String.format("Transaction completed. Elapsed: %dms", l), new Object[0]);
        }
    }

    @Override
    public void setTransactionSuccessful() {
        this.zzcaI.setTransactionSuccessful();
    }

    private SQLiteDatabase zzP(Context context, String string) {
        zza zza2 = new zza(context, string);
        try {
            SQLiteDatabase sQLiteDatabase = zza2.getWritableDatabase();
            sQLiteDatabase.rawQuery("PRAGMA locking_mode = EXCLUSIVE", null).close();
            sQLiteDatabase.beginTransaction();
            sQLiteDatabase.endTransaction();
            return sQLiteDatabase;
        }
        catch (SQLiteException sQLiteException) {
            if (sQLiteException instanceof SQLiteDatabaseLockedException) {
                String string2 = "Failed to gain exclusive lock to Firebase Database's offline persistence. This generally means you are using Firebase Database from multiple processes in your app. Keep in mind that multi-process Android apps execute the code in your Application class in all processes, so you may need to avoid initializing FirebaseDatabase in your Application class. If you are intentionally using Firebase Database from multiple processes, you can only enable offline persistence (i.e. call setPersistenceEnabled(true)) in one of them.";
                throw new DatabaseException(string2, sQLiteException);
            }
            throw sQLiteException;
        }
    }

    private void zzWR() {
        zzbte.zzb(this.zzcaK, "Transaction expected to already be in progress.");
    }

    private int zzc(zzbph zzbph2, zzbsc zzbsc2) {
        long l = zzbsz.zzt(zzbsc2);
        if (zzbsc2 instanceof zzbrr && l > 16384L) {
            if (this.zzcaJ.zzaaC()) {
                this.zzcaJ.zzi(String.format("Node estimated serialized size at path %s of %d bytes exceeds limit of %d bytes. Splitting up.", zzbph2, l, 16384), new Object[0]);
            }
            int n = 0;
            for (zzbsb zzbsb2 : zzbsc2) {
                n += this.zzc(zzbph2.zza(zzbsb2.zzabi()), zzbsb2.zzWH());
            }
            if (!zzbsc2.zzaaN().isEmpty()) {
                this.zzd(zzbph2.zza(zzbrq.zzaaH()), zzbsc2.zzaaN());
                ++n;
            }
            this.zzd(zzbph2, zzbrv.zzaaY());
            return ++n;
        }
        this.zzd(zzbph2, zzbsc2);
        return 1;
    }

    private String zza(zzbph zzbph2, int n) {
        String string = String.valueOf(zzbnw.zzc(zzbph2));
        String string2 = String.valueOf(String.format(".part-%04d", n));
        return string2.length() != 0 ? string.concat(string2) : new String(string);
    }

    private void zzd(zzbph zzbph2, zzbsc zzbsc2) {
        byte[] byArray = this.zzaf(zzbsc2.getValue(true));
        if (byArray.length >= 262144) {
            int n;
            List<byte[]> list = zzbnw.zzd(byArray, 262144);
            if (this.zzcaJ.zzaaC()) {
                n = list.size();
                this.zzcaJ.zzi(new StringBuilder(45).append("Saving huge leaf node with ").append(n).append(" parts.").toString(), new Object[0]);
            }
            for (n = 0; n < list.size(); ++n) {
                ContentValues contentValues = new ContentValues();
                contentValues.put("path", this.zza(zzbph2, n));
                contentValues.put("value", list.get(n));
                this.zzcaI.insertWithOnConflict("serverCache", null, contentValues, 5);
            }
        } else {
            ContentValues contentValues = new ContentValues();
            contentValues.put("path", zzbnw.zzc(zzbph2));
            contentValues.put("value", byArray);
            this.zzcaI.insertWithOnConflict("serverCache", null, contentValues, 5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private zzbsc zzb(zzbph zzbph2) {
        zzbph zzbph3;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<byte[]> arrayList2 = new ArrayList<byte[]>();
        long l = System.currentTimeMillis();
        Cursor cursor = this.zza(zzbph2, new String[]{"path", "value"});
        long l2 = System.currentTimeMillis() - l;
        long l3 = System.currentTimeMillis();
        try {
            while (cursor.moveToNext()) {
                arrayList.add(cursor.getString(0));
                arrayList2.add(cursor.getBlob(1));
            }
        }
        finally {
            cursor.close();
        }
        long l4 = System.currentTimeMillis() - l3;
        long l5 = System.currentTimeMillis();
        zzbsc zzbsc2 = zzbrv.zzaaY();
        boolean bl = false;
        HashMap<zzbph, void> hashMap = new HashMap<zzbph, void>();
        for (int i = 0; i < arrayList2.size(); ++i) {
            void object;
            Object object2;
            if (((String)arrayList.get(i)).endsWith(".part-0000")) {
                object2 = (String)arrayList.get(i);
                zzbph3 = new zzbph(((String)object2).substring(0, ((String)object2).length() - ".part-0000".length()));
                int n = this.zza(zzbph3, arrayList, i);
                if (this.zzcaJ.zzaaC()) {
                    this.zzcaJ.zzi(new StringBuilder(42).append("Loading split node with ").append(n).append(" parts.").toString(), new Object[0]);
                }
                zzbsc zzbsc3 = this.zzV(this.zzV(arrayList2.subList(i, i + n)));
                i = i + n - 1;
            } else {
                zzbsc zzbsc4 = this.zzV((byte[])arrayList2.get(i));
                zzbph3 = new zzbph((String)arrayList.get(i));
            }
            if (zzbph3.zzYU() != null && zzbph3.zzYU().zzaaJ()) {
                hashMap.put(zzbph3, object);
                continue;
            }
            if (zzbph3.zzi(zzbph2)) {
                zzbte.zzb(!bl, "Descendants of path must come after ancestors.");
                zzbsc2 = object.zzO(zzbph.zza(zzbph3, zzbph2));
                continue;
            }
            if (zzbph2.zzi(zzbph3)) {
                bl = true;
                object2 = zzbph.zza(zzbph2, zzbph3);
                zzbsc2 = zzbsc2.zzl((zzbph)object2, (zzbsc)object);
                continue;
            }
            throw new IllegalStateException(String.format("Loading an unrelated row with path %s for %s", zzbph3, zzbph2));
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            zzbph3 = (zzbph)entry.getKey();
            zzbsc2 = zzbsc2.zzl(zzbph.zza(zzbph2, zzbph3), (zzbsc)entry.getValue());
        }
        long l6 = System.currentTimeMillis() - l5;
        long l7 = System.currentTimeMillis() - l;
        if (this.zzcaJ.zzaaC()) {
            this.zzcaJ.zzi(String.format("Loaded a total of %d rows for a total of %d nodes at %s in %dms (Query: %dms, Loading: %dms, Serializing: %dms)", arrayList2.size(), zzbsz.zzu(zzbsc2), zzbph2, l7, l2, l4, l6), new Object[0]);
        }
        return zzbsc2;
    }

    private int zza(zzbph zzbph2, List<String> list, int n) {
        int n2;
        String string = zzbnw.zzc(zzbph2);
        if (!list.get(n).startsWith(string)) {
            throw new IllegalStateException("Extracting split nodes needs to start with path prefix");
        }
        for (n2 = n + 1; n2 < list.size() && list.get(n2).equals(this.zza(zzbph2, n2 - n)); ++n2) {
        }
        if (n2 < list.size()) {
            String string2 = String.valueOf(string);
            String string3 = String.valueOf(".part-");
            if (list.get(n2).startsWith(string3.length() != 0 ? string2.concat(string3) : new String(string2))) {
                throw new IllegalStateException("Run did not finish with all parts");
            }
        }
        return n2 - n;
    }

    private Cursor zza(zzbph zzbph2, String[] stringArray) {
        String string = zzbnw.zzc(zzbph2);
        String string2 = zzbnw.zziG(string);
        String[] stringArray2 = new String[zzbph2.size() + 3];
        String string3 = zzbnw.zzb(zzbph2, stringArray2);
        String string4 = String.valueOf(string3);
        String string5 = String.valueOf(" OR (path > ? AND path < ?)");
        string3 = string5.length() != 0 ? string4.concat(string5) : new String(string4);
        stringArray2[zzbph2.size() + 1] = string;
        stringArray2[zzbph2.size() + 2] = string2;
        String string6 = "path";
        return this.zzcaI.query("serverCache", stringArray, string3, stringArray2, null, null, string6);
    }

    private static String zzc(zzbph zzbph2) {
        if (zzbph2.isEmpty()) {
            return "/";
        }
        return String.valueOf(zzbph2.toString()).concat("/");
    }

    private static String zziG(String string) {
        assert (string.endsWith("/")) : "Path keys must end with a '/'";
        String string2 = String.valueOf(string.substring(0, string.length() - 1));
        return new StringBuilder(1 + String.valueOf(string2).length()).append(string2).append('0').toString();
    }

    private static String zzb(zzbph zzbph2, String[] stringArray) {
        assert (stringArray.length >= zzbph2.size() + 1);
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder("(");
        while (!zzbph2.isEmpty()) {
            stringBuilder.append("path");
            stringBuilder.append(" = ? OR ");
            stringArray[n] = zzbnw.zzc(zzbph2);
            zzbph2 = zzbph2.zzYT();
            ++n;
        }
        stringBuilder.append("path");
        stringBuilder.append(" = ?)");
        stringArray[n] = zzbnw.zzc(zzbph.zzYO());
        return stringBuilder.toString();
    }

    private int zza(String string, zzbph zzbph2) {
        String string2 = "path >= ? AND path < ?";
        String string3 = zzbnw.zzc(zzbph2);
        String string4 = zzbnw.zziG(string3);
        return this.zzcaI.delete(string, string2, new String[]{string3, string4});
    }

    private static List<byte[]> zzd(byte[] byArray, int n) {
        int n2 = (byArray.length - 1) / n + 1;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(n2);
        for (int i = 0; i < n2; ++i) {
            int n3 = Math.min(n, byArray.length - i * n);
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, i * n, byArray2, 0, n3);
            arrayList.add(byArray2);
        }
        return arrayList;
    }

    private byte[] zzV(List<byte[]> list) {
        int n = 0;
        for (byte[] byArray : list) {
            n += byArray.length;
        }
        Object object = new byte[n];
        int n2 = 0;
        for (byte[] byArray : list) {
            System.arraycopy(byArray, 0, object, n2, byArray.length);
            n2 += byArray.length;
        }
        return object;
    }

    private byte[] zzaf(Object object) {
        try {
            return zzbsv.zzav((Object)object).getBytes(zzawC);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Could not serialize leaf node", iOException);
        }
    }

    private zzbsc zzV(byte[] byArray) {
        try {
            Object object = zzbsv.zzjf((String)new String(byArray, zzawC));
            return zzbsd.zzat(object);
        }
        catch (IOException iOException) {
            String string = new String(byArray, zzawC);
            String string2 = String.valueOf(string);
            throw new RuntimeException(string2.length() != 0 ? "Could not deserialize node: ".concat(string2) : new String("Could not deserialize node: "), iOException);
        }
    }

    private String zzp(Collection<Long> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (long l : collection) {
            if (!bl) {
                stringBuilder.append(",");
            }
            bl = false;
            stringBuilder.append(l);
        }
        return stringBuilder.toString();
    }

    private static class zza
    extends SQLiteOpenHelper {
        public zza(Context context, String string) {
            super(context, string, null, 2);
        }

        public void onCreate(SQLiteDatabase sQLiteDatabase) {
            sQLiteDatabase.execSQL("CREATE TABLE serverCache (path TEXT PRIMARY KEY, value BLOB);");
            sQLiteDatabase.execSQL("CREATE TABLE writes (id INTEGER, path TEXT, type TEXT, part INTEGER, node BLOB, UNIQUE (id, part));");
            sQLiteDatabase.execSQL("CREATE TABLE trackedQueries (id INTEGER PRIMARY KEY, path TEXT, queryParams TEXT, lastUse INTEGER, complete INTEGER, active INTEGER);");
            sQLiteDatabase.execSQL("CREATE TABLE trackedKeys (id INTEGER, key TEXT);");
        }

        public void onUpgrade(SQLiteDatabase sQLiteDatabase, int n, int n2) {
            assert (n2 == 2) : "Why is onUpgrade() called with a different version?";
            if (n > 1) {
                throw new AssertionError((Object)new StringBuilder(40).append("We don't handle upgrading to ").append(n2).toString());
            }
            this.zzc(sQLiteDatabase, "serverCache");
            sQLiteDatabase.execSQL("CREATE TABLE serverCache (path TEXT PRIMARY KEY, value BLOB);");
            this.zzc(sQLiteDatabase, "complete");
            sQLiteDatabase.execSQL("CREATE TABLE trackedKeys (id INTEGER, key TEXT);");
            sQLiteDatabase.execSQL("CREATE TABLE trackedQueries (id INTEGER PRIMARY KEY, path TEXT, queryParams TEXT, lastUse INTEGER, complete INTEGER, active INTEGER);");
        }

        private void zzc(SQLiteDatabase sQLiteDatabase, String string) {
            String string2 = String.valueOf(string);
            sQLiteDatabase.execSQL(string2.length() != 0 ? "DROP TABLE IF EXISTS ".concat(string2) : new String("DROP TABLE IF EXISTS "));
        }
    }
}

