/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzbny;
import com.google.android.gms.internal.zzbod;
import com.google.android.gms.internal.zzbog;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class zzbnx<K, V>
extends zzbny<K, V> {
    private final K[] zzcaQ;
    private final V[] zzcaR;
    private final Comparator<K> zzcaS;

    public static <A, B, C> zzbnx<A, C> zza(List<A> list, Map<B, C> map, zzbny.zza.zza<A, B> zza2, Comparator<A> comparator) {
        Collections.sort(list, comparator);
        int n = list.size();
        Object[] objectArray = new Object[n];
        Object[] objectArray2 = new Object[n];
        int n2 = 0;
        for (A a : list) {
            objectArray[n2] = a;
            C c = map.get(zza2.zzak(a));
            objectArray2[n2] = c;
            ++n2;
        }
        return new zzbnx<Object, Object>(comparator, objectArray, objectArray2);
    }

    public static <K, V> zzbnx<K, V> zza(Map<K, V> map, Comparator<K> comparator) {
        return zzbnx.zza(new ArrayList<K>(map.keySet()), map, zzbny.zza.zzWV(), comparator);
    }

    public zzbnx(Comparator<K> comparator) {
        this.zzcaQ = new Object[0];
        this.zzcaR = new Object[0];
        this.zzcaS = comparator;
    }

    private zzbnx(Comparator<K> comparator, K[] KArray, V[] VArray) {
        this.zzcaQ = KArray;
        this.zzcaR = VArray;
        this.zzcaS = comparator;
    }

    @Override
    public boolean containsKey(K k) {
        return this.zzaj(k) != -1;
    }

    @Override
    public V get(K k) {
        int n = this.zzaj(k);
        return n != -1 ? (V)this.zzcaR[n] : null;
    }

    @Override
    public zzbny<K, V> zzag(K k) {
        int n = this.zzaj(k);
        if (n == -1) {
            return this;
        }
        K[] KArray = zzbnx.zza(this.zzcaQ, n);
        V[] VArray = zzbnx.zza(this.zzcaR, n);
        return new zzbnx<K, V>(this.zzcaS, KArray, VArray);
    }

    @Override
    public zzbny<K, V> zzi(K k, V v) {
        int n = this.zzaj(k);
        if (n != -1) {
            if (this.zzcaQ[n] == k && this.zzcaR[n] == v) {
                return this;
            }
            K[] KArray = zzbnx.zzb(this.zzcaQ, n, k);
            V[] VArray = zzbnx.zzb(this.zzcaR, n, v);
            return new zzbnx<K, V>(this.zzcaS, KArray, VArray);
        }
        if (this.zzcaQ.length > 25) {
            HashMap<K, V> hashMap = new HashMap<K, V>(this.zzcaQ.length + 1);
            for (int i = 0; i < this.zzcaQ.length; ++i) {
                hashMap.put(this.zzcaQ[i], this.zzcaR[i]);
            }
            hashMap.put(k, v);
            return zzbog.zzc(hashMap, this.zzcaS);
        }
        int n2 = this.zzai(k);
        K[] KArray = zzbnx.zza(this.zzcaQ, n2, k);
        V[] VArray = zzbnx.zza(this.zzcaR, n2, v);
        return new zzbnx<K, V>(this.zzcaS, KArray, VArray);
    }

    @Override
    public K zzWS() {
        return this.zzcaQ.length > 0 ? (K)this.zzcaQ[0] : null;
    }

    @Override
    public K zzWT() {
        return this.zzcaQ.length > 0 ? (K)this.zzcaQ[this.zzcaQ.length - 1] : null;
    }

    @Override
    public int size() {
        return this.zzcaQ.length;
    }

    @Override
    public boolean isEmpty() {
        return this.zzcaQ.length == 0;
    }

    @Override
    public void zza(zzbod.zzb<K, V> zzb2) {
        for (int i = 0; i < this.zzcaQ.length; ++i) {
            zzb2.zzj(this.zzcaQ[i], this.zzcaR[i]);
        }
    }

    private Iterator<Map.Entry<K, V>> zze(final int n, final boolean bl) {
        return new Iterator<Map.Entry<K, V>>(){
            int zzcaT;
            {
                this.zzcaT = n;
            }

            @Override
            public boolean hasNext() {
                return bl ? this.zzcaT >= 0 : this.zzcaT < zzbnx.this.zzcaQ.length;
            }

            @Override
            public Map.Entry<K, V> next() {
                Object object = zzbnx.this.zzcaQ[this.zzcaT];
                Object object2 = zzbnx.this.zzcaR[this.zzcaT];
                this.zzcaT = bl ? this.zzcaT - 1 : this.zzcaT + 1;
                return new AbstractMap.SimpleImmutableEntry<Object, Object>(object, object2);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Can't remove elements from ImmutableSortedMap");
            }
        };
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return this.zze(0, false);
    }

    @Override
    public Iterator<Map.Entry<K, V>> zzWU() {
        return this.zze(this.zzcaQ.length - 1, true);
    }

    @Override
    public K zzah(K k) {
        int n = this.zzaj(k);
        if (n == -1) {
            throw new IllegalArgumentException("Can't find predecessor of nonexistent key");
        }
        return n > 0 ? (K)this.zzcaQ[n - 1] : null;
    }

    @Override
    public Comparator<K> getComparator() {
        return this.zzcaS;
    }

    private static <T> T[] zza(T[] TArray, int n) {
        int n2 = TArray.length - 1;
        Object[] objectArray = new Object[n2];
        System.arraycopy(TArray, 0, objectArray, 0, n);
        System.arraycopy(TArray, n + 1, objectArray, n, n2 - n);
        return objectArray;
    }

    private static <T> T[] zza(T[] TArray, int n, T t) {
        int n2 = TArray.length + 1;
        Object[] objectArray = new Object[n2];
        System.arraycopy(TArray, 0, objectArray, 0, n);
        objectArray[n] = t;
        System.arraycopy(TArray, n, objectArray, n + 1, n2 - n - 1);
        return objectArray;
    }

    private static <T> T[] zzb(T[] TArray, int n, T t) {
        int n2 = TArray.length;
        Object[] objectArray = new Object[n2];
        System.arraycopy(TArray, 0, objectArray, 0, n2);
        objectArray[n] = t;
        return objectArray;
    }

    private int zzai(K k) {
        int n;
        for (n = 0; n < this.zzcaQ.length && this.zzcaS.compare(this.zzcaQ[n], k) < 0; ++n) {
        }
        return n;
    }

    private int zzaj(K k) {
        int n = 0;
        for (K k2 : this.zzcaQ) {
            if (this.zzcaS.compare(k, k2) == 0) {
                return n;
            }
            ++n;
        }
        return -1;
    }
}

