/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzbrq;
import com.google.firebase.database.DatabaseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class zzbph
implements Comparable<zzbph>,
Iterable<zzbrq> {
    private final zzbrq[] zzceo;
    private final int start;
    private final int end;
    private static final zzbph zzcep = new zzbph("");

    public static zzbph zza(zzbph zzbph2, zzbph zzbph3) {
        zzbrq zzbrq2 = zzbph2.zzYR();
        zzbrq zzbrq3 = zzbph3.zzYR();
        if (zzbrq2 == null) {
            return zzbph3;
        }
        if (zzbrq2.equals(zzbrq3)) {
            return zzbph.zza(zzbph2.zzYS(), zzbph3.zzYS());
        }
        String string = String.valueOf(zzbph3);
        String string2 = String.valueOf(zzbph2);
        throw new DatabaseException(new StringBuilder(37 + String.valueOf(string).length() + String.valueOf(string2).length()).append("INTERNAL ERROR: ").append(string).append(" is not contained in ").append(string2).toString());
    }

    public static zzbph zzYO() {
        return zzcep;
    }

    public zzbph(zzbrq ... zzbrqArray) {
        this.zzceo = Arrays.copyOf(zzbrqArray, zzbrqArray.length);
        this.start = 0;
        this.end = zzbrqArray.length;
        for (zzbrq zzbrq2 : zzbrqArray) {
            assert (zzbrq2 != null) : "Can't construct a path with a null value!";
        }
    }

    public zzbph(List<String> list) {
        this.zzceo = new zzbrq[list.size()];
        int n = 0;
        for (String string : list) {
            this.zzceo[n++] = zzbrq.zzja(string);
        }
        this.start = 0;
        this.end = list.size();
    }

    public zzbph(String string) {
        String[] stringArray = string.split("/");
        int n = 0;
        for (String string2 : stringArray) {
            if (string2.length() <= 0) continue;
            ++n;
        }
        this.zzceo = new zzbrq[n];
        int n2 = 0;
        for (String string3 : stringArray) {
            if (string3.length() <= 0) continue;
            this.zzceo[n2++] = zzbrq.zzja(string3);
        }
        this.start = 0;
        this.end = this.zzceo.length;
    }

    private zzbph(zzbrq[] zzbrqArray, int n, int n2) {
        this.zzceo = zzbrqArray;
        this.start = n;
        this.end = n2;
    }

    public zzbph zzh(zzbph zzbph2) {
        int n = this.size() + zzbph2.size();
        zzbrq[] zzbrqArray = new zzbrq[n];
        System.arraycopy(this.zzceo, this.start, zzbrqArray, 0, this.size());
        System.arraycopy(zzbph2.zzceo, zzbph2.start, zzbrqArray, this.size(), zzbph2.size());
        return new zzbph(zzbrqArray, 0, n);
    }

    public zzbph zza(zzbrq zzbrq2) {
        int n = this.size();
        zzbrq[] zzbrqArray = new zzbrq[n + 1];
        System.arraycopy(this.zzceo, this.start, zzbrqArray, 0, n);
        zzbrqArray[n] = zzbrq2;
        return new zzbph(zzbrqArray, 0, n + 1);
    }

    public String toString() {
        if (this.isEmpty()) {
            return "/";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = this.start; i < this.end; ++i) {
            stringBuilder.append("/");
            stringBuilder.append(this.zzceo[i].asString());
        }
        return stringBuilder.toString();
    }

    public String zzYP() {
        if (this.isEmpty()) {
            return "/";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = this.start; i < this.end; ++i) {
            if (i > this.start) {
                stringBuilder.append("/");
            }
            stringBuilder.append(this.zzceo[i].asString());
        }
        return stringBuilder.toString();
    }

    public List<String> zzYQ() {
        ArrayList<String> arrayList = new ArrayList<String>(this.size());
        for (zzbrq zzbrq2 : this) {
            arrayList.add(zzbrq2.asString());
        }
        return arrayList;
    }

    public zzbrq zzYR() {
        if (this.isEmpty()) {
            return null;
        }
        return this.zzceo[this.start];
    }

    public zzbph zzYS() {
        int n = this.start;
        if (!this.isEmpty()) {
            ++n;
        }
        return new zzbph(this.zzceo, n, this.end);
    }

    public zzbph zzYT() {
        if (this.isEmpty()) {
            return null;
        }
        return new zzbph(this.zzceo, this.start, this.end - 1);
    }

    public zzbrq zzYU() {
        if (!this.isEmpty()) {
            return this.zzceo[this.end - 1];
        }
        return null;
    }

    public boolean isEmpty() {
        return this.start >= this.end;
    }

    public int size() {
        return this.end - this.start;
    }

    @Override
    public Iterator<zzbrq> iterator() {
        return new Iterator<zzbrq>(){
            int offset;
            {
                this.offset = zzbph.this.start;
            }

            @Override
            public boolean hasNext() {
                return this.offset < zzbph.this.end;
            }

            public zzbrq zzYV() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No more elements.");
                }
                zzbrq zzbrq2 = zzbph.this.zzceo[this.offset];
                ++this.offset;
                return zzbrq2;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Can't remove component from immutable Path!");
            }

            @Override
            public /* synthetic */ Object next() {
                return this.zzYV();
            }
        };
    }

    public boolean zzi(zzbph zzbph2) {
        if (this.size() > zzbph2.size()) {
            return false;
        }
        int n = this.start;
        int n2 = zzbph2.start;
        while (n < this.end) {
            if (!this.zzceo[n].equals(zzbph2.zzceo[n2])) {
                return false;
            }
            ++n;
            ++n2;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (!(object instanceof zzbph)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        zzbph zzbph2 = (zzbph)object;
        if (this.size() != zzbph2.size()) {
            return false;
        }
        int n = this.start;
        for (int i = zzbph2.start; n < this.end && i < zzbph2.end; ++n, ++i) {
            if (this.zzceo[n].equals(zzbph2.zzceo[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        for (int i = this.start; i < this.end; ++i) {
            n = n * 37 + this.zzceo[i].hashCode();
        }
        return n;
    }

    public int zzj(zzbph zzbph2) {
        int n;
        int n2 = this.start;
        for (n = zzbph2.start; n2 < this.end && n < zzbph2.end; ++n2, ++n) {
            int n3 = this.zzceo[n2].zzi(zzbph2.zzceo[n]);
            if (n3 == 0) continue;
            return n3;
        }
        if (n2 == this.end && n == zzbph2.end) {
            return 0;
        }
        if (n2 == this.end) {
            return -1;
        }
        return 1;
    }

    @Override
    public /* synthetic */ int compareTo(Object object) {
        return this.zzj((zzbph)object);
    }
}

