/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import com.google.firebase.database.DatabaseException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;

public class DatabaseError {
    public static final int DATA_STALE = -1;
    public static final int OPERATION_FAILED = -2;
    public static final int PERMISSION_DENIED = -3;
    public static final int DISCONNECTED = -4;
    public static final int EXPIRED_TOKEN = -6;
    public static final int INVALID_TOKEN = -7;
    public static final int MAX_RETRIES = -8;
    public static final int OVERRIDDEN_BY_SET = -9;
    public static final int UNAVAILABLE = -10;
    public static final int USER_CODE_EXCEPTION = -11;
    public static final int NETWORK_ERROR = -24;
    public static final int WRITE_CANCELED = -25;
    public static final int UNKNOWN_ERROR = -999;
    private static final Map<Integer, String> zzbZM = new HashMap<Integer, String>();
    private static final Map<String, Integer> zzbZN;
    private final int zzbZO;
    private final String message;
    private final String zzbZP;

    public static DatabaseError zziD(String string) {
        return DatabaseError.zzap(string, null);
    }

    public static DatabaseError zzap(String string, String string2) {
        return DatabaseError.zzs(string, string2, null);
    }

    public static DatabaseError zzqv(int n) {
        if (!zzbZM.containsKey(n)) {
            throw new IllegalArgumentException(new StringBuilder(49).append("Invalid Firebase Database error code: ").append(n).toString());
        }
        String string = zzbZM.get(n);
        return new DatabaseError(n, string, null);
    }

    public static DatabaseError zzs(String string, String string2, String string3) {
        Integer n = zzbZN.get(string.toLowerCase());
        if (n == null) {
            n = -999;
        }
        String string4 = string2 == null ? zzbZM.get(n) : string2;
        return new DatabaseError(n, string4, string3);
    }

    public static DatabaseError fromException(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        String string = String.valueOf(zzbZM.get(-11));
        String string2 = String.valueOf(stringWriter.toString());
        String string3 = string2.length() != 0 ? string.concat(string2) : new String(string);
        return new DatabaseError(-11, string3);
    }

    private DatabaseError(int n, String string) {
        this(n, string, null);
    }

    private DatabaseError(int n, String string, String string2) {
        this.zzbZO = n;
        this.message = string;
        this.zzbZP = string2 == null ? "" : string2;
    }

    public int getCode() {
        return this.zzbZO;
    }

    public String getMessage() {
        return this.message;
    }

    public String getDetails() {
        return this.zzbZP;
    }

    public String toString() {
        String string = String.valueOf(this.message);
        return string.length() != 0 ? "DatabaseError: ".concat(string) : new String("DatabaseError: ");
    }

    public DatabaseException toException() {
        String string = String.valueOf(this.message);
        return new DatabaseException(string.length() != 0 ? "Firebase Database error: ".concat(string) : new String("Firebase Database error: "));
    }

    static {
        zzbZM.put(-1, "The transaction needs to be run again with current data");
        zzbZM.put(-2, "The server indicated that this operation failed");
        zzbZM.put(-3, "This client does not have permission to perform this operation");
        zzbZM.put(-4, "The operation had to be aborted due to a network disconnect");
        zzbZM.put(-6, "The supplied auth token has expired");
        zzbZM.put(-7, "The supplied auth token was invalid");
        zzbZM.put(-8, "The transaction had too many retries");
        zzbZM.put(-9, "The transaction was overridden by a subsequent set");
        zzbZM.put(-10, "The service is unavailable");
        zzbZM.put(-11, "User code called from the Firebase Database runloop threw an exception:\n");
        zzbZM.put(-24, "The operation could not be performed due to a network error");
        zzbZM.put(-25, "The write was canceled by the user.");
        zzbZM.put(-999, "An unknown error occurred");
        zzbZN = new HashMap<String, Integer>();
        zzbZN.put("datastale", -1);
        zzbZN.put("failure", -2);
        zzbZN.put("permission_denied", -3);
        zzbZN.put("disconnected", -4);
        zzbZN.put("expired_token", -6);
        zzbZN.put("invalid_token", -7);
        zzbZN.put("maxretries", -8);
        zzbZN.put("overriddenbyset", -9);
        zzbZN.put("unavailable", -10);
        zzbZN.put("network_error", -24);
        zzbZN.put("write_canceled", -25);
    }
}

