/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzbny;
import com.google.android.gms.internal.zzbod;
import com.google.android.gms.internal.zzbog;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class zzbnx<K, V>
extends zzbny<K, V> {
    private final K[] zzcaM;
    private final V[] zzcaN;
    private final Comparator<K> zzcaO;

    public static <A, B, C> zzbnx<A, C> zza(List<A> list, Map<B, C> map, zzbny.zza.zza<A, B> zza2, Comparator<A> comparator) {
        Collections.sort(list, comparator);
        int n = list.size();
        Object[] objectArray = new Object[n];
        Object[] objectArray2 = new Object[n];
        int n2 = 0;
        for (A a : list) {
            objectArray[n2] = a;
            C c = map.get(zza2.zzak(a));
            objectArray2[n2] = c;
            ++n2;
        }
        return new zzbnx<Object, Object>(comparator, objectArray, objectArray2);
    }

    public static <K, V> zzbnx<K, V> zza(Map<K, V> map, Comparator<K> comparator) {
        return zzbnx.zza(new ArrayList<K>(map.keySet()), map, zzbny.zza.zzWW(), comparator);
    }

    public zzbnx(Comparator<K> comparator) {
        this.zzcaM = new Object[0];
        this.zzcaN = new Object[0];
        this.zzcaO = comparator;
    }

    private zzbnx(Comparator<K> comparator, K[] KArray, V[] VArray) {
        this.zzcaM = KArray;
        this.zzcaN = VArray;
        this.zzcaO = comparator;
    }

    @Override
    public boolean containsKey(K k) {
        return this.zzaj(k) != -1;
    }

    @Override
    public V get(K k) {
        int n = this.zzaj(k);
        return n != -1 ? (V)this.zzcaN[n] : null;
    }

    @Override
    public zzbny<K, V> zzag(K k) {
        int n = this.zzaj(k);
        if (n == -1) {
            return this;
        }
        K[] KArray = zzbnx.zza(this.zzcaM, n);
        V[] VArray = zzbnx.zza(this.zzcaN, n);
        return new zzbnx<K, V>(this.zzcaO, KArray, VArray);
    }

    @Override
    public zzbny<K, V> zzi(K k, V v) {
        int n = this.zzaj(k);
        if (n != -1) {
            if (this.zzcaM[n] == k && this.zzcaN[n] == v) {
                return this;
            }
            K[] KArray = zzbnx.zzb(this.zzcaM, n, k);
            V[] VArray = zzbnx.zzb(this.zzcaN, n, v);
            return new zzbnx<K, V>(this.zzcaO, KArray, VArray);
        }
        if (this.zzcaM.length > 25) {
            HashMap<K, V> hashMap = new HashMap<K, V>(this.zzcaM.length + 1);
            for (int i = 0; i < this.zzcaM.length; ++i) {
                hashMap.put(this.zzcaM[i], this.zzcaN[i]);
            }
            hashMap.put(k, v);
            return zzbog.zzc(hashMap, this.zzcaO);
        }
        int n2 = this.zzai(k);
        K[] KArray = zzbnx.zza(this.zzcaM, n2, k);
        V[] VArray = zzbnx.zza(this.zzcaN, n2, v);
        return new zzbnx<K, V>(this.zzcaO, KArray, VArray);
    }

    @Override
    public K zzWT() {
        return this.zzcaM.length > 0 ? (K)this.zzcaM[0] : null;
    }

    @Override
    public K zzWU() {
        return this.zzcaM.length > 0 ? (K)this.zzcaM[this.zzcaM.length - 1] : null;
    }

    @Override
    public int size() {
        return this.zzcaM.length;
    }

    @Override
    public boolean isEmpty() {
        return this.zzcaM.length == 0;
    }

    @Override
    public void zza(zzbod.zzb<K, V> zzb2) {
        for (int i = 0; i < this.zzcaM.length; ++i) {
            zzb2.zzj(this.zzcaM[i], this.zzcaN[i]);
        }
    }

    private Iterator<Map.Entry<K, V>> zze(final int n, final boolean bl) {
        return new Iterator<Map.Entry<K, V>>(){
            int zzcaP;
            {
                this.zzcaP = n;
            }

            @Override
            public boolean hasNext() {
                return bl ? this.zzcaP >= 0 : this.zzcaP < zzbnx.this.zzcaM.length;
            }

            @Override
            public Map.Entry<K, V> next() {
                Object object = zzbnx.this.zzcaM[this.zzcaP];
                Object object2 = zzbnx.this.zzcaN[this.zzcaP];
                this.zzcaP = bl ? this.zzcaP - 1 : this.zzcaP + 1;
                return new AbstractMap.SimpleImmutableEntry<Object, Object>(object, object2);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Can't remove elements from ImmutableSortedMap");
            }
        };
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return this.zze(0, false);
    }

    @Override
    public Iterator<Map.Entry<K, V>> zzWV() {
        return this.zze(this.zzcaM.length - 1, true);
    }

    @Override
    public K zzah(K k) {
        int n = this.zzaj(k);
        if (n == -1) {
            throw new IllegalArgumentException("Can't find predecessor of nonexistent key");
        }
        return n > 0 ? (K)this.zzcaM[n - 1] : null;
    }

    @Override
    public Comparator<K> getComparator() {
        return this.zzcaO;
    }

    private static <T> T[] zza(T[] TArray, int n) {
        int n2 = TArray.length - 1;
        Object[] objectArray = new Object[n2];
        System.arraycopy(TArray, 0, objectArray, 0, n);
        System.arraycopy(TArray, n + 1, objectArray, n, n2 - n);
        return objectArray;
    }

    private static <T> T[] zza(T[] TArray, int n, T t) {
        int n2 = TArray.length + 1;
        Object[] objectArray = new Object[n2];
        System.arraycopy(TArray, 0, objectArray, 0, n);
        objectArray[n] = t;
        System.arraycopy(TArray, n, objectArray, n + 1, n2 - n - 1);
        return objectArray;
    }

    private static <T> T[] zzb(T[] TArray, int n, T t) {
        int n2 = TArray.length;
        Object[] objectArray = new Object[n2];
        System.arraycopy(TArray, 0, objectArray, 0, n2);
        objectArray[n] = t;
        return objectArray;
    }

    private int zzai(K k) {
        int n;
        for (n = 0; n < this.zzcaM.length && this.zzcaO.compare(this.zzcaM[n], k) < 0; ++n) {
        }
        return n;
    }

    private int zzaj(K k) {
        int n = 0;
        for (K k2 : this.zzcaM) {
            if (this.zzcaO.compare(k, k2) == 0) {
                return n;
            }
            ++n;
        }
        return -1;
    }
}

