/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import com.google.firebase.database.DatabaseException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;

public class DatabaseError {
    public static final int DATA_STALE = -1;
    public static final int OPERATION_FAILED = -2;
    public static final int PERMISSION_DENIED = -3;
    public static final int DISCONNECTED = -4;
    public static final int EXPIRED_TOKEN = -6;
    public static final int INVALID_TOKEN = -7;
    public static final int MAX_RETRIES = -8;
    public static final int OVERRIDDEN_BY_SET = -9;
    public static final int UNAVAILABLE = -10;
    public static final int USER_CODE_EXCEPTION = -11;
    public static final int NETWORK_ERROR = -24;
    public static final int WRITE_CANCELED = -25;
    public static final int UNKNOWN_ERROR = -999;
    private static final Map<Integer, String> zzcbF = new HashMap<Integer, String>();
    private static final Map<String, Integer> zzcbG;
    private final int code;
    private final String message;
    private final String zzcbH;

    public static DatabaseError zzgZ(String string) {
        String string2 = string;
        Integer n = zzcbG.get(string2.toLowerCase());
        if (n == null) {
            n = -999;
        }
        String string3 = zzcbF.get(n);
        return new DatabaseError(n, string3, null);
    }

    public static DatabaseError zzaa(String string, String string2) {
        String string3 = string2;
        String string4 = string;
        Integer n = zzcbG.get(string4.toLowerCase());
        if (n == null) {
            n = -999;
        }
        String string5 = string3 == null ? zzcbF.get(n) : string3;
        return new DatabaseError(n, string5, null);
    }

    public static DatabaseError zzbT(int n) {
        if (!zzcbF.containsKey(-25)) {
            throw new IllegalArgumentException(new StringBuilder(49).append("Invalid Firebase Database error code: -25").toString());
        }
        String string = zzcbF.get(-25);
        return new DatabaseError(-25, string, null);
    }

    public static DatabaseError fromException(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        String string = String.valueOf(zzcbF.get(-11));
        String string2 = String.valueOf(stringWriter.toString());
        String string3 = string2.length() != 0 ? string.concat(string2) : new String(string);
        return new DatabaseError(-11, string3);
    }

    private DatabaseError(int n, String string) {
        this(-11, string, null);
    }

    private DatabaseError(int n, String string, String string2) {
        this.code = n;
        this.message = string;
        this.zzcbH = "";
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getDetails() {
        return this.zzcbH;
    }

    public String toString() {
        String string = String.valueOf(this.message);
        if (string.length() != 0) {
            return "DatabaseError: ".concat(string);
        }
        return new String("DatabaseError: ");
    }

    public DatabaseException toException() {
        String string = String.valueOf(this.message);
        return new DatabaseException(string.length() != 0 ? "Firebase Database error: ".concat(string) : new String("Firebase Database error: "));
    }

    static {
        zzcbF.put(-1, "The transaction needs to be run again with current data");
        zzcbF.put(-2, "The server indicated that this operation failed");
        zzcbF.put(-3, "This client does not have permission to perform this operation");
        zzcbF.put(-4, "The operation had to be aborted due to a network disconnect");
        zzcbF.put(-6, "The supplied auth token has expired");
        zzcbF.put(-7, "The supplied auth token was invalid");
        zzcbF.put(-8, "The transaction had too many retries");
        zzcbF.put(-9, "The transaction was overridden by a subsequent set");
        zzcbF.put(-10, "The service is unavailable");
        zzcbF.put(-11, "User code called from the Firebase Database runloop threw an exception:\n");
        zzcbF.put(-24, "The operation could not be performed due to a network error");
        zzcbF.put(-25, "The write was canceled by the user.");
        zzcbF.put(-999, "An unknown error occurred");
        zzcbG = new HashMap<String, Integer>();
        zzcbG.put("datastale", -1);
        zzcbG.put("failure", -2);
        zzcbG.put("permission_denied", -3);
        zzcbG.put("disconnected", -4);
        zzcbG.put("expired_token", -6);
        zzcbG.put("invalid_token", -7);
        zzcbG.put("maxretries", -8);
        zzcbG.put("overriddenbyset", -9);
        zzcbG.put("unavailable", -10);
        zzcbG.put("network_error", -24);
        zzcbG.put("write_canceled", -25);
    }
}

