/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import com.google.android.gms.internal.abi;
import com.google.android.gms.internal.ace;
import com.google.android.gms.internal.ach;
import com.google.android.gms.internal.ack;
import com.google.android.gms.internal.adq;
import com.google.android.gms.internal.ads;
import com.google.android.gms.internal.adt;
import com.google.android.gms.internal.adv;
import com.google.android.gms.internal.adw;
import com.google.android.gms.internal.uw;
import com.google.android.gms.internal.vd;
import com.google.android.gms.internal.vn;
import com.google.android.gms.internal.vq;
import com.google.android.gms.internal.wu;
import com.google.android.gms.internal.yj;
import com.google.android.gms.tasks.Task;
import com.google.firebase.database.DatabaseError;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.FirebaseDatabase;
import com.google.firebase.database.OnDisconnect;
import com.google.firebase.database.Query;
import com.google.firebase.database.Transaction;
import com.google.firebase.database.zzc;
import com.google.firebase.database.zzd;
import com.google.firebase.database.zze;
import com.google.firebase.database.zzf;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;

public class DatabaseReference
extends Query {
    private static vd zzcbI;

    DatabaseReference(vq vq2, vn vn2) {
        super(vq2, vn2);
    }

    public DatabaseReference child(String string) {
        if (string == null) {
            throw new NullPointerException("Can't pass null for argument 'pathString' in child()");
        }
        if (this.zzcch.isEmpty()) {
            adv.zzhB(string);
        } else {
            adv.zzhA(string);
        }
        vn vn2 = this.zzcch.zzh(new vn(string));
        return new DatabaseReference(this.zzcbV, vn2);
    }

    public DatabaseReference push() {
        abi abi2 = abi.zzhs(ads.zzaz(this.zzcbV.zzHz()));
        return new DatabaseReference(this.zzcbV, this.zzcch.zza(abi2));
    }

    public Task<Void> setValue(Object object) {
        return this.zza(object, ack.zzc(this.zzcch, null), null);
    }

    public Task<Void> setValue(Object object, Object object2) {
        return this.zza(object, ack.zzc(this.zzcch, object2), null);
    }

    public void setValue(Object object, CompletionListener completionListener) {
        this.zza(object, ack.zzc(this.zzcch, null), completionListener);
    }

    public void setValue(Object object, Object object2, CompletionListener completionListener) {
        this.zza(object, ack.zzc(this.zzcch, object2), completionListener);
    }

    private final Task<Void> zza(Object object, ace ace2, CompletionListener completionListener) {
        adv.zzO(this.zzcch);
        yj.zza(this.zzcch, object);
        Object object2 = adw.zzan(object);
        adv.zzam(object2);
        ace ace3 = ach.zza(object2, ace2);
        adq<Task<Void>, CompletionListener> adq2 = adt.zzb(completionListener);
        this.zzcbV.zzq(new zzc(this, ace3, adq2));
        return adq2.getFirst();
    }

    public Task<Void> setPriority(Object object) {
        return this.zza(ack.zzc(this.zzcch, object), null);
    }

    public void setPriority(Object object, CompletionListener completionListener) {
        this.zza(ack.zzc(this.zzcch, object), completionListener);
    }

    private final Task<Void> zza(ace ace2, CompletionListener completionListener) {
        adv.zzO(this.zzcch);
        adq<Task<Void>, CompletionListener> adq2 = adt.zzb(completionListener);
        this.zzcbV.zzq(new zzd(this, ace2, adq2));
        return adq2.getFirst();
    }

    public Task<Void> updateChildren(Map<String, Object> map) {
        return this.zza(map, null);
    }

    public void updateChildren(Map<String, Object> map, CompletionListener completionListener) {
        this.zza(map, completionListener);
    }

    private final Task<Void> zza(Map<String, Object> map, CompletionListener completionListener) {
        if (map == null) {
            throw new NullPointerException("Can't pass null for argument 'update' in updateChildren()");
        }
        Map<String, Object> map2 = adw.zzG(map);
        uw uw2 = uw.zzE(adv.zzb(this.zzcch, map2));
        adq<Task<Void>, CompletionListener> adq2 = adt.zzb(completionListener);
        this.zzcbV.zzq(new zze(this, uw2, adq2, map2));
        return adq2.getFirst();
    }

    public Task<Void> removeValue() {
        return this.setValue(null);
    }

    public void removeValue(CompletionListener completionListener) {
        this.setValue(null, completionListener);
    }

    public OnDisconnect onDisconnect() {
        adv.zzO(this.zzcch);
        return new OnDisconnect(this.zzcbV, this.zzcch);
    }

    public void runTransaction(Transaction.Handler handler) {
        this.runTransaction(handler, true);
    }

    public void runTransaction(Transaction.Handler handler, boolean bl) {
        if (handler == null) {
            throw new NullPointerException("Can't pass null for argument 'handler' in runTransaction()");
        }
        adv.zzO(this.zzcch);
        this.zzcbV.zzq(new zzf(this, handler, bl));
    }

    public static void goOffline() {
        wu.zzd(DatabaseReference.zzFC());
    }

    public static void goOnline() {
        wu.zze(DatabaseReference.zzFC());
    }

    public FirebaseDatabase getDatabase() {
        return this.zzcbV.getDatabase();
    }

    public String toString() {
        DatabaseReference databaseReference = this.getParent();
        if (databaseReference == null) {
            return this.zzcbV.toString();
        }
        try {
            String string = String.valueOf(databaseReference.toString());
            String string2 = String.valueOf(URLEncoder.encode(this.getKey(), "UTF-8").replace("+", "%20"));
            return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("/").append(string2).toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string = String.valueOf(this.getKey());
            throw new DatabaseException(string.length() != 0 ? "Failed to URLEncode key: ".concat(string) : new String("Failed to URLEncode key: "), unsupportedEncodingException);
        }
    }

    public DatabaseReference getParent() {
        vn vn2 = this.zzcch.zzHv();
        if (vn2 != null) {
            return new DatabaseReference(this.zzcbV, vn2);
        }
        return null;
    }

    public DatabaseReference getRoot() {
        return new DatabaseReference(this.zzcbV, new vn(""));
    }

    public String getKey() {
        if (this.zzcch.isEmpty()) {
            return null;
        }
        return this.zzcch.zzHw().asString();
    }

    public boolean equals(Object object) {
        return object instanceof DatabaseReference && this.toString().equals(object.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private static synchronized vd zzFC() {
        if (zzcbI == null) {
            zzcbI = new vd();
        }
        return zzcbI;
    }

    public static interface CompletionListener {
        public void onComplete(DatabaseError var1, DatabaseReference var2);
    }
}

