/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import android.text.TextUtils;
import com.google.android.gms.internal.qe;
import com.google.android.gms.internal.qo;
import com.google.android.gms.internal.qr;
import com.google.android.gms.internal.ru;
import com.google.android.gms.internal.rv;
import com.google.android.gms.internal.ys;
import com.google.android.gms.internal.yu;
import com.google.android.gms.internal.yw;
import com.google.firebase.FirebaseApp;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.Logger;
import com.google.firebase.database.zzg;
import java.util.HashMap;
import java.util.Map;

public class FirebaseDatabase {
    private static final Map<String, Map<ru, FirebaseDatabase>> zzbYS = new HashMap<String, Map<ru, FirebaseDatabase>>();
    private final FirebaseApp zzbYT;
    private final ru zzbYU;
    private final qe zzbYV;
    private qr zzbYW;

    public static FirebaseDatabase getInstance() {
        FirebaseApp firebaseApp = FirebaseApp.getInstance();
        if (firebaseApp == null) {
            throw new DatabaseException("You must call FirebaseApp.initialize() first.");
        }
        return FirebaseDatabase.getInstance(firebaseApp, firebaseApp.getOptions().getDatabaseUrl());
    }

    public static FirebaseDatabase getInstance(String string) {
        FirebaseApp firebaseApp = FirebaseApp.getInstance();
        if (firebaseApp == null) {
            throw new DatabaseException("You must call FirebaseApp.initialize() first.");
        }
        return FirebaseDatabase.getInstance(firebaseApp, string);
    }

    public static FirebaseDatabase getInstance(FirebaseApp firebaseApp) {
        return FirebaseDatabase.getInstance(firebaseApp, firebaseApp.getOptions().getDatabaseUrl());
    }

    public static synchronized FirebaseDatabase getInstance(FirebaseApp firebaseApp, String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new DatabaseException("Failed to get FirebaseDatabase instance: Specify DatabaseURL within FirebaseApp or from your getInstance() call.");
        }
        Map<ru, FirebaseDatabase> map = zzbYS.get(firebaseApp.getName());
        if (map == null) {
            map = new HashMap<ru, FirebaseDatabase>();
            zzbYS.put(firebaseApp.getName(), map);
        }
        ys ys2 = yu.zzgX(string);
        if (!ys2.zzbZi.isEmpty()) {
            String string2 = String.valueOf(ys2.zzbZi.toString());
            throw new DatabaseException(new StringBuilder(113 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Specified Database URL '").append(string).append("' is invalid. It should point to the root of a Firebase Database but it includes a path: ").append(string2).toString());
        }
        FirebaseDatabase firebaseDatabase = map.get(ys2.zzbYU);
        if (firebaseDatabase == null) {
            qe qe2 = new qe();
            if (!firebaseApp.zzEp()) {
                qe2.zzgR(firebaseApp.getName());
            }
            qe2.zzd(firebaseApp);
            firebaseDatabase = new FirebaseDatabase(firebaseApp, ys2.zzbYU, qe2);
            map.put(ys2.zzbYU, firebaseDatabase);
        }
        return firebaseDatabase;
    }

    private FirebaseDatabase(FirebaseApp firebaseApp, ru ru2, qe qe2) {
        this.zzbYT = firebaseApp;
        this.zzbYU = ru2;
        this.zzbYV = qe2;
    }

    public FirebaseApp getApp() {
        return this.zzbYT;
    }

    public DatabaseReference getReference() {
        this.zzFl();
        return new DatabaseReference(this.zzbYW, qo.zzGY());
    }

    public DatabaseReference getReference(String string) {
        this.zzFl();
        if (string == null) {
            throw new NullPointerException("Can't pass null for argument 'pathString' in FirebaseDatabase.getReference()");
        }
        yw.zzhc(string);
        qo qo2 = new qo(string);
        return new DatabaseReference(this.zzbYW, qo2);
    }

    public DatabaseReference getReferenceFromUrl(String string) {
        this.zzFl();
        if (string == null) {
            throw new NullPointerException("Can't pass null for argument 'url' in FirebaseDatabase.getReferenceFromUrl()");
        }
        ys ys2 = yu.zzgX(string);
        if (!ys2.zzbYU.host.equals(this.zzbYW.zzHg().host)) {
            String string2 = String.valueOf(this.getReference().toString());
            throw new DatabaseException(new StringBuilder(93 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Invalid URL (").append(string).append(") passed to getReference().  URL was expected to match configured Database URL: ").append(string2).toString());
        }
        return new DatabaseReference(this.zzbYW, ys2.zzbZi);
    }

    public void purgeOutstandingWrites() {
        this.zzFl();
        this.zzbYW.zzq(new zzg(this));
    }

    public void goOnline() {
        this.zzFl();
        rv.zzl(this.zzbYW);
    }

    public void goOffline() {
        this.zzFl();
        rv.zzk(this.zzbYW);
    }

    public synchronized void setLogLevel(Logger.Level level) {
        this.zzgB("setLogLevel");
        this.zzbYV.setLogLevel(level);
    }

    public synchronized void setPersistenceEnabled(boolean bl) {
        this.zzgB("setPersistenceEnabled");
        this.zzbYV.setPersistenceEnabled(bl);
    }

    public synchronized void setPersistenceCacheSizeBytes(long l) {
        this.zzgB("setPersistenceCacheSizeBytes");
        this.zzbYV.setPersistenceCacheSizeBytes(l);
    }

    public static String getSdkVersion() {
        return "3.0.0";
    }

    private final void zzgB(String string) {
        if (this.zzbYW != null) {
            throw new DatabaseException(new StringBuilder(77 + String.valueOf(string).length()).append("Calls to ").append(string).append("() must be made before any other usage of FirebaseDatabase instance.").toString());
        }
    }

    private final synchronized void zzFl() {
        if (this.zzbYW == null) {
            this.zzbYW = rv.zza(this.zzbYV, this.zzbYU, this);
        }
    }

    static /* synthetic */ qr zza(FirebaseDatabase firebaseDatabase) {
        return firebaseDatabase.zzbYW;
    }
}

