/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import android.text.TextUtils;
import com.google.android.gms.internal.qg;
import com.google.android.gms.internal.qr;
import com.google.android.gms.internal.qu;
import com.google.android.gms.internal.rx;
import com.google.android.gms.internal.ry;
import com.google.android.gms.internal.zb;
import com.google.android.gms.internal.zd;
import com.google.android.gms.internal.zf;
import com.google.firebase.FirebaseApp;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.Logger;
import com.google.firebase.database.zzg;
import java.util.HashMap;
import java.util.Map;

public class FirebaseDatabase {
    private static final Map<String, Map<rx, FirebaseDatabase>> zzbYU = new HashMap<String, Map<rx, FirebaseDatabase>>();
    private final FirebaseApp zzbYV;
    private final rx zzbYW;
    private final qg zzbYX;
    private qu zzbYY;

    public static FirebaseDatabase getInstance() {
        FirebaseApp firebaseApp = FirebaseApp.getInstance();
        if (firebaseApp == null) {
            throw new DatabaseException("You must call FirebaseApp.initialize() first.");
        }
        return FirebaseDatabase.getInstance(firebaseApp, firebaseApp.getOptions().getDatabaseUrl());
    }

    public static FirebaseDatabase getInstance(String string) {
        FirebaseApp firebaseApp = FirebaseApp.getInstance();
        if (firebaseApp == null) {
            throw new DatabaseException("You must call FirebaseApp.initialize() first.");
        }
        return FirebaseDatabase.getInstance(firebaseApp, string);
    }

    public static FirebaseDatabase getInstance(FirebaseApp firebaseApp) {
        return FirebaseDatabase.getInstance(firebaseApp, firebaseApp.getOptions().getDatabaseUrl());
    }

    public static synchronized FirebaseDatabase getInstance(FirebaseApp firebaseApp, String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new DatabaseException("Failed to get FirebaseDatabase instance: Specify DatabaseURL within FirebaseApp or from your getInstance() call.");
        }
        Map<rx, FirebaseDatabase> map = zzbYU.get(firebaseApp.getName());
        if (map == null) {
            map = new HashMap<rx, FirebaseDatabase>();
            zzbYU.put(firebaseApp.getName(), map);
        }
        zb zb2 = zd.zzgX(string);
        if (!zb2.zzbZf.isEmpty()) {
            String string2 = String.valueOf(zb2.zzbZf.toString());
            throw new DatabaseException(new StringBuilder(113 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Specified Database URL '").append(string).append("' is invalid. It should point to the root of a Firebase Database but it includes a path: ").append(string2).toString());
        }
        FirebaseDatabase firebaseDatabase = map.get(zb2.zzbYW);
        if (firebaseDatabase == null) {
            qg qg2 = new qg();
            if (!firebaseApp.zzEq()) {
                qg2.zzgR(firebaseApp.getName());
            }
            qg2.zzd(firebaseApp);
            firebaseDatabase = new FirebaseDatabase(firebaseApp, zb2.zzbYW, qg2);
            map.put(zb2.zzbYW, firebaseDatabase);
        }
        return firebaseDatabase;
    }

    private FirebaseDatabase(FirebaseApp firebaseApp, rx rx2, qg qg2) {
        this.zzbYV = firebaseApp;
        this.zzbYW = rx2;
        this.zzbYX = qg2;
    }

    public FirebaseApp getApp() {
        return this.zzbYV;
    }

    public DatabaseReference getReference() {
        this.zzFm();
        return new DatabaseReference(this.zzbYY, qr.zzGZ());
    }

    public DatabaseReference getReference(String string) {
        this.zzFm();
        if (string == null) {
            throw new NullPointerException("Can't pass null for argument 'pathString' in FirebaseDatabase.getReference()");
        }
        zf.zzhc(string);
        qr qr2 = new qr(string);
        return new DatabaseReference(this.zzbYY, qr2);
    }

    public DatabaseReference getReferenceFromUrl(String string) {
        this.zzFm();
        if (string == null) {
            throw new NullPointerException("Can't pass null for argument 'url' in FirebaseDatabase.getReferenceFromUrl()");
        }
        zb zb2 = zd.zzgX(string);
        if (!zb2.zzbYW.host.equals(this.zzbYY.zzHh().host)) {
            String string2 = String.valueOf(this.getReference().toString());
            throw new DatabaseException(new StringBuilder(93 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Invalid URL (").append(string).append(") passed to getReference().  URL was expected to match configured Database URL: ").append(string2).toString());
        }
        return new DatabaseReference(this.zzbYY, zb2.zzbZf);
    }

    public void purgeOutstandingWrites() {
        this.zzFm();
        this.zzbYY.zzq(new zzg(this));
    }

    public void goOnline() {
        this.zzFm();
        ry.zzl(this.zzbYY);
    }

    public void goOffline() {
        this.zzFm();
        ry.zzk(this.zzbYY);
    }

    public synchronized void setLogLevel(Logger.Level level) {
        this.zzgB("setLogLevel");
        this.zzbYX.setLogLevel(level);
    }

    public synchronized void setPersistenceEnabled(boolean bl) {
        this.zzgB("setPersistenceEnabled");
        this.zzbYX.setPersistenceEnabled(bl);
    }

    public synchronized void setPersistenceCacheSizeBytes(long l) {
        this.zzgB("setPersistenceCacheSizeBytes");
        this.zzbYX.setPersistenceCacheSizeBytes(l);
    }

    public static String getSdkVersion() {
        return "3.0.0";
    }

    private final void zzgB(String string) {
        if (this.zzbYY != null) {
            throw new DatabaseException(new StringBuilder(77 + String.valueOf(string).length()).append("Calls to ").append(string).append("() must be made before any other usage of FirebaseDatabase instance.").toString());
        }
    }

    private final synchronized void zzFm() {
        if (this.zzbYY == null) {
            this.zzbYY = ry.zza(this.zzbYX, this.zzbYW, this);
        }
    }

    static /* synthetic */ qu zza(FirebaseDatabase firebaseDatabase) {
        return firebaseDatabase.zzbYY;
    }
}

