/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabaseLockedException;
import android.database.sqlite.SQLiteException;
import com.google.android.gms.internal.zzdnb;
import com.google.android.gms.internal.zzdnc;
import com.google.android.gms.internal.zzdnd;
import com.google.android.gms.internal.zzdpy;
import com.google.android.gms.internal.zzdqc;
import com.google.android.gms.internal.zzdqq;
import com.google.android.gms.internal.zzdtl;
import com.google.android.gms.internal.zzduh;
import com.google.android.gms.internal.zzdui;
import com.google.android.gms.internal.zzdum;
import com.google.android.gms.internal.zzduu;
import com.google.android.gms.internal.zzdvp;
import com.google.android.gms.internal.zzdvs;
import com.google.android.gms.internal.zzdwk;
import com.google.android.gms.internal.zzdwo;
import com.google.android.gms.internal.zzdwq;
import com.google.android.gms.internal.zzdxc;
import com.google.android.gms.internal.zzdxk;
import com.google.android.gms.internal.zzdxl;
import com.google.android.gms.internal.zzdxo;
import com.google.android.gms.internal.zzdyq;
import com.google.android.gms.internal.zzdyx;
import com.google.android.gms.internal.zzdyz;
import com.google.android.gms.internal.zzdzc;
import com.google.firebase.database.DatabaseException;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class zzdna
implements zzduh {
    private static final Charset zzfbx = Charset.forName("UTF-8");
    private final SQLiteDatabase zzlne;
    private final zzdwk zzlnf;
    private boolean zzlng;
    private long zzlnh = 0L;

    public zzdna(Context context, zzdqc zzdqc2, String string) {
        String string2;
        try {
            string2 = URLEncoder.encode(string, "utf-8");
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.zzlnf = zzdqc2.zzpa("Persistence");
        this.zzlne = zzdna.zzao(context, string2);
    }

    @Override
    public final void zza(zzdqq zzdqq2, zzdxl zzdxl2, long l) {
        this.zzbpq();
        long l2 = System.currentTimeMillis();
        byte[] byArray = zzdna.zzaw(zzdxl2.getValue(true));
        this.zza(zzdqq2, l, "o", byArray);
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzlnf.zzbwa()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Persisted user overwrite in %dms", l3);
            this.zzlnf.zzb(string, null, objectArray);
        }
    }

    @Override
    public final void zza(zzdqq zzdqq2, zzdpy zzdpy2, long l) {
        this.zzbpq();
        long l2 = System.currentTimeMillis();
        byte[] byArray = zzdna.zzaw(zzdpy2.zzce(true));
        this.zza(zzdqq2, l, "m", byArray);
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzlnf.zzbwa()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Persisted user merge in %dms", l3);
            this.zzlnf.zzb(string, null, objectArray);
        }
    }

    @Override
    public final void zzbk(long l) {
        this.zzbpq();
        long l2 = System.currentTimeMillis();
        int n = this.zzlne.delete("writes", "id = ?", new String[]{String.valueOf(l)});
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzlnf.zzbwa()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Deleted %d write(s) with writeId %d in %dms", n, l, l3);
            this.zzlnf.zzb(string, null, objectArray);
        }
    }

    @Override
    public final List<zzdtl> zzbpm() {
        String[] stringArray = new String[]{"id", "path", "type", "part", "node"};
        long l = System.currentTimeMillis();
        ArrayList<zzdtl> arrayList = new ArrayList<zzdtl>();
        try (Cursor cursor = this.zzlne.query("writes", stringArray, null, null, null, null, "id, part");){
            ArrayList<zzdtl> arrayList2;
            long l2;
            while (cursor.moveToNext()) {
                zzdtl zzdtl2;
                Iterable<zzdxk> iterable;
                byte[] byArray;
                l2 = cursor.getLong(0);
                arrayList2 = new zzdqq(cursor.getString(1));
                String string = cursor.getString(2);
                if (cursor.isNull(3)) {
                    byArray = cursor.getBlob(4);
                } else {
                    ArrayList<byte[]> arrayList3 = new ArrayList<byte[]>();
                    do {
                        arrayList3.add(cursor.getBlob(4));
                    } while (cursor.moveToNext() && cursor.getLong(0) == l2);
                    cursor.moveToPrevious();
                    byArray = zzdna.zzao(arrayList3);
                }
                Object object = zzdyq.zzph((String)new String(byArray, zzfbx));
                if ("o".equals(string)) {
                    iterable = zzdxo.zza(object, zzdxc.zzbwu());
                    zzdtl2 = new zzdtl(l2, (zzdqq)((Object)arrayList2), (zzdxl)iterable, true);
                } else if ("m".equals(string)) {
                    iterable = zzdpy.zzae((Map)object);
                    zzdtl2 = new zzdtl(l2, (zzdqq)((Object)arrayList2), (zzdpy)iterable);
                } else {
                    String string2 = String.valueOf(string);
                    throw new IllegalStateException(string2.length() != 0 ? "Got invalid write type: ".concat(string2) : new String("Got invalid write type: "));
                }
                arrayList.add(zzdtl2);
            }
            l2 = System.currentTimeMillis() - l;
            if (this.zzlnf.zzbwa()) {
                Object[] objectArray = new Object[]{};
                String string = String.format("Loaded %d writes in %dms", arrayList.size(), l2);
                this.zzlnf.zzb(string, null, objectArray);
            }
            arrayList2 = arrayList;
            return arrayList2;
        }
    }

    private final void zza(zzdqq zzdqq2, long l, String string, byte[] byArray) {
        this.zzbpq();
        this.zzlne.delete("writes", "id = ?", new String[]{String.valueOf(l)});
        if (byArray.length >= 262144) {
            List<byte[]> list = zzdna.zzd(byArray, 262144);
            for (int i = 0; i < list.size(); ++i) {
                ContentValues contentValues = new ContentValues();
                contentValues.put("id", Long.valueOf(l));
                contentValues.put("path", zzdna.zzc(zzdqq2));
                contentValues.put("type", string);
                contentValues.put("part", Integer.valueOf(i));
                contentValues.put("node", list.get(i));
                this.zzlne.insertWithOnConflict("writes", null, contentValues, 5);
            }
            return;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("id", Long.valueOf(l));
        contentValues.put("path", zzdna.zzc(zzdqq2));
        contentValues.put("type", string);
        contentValues.put("part", null);
        contentValues.put("node", byArray);
        this.zzlne.insertWithOnConflict("writes", null, contentValues, 5);
    }

    @Override
    public final zzdxl zza(zzdqq zzdqq2) {
        return this.zzb(zzdqq2);
    }

    @Override
    public final void zza(zzdqq zzdqq2, zzdxl zzdxl2) {
        this.zzbpq();
        this.zza(zzdqq2, zzdxl2, false);
    }

    @Override
    public final void zzb(zzdqq zzdqq2, zzdxl zzdxl2) {
        this.zzbpq();
        this.zza(zzdqq2, zzdxl2, true);
    }

    private final void zza(zzdqq zzdqq2, zzdxl zzdxl2, boolean bl) {
        int n;
        int n2;
        long l = System.currentTimeMillis();
        if (!bl) {
            n2 = this.zza("serverCache", zzdqq2);
            n = this.zzc(zzdqq2, zzdxl2);
        } else {
            n2 = 0;
            n = 0;
            for (zzdxk zzdxk2 : zzdxl2) {
                n2 += this.zza("serverCache", zzdqq2.zza(zzdxk2.zzbxd()));
                n += this.zzc(zzdqq2.zza(zzdxk2.zzbxd()), zzdxk2.zzbph());
            }
        }
        long l2 = System.currentTimeMillis() - l;
        if (this.zzlnf.zzbwa()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Persisted a total of %d rows and deleted %d rows for a set at %s in %dms", n, n2, zzdqq2.toString(), l2);
            this.zzlnf.zzb(string, null, objectArray);
        }
    }

    @Override
    public final void zza(zzdqq zzdqq2, zzdpy zzdpy2) {
        this.zzbpq();
        long l = System.currentTimeMillis();
        int n = 0;
        int n2 = 0;
        for (Map.Entry<zzdqq, zzdxl> entry : zzdpy2) {
            n2 += this.zza("serverCache", zzdqq2.zzh(entry.getKey()));
            n += this.zzc(zzdqq2.zzh(entry.getKey()), entry.getValue());
        }
        long l2 = System.currentTimeMillis() - l;
        if (this.zzlnf.zzbwa()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Persisted a total of %d rows and deleted %d rows for a merge at %s in %dms", n, n2, zzdqq2.toString(), l2);
            this.zzlnf.zzb(string, null, objectArray);
        }
    }

    @Override
    public final long zzbpn() {
        String string = String.format("SELECT sum(length(%s) + length(%s)) FROM %s", "value", "path", "serverCache");
        try (Cursor cursor = this.zzlne.rawQuery(string, null);){
            if (cursor.moveToFirst()) {
                long l = cursor.getLong(0);
                return l;
            }
            throw new IllegalStateException("Couldn't read database result!");
        }
    }

    @Override
    public final void zza(zzdum zzdum2) {
        this.zzbpq();
        long l = System.currentTimeMillis();
        ContentValues contentValues = new ContentValues();
        contentValues.put("id", Long.valueOf(zzdum2.id));
        contentValues.put("path", zzdna.zzc(zzdum2.zzmaj.zzbpk()));
        contentValues.put("queryParams", zzdum2.zzmaj.zzbvn().zzbvl());
        contentValues.put("lastUse", Long.valueOf(zzdum2.zzmak));
        contentValues.put("complete", Boolean.valueOf(zzdum2.complete));
        contentValues.put("active", Boolean.valueOf(zzdum2.zzimc));
        this.zzlne.insertWithOnConflict("trackedQueries", null, contentValues, 5);
        long l2 = System.currentTimeMillis() - l;
        if (this.zzlnf.zzbwa()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Saved new tracked query in %dms", l2);
            this.zzlnf.zzb(string, null, objectArray);
        }
    }

    @Override
    public final void zzbl(long l) {
        this.zzbpq();
        String string = String.valueOf(l);
        String string2 = "id = ?";
        this.zzlne.delete("trackedQueries", string2, new String[]{string});
        String string3 = "id = ?";
        this.zzlne.delete("trackedKeys", string3, new String[]{string});
    }

    @Override
    public final List<zzdum> zzbpo() {
        String[] stringArray = new String[]{"id", "path", "queryParams", "lastUse", "complete", "active"};
        long l = System.currentTimeMillis();
        ArrayList<zzdum> arrayList = new ArrayList<zzdum>();
        try (Cursor cursor = this.zzlne.query("trackedQueries", stringArray, null, null, null, null, "id");){
            Object[] objectArray;
            Object object;
            ArrayList<zzdum> arrayList2;
            long l2;
            while (cursor.moveToNext()) {
                Map map;
                l2 = cursor.getLong(0);
                arrayList2 = new zzdqq(cursor.getString(1));
                String string = cursor.getString(2);
                try {
                    map = zzdyq.zzpg((String)string);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
                object = map;
                ArrayList<zzdum> arrayList3 = arrayList2;
                objectArray = zzdvp.zzag((Map<String, Object>)object);
                zzdvs zzdvs2 = new zzdvs((zzdqq)((Object)arrayList3), (zzdvp)objectArray);
                long l3 = cursor.getLong(3);
                boolean bl = cursor.getInt(4) != 0;
                boolean bl2 = cursor.getInt(5) != 0;
                zzdum zzdum2 = new zzdum(l2, zzdvs2, l3, bl, bl2);
                arrayList.add(zzdum2);
            }
            l2 = System.currentTimeMillis() - l;
            if (this.zzlnf.zzbwa()) {
                objectArray = new Object[]{};
                object = String.format("Loaded %d tracked queries in %dms", arrayList.size(), l2);
                this.zzlnf.zzb((String)object, null, objectArray);
            }
            arrayList2 = arrayList;
            return arrayList2;
        }
    }

    @Override
    public final void zzbm(long l) {
        this.zzbpq();
        long l2 = System.currentTimeMillis();
        String string = "active = 1";
        ContentValues contentValues = new ContentValues();
        contentValues.put("active", Boolean.valueOf(false));
        contentValues.put("lastUse", Long.valueOf(l));
        this.zzlne.updateWithOnConflict("trackedQueries", contentValues, string, new String[0], 5);
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzlnf.zzbwa()) {
            Object[] objectArray = new Object[]{};
            String string2 = String.format("Reset active tracked queries in %dms", l3);
            this.zzlnf.zzb(string2, null, objectArray);
        }
    }

    @Override
    public final void zza(long l, Set<zzdwo> set) {
        this.zzbpq();
        long l2 = System.currentTimeMillis();
        String string = String.valueOf(l);
        String string2 = "id = ?";
        this.zzlne.delete("trackedKeys", string2, new String[]{string});
        for (zzdwo zzdwo2 : set) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("id", Long.valueOf(l));
            contentValues.put("key", zzdwo2.asString());
            this.zzlne.insertWithOnConflict("trackedKeys", null, contentValues, 5);
        }
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzlnf.zzbwa()) {
            Object[] objectArray = new Object[]{};
            String string3 = String.format("Set %d tracked query keys for tracked query %d in %dms", set.size(), l, l3);
            this.zzlnf.zzb(string3, null, objectArray);
        }
    }

    @Override
    public final void zza(long l, Set<zzdwo> set, Set<zzdwo> set2) {
        this.zzbpq();
        long l2 = System.currentTimeMillis();
        String string = "id = ? AND key = ?";
        String string2 = String.valueOf(l);
        for (zzdwo zzdwo2 : set2) {
            this.zzlne.delete("trackedKeys", string, new String[]{string2, zzdwo2.asString()});
        }
        for (zzdwo zzdwo2 : set) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("id", Long.valueOf(l));
            contentValues.put("key", zzdwo2.asString());
            this.zzlne.insertWithOnConflict("trackedKeys", null, contentValues, 5);
        }
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzlnf.zzbwa()) {
            Object[] objectArray = new Object[]{};
            String string3 = String.format("Updated tracked query keys (%d added, %d removed) for tracked query id %d in %dms", set.size(), set2.size(), l, l3);
            this.zzlnf.zzb(string3, null, objectArray);
        }
    }

    @Override
    public final Set<zzdwo> zzbn(long l) {
        return this.zze(Collections.singleton(l));
    }

    @Override
    public final Set<zzdwo> zze(Set<Long> set) {
        String[] stringArray = new String[]{"key"};
        long l = System.currentTimeMillis();
        String string = "id IN (";
        Object object = zzdna.zzk(set);
        String string2 = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(object).length()).append(string).append((String)object).append(")").toString();
        string = this.zzlne.query(true, "trackedKeys", stringArray, string2, null, null, null, null, null);
        object = new HashSet();
        try {
            while (string.moveToNext()) {
                String string3 = string.getString(0);
                object.add(zzdwo.zzpe(string3));
            }
            long l2 = System.currentTimeMillis() - l;
            if (this.zzlnf.zzbwa()) {
                Object[] objectArray = new Object[]{};
                String string4 = String.format("Loaded %d tracked queries keys for tracked queries %s in %dms", object.size(), set.toString(), l2);
                this.zzlnf.zzb(string4, null, objectArray);
            }
            Object object2 = object;
            return object2;
        }
        finally {
            string.close();
        }
    }

    @Override
    public final void zza(zzdqq zzdqq2, zzdui zzdui2) {
        String string;
        String string2;
        String string3;
        Iterable<Object> iterable;
        Iterable<zzdwo> iterable2;
        if (!zzdui2.zzbuh()) {
            return;
        }
        this.zzbpq();
        long l = System.currentTimeMillis();
        Cursor cursor = this.zza(zzdqq2, new String[]{"rowid", "path"});
        zzduu<Object> zzduu2 = new zzduu<Object>(null);
        zzduu<Object> zzduu3 = new zzduu<Object>(null);
        while (cursor.moveToNext()) {
            long l2 = cursor.getLong(0);
            iterable2 = new zzdqq(cursor.getString(1));
            if (!zzdqq2.zzi((zzdqq)iterable2)) {
                iterable = String.valueOf(zzdqq2);
                string3 = String.valueOf(iterable2);
                string2 = new StringBuilder(67 + String.valueOf(iterable).length() + String.valueOf(string3).length()).append("We are pruning at ").append((String)((Object)iterable)).append(" but we have data stored higher up at ").append(string3).append(". Ignoring.").toString();
                this.zzlnf.zze(string2, null);
                continue;
            }
            iterable = zzdqq.zza(zzdqq2, (zzdqq)iterable2);
            if (zzdui2.zzv((zzdqq)iterable)) {
                zzduu2 = zzduu2.zzb((zzdqq)iterable, l2);
                continue;
            }
            if (zzdui2.zzw((zzdqq)iterable)) {
                zzduu3 = zzduu3.zzb((zzdqq)iterable, l2);
                continue;
            }
            string3 = String.valueOf(zzdqq2);
            string = String.valueOf(iterable2);
            string2 = new StringBuilder(88 + String.valueOf(string3).length() + String.valueOf(string).length()).append("We are pruning at ").append(string3).append(" and have data at ").append(string).append(" that isn't marked for pruning or keeping. Ignoring.").toString();
            this.zzlnf.zze(string2, null);
        }
        int n = 0;
        int n2 = 0;
        if (!zzduu2.isEmpty()) {
            iterable2 = new ArrayList();
            this.zza(zzdqq2, zzdqq.zzbst(), zzduu2, zzduu3, zzdui2, (List<zzdyz<zzdqq, zzdxl>>)iterable2);
            iterable = zzduu2.values();
            string = zzdna.zzk(iterable);
            string3 = new StringBuilder(11 + String.valueOf(string).length()).append("rowid IN (").append(string).append(")").toString();
            this.zzlne.delete("serverCache", string3, null);
            ArrayList arrayList = (ArrayList)iterable2;
            int n3 = arrayList.size();
            for (int i = 0; i < n3; ++i) {
                Object e = arrayList.get(i);
                zzdyz zzdyz2 = (zzdyz)e;
                this.zzc(zzdqq2.zzh((zzdqq)zzdyz2.getFirst()), (zzdxl)zzdyz2.zzbxx());
            }
            n = iterable.size();
            n2 = iterable2.size();
        }
        long l3 = System.currentTimeMillis() - l;
        if (this.zzlnf.zzbwa()) {
            Object[] objectArray = new Object[]{};
            string2 = String.format("Pruned %d rows with %d nodes resaved in %dms", n, n2, l3);
            this.zzlnf.zzb(string2, null, objectArray);
        }
    }

    private final void zza(zzdqq zzdqq2, zzdqq zzdqq3, zzduu<Long> zzduu2, zzduu<Long> zzduu3, zzdui zzdui2, List<zzdyz<zzdqq, zzdxl>> list) {
        if (zzduu2.getValue() != null) {
            int n = zzdui2.zza(0, new zzdnb(this, zzduu3));
            if (n > 0) {
                zzdqq zzdqq4 = zzdqq2.zzh(zzdqq3);
                if (this.zzlnf.zzbwa()) {
                    Object[] objectArray = new Object[]{};
                    String string = String.format("Need to rewrite %d nodes below path %s", n, zzdqq4);
                    this.zzlnf.zzb(string, null, objectArray);
                }
                zzdxl zzdxl2 = this.zzb(zzdqq4);
                zzdui2.zza(null, new zzdnc(this, zzduu3, list, zzdqq3, zzdxl2));
            }
            return;
        }
        for (Map.Entry<zzdwo, zzduu<Long>> entry : zzduu2.zzbum()) {
            zzdwo zzdwo2 = entry.getKey();
            zzdui zzdui3 = zzdui2.zzd(entry.getKey());
            this.zza(zzdqq2, zzdqq3.zza(zzdwo2), entry.getValue(), zzduu3.zze(zzdwo2), zzdui3, list);
        }
    }

    @Override
    public final void zzbpp() {
        this.zzbpq();
        long l = System.currentTimeMillis();
        int n = this.zzlne.delete("writes", null, null);
        long l2 = System.currentTimeMillis() - l;
        if (this.zzlnf.zzbwa()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Deleted %d (all) write(s) in %dms", n, l2);
            this.zzlnf.zzb(string, null, objectArray);
        }
    }

    @Override
    public final void beginTransaction() {
        zzdzc.zzb(!this.zzlng, "runInTransaction called when an existing transaction is already in progress.");
        if (this.zzlnf.zzbwa()) {
            Object[] objectArray = new Object[]{};
            String string = "Starting transaction.";
            this.zzlnf.zzb("Starting transaction.", null, objectArray);
        }
        this.zzlne.beginTransaction();
        this.zzlng = true;
        this.zzlnh = System.currentTimeMillis();
    }

    @Override
    public final void endTransaction() {
        this.zzlne.endTransaction();
        this.zzlng = false;
        long l = System.currentTimeMillis() - this.zzlnh;
        if (this.zzlnf.zzbwa()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Transaction completed. Elapsed: %dms", l);
            this.zzlnf.zzb(string, null, objectArray);
        }
    }

    @Override
    public final void setTransactionSuccessful() {
        this.zzlne.setTransactionSuccessful();
    }

    private static SQLiteDatabase zzao(Context context, String string) {
        zzdnd zzdnd2 = new zzdnd(context, string);
        try {
            SQLiteDatabase sQLiteDatabase = zzdnd2.getWritableDatabase();
            sQLiteDatabase.rawQuery("PRAGMA locking_mode = EXCLUSIVE", null).close();
            sQLiteDatabase.beginTransaction();
            sQLiteDatabase.endTransaction();
            return sQLiteDatabase;
        }
        catch (SQLiteException sQLiteException) {
            SQLiteException sQLiteException2 = sQLiteException;
            if (sQLiteException instanceof SQLiteDatabaseLockedException) {
                String string2 = "Failed to gain exclusive lock to Firebase Database's offline persistence. This generally means you are using Firebase Database from multiple processes in your app. Keep in mind that multi-process Android apps execute the code in your Application class in all processes, so you may need to avoid initializing FirebaseDatabase in your Application class. If you are intentionally using Firebase Database from multiple processes, you can only enable offline persistence (i.e. call setPersistenceEnabled(true)) in one of them.";
                throw new DatabaseException(string2, sQLiteException2);
            }
            throw sQLiteException2;
        }
    }

    private final void zzbpq() {
        zzdzc.zzb(this.zzlng, "Transaction expected to already be in progress.");
    }

    private final int zzc(zzdqq zzdqq2, zzdxl zzdxl2) {
        long l = zzdyx.zzn(zzdxl2);
        if (zzdxl2 instanceof zzdwq && l > 16384L) {
            if (this.zzlnf.zzbwa()) {
                Object[] objectArray = new Object[]{};
                String string = String.format("Node estimated serialized size at path %s of %d bytes exceeds limit of %d bytes. Splitting up.", zzdqq2, l, 16384);
                this.zzlnf.zzb(string, null, objectArray);
            }
            int n = 0;
            for (zzdxk zzdxk2 : zzdxl2) {
                n += this.zzc(zzdqq2.zza(zzdxk2.zzbxd()), zzdxk2.zzbph());
            }
            if (!zzdxl2.zzbwk().isEmpty()) {
                this.zzd(zzdqq2.zza(zzdwo.zzbwe()), zzdxl2.zzbwk());
                ++n;
            }
            this.zzd(zzdqq2, zzdxc.zzbwu());
            return ++n;
        }
        this.zzd(zzdqq2, zzdxl2);
        return 1;
    }

    private static String zza(zzdqq zzdqq2, int n) {
        String string = String.valueOf(zzdna.zzc(zzdqq2));
        String string2 = String.valueOf(String.format(".part-%04d", n));
        if (string2.length() != 0) {
            return string.concat(string2);
        }
        return new String(string);
    }

    private final void zzd(zzdqq zzdqq2, zzdxl zzdxl2) {
        byte[] byArray = zzdna.zzaw(zzdxl2.getValue(true));
        if (byArray.length >= 262144) {
            int n;
            List<byte[]> list = zzdna.zzd(byArray, 262144);
            if (this.zzlnf.zzbwa()) {
                n = list.size();
                Object[] objectArray = new Object[]{};
                String string = new StringBuilder(45).append("Saving huge leaf node with ").append(n).append(" parts.").toString();
                this.zzlnf.zzb(string, null, objectArray);
            }
            for (n = 0; n < list.size(); ++n) {
                ContentValues contentValues = new ContentValues();
                contentValues.put("path", zzdna.zza(zzdqq2, n));
                contentValues.put("value", list.get(n));
                this.zzlne.insertWithOnConflict("serverCache", null, contentValues, 5);
            }
            return;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("path", zzdna.zzc(zzdqq2));
        contentValues.put("value", byArray);
        this.zzlne.insertWithOnConflict("serverCache", null, contentValues, 5);
    }

    /*
     * WARNING - void declaration
     */
    private final zzdxl zzb(zzdqq zzdqq2) {
        String string;
        Object[] objectArray;
        zzdqq zzdqq3;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<byte[]> arrayList2 = new ArrayList<byte[]>();
        long l = System.currentTimeMillis();
        Cursor cursor = this.zza(zzdqq2, new String[]{"path", "value"});
        long l2 = System.currentTimeMillis() - l;
        long l3 = System.currentTimeMillis();
        try {
            while (cursor.moveToNext()) {
                arrayList.add(cursor.getString(0));
                arrayList2.add(cursor.getBlob(1));
            }
        }
        finally {
            cursor.close();
        }
        long l4 = System.currentTimeMillis() - l3;
        long l5 = System.currentTimeMillis();
        zzdxl zzdxl2 = zzdxc.zzbwu();
        boolean bl = false;
        HashMap<zzdqq, void> hashMap = new HashMap<zzdqq, void>();
        for (int i = 0; i < arrayList2.size(); ++i) {
            void object;
            Object object2;
            if (((String)arrayList.get(i)).endsWith(".part-0000")) {
                object2 = (String)arrayList.get(i);
                zzdqq3 = new zzdqq(((String)object2).substring(0, ((String)object2).length() - 10));
                int n = zzdna.zza(zzdqq3, arrayList, i);
                if (this.zzlnf.zzbwa()) {
                    objectArray = new Object[]{};
                    string = new StringBuilder(42).append("Loading split node with ").append(n).append(" parts.").toString();
                    this.zzlnf.zzb(string, null, objectArray);
                }
                zzdxl zzdxl3 = zzdna.zzak(zzdna.zzao(arrayList2.subList(i, i + n)));
                i = i + n - 1;
            } else {
                zzdxl zzdxl4 = zzdna.zzak((byte[])arrayList2.get(i));
                zzdqq3 = new zzdqq((String)arrayList.get(i));
            }
            if (zzdqq3.zzbsz() != null && zzdqq3.zzbsz().zzbwg()) {
                hashMap.put(zzdqq3, object);
                continue;
            }
            if (zzdqq3.zzi(zzdqq2)) {
                zzdzc.zzb(!bl, "Descendants of path must come after ancestors.");
                zzdxl2 = object.zzan(zzdqq.zza(zzdqq3, zzdqq2));
                continue;
            }
            if (zzdqq2.zzi(zzdqq3)) {
                bl = true;
                object2 = zzdqq.zza(zzdqq2, zzdqq3);
                zzdxl2 = zzdxl2.zzl((zzdqq)object2, (zzdxl)object);
                continue;
            }
            throw new IllegalStateException(String.format("Loading an unrelated row with path %s for %s", zzdqq3, zzdqq2));
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            zzdqq3 = (zzdqq)entry.getKey();
            zzdxl2 = zzdxl2.zzl(zzdqq.zza(zzdqq2, zzdqq3), (zzdxl)entry.getValue());
        }
        long l6 = System.currentTimeMillis() - l5;
        long l7 = System.currentTimeMillis() - l;
        if (this.zzlnf.zzbwa()) {
            objectArray = new Object[]{};
            string = String.format("Loaded a total of %d rows for a total of %d nodes at %s in %dms (Query: %dms, Loading: %dms, Serializing: %dms)", arrayList2.size(), zzdyx.zzo(zzdxl2), zzdqq2, l7, l2, l4, l6);
            this.zzlnf.zzb(string, null, objectArray);
        }
        return zzdxl2;
    }

    private static int zza(zzdqq zzdqq2, List<String> list, int n) {
        int n2;
        String string = zzdna.zzc(zzdqq2);
        if (!list.get(n).startsWith(string)) {
            throw new IllegalStateException("Extracting split nodes needs to start with path prefix");
        }
        for (n2 = n + 1; n2 < list.size() && list.get(n2).equals(zzdna.zza(zzdqq2, n2 - n)); ++n2) {
        }
        if (n2 < list.size()) {
            String string2 = String.valueOf(string);
            String string3 = String.valueOf(".part-");
            if (list.get(n2).startsWith(string3.length() != 0 ? string2.concat(string3) : new String(string2))) {
                throw new IllegalStateException("Run did not finish with all parts");
            }
        }
        return n2 - n;
    }

    private final Cursor zza(zzdqq zzdqq2, String[] stringArray) {
        String[] stringArray2;
        String string = zzdna.zzc(zzdqq2);
        String string2 = zzdna.zzon(string);
        String[] stringArray3 = stringArray2 = new String[zzdqq2.size() + 3];
        zzdqq zzdqq3 = zzdqq2;
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder("(");
        while (!zzdqq3.isEmpty()) {
            stringBuilder.append("path");
            stringBuilder.append(" = ? OR ");
            stringArray3[n] = zzdna.zzc(zzdqq3);
            zzdqq3 = zzdqq3.zzbsy();
            ++n;
        }
        stringBuilder.append("path");
        stringBuilder.append(" = ?)");
        stringArray3[n] = zzdna.zzc(zzdqq.zzbst());
        String string3 = String.valueOf(stringBuilder.toString());
        String string4 = String.valueOf(" OR (path > ? AND path < ?)");
        String string5 = string4.length() != 0 ? string3.concat(string4) : new String(string3);
        stringArray2[zzdqq2.size() + 1] = string;
        stringArray2[zzdqq2.size() + 2] = string2;
        String string6 = "path";
        return this.zzlne.query("serverCache", stringArray, string5, stringArray2, null, null, string6);
    }

    private static String zzc(zzdqq zzdqq2) {
        if (zzdqq2.isEmpty()) {
            return "/";
        }
        return String.valueOf(zzdqq2.toString()).concat("/");
    }

    private static String zzon(String string) {
        String string2 = string.substring(0, string.length() - 1);
        return new StringBuilder(1 + String.valueOf(string2).length()).append(string2).append('0').toString();
    }

    private final int zza(String string, zzdqq zzdqq2) {
        String string2 = "path >= ? AND path < ?";
        String string3 = zzdna.zzc(zzdqq2);
        String string4 = zzdna.zzon(string3);
        return this.zzlne.delete(string, string2, new String[]{string3, string4});
    }

    private static List<byte[]> zzd(byte[] byArray, int n) {
        int n2 = (byArray.length - 1) / 262144 + 1;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(n2);
        for (int i = 0; i < n2; ++i) {
            int n3 = Math.min(262144, byArray.length - i * 262144);
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, i * 262144, byArray2, 0, n3);
            arrayList.add(byArray2);
        }
        return arrayList;
    }

    private static byte[] zzao(List<byte[]> list) {
        int n = 0;
        for (byte[] byArray : list) {
            n += byArray.length;
        }
        Object object = new byte[n];
        int n2 = 0;
        for (byte[] byArray : list) {
            System.arraycopy(byArray, 0, object, n2, byArray.length);
            n2 += byArray.length;
        }
        return object;
    }

    private static byte[] zzaw(Object object) {
        try {
            return zzdyq.zzbk((Object)object).getBytes(zzfbx);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Could not serialize leaf node", iOException);
        }
    }

    private static zzdxl zzak(byte[] byArray) {
        try {
            return zzdxo.zza(zzdyq.zzph((String)new String(byArray, zzfbx)), zzdxc.zzbwu());
        }
        catch (IOException iOException) {
            String string = new String(byArray, zzfbx);
            String string2 = String.valueOf(string);
            throw new RuntimeException(string2.length() != 0 ? "Could not deserialize node: ".concat(string2) : new String("Could not deserialize node: "), iOException);
        }
    }

    private static String zzk(Collection<Long> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (long l : collection) {
            if (!bl) {
                stringBuilder.append(",");
            }
            bl = false;
            stringBuilder.append(l);
        }
        return stringBuilder.toString();
    }
}

