/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzdsc;
import com.google.android.gms.internal.zzdth;
import com.google.android.gms.internal.zzdyu;
import com.google.android.gms.internal.zzdyv;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.FirebaseDatabase;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public abstract class zzdyt
implements zzdsc {
    private ScheduledThreadPoolExecutor zzmgv;

    protected ThreadFactory getThreadFactory() {
        return Executors.defaultThreadFactory();
    }

    protected zzdth zzbss() {
        return zzdth.zzlyi;
    }

    public abstract void zze(Throwable var1);

    public zzdyt() {
        zzdyv zzdyv2 = new zzdyv(this, null);
        this.zzmgv = new zzdyu(this, 1, zzdyv2);
        this.zzmgv.setKeepAliveTime(3L, TimeUnit.SECONDS);
    }

    public final ScheduledExecutorService zzbqp() {
        return this.zzmgv;
    }

    @Override
    public final void zzn(Runnable runnable) {
        this.zzmgv.execute(runnable);
    }

    @Override
    public final void shutdown() {
        this.zzmgv.setCorePoolSize(0);
    }

    @Override
    public final void restart() {
        this.zzmgv.setCorePoolSize(1);
    }

    public static String zzg(Throwable throwable) {
        if (throwable instanceof OutOfMemoryError) {
            return "Firebase Database encountered an OutOfMemoryError. You may need to reduce the amount of data you are syncing to the client (e.g. by using queries or syncing a deeper path). See https://firebase.google.com/docs/database/ios/structure-data#best_practices_for_data_structure and https://firebase.google.com/docs/database/android/retrieve-data#filtering_data";
        }
        if (throwable instanceof DatabaseException) {
            return "";
        }
        String string = FirebaseDatabase.getSdkVersion();
        return new StringBuilder(104 + String.valueOf(string).length()).append("Uncaught exception in Firebase Database runloop (").append(string).append("). Please report to firebase-database-client@google.com").toString();
    }
}

