/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import com.google.android.gms.internal.zzdpw;
import com.google.android.gms.internal.zzdqh;
import com.google.android.gms.internal.zzdqq;
import com.google.android.gms.internal.zzdqt;
import com.google.android.gms.internal.zzdtn;
import com.google.android.gms.internal.zzdts;
import com.google.android.gms.internal.zzdvp;
import com.google.android.gms.internal.zzdvs;
import com.google.android.gms.internal.zzdwn;
import com.google.android.gms.internal.zzdwo;
import com.google.android.gms.internal.zzdxb;
import com.google.android.gms.internal.zzdxc;
import com.google.android.gms.internal.zzdxf;
import com.google.android.gms.internal.zzdxl;
import com.google.android.gms.internal.zzdxp;
import com.google.android.gms.internal.zzdxq;
import com.google.android.gms.internal.zzdxr;
import com.google.android.gms.internal.zzdxt;
import com.google.android.gms.internal.zzdxv;
import com.google.android.gms.internal.zzdzc;
import com.google.android.gms.internal.zzdze;
import com.google.firebase.database.ChildEventListener;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.ValueEventListener;
import com.google.firebase.database.zzp;
import com.google.firebase.database.zzq;
import com.google.firebase.database.zzr;
import com.google.firebase.database.zzs;

public class Query {
    protected final zzdqt zzllz;
    protected final zzdqq zzlmg;
    private zzdvp zzlmk;
    private final boolean zzlml;

    private Query(zzdqt zzdqt2, zzdqq zzdqq2, zzdvp zzdvp2, boolean bl) throws DatabaseException {
        this.zzllz = zzdqt2;
        this.zzlmg = zzdqq2;
        this.zzlmk = zzdvp2;
        this.zzlml = bl;
        zzdvp zzdvp3 = zzdvp2;
        zzdzc.zzb(!zzdvp3.zzbuy() || !zzdvp3.zzbvb() || !zzdvp3.zzbve() || zzdvp3.zzbvf(), "Validation of queries failed.");
    }

    Query(zzdqt zzdqt2, zzdqq zzdqq2) {
        this.zzllz = zzdqt2;
        this.zzlmg = zzdqq2;
        this.zzlmk = zzdvp.zzmca;
        this.zzlml = false;
    }

    private static void zza(zzdvp zzdvp2) {
        if (zzdvp2.zzbvg().equals(zzdxf.zzbxa())) {
            zzdxl zzdxl2;
            String string = "You must use startAt(String value), endAt(String value) or equalTo(String value) in combination with orderByKey(). Other type of values or using the version with 2 parameters is not supported";
            if (zzdvp2.zzbuy()) {
                zzdxl2 = zzdvp2.zzbuz();
                if (zzdvp2.zzbva() != zzdwo.zzbwc() || !(zzdxl2 instanceof zzdxt)) {
                    throw new IllegalArgumentException(string);
                }
            }
            if (zzdvp2.zzbvb()) {
                zzdxl2 = zzdvp2.zzbvc();
                if (zzdvp2.zzbvd() != zzdwo.zzbwd() || !(zzdxl2 instanceof zzdxt)) {
                    throw new IllegalArgumentException(string);
                }
            }
            return;
        }
        if (zzdvp2.zzbvg().equals(zzdxq.zzbxe()) && (zzdvp2.zzbuy() && !zzdxr.zzl(zzdvp2.zzbuz()) || zzdvp2.zzbvb() && !zzdxr.zzl(zzdvp2.zzbvc()))) {
            throw new IllegalArgumentException("When using orderByPriority(), values provided to startAt(), endAt(), or equalTo() must be valid priorities.");
        }
    }

    private static void zzb(zzdvp zzdvp2) {
        if (zzdvp2.zzbuy() && zzdvp2.zzbvb() && zzdvp2.zzbve() && !zzdvp2.zzbvf()) {
            throw new IllegalArgumentException("Can't combine startAt(), endAt() and limit(). Use limitToFirst() or limitToLast() instead");
        }
    }

    private final void zzbpi() {
        if (this.zzlmk.zzbuy()) {
            throw new IllegalArgumentException("Can't call equalTo() and startAt() combined");
        }
        if (this.zzlmk.zzbvb()) {
            throw new IllegalArgumentException("Can't call equalTo() and endAt() combined");
        }
    }

    private final void zzbpj() {
        if (this.zzlml) {
            throw new IllegalArgumentException("You can't combine multiple orderBy calls!");
        }
    }

    public ValueEventListener addValueEventListener(ValueEventListener valueEventListener) {
        this.zzb(new zzdtn(this.zzllz, valueEventListener, this.zzbpl()));
        return valueEventListener;
    }

    public ChildEventListener addChildEventListener(ChildEventListener childEventListener) {
        this.zzb(new zzdpw(this.zzllz, childEventListener, this.zzbpl()));
        return childEventListener;
    }

    public void addListenerForSingleValueEvent(ValueEventListener valueEventListener) {
        this.zzb(new zzdtn(this.zzllz, new zzp(this, valueEventListener), this.zzbpl()));
    }

    public void removeEventListener(ValueEventListener valueEventListener) {
        if (valueEventListener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.zza(new zzdtn(this.zzllz, valueEventListener, this.zzbpl()));
    }

    public void removeEventListener(ChildEventListener childEventListener) {
        if (childEventListener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.zza(new zzdpw(this.zzllz, childEventListener, this.zzbpl()));
    }

    private final void zza(zzdqh zzdqh2) {
        zzdts.zzbtu().zzj(zzdqh2);
        this.zzllz.zzn(new zzq(this, zzdqh2));
    }

    private final void zzb(zzdqh zzdqh2) {
        zzdts.zzbtu().zzi(zzdqh2);
        this.zzllz.zzn(new zzr(this, zzdqh2));
    }

    public void keepSynced(boolean bl) {
        if (!this.zzlmg.isEmpty() && this.zzlmg.zzbsw().equals(zzdwo.zzbwf())) {
            throw new DatabaseException("Can't call keepSynced() on .info paths.");
        }
        this.zzllz.zzn(new zzs(this, bl));
    }

    public Query startAt(String string) {
        return this.startAt(string, null);
    }

    public Query startAt(double d) {
        return this.startAt(d, null);
    }

    public Query startAt(boolean bl) {
        return this.startAt(bl, null);
    }

    public Query startAt(String string, String string2) {
        zzdxl zzdxl2 = string != null ? new zzdxt(string, zzdxc.zzbwu()) : zzdxc.zzbwu();
        return this.zza(zzdxl2, string2);
    }

    public Query startAt(double d, String string) {
        return this.zza(new zzdxb(d, zzdxc.zzbwu()), string);
    }

    public Query startAt(boolean bl, String string) {
        return this.zza(new zzdwn(bl, zzdxc.zzbwu()), string);
    }

    private final Query zza(zzdxl zzdxl2, String string) {
        zzdze.zzpo(string);
        if (!zzdxl2.zzbwj() && !zzdxl2.isEmpty()) {
            throw new IllegalArgumentException("Can only use simple values for startAt()");
        }
        if (this.zzlmk.zzbuy()) {
            throw new IllegalArgumentException("Can't call startAt() or equalTo() multiple times");
        }
        zzdwo zzdwo2 = string != null ? zzdwo.zzpe(string) : null;
        zzdvp zzdvp2 = this.zzlmk.zza(zzdxl2, zzdwo2);
        Query.zzb(zzdvp2);
        Query.zza(zzdvp2);
        return new Query(this.zzllz, this.zzlmg, zzdvp2, this.zzlml);
    }

    public Query endAt(String string) {
        return this.endAt(string, null);
    }

    public Query endAt(double d) {
        return this.endAt(d, null);
    }

    public Query endAt(boolean bl) {
        return this.endAt(bl, null);
    }

    public Query endAt(String string, String string2) {
        zzdxl zzdxl2 = string != null ? new zzdxt(string, zzdxc.zzbwu()) : zzdxc.zzbwu();
        return this.zzb(zzdxl2, string2);
    }

    public Query endAt(double d, String string) {
        return this.zzb(new zzdxb(d, zzdxc.zzbwu()), string);
    }

    public Query endAt(boolean bl, String string) {
        return this.zzb(new zzdwn(bl, zzdxc.zzbwu()), string);
    }

    private final Query zzb(zzdxl zzdxl2, String string) {
        zzdwo zzdwo2;
        zzdze.zzpo(string);
        if (!zzdxl2.zzbwj() && !zzdxl2.isEmpty()) {
            throw new IllegalArgumentException("Can only use simple values for endAt()");
        }
        zzdwo zzdwo3 = zzdwo2 = string != null ? zzdwo.zzpe(string) : null;
        if (this.zzlmk.zzbvb()) {
            throw new IllegalArgumentException("Can't call endAt() or equalTo() multiple times");
        }
        zzdvp zzdvp2 = this.zzlmk.zzb(zzdxl2, zzdwo2);
        Query.zzb(zzdvp2);
        Query.zza(zzdvp2);
        return new Query(this.zzllz, this.zzlmg, zzdvp2, this.zzlml);
    }

    public Query equalTo(String string) {
        this.zzbpi();
        return this.startAt(string).endAt(string);
    }

    public Query equalTo(double d) {
        this.zzbpi();
        return this.startAt(d).endAt(d);
    }

    public Query equalTo(boolean bl) {
        this.zzbpi();
        return this.startAt(bl).endAt(bl);
    }

    public Query equalTo(String string, String string2) {
        this.zzbpi();
        return this.startAt(string, string2).endAt(string, string2);
    }

    public Query equalTo(double d, String string) {
        this.zzbpi();
        return this.startAt(d, string).endAt(d, string);
    }

    public Query equalTo(boolean bl, String string) {
        this.zzbpi();
        return this.startAt(bl, string).endAt(bl, string);
    }

    public Query limitToFirst(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Limit must be a positive integer!");
        }
        if (this.zzlmk.zzbve()) {
            throw new IllegalArgumentException("Can't call limitToLast on query with previously set limit!");
        }
        return new Query(this.zzllz, this.zzlmg, this.zzlmk.zzft(n), this.zzlml);
    }

    public Query limitToLast(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Limit must be a positive integer!");
        }
        if (this.zzlmk.zzbve()) {
            throw new IllegalArgumentException("Can't call limitToLast on query with previously set limit!");
        }
        return new Query(this.zzllz, this.zzlmg, this.zzlmk.zzfu(n), this.zzlml);
    }

    public Query orderByChild(String string) {
        if (string == null) {
            throw new NullPointerException("Key can't be null");
        }
        if (string.equals("$key") || string.equals(".key")) {
            throw new IllegalArgumentException(new StringBuilder(54 + String.valueOf(string).length()).append("Can't use '").append(string).append("' as path, please use orderByKey() instead!").toString());
        }
        if (string.equals("$priority") || string.equals(".priority")) {
            throw new IllegalArgumentException(new StringBuilder(59 + String.valueOf(string).length()).append("Can't use '").append(string).append("' as path, please use orderByPriority() instead!").toString());
        }
        if (string.equals("$value") || string.equals(".value")) {
            throw new IllegalArgumentException(new StringBuilder(56 + String.valueOf(string).length()).append("Can't use '").append(string).append("' as path, please use orderByValue() instead!").toString());
        }
        zzdze.zzpm(string);
        this.zzbpj();
        zzdqq zzdqq2 = new zzdqq(string);
        if (zzdqq2.size() == 0) {
            throw new IllegalArgumentException("Can't use empty path, use orderByValue() instead!");
        }
        zzdxp zzdxp2 = new zzdxp(zzdqq2);
        return new Query(this.zzllz, this.zzlmg, this.zzlmk.zza(zzdxp2), true);
    }

    public Query orderByPriority() {
        this.zzbpj();
        zzdvp zzdvp2 = this.zzlmk.zza(zzdxq.zzbxe());
        Query.zza(zzdvp2);
        return new Query(this.zzllz, this.zzlmg, zzdvp2, true);
    }

    public Query orderByKey() {
        this.zzbpj();
        zzdvp zzdvp2 = this.zzlmk.zza(zzdxf.zzbxa());
        Query.zza(zzdvp2);
        return new Query(this.zzllz, this.zzlmg, zzdvp2, true);
    }

    public Query orderByValue() {
        this.zzbpj();
        return new Query(this.zzllz, this.zzlmg, this.zzlmk.zza(zzdxv.zzbxf()), true);
    }

    public DatabaseReference getRef() {
        return new DatabaseReference(this.zzllz, this.zzlmg);
    }

    public final zzdqq zzbpk() {
        return this.zzlmg;
    }

    public final zzdvs zzbpl() {
        return new zzdvs(this.zzlmg, this.zzlmk);
    }
}

