/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import com.google.android.gms.internal.zzdqe;
import com.google.android.gms.internal.zzdql;
import com.google.android.gms.internal.zzdqw;
import com.google.android.gms.internal.zzdqz;
import com.google.android.gms.internal.zzdsd;
import com.google.android.gms.internal.zzdts;
import com.google.android.gms.internal.zzdwu;
import com.google.android.gms.internal.zzdxr;
import com.google.android.gms.internal.zzdxu;
import com.google.android.gms.internal.zzdxx;
import com.google.android.gms.internal.zzdzf;
import com.google.android.gms.internal.zzdzh;
import com.google.android.gms.internal.zzdzi;
import com.google.android.gms.internal.zzdzk;
import com.google.android.gms.internal.zzdzl;
import com.google.android.gms.tasks.Task;
import com.google.firebase.database.DatabaseError;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.FirebaseDatabase;
import com.google.firebase.database.OnDisconnect;
import com.google.firebase.database.Query;
import com.google.firebase.database.Transaction;
import com.google.firebase.database.zzc;
import com.google.firebase.database.zzd;
import com.google.firebase.database.zze;
import com.google.firebase.database.zzf;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;

public class DatabaseReference
extends Query {
    private static zzdql zzllm;

    DatabaseReference(zzdqz zzdqz2, zzdqw zzdqw2) {
        super(zzdqz2, zzdqw2);
    }

    public DatabaseReference child(String string) {
        if (string == null) {
            throw new NullPointerException("Can't pass null for argument 'pathString' in child()");
        }
        if (this.zzlmg.isEmpty()) {
            zzdzk.zzpn(string);
        } else {
            zzdzk.zzpm(string);
        }
        zzdqw zzdqw2 = this.zzlmg.zzh(new zzdqw(string));
        return new DatabaseReference(this.zzllz, zzdqw2);
    }

    public DatabaseReference push() {
        zzdwu zzdwu2 = zzdwu.zzpe(zzdzh.zzby(this.zzllz.zzbtc()));
        return new DatabaseReference(this.zzllz, this.zzlmg.zza(zzdwu2));
    }

    public Task<Void> setValue(Object object) {
        return this.zza(object, zzdxx.zzc(this.zzlmg, null), null);
    }

    public Task<Void> setValue(Object object, Object object2) {
        return this.zza(object, zzdxx.zzc(this.zzlmg, object2), null);
    }

    public void setValue(Object object, CompletionListener completionListener) {
        this.zza(object, zzdxx.zzc(this.zzlmg, null), completionListener);
    }

    public void setValue(Object object, Object object2, CompletionListener completionListener) {
        this.zza(object, zzdxx.zzc(this.zzlmg, object2), completionListener);
    }

    private final Task<Void> zza(Object object, zzdxr zzdxr2, CompletionListener completionListener) {
        zzdzk.zzao(this.zzlmg);
        zzdts.zza(this.zzlmg, object);
        Object object2 = zzdzl.zzbn(object);
        zzdzk.zzbm(object2);
        zzdxr zzdxr3 = zzdxu.zza(object2, zzdxr2);
        zzdzf<Task<Void>, CompletionListener> zzdzf2 = zzdzi.zzb(completionListener);
        this.zzllz.zzn(new zzc(this, zzdxr3, zzdzf2));
        return zzdzf2.getFirst();
    }

    public Task<Void> setPriority(Object object) {
        return this.zza(zzdxx.zzc(this.zzlmg, object), null);
    }

    public void setPriority(Object object, CompletionListener completionListener) {
        this.zza(zzdxx.zzc(this.zzlmg, object), completionListener);
    }

    private final Task<Void> zza(zzdxr zzdxr2, CompletionListener completionListener) {
        zzdzk.zzao(this.zzlmg);
        zzdzf<Task<Void>, CompletionListener> zzdzf2 = zzdzi.zzb(completionListener);
        this.zzllz.zzn(new zzd(this, zzdxr2, zzdzf2));
        return zzdzf2.getFirst();
    }

    public Task<Void> updateChildren(Map<String, Object> map) {
        return this.zza(map, null);
    }

    public void updateChildren(Map<String, Object> map, CompletionListener completionListener) {
        this.zza(map, completionListener);
    }

    private final Task<Void> zza(Map<String, Object> map, CompletionListener completionListener) {
        if (map == null) {
            throw new NullPointerException("Can't pass null for argument 'update' in updateChildren()");
        }
        Map<String, Object> map2 = zzdzl.zzah(map);
        zzdqe zzdqe2 = zzdqe.zzaf(zzdzk.zzb(this.zzlmg, map2));
        zzdzf<Task<Void>, CompletionListener> zzdzf2 = zzdzi.zzb(completionListener);
        this.zzllz.zzn(new zze(this, zzdqe2, zzdzf2, map2));
        return zzdzf2.getFirst();
    }

    public Task<Void> removeValue() {
        return this.setValue(null);
    }

    public void removeValue(CompletionListener completionListener) {
        this.setValue(null, completionListener);
    }

    public OnDisconnect onDisconnect() {
        zzdzk.zzao(this.zzlmg);
        return new OnDisconnect(this.zzllz, this.zzlmg);
    }

    public void runTransaction(Transaction.Handler handler) {
        this.runTransaction(handler, true);
    }

    public void runTransaction(Transaction.Handler handler, boolean bl) {
        if (handler == null) {
            throw new NullPointerException("Can't pass null for argument 'handler' in runTransaction()");
        }
        zzdzk.zzao(this.zzlmg);
        this.zzllz.zzn(new zzf(this, handler, bl));
    }

    public static void goOffline() {
        zzdsd.zzd(DatabaseReference.zzbpf());
    }

    public static void goOnline() {
        zzdsd.zze(DatabaseReference.zzbpf());
    }

    public FirebaseDatabase getDatabase() {
        return this.zzllz.getDatabase();
    }

    public String toString() {
        DatabaseReference databaseReference = this.getParent();
        if (databaseReference == null) {
            return this.zzllz.toString();
        }
        try {
            String string = databaseReference.toString();
            String string2 = URLEncoder.encode(this.getKey(), "UTF-8").replace("+", "%20");
            return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("/").append(string2).toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string = String.valueOf(this.getKey());
            throw new DatabaseException(string.length() != 0 ? "Failed to URLEncode key: ".concat(string) : new String("Failed to URLEncode key: "), unsupportedEncodingException);
        }
    }

    public DatabaseReference getParent() {
        zzdqw zzdqw2 = this.zzlmg.zzbsy();
        if (zzdqw2 != null) {
            return new DatabaseReference(this.zzllz, zzdqw2);
        }
        return null;
    }

    public DatabaseReference getRoot() {
        return new DatabaseReference(this.zzllz, new zzdqw(""));
    }

    public String getKey() {
        if (this.zzlmg.isEmpty()) {
            return null;
        }
        return this.zzlmg.zzbsz().asString();
    }

    public boolean equals(Object object) {
        return object instanceof DatabaseReference && this.toString().equals(object.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private static synchronized zzdql zzbpf() {
        if (zzllm == null) {
            zzllm = new zzdql();
        }
        return zzllm;
    }

    public static interface CompletionListener {
        public void onComplete(DatabaseError var1, DatabaseReference var2);
    }
}

