/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzdso;
import com.google.android.gms.internal.zzdtt;
import com.google.android.gms.internal.zzdzg;
import com.google.android.gms.internal.zzdzh;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.FirebaseDatabase;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public abstract class zzdzf
implements zzdso {
    private ScheduledThreadPoolExecutor zzmji;

    protected ThreadFactory getThreadFactory() {
        return Executors.defaultThreadFactory();
    }

    protected zzdtt zzbsv() {
        return zzdtt.zzmav;
    }

    public abstract void zze(Throwable var1);

    public zzdzf() {
        zzdzh zzdzh2 = new zzdzh(this, null);
        this.zzmji = new zzdzg(this, 1, zzdzh2);
        this.zzmji.setKeepAliveTime(3L, TimeUnit.SECONDS);
    }

    public final ScheduledExecutorService zzbqs() {
        return this.zzmji;
    }

    @Override
    public final void zzn(Runnable runnable) {
        this.zzmji.execute(runnable);
    }

    @Override
    public final void shutdown() {
        this.zzmji.setCorePoolSize(0);
    }

    @Override
    public final void restart() {
        this.zzmji.setCorePoolSize(1);
    }

    public static String zzg(Throwable throwable) {
        if (throwable instanceof OutOfMemoryError) {
            return "Firebase Database encountered an OutOfMemoryError. You may need to reduce the amount of data you are syncing to the client (e.g. by using queries or syncing a deeper path). See https://firebase.google.com/docs/database/ios/structure-data#best_practices_for_data_structure and https://firebase.google.com/docs/database/android/retrieve-data#filtering_data";
        }
        if (throwable instanceof DatabaseException) {
            return "";
        }
        String string = FirebaseDatabase.getSdkVersion();
        return new StringBuilder(104 + String.valueOf(string).length()).append("Uncaught exception in Firebase Database runloop (").append(string).append("). Please report to firebase-database-client@google.com").toString();
    }
}

