/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import com.google.android.gms.internal.zzdqk;
import com.google.android.gms.internal.zzdqr;
import com.google.android.gms.internal.zzdrc;
import com.google.android.gms.internal.zzdrf;
import com.google.android.gms.internal.zzdsj;
import com.google.android.gms.internal.zzdty;
import com.google.android.gms.internal.zzdxa;
import com.google.android.gms.internal.zzdxx;
import com.google.android.gms.internal.zzdya;
import com.google.android.gms.internal.zzdyd;
import com.google.android.gms.internal.zzdzl;
import com.google.android.gms.internal.zzdzn;
import com.google.android.gms.internal.zzdzo;
import com.google.android.gms.internal.zzdzq;
import com.google.android.gms.internal.zzdzr;
import com.google.android.gms.tasks.Task;
import com.google.firebase.database.DatabaseError;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.FirebaseDatabase;
import com.google.firebase.database.OnDisconnect;
import com.google.firebase.database.Query;
import com.google.firebase.database.Transaction;
import com.google.firebase.database.zzc;
import com.google.firebase.database.zzd;
import com.google.firebase.database.zze;
import com.google.firebase.database.zzf;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;

public class DatabaseReference
extends Query {
    private static zzdqr zzlnz;

    DatabaseReference(zzdrf zzdrf2, zzdrc zzdrc2) {
        super(zzdrf2, zzdrc2);
    }

    public DatabaseReference child(String string) {
        if (string == null) {
            throw new NullPointerException("Can't pass null for argument 'pathString' in child()");
        }
        if (this.zzlot.isEmpty()) {
            zzdzq.zzpx(string);
        } else {
            zzdzq.zzpw(string);
        }
        zzdrc zzdrc2 = this.zzlot.zzh(new zzdrc(string));
        return new DatabaseReference(this.zzlom, zzdrc2);
    }

    public DatabaseReference push() {
        zzdxa zzdxa2 = zzdxa.zzpo(zzdzn.zzby(this.zzlom.zzbtf()));
        return new DatabaseReference(this.zzlom, this.zzlot.zza(zzdxa2));
    }

    public Task<Void> setValue(Object object) {
        return this.zza(object, zzdyd.zzc(this.zzlot, null), null);
    }

    public Task<Void> setValue(Object object, Object object2) {
        return this.zza(object, zzdyd.zzc(this.zzlot, object2), null);
    }

    public void setValue(Object object, CompletionListener completionListener) {
        this.zza(object, zzdyd.zzc(this.zzlot, null), completionListener);
    }

    public void setValue(Object object, Object object2, CompletionListener completionListener) {
        this.zza(object, zzdyd.zzc(this.zzlot, object2), completionListener);
    }

    private final Task<Void> zza(Object object, zzdxx zzdxx2, CompletionListener completionListener) {
        zzdzq.zzao(this.zzlot);
        zzdty.zza(this.zzlot, object);
        Object object2 = zzdzr.zzbm(object);
        zzdzq.zzbl(object2);
        zzdxx zzdxx3 = zzdya.zza(object2, zzdxx2);
        zzdzl<Task<Void>, CompletionListener> zzdzl2 = zzdzo.zzb(completionListener);
        this.zzlom.zzn(new zzc(this, zzdxx3, zzdzl2));
        return zzdzl2.getFirst();
    }

    public Task<Void> setPriority(Object object) {
        return this.zza(zzdyd.zzc(this.zzlot, object), null);
    }

    public void setPriority(Object object, CompletionListener completionListener) {
        this.zza(zzdyd.zzc(this.zzlot, object), completionListener);
    }

    private final Task<Void> zza(zzdxx zzdxx2, CompletionListener completionListener) {
        zzdzq.zzao(this.zzlot);
        zzdzl<Task<Void>, CompletionListener> zzdzl2 = zzdzo.zzb(completionListener);
        this.zzlom.zzn(new zzd(this, zzdxx2, zzdzl2));
        return zzdzl2.getFirst();
    }

    public Task<Void> updateChildren(Map<String, Object> map) {
        return this.zza(map, null);
    }

    public void updateChildren(Map<String, Object> map, CompletionListener completionListener) {
        this.zza(map, completionListener);
    }

    private final Task<Void> zza(Map<String, Object> map, CompletionListener completionListener) {
        if (map == null) {
            throw new NullPointerException("Can't pass null for argument 'update' in updateChildren()");
        }
        Map<String, Object> map2 = zzdzr.zzah(map);
        zzdqk zzdqk2 = zzdqk.zzaf(zzdzq.zzb(this.zzlot, map2));
        zzdzl<Task<Void>, CompletionListener> zzdzl2 = zzdzo.zzb(completionListener);
        this.zzlom.zzn(new zze(this, zzdqk2, zzdzl2, map2));
        return zzdzl2.getFirst();
    }

    public Task<Void> removeValue() {
        return this.setValue(null);
    }

    public void removeValue(CompletionListener completionListener) {
        this.setValue(null, completionListener);
    }

    public OnDisconnect onDisconnect() {
        zzdzq.zzao(this.zzlot);
        return new OnDisconnect(this.zzlom, this.zzlot);
    }

    public void runTransaction(Transaction.Handler handler) {
        this.runTransaction(handler, true);
    }

    public void runTransaction(Transaction.Handler handler, boolean bl) {
        if (handler == null) {
            throw new NullPointerException("Can't pass null for argument 'handler' in runTransaction()");
        }
        zzdzq.zzao(this.zzlot);
        this.zzlom.zzn(new zzf(this, handler, bl));
    }

    public static void goOffline() {
        zzdsj.zzd(DatabaseReference.zzbpi());
    }

    public static void goOnline() {
        zzdsj.zze(DatabaseReference.zzbpi());
    }

    public FirebaseDatabase getDatabase() {
        return this.zzlom.getDatabase();
    }

    public String toString() {
        DatabaseReference databaseReference = this.getParent();
        if (databaseReference == null) {
            return this.zzlom.toString();
        }
        try {
            String string = databaseReference.toString();
            String string2 = URLEncoder.encode(this.getKey(), "UTF-8").replace("+", "%20");
            return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("/").append(string2).toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string = String.valueOf(this.getKey());
            throw new DatabaseException(string.length() != 0 ? "Failed to URLEncode key: ".concat(string) : new String("Failed to URLEncode key: "), unsupportedEncodingException);
        }
    }

    public DatabaseReference getParent() {
        zzdrc zzdrc2 = this.zzlot.zzbtb();
        if (zzdrc2 != null) {
            return new DatabaseReference(this.zzlom, zzdrc2);
        }
        return null;
    }

    public DatabaseReference getRoot() {
        return new DatabaseReference(this.zzlom, new zzdrc(""));
    }

    public String getKey() {
        if (this.zzlot.isEmpty()) {
            return null;
        }
        return this.zzlot.zzbtc().asString();
    }

    public boolean equals(Object object) {
        return object instanceof DatabaseReference && this.toString().equals(object.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private static synchronized zzdqr zzbpi() {
        if (zzlnz == null) {
            zzlnz = new zzdqr();
        }
        return zzlnz;
    }

    public static interface CompletionListener {
        public void onComplete(DatabaseError var1, DatabaseReference var2);
    }
}

