/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import com.google.android.gms.internal.zzdrk;
import com.google.android.gms.internal.zzdrr;
import com.google.android.gms.internal.zzdsc;
import com.google.android.gms.internal.zzdsf;
import com.google.android.gms.internal.zzdtj;
import com.google.android.gms.internal.zzduy;
import com.google.android.gms.internal.zzdya;
import com.google.android.gms.internal.zzdyx;
import com.google.android.gms.internal.zzdza;
import com.google.android.gms.internal.zzdzd;
import com.google.android.gms.internal.zzeal;
import com.google.android.gms.internal.zzean;
import com.google.android.gms.internal.zzeao;
import com.google.android.gms.internal.zzeaq;
import com.google.android.gms.internal.zzear;
import com.google.android.gms.tasks.Task;
import com.google.firebase.database.DatabaseError;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.FirebaseDatabase;
import com.google.firebase.database.OnDisconnect;
import com.google.firebase.database.Query;
import com.google.firebase.database.Transaction;
import com.google.firebase.database.zzc;
import com.google.firebase.database.zzd;
import com.google.firebase.database.zze;
import com.google.firebase.database.zzf;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;

public class DatabaseReference
extends Query {
    private static zzdrr zzlqc;

    DatabaseReference(zzdsf zzdsf2, zzdsc zzdsc2) {
        super(zzdsf2, zzdsc2);
    }

    public DatabaseReference child(String string) {
        if (string == null) {
            throw new NullPointerException("Can't pass null for argument 'pathString' in child()");
        }
        if (this.zzlqw.isEmpty()) {
            zzeaq.zzpz(string);
        } else {
            zzeaq.zzpy(string);
        }
        zzdsc zzdsc2 = this.zzlqw.zzh(new zzdsc(string));
        return new DatabaseReference(this.zzlqp, zzdsc2);
    }

    public DatabaseReference push() {
        zzdya zzdya2 = zzdya.zzpq(zzean.zzby(this.zzlqp.zzbtm()));
        return new DatabaseReference(this.zzlqp, this.zzlqw.zza(zzdya2));
    }

    public Task<Void> setValue(Object object) {
        return this.zza(object, zzdzd.zzc(this.zzlqw, null), null);
    }

    public Task<Void> setValue(Object object, Object object2) {
        return this.zza(object, zzdzd.zzc(this.zzlqw, object2), null);
    }

    public void setValue(Object object, CompletionListener completionListener) {
        this.zza(object, zzdzd.zzc(this.zzlqw, null), completionListener);
    }

    public void setValue(Object object, Object object2, CompletionListener completionListener) {
        this.zza(object, zzdzd.zzc(this.zzlqw, object2), completionListener);
    }

    private final Task<Void> zza(Object object, zzdyx zzdyx2, CompletionListener completionListener) {
        zzeaq.zzao(this.zzlqw);
        zzduy.zza(this.zzlqw, object);
        Object object2 = zzear.zzbp(object);
        zzeaq.zzbo(object2);
        zzdyx zzdyx3 = zzdza.zza(object2, zzdyx2);
        zzeal<Task<Void>, CompletionListener> zzeal2 = zzeao.zzb(completionListener);
        this.zzlqp.zzn(new zzc(this, zzdyx3, zzeal2));
        return zzeal2.getFirst();
    }

    public Task<Void> setPriority(Object object) {
        return this.zza(zzdzd.zzc(this.zzlqw, object), null);
    }

    public void setPriority(Object object, CompletionListener completionListener) {
        this.zza(zzdzd.zzc(this.zzlqw, object), completionListener);
    }

    private final Task<Void> zza(zzdyx zzdyx2, CompletionListener completionListener) {
        zzeaq.zzao(this.zzlqw);
        zzeal<Task<Void>, CompletionListener> zzeal2 = zzeao.zzb(completionListener);
        this.zzlqp.zzn(new zzd(this, zzdyx2, zzeal2));
        return zzeal2.getFirst();
    }

    public Task<Void> updateChildren(Map<String, Object> map) {
        return this.zza(map, null);
    }

    public void updateChildren(Map<String, Object> map, CompletionListener completionListener) {
        this.zza(map, completionListener);
    }

    private final Task<Void> zza(Map<String, Object> map, CompletionListener completionListener) {
        if (map == null) {
            throw new NullPointerException("Can't pass null for argument 'update' in updateChildren()");
        }
        Map<String, Object> map2 = zzear.zzah(map);
        zzdrk zzdrk2 = zzdrk.zzaf(zzeaq.zzb(this.zzlqw, map2));
        zzeal<Task<Void>, CompletionListener> zzeal2 = zzeao.zzb(completionListener);
        this.zzlqp.zzn(new zze(this, zzdrk2, zzeal2, map2));
        return zzeal2.getFirst();
    }

    public Task<Void> removeValue() {
        return this.setValue(null);
    }

    public void removeValue(CompletionListener completionListener) {
        this.setValue(null, completionListener);
    }

    public OnDisconnect onDisconnect() {
        zzeaq.zzao(this.zzlqw);
        return new OnDisconnect(this.zzlqp, this.zzlqw);
    }

    public void runTransaction(Transaction.Handler handler) {
        this.runTransaction(handler, true);
    }

    public void runTransaction(Transaction.Handler handler, boolean bl) {
        if (handler == null) {
            throw new NullPointerException("Can't pass null for argument 'handler' in runTransaction()");
        }
        zzeaq.zzao(this.zzlqw);
        this.zzlqp.zzn(new zzf(this, handler, bl));
    }

    public static void goOffline() {
        zzdtj.zzd(DatabaseReference.zzbpr());
    }

    public static void goOnline() {
        zzdtj.zze(DatabaseReference.zzbpr());
    }

    public FirebaseDatabase getDatabase() {
        return this.zzlqp.getDatabase();
    }

    public String toString() {
        DatabaseReference databaseReference = this.getParent();
        if (databaseReference == null) {
            return this.zzlqp.toString();
        }
        try {
            String string = databaseReference.toString();
            String string2 = URLEncoder.encode(this.getKey(), "UTF-8").replace("+", "%20");
            return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("/").append(string2).toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string = String.valueOf(this.getKey());
            throw new DatabaseException(string.length() != 0 ? "Failed to URLEncode key: ".concat(string) : new String("Failed to URLEncode key: "), unsupportedEncodingException);
        }
    }

    public DatabaseReference getParent() {
        zzdsc zzdsc2 = this.zzlqw.zzbti();
        if (zzdsc2 != null) {
            return new DatabaseReference(this.zzlqp, zzdsc2);
        }
        return null;
    }

    public DatabaseReference getRoot() {
        return new DatabaseReference(this.zzlqp, new zzdsc(""));
    }

    public String getKey() {
        if (this.zzlqw.isEmpty()) {
            return null;
        }
        return this.zzlqw.zzbtj().asString();
    }

    public boolean equals(Object object) {
        return object instanceof DatabaseReference && this.toString().equals(object.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private static synchronized zzdrr zzbpr() {
        if (zzlqc == null) {
            zzlqc = new zzdrr();
        }
        return zzlqc;
    }

    public static interface CompletionListener {
        public void onComplete(DatabaseError var1, DatabaseReference var2);
    }
}

