/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import com.google.android.gms.internal.zzdri;
import com.google.android.gms.internal.zzdrt;
import com.google.android.gms.internal.zzdsc;
import com.google.android.gms.internal.zzdsf;
import com.google.android.gms.internal.zzduz;
import com.google.android.gms.internal.zzdve;
import com.google.android.gms.internal.zzdxb;
import com.google.android.gms.internal.zzdxe;
import com.google.android.gms.internal.zzdxz;
import com.google.android.gms.internal.zzdya;
import com.google.android.gms.internal.zzdyn;
import com.google.android.gms.internal.zzdyo;
import com.google.android.gms.internal.zzdyr;
import com.google.android.gms.internal.zzdyx;
import com.google.android.gms.internal.zzdzb;
import com.google.android.gms.internal.zzdzc;
import com.google.android.gms.internal.zzdzd;
import com.google.android.gms.internal.zzdzf;
import com.google.android.gms.internal.zzdzh;
import com.google.android.gms.internal.zzeao;
import com.google.android.gms.internal.zzeaq;
import com.google.firebase.database.ChildEventListener;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.ValueEventListener;
import com.google.firebase.database.zzp;
import com.google.firebase.database.zzq;
import com.google.firebase.database.zzr;
import com.google.firebase.database.zzs;

public class Query {
    protected final zzdsf zzlqp;
    protected final zzdsc zzlqw;
    private zzdxb zzlra;
    private final boolean zzlrb;

    private Query(zzdsf zzdsf2, zzdsc zzdsc2, zzdxb zzdxb2, boolean bl) throws DatabaseException {
        this.zzlqp = zzdsf2;
        this.zzlqw = zzdsc2;
        this.zzlra = zzdxb2;
        this.zzlrb = bl;
        zzdxb zzdxb3 = zzdxb2;
        zzeao.zzb(!zzdxb3.zzbvi() || !zzdxb3.zzbvl() || !zzdxb3.zzbvo() || zzdxb3.zzbvp(), "Validation of queries failed.");
    }

    Query(zzdsf zzdsf2, zzdsc zzdsc2) {
        this.zzlqp = zzdsf2;
        this.zzlqw = zzdsc2;
        this.zzlra = zzdxb.zzmgp;
        this.zzlrb = false;
    }

    private static void zza(zzdxb zzdxb2) {
        if (zzdxb2.zzbvq().equals(zzdyr.zzbxk())) {
            zzdyx zzdyx2;
            String string = "You must use startAt(String value), endAt(String value) or equalTo(String value) in combination with orderByKey(). Other type of values or using the version with 2 parameters is not supported";
            if (zzdxb2.zzbvi()) {
                zzdyx2 = zzdxb2.zzbvj();
                if (zzdxb2.zzbvk() != zzdya.zzbwm() || !(zzdyx2 instanceof zzdzf)) {
                    throw new IllegalArgumentException(string);
                }
            }
            if (zzdxb2.zzbvl()) {
                zzdyx2 = zzdxb2.zzbvm();
                if (zzdxb2.zzbvn() != zzdya.zzbwn() || !(zzdyx2 instanceof zzdzf)) {
                    throw new IllegalArgumentException(string);
                }
            }
            return;
        }
        if (zzdxb2.zzbvq().equals(zzdzc.zzbxo()) && (zzdxb2.zzbvi() && !zzdzd.zzl(zzdxb2.zzbvj()) || zzdxb2.zzbvl() && !zzdzd.zzl(zzdxb2.zzbvm()))) {
            throw new IllegalArgumentException("When using orderByPriority(), values provided to startAt(), endAt(), or equalTo() must be valid priorities.");
        }
    }

    private static void zzb(zzdxb zzdxb2) {
        if (zzdxb2.zzbvi() && zzdxb2.zzbvl() && zzdxb2.zzbvo() && !zzdxb2.zzbvp()) {
            throw new IllegalArgumentException("Can't combine startAt(), endAt() and limit(). Use limitToFirst() or limitToLast() instead");
        }
    }

    private final void zzbpu() {
        if (this.zzlra.zzbvi()) {
            throw new IllegalArgumentException("Can't call equalTo() and startAt() combined");
        }
        if (this.zzlra.zzbvl()) {
            throw new IllegalArgumentException("Can't call equalTo() and endAt() combined");
        }
    }

    private final void zzbpv() {
        if (this.zzlrb) {
            throw new IllegalArgumentException("You can't combine multiple orderBy calls!");
        }
    }

    public ValueEventListener addValueEventListener(ValueEventListener valueEventListener) {
        this.zzb(new zzduz(this.zzlqp, valueEventListener, this.zzbpx()));
        return valueEventListener;
    }

    public ChildEventListener addChildEventListener(ChildEventListener childEventListener) {
        this.zzb(new zzdri(this.zzlqp, childEventListener, this.zzbpx()));
        return childEventListener;
    }

    public void addListenerForSingleValueEvent(ValueEventListener valueEventListener) {
        this.zzb(new zzduz(this.zzlqp, new zzp(this, valueEventListener), this.zzbpx()));
    }

    public void removeEventListener(ValueEventListener valueEventListener) {
        if (valueEventListener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.zza(new zzduz(this.zzlqp, valueEventListener, this.zzbpx()));
    }

    public void removeEventListener(ChildEventListener childEventListener) {
        if (childEventListener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.zza(new zzdri(this.zzlqp, childEventListener, this.zzbpx()));
    }

    private final void zza(zzdrt zzdrt2) {
        zzdve.zzbue().zzj(zzdrt2);
        this.zzlqp.zzn(new zzq(this, zzdrt2));
    }

    private final void zzb(zzdrt zzdrt2) {
        zzdve.zzbue().zzi(zzdrt2);
        this.zzlqp.zzn(new zzr(this, zzdrt2));
    }

    public void keepSynced(boolean bl) {
        if (!this.zzlqw.isEmpty() && this.zzlqw.zzbtg().equals(zzdya.zzbwp())) {
            throw new DatabaseException("Can't call keepSynced() on .info paths.");
        }
        this.zzlqp.zzn(new zzs(this, bl));
    }

    public Query startAt(String string) {
        return this.startAt(string, null);
    }

    public Query startAt(double d) {
        return this.startAt(d, null);
    }

    public Query startAt(boolean bl) {
        return this.startAt(bl, null);
    }

    public Query startAt(String string, String string2) {
        zzdyx zzdyx2 = string != null ? new zzdzf(string, zzdyo.zzbxe()) : zzdyo.zzbxe();
        return this.zza(zzdyx2, string2);
    }

    public Query startAt(double d, String string) {
        return this.zza(new zzdyn(d, zzdyo.zzbxe()), string);
    }

    public Query startAt(boolean bl, String string) {
        return this.zza(new zzdxz(bl, zzdyo.zzbxe()), string);
    }

    private final Query zza(zzdyx zzdyx2, String string) {
        zzeaq.zzqa(string);
        if (!zzdyx2.zzbwt() && !zzdyx2.isEmpty()) {
            throw new IllegalArgumentException("Can only use simple values for startAt()");
        }
        if (this.zzlra.zzbvi()) {
            throw new IllegalArgumentException("Can't call startAt() or equalTo() multiple times");
        }
        zzdya zzdya2 = string != null ? zzdya.zzpq(string) : null;
        zzdxb zzdxb2 = this.zzlra.zza(zzdyx2, zzdya2);
        Query.zzb(zzdxb2);
        Query.zza(zzdxb2);
        return new Query(this.zzlqp, this.zzlqw, zzdxb2, this.zzlrb);
    }

    public Query endAt(String string) {
        return this.endAt(string, null);
    }

    public Query endAt(double d) {
        return this.endAt(d, null);
    }

    public Query endAt(boolean bl) {
        return this.endAt(bl, null);
    }

    public Query endAt(String string, String string2) {
        zzdyx zzdyx2 = string != null ? new zzdzf(string, zzdyo.zzbxe()) : zzdyo.zzbxe();
        return this.zzb(zzdyx2, string2);
    }

    public Query endAt(double d, String string) {
        return this.zzb(new zzdyn(d, zzdyo.zzbxe()), string);
    }

    public Query endAt(boolean bl, String string) {
        return this.zzb(new zzdxz(bl, zzdyo.zzbxe()), string);
    }

    private final Query zzb(zzdyx zzdyx2, String string) {
        zzdya zzdya2;
        zzeaq.zzqa(string);
        if (!zzdyx2.zzbwt() && !zzdyx2.isEmpty()) {
            throw new IllegalArgumentException("Can only use simple values for endAt()");
        }
        zzdya zzdya3 = zzdya2 = string != null ? zzdya.zzpq(string) : null;
        if (this.zzlra.zzbvl()) {
            throw new IllegalArgumentException("Can't call endAt() or equalTo() multiple times");
        }
        zzdxb zzdxb2 = this.zzlra.zzb(zzdyx2, zzdya2);
        Query.zzb(zzdxb2);
        Query.zza(zzdxb2);
        return new Query(this.zzlqp, this.zzlqw, zzdxb2, this.zzlrb);
    }

    public Query equalTo(String string) {
        this.zzbpu();
        return this.startAt(string).endAt(string);
    }

    public Query equalTo(double d) {
        this.zzbpu();
        return this.startAt(d).endAt(d);
    }

    public Query equalTo(boolean bl) {
        this.zzbpu();
        return this.startAt(bl).endAt(bl);
    }

    public Query equalTo(String string, String string2) {
        this.zzbpu();
        return this.startAt(string, string2).endAt(string, string2);
    }

    public Query equalTo(double d, String string) {
        this.zzbpu();
        return this.startAt(d, string).endAt(d, string);
    }

    public Query equalTo(boolean bl, String string) {
        this.zzbpu();
        return this.startAt(bl, string).endAt(bl, string);
    }

    public Query limitToFirst(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Limit must be a positive integer!");
        }
        if (this.zzlra.zzbvo()) {
            throw new IllegalArgumentException("Can't call limitToLast on query with previously set limit!");
        }
        return new Query(this.zzlqp, this.zzlqw, this.zzlra.zzfz(n), this.zzlrb);
    }

    public Query limitToLast(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Limit must be a positive integer!");
        }
        if (this.zzlra.zzbvo()) {
            throw new IllegalArgumentException("Can't call limitToLast on query with previously set limit!");
        }
        return new Query(this.zzlqp, this.zzlqw, this.zzlra.zzga(n), this.zzlrb);
    }

    public Query orderByChild(String string) {
        if (string == null) {
            throw new NullPointerException("Key can't be null");
        }
        if (string.equals("$key") || string.equals(".key")) {
            throw new IllegalArgumentException(new StringBuilder(54 + String.valueOf(string).length()).append("Can't use '").append(string).append("' as path, please use orderByKey() instead!").toString());
        }
        if (string.equals("$priority") || string.equals(".priority")) {
            throw new IllegalArgumentException(new StringBuilder(59 + String.valueOf(string).length()).append("Can't use '").append(string).append("' as path, please use orderByPriority() instead!").toString());
        }
        if (string.equals("$value") || string.equals(".value")) {
            throw new IllegalArgumentException(new StringBuilder(56 + String.valueOf(string).length()).append("Can't use '").append(string).append("' as path, please use orderByValue() instead!").toString());
        }
        zzeaq.zzpy(string);
        this.zzbpv();
        zzdsc zzdsc2 = new zzdsc(string);
        if (zzdsc2.size() == 0) {
            throw new IllegalArgumentException("Can't use empty path, use orderByValue() instead!");
        }
        zzdzb zzdzb2 = new zzdzb(zzdsc2);
        return new Query(this.zzlqp, this.zzlqw, this.zzlra.zza(zzdzb2), true);
    }

    public Query orderByPriority() {
        this.zzbpv();
        zzdxb zzdxb2 = this.zzlra.zza(zzdzc.zzbxo());
        Query.zza(zzdxb2);
        return new Query(this.zzlqp, this.zzlqw, zzdxb2, true);
    }

    public Query orderByKey() {
        this.zzbpv();
        zzdxb zzdxb2 = this.zzlra.zza(zzdyr.zzbxk());
        Query.zza(zzdxb2);
        return new Query(this.zzlqp, this.zzlqw, zzdxb2, true);
    }

    public Query orderByValue() {
        this.zzbpv();
        return new Query(this.zzlqp, this.zzlqw, this.zzlra.zza(zzdzh.zzbxp()), true);
    }

    public DatabaseReference getRef() {
        return new DatabaseReference(this.zzlqp, this.zzlqw);
    }

    public final zzdsc zzbpw() {
        return this.zzlqw;
    }

    public final zzdxe zzbpx() {
        return new zzdxe(this.zzlqw, this.zzlra);
    }
}

