/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzedm;
import com.google.android.gms.internal.zzeer;
import com.google.android.gms.internal.zzeke;
import com.google.android.gms.internal.zzekf;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.FirebaseDatabase;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public abstract class zzekd
implements zzedm {
    private ScheduledThreadPoolExecutor zznat;

    protected ThreadFactory getThreadFactory() {
        return Executors.defaultThreadFactory();
    }

    protected zzeer zzbuh() {
        return zzeer.zzmsg;
    }

    public abstract void zzi(Throwable var1);

    public zzekd() {
        zzekf zzekf2 = new zzekf(this, null);
        this.zznat = new zzeke(this, 1, zzekf2);
        this.zznat.setKeepAliveTime(3L, TimeUnit.SECONDS);
    }

    public final ScheduledExecutorService zzbsf() {
        return this.zznat;
    }

    @Override
    public final void zzo(Runnable runnable) {
        this.zznat.execute(runnable);
    }

    @Override
    public final void shutdown() {
        this.zznat.setCorePoolSize(0);
    }

    @Override
    public final void restart() {
        this.zznat.setCorePoolSize(1);
    }

    public static String zzk(Throwable throwable) {
        if (throwable instanceof OutOfMemoryError) {
            return "Firebase Database encountered an OutOfMemoryError. You may need to reduce the amount of data you are syncing to the client (e.g. by using queries or syncing a deeper path). See https://firebase.google.com/docs/database/ios/structure-data#best_practices_for_data_structure and https://firebase.google.com/docs/database/android/retrieve-data#filtering_data";
        }
        if (throwable instanceof DatabaseException) {
            return "";
        }
        String string = FirebaseDatabase.getSdkVersion();
        return new StringBuilder(104 + String.valueOf(string).length()).append("Uncaught exception in Firebase Database runloop (").append(string).append("). Please report to firebase-database-client@google.com").toString();
    }
}

