/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzekm;
import com.google.android.gms.internal.zzekq;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.GenericTypeIndicator;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class zzekp {
    private static final ConcurrentMap<Class<?>, zzekq<?>> zznbe = new ConcurrentHashMap();

    public static Object zzbv(Object object) {
        return zzekp.zzbw(object);
    }

    public static Map<String, Object> zzam(Map<String, Object> map) {
        Object object = zzekp.zzbw(map);
        zzekm.zzcm(object instanceof Map);
        return (Map)object;
    }

    public static <T> T zza(Object object, Class<T> clazz) {
        return zzekp.zzb(object, clazz);
    }

    public static <T> T zza(Object object, GenericTypeIndicator<T> genericTypeIndicator) {
        Type type = genericTypeIndicator.getClass().getGenericSuperclass();
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            if (!parameterizedType.getRawType().equals(GenericTypeIndicator.class)) {
                String string = String.valueOf(type);
                throw new DatabaseException(new StringBuilder(47 + String.valueOf(string).length()).append("Not a direct subclass of GenericTypeIndicator: ").append(string).toString());
            }
            Type type2 = parameterizedType.getActualTypeArguments()[0];
            return zzekp.zza(object, type2);
        }
        String string = String.valueOf(type);
        throw new DatabaseException(new StringBuilder(47 + String.valueOf(string).length()).append("Not a direct subclass of GenericTypeIndicator: ").append(string).toString());
    }

    private static <T> Object zzbw(T t) {
        if (t == null) {
            return null;
        }
        if (t instanceof Number) {
            if (t instanceof Float || t instanceof Double) {
                double d;
                double d2 = ((Number)t).doubleValue();
                if (d <= 9.223372036854776E18 && d2 >= -9.223372036854776E18 && Math.floor(d2) == d2) {
                    return ((Number)t).longValue();
                }
                return d2;
            }
            if (t instanceof Short) {
                throw new DatabaseException("Shorts are not supported, please use int or long");
            }
            if (t instanceof Byte) {
                throw new DatabaseException("Bytes are not supported, please use int or long");
            }
            return t;
        }
        if (t instanceof String) {
            return t;
        }
        if (t instanceof Boolean) {
            return t;
        }
        if (t instanceof Character) {
            throw new DatabaseException("Characters are not supported, please strings");
        }
        if (t instanceof Map) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (Map.Entry entry : ((Map)t).entrySet()) {
                Object k = entry.getKey();
                if (k instanceof String) {
                    String string = (String)k;
                    hashMap.put(string, zzekp.zzbw(entry.getValue()));
                    continue;
                }
                throw new DatabaseException("Maps with non-string keys are not supported");
            }
            return hashMap;
        }
        if (t instanceof Collection) {
            if (t instanceof List) {
                List list = (List)t;
                ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
                for (Object e : list) {
                    arrayList.add(zzekp.zzbw(e));
                }
                return arrayList;
            }
            throw new DatabaseException("Serializing Collections is not supported, please use Lists instead");
        }
        if (t.getClass().isArray()) {
            throw new DatabaseException("Serializing Arrays is not supported, please use Lists instead");
        }
        if (t instanceof Enum) {
            return ((Enum)t).name();
        }
        return zzekp.zzf(t.getClass()).zzca(t);
    }

    private static <T> T zza(Object object, Type type) {
        if (object == null) {
            return null;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Object object2 = object;
            Class clazz = (Class)parameterizedType.getRawType();
            if (List.class.isAssignableFrom(clazz)) {
                Type type2 = parameterizedType.getActualTypeArguments()[0];
                if (object2 instanceof List) {
                    List list = (List)object2;
                    ArrayList<T> arrayList = new ArrayList<T>(list.size());
                    for (Object e : list) {
                        arrayList.add(zzekp.zza(e, type2));
                    }
                    return (T)arrayList;
                }
                String string = String.valueOf(object2.getClass());
                throw new DatabaseException(new StringBuilder(47 + String.valueOf(string).length()).append("Expected a List while deserializing, but got a ").append(string).toString());
            }
            if (Map.class.isAssignableFrom(clazz)) {
                Type type3 = parameterizedType.getActualTypeArguments()[0];
                Type type4 = parameterizedType.getActualTypeArguments()[1];
                if (!type3.equals(String.class)) {
                    String string = String.valueOf(type3);
                    throw new DatabaseException(new StringBuilder(70 + String.valueOf(string).length()).append("Only Maps with string keys are supported, but found Map with key type ").append(string).toString());
                }
                Map<String, Object> map = zzekp.zzbx(object2);
                HashMap<String, T> hashMap = new HashMap<String, T>();
                for (Map.Entry<String, Object> entry : map.entrySet()) {
                    hashMap.put(entry.getKey(), zzekp.zza(entry.getValue(), type4));
                }
                return (T)hashMap;
            }
            if (Collection.class.isAssignableFrom(clazz)) {
                throw new DatabaseException("Collections are not supported, please use Lists instead");
            }
            Map<String, Object> map = zzekp.zzbx(object2);
            zzekq zzekq2 = zzekp.zzf(clazz);
            HashMap hashMap = new HashMap();
            TypeVariable<Class<T>>[] typeVariableArray = zzekq.zza(zzekq2).getTypeParameters();
            Type[] typeArray = parameterizedType.getActualTypeArguments();
            if (typeArray.length != typeVariableArray.length) {
                throw new IllegalStateException("Mismatched lengths for type variables and actual types");
            }
            for (int i = 0; i < typeVariableArray.length; ++i) {
                hashMap.put(typeVariableArray[i], typeArray[i]);
            }
            return zzekq2.zze(map, hashMap);
        }
        if (type instanceof Class) {
            return zzekp.zzb(object, (Class)type);
        }
        if (type instanceof WildcardType) {
            throw new DatabaseException("Generic wildcard types are not supported");
        }
        if (type instanceof GenericArrayType) {
            throw new DatabaseException("Generic Arrays are not supported, please use Lists instead");
        }
        String string = String.valueOf(type);
        throw new IllegalStateException(new StringBuilder(26 + String.valueOf(string).length()).append("Unknown type encountered: ").append(string).toString());
    }

    private static <T> T zzb(Object object, Class<T> clazz) {
        if (object == null) {
            return null;
        }
        if (clazz.isPrimitive() || Number.class.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz) || Character.class.isAssignableFrom(clazz)) {
            Class<T> clazz2 = clazz;
            Object object2 = object;
            if (Integer.class.isAssignableFrom(clazz2) || Integer.TYPE.isAssignableFrom(clazz2)) {
                Object object3 = object2;
                if (object3 instanceof Integer) {
                    return (T)((Integer)object3);
                }
                if (object3 instanceof Long || object3 instanceof Double) {
                    double d;
                    double d2 = ((Number)object3).doubleValue();
                    if (d >= -2.147483648E9 && d2 <= 2.147483647E9) {
                        return (T)Integer.valueOf(((Number)object3).intValue());
                    }
                    throw new DatabaseException(new StringBuilder(124).append("Numeric value out of 32-bit integer range: ").append(d2).append(". Did you mean to use a long or double instead of an int?").toString());
                }
                String string = object3.getClass().getName();
                throw new DatabaseException(new StringBuilder(41 + String.valueOf(string).length()).append("Failed to convert a value of type ").append(string).append(" to int").toString());
            }
            if (Boolean.class.isAssignableFrom(clazz2) || Boolean.TYPE.isAssignableFrom(clazz2)) {
                Object object4 = object2;
                if (object4 instanceof Boolean) {
                    return (T)((Boolean)object4);
                }
                String string = object4.getClass().getName();
                throw new DatabaseException(new StringBuilder(43 + String.valueOf(string).length()).append("Failed to convert value of type ").append(string).append(" to boolean").toString());
            }
            if (Double.class.isAssignableFrom(clazz2) || Double.TYPE.isAssignableFrom(clazz2)) {
                return (T)zzekp.zzby(object2);
            }
            if (Long.class.isAssignableFrom(clazz2) || Long.TYPE.isAssignableFrom(clazz2)) {
                Object object5 = object2;
                if (object5 instanceof Integer) {
                    return (T)Long.valueOf(((Integer)object5).longValue());
                }
                if (object5 instanceof Long) {
                    return (T)((Long)object5);
                }
                if (object5 instanceof Double) {
                    Double d;
                    Double d3 = (Double)object5;
                    if (d >= -9.223372036854776E18 && d3 <= 9.223372036854776E18) {
                        return (T)Long.valueOf(d3.longValue());
                    }
                    String string = String.valueOf(d3);
                    throw new DatabaseException(new StringBuilder(89 + String.valueOf(string).length()).append("Numeric value out of 64-bit long range: ").append(string).append(". Did you mean to use a double instead of a long?").toString());
                }
                String string = object5.getClass().getName();
                throw new DatabaseException(new StringBuilder(42 + String.valueOf(string).length()).append("Failed to convert a value of type ").append(string).append(" to long").toString());
            }
            if (Float.class.isAssignableFrom(clazz2) || Float.TYPE.isAssignableFrom(clazz2)) {
                return (T)Float.valueOf(zzekp.zzby(object2).floatValue());
            }
            if (Short.class.isAssignableFrom(clazz2) || Short.TYPE.isAssignableFrom(clazz2)) {
                throw new DatabaseException("Deserializing to shorts is not supported");
            }
            if (Byte.class.isAssignableFrom(clazz2) || Byte.TYPE.isAssignableFrom(clazz2)) {
                throw new DatabaseException("Deserializing to bytes is not supported");
            }
            if (Character.class.isAssignableFrom(clazz2) || Character.TYPE.isAssignableFrom(clazz2)) {
                throw new DatabaseException("Deserializing to char is not supported");
            }
            String string = String.valueOf(clazz2);
            throw new IllegalArgumentException(new StringBuilder(24 + String.valueOf(string).length()).append("Unknown primitive type: ").append(string).toString());
        }
        if (String.class.isAssignableFrom(clazz)) {
            Object object6 = object;
            if (object6 instanceof String) {
                return (T)((String)object6);
            }
            String string = object6.getClass().getName();
            throw new DatabaseException(new StringBuilder(42 + String.valueOf(string).length()).append("Failed to convert value of type ").append(string).append(" to String").toString());
        }
        if (clazz.isArray()) {
            throw new DatabaseException("Converting to Arrays is not supported, please use Listsinstead");
        }
        if (clazz.getTypeParameters().length > 0) {
            String string = clazz.getName();
            throw new DatabaseException(new StringBuilder(75 + String.valueOf(string).length()).append("Class ").append(string).append(" has generic type parameters, please use GenericTypeIndicator instead").toString());
        }
        if (clazz.equals(Object.class)) {
            return (T)object;
        }
        if (clazz.isEnum()) {
            return zzekp.zzc(object, clazz);
        }
        Class<T> clazz3 = clazz;
        Object object7 = object;
        zzekq zzekq2 = zzekp.zzf(clazz3);
        if (object7 instanceof Map) {
            Map<String, Object> map = zzekp.zzbx(object7);
            return zzekq2.zze(map, Collections.emptyMap());
        }
        String string = object7.getClass().getName();
        String string2 = clazz3.getName();
        throw new DatabaseException(new StringBuilder(38 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Can't convert object of type ").append(string).append(" to type ").append(string2).toString());
    }

    private static <T> T zzc(Object object, Class<T> clazz) {
        if (object instanceof String) {
            String string = (String)object;
            try {
                return Enum.valueOf(clazz, string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String string2 = clazz.getName();
                throw new DatabaseException(new StringBuilder(42 + String.valueOf(string2).length() + String.valueOf(string).length()).append("Could not find enum value of ").append(string2).append(" for value \"").append(string).append("\"").toString());
            }
        }
        String string = String.valueOf(clazz);
        String string3 = String.valueOf(object.getClass());
        throw new DatabaseException(new StringBuilder(57 + String.valueOf(string).length() + String.valueOf(string3).length()).append("Expected a String while deserializing to enum ").append(string).append(" but got a ").append(string3).toString());
    }

    private static <T> zzekq<T> zzf(Class<T> clazz) {
        zzekq<T> zzekq2 = (zzekq<T>)zznbe.get(clazz);
        if (zzekq2 == null) {
            zzekq2 = new zzekq<T>(clazz);
            zznbe.put(clazz, zzekq2);
        }
        return zzekq2;
    }

    private static Map<String, Object> zzbx(Object object) {
        if (object instanceof Map) {
            return (Map)object;
        }
        String string = String.valueOf(object.getClass());
        throw new DatabaseException(new StringBuilder(46 + String.valueOf(string).length()).append("Expected a Map while deserializing, but got a ").append(string).toString());
    }

    private static Double zzby(Object object) {
        if (object instanceof Integer) {
            return ((Integer)object).doubleValue();
        }
        if (object instanceof Long) {
            Long l = (Long)object;
            Double d = ((Long)object).doubleValue();
            if (d.longValue() == l.longValue()) {
                return d;
            }
            String string = String.valueOf(object);
            throw new DatabaseException(new StringBuilder(97 + String.valueOf(string).length()).append("Loss of precision while converting number to double: ").append(string).append(". Did you mean to use a 64-bit long instead?").toString());
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        String string = object.getClass().getName();
        throw new DatabaseException(new StringBuilder(44 + String.valueOf(string).length()).append("Failed to convert a value of type ").append(string).append(" to double").toString());
    }

    static /* synthetic */ Object zzb(Object object, Type type) {
        return zzekp.zza(object, type);
    }

    static /* synthetic */ Object zzbz(Object object) {
        return zzekp.zzbw(object);
    }
}

