/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import android.support.annotation.Nullable;
import com.google.android.gms.internal.zzeca;
import com.google.android.gms.internal.zzeio;
import com.google.android.gms.internal.zzeiu;
import com.google.android.gms.internal.zzeiv;
import com.google.android.gms.internal.zzeko;
import com.google.android.gms.internal.zzekp;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.GenericTypeIndicator;
import com.google.firebase.database.zza;
import java.util.Iterator;

public class DataSnapshot {
    private final zzeio zzmfc;
    private final DatabaseReference zzmfd;

    DataSnapshot(DatabaseReference databaseReference, zzeio zzeio2) {
        this.zzmfc = zzeio2;
        this.zzmfd = databaseReference;
    }

    public DataSnapshot child(String string) {
        DatabaseReference databaseReference = this.zzmfd.child(string);
        zzeiv zzeiv2 = this.zzmfc.zzbqy().zzan(new zzeca(string));
        return new DataSnapshot(databaseReference, zzeio.zzj(zzeiv2));
    }

    public boolean hasChild(String string) {
        if (this.zzmfd.getParent() == null) {
            zzeko.zzpt(string);
        } else {
            zzeko.zzps(string);
        }
        return !this.zzmfc.zzbqy().zzan(new zzeca(string)).isEmpty();
    }

    public boolean hasChildren() {
        return this.zzmfc.zzbqy().getChildCount() > 0;
    }

    public boolean exists() {
        return !this.zzmfc.zzbqy().isEmpty();
    }

    @Nullable
    public Object getValue() {
        return this.zzmfc.zzbqy().getValue();
    }

    @Nullable
    public Object getValue(boolean bl) {
        return this.zzmfc.zzbqy().getValue(bl);
    }

    @Nullable
    public <T> T getValue(Class<T> clazz) {
        return zzekp.zza(this.zzmfc.zzbqy().getValue(), clazz);
    }

    @Nullable
    public <T> T getValue(GenericTypeIndicator<T> genericTypeIndicator) {
        return zzekp.zza(this.zzmfc.zzbqy().getValue(), genericTypeIndicator);
    }

    public long getChildrenCount() {
        return this.zzmfc.zzbqy().getChildCount();
    }

    public DatabaseReference getRef() {
        return this.zzmfd;
    }

    public String getKey() {
        return this.zzmfd.getKey();
    }

    public Iterable<DataSnapshot> getChildren() {
        Iterator<zzeiu> iterator = this.zzmfc.iterator();
        return new zza(this, iterator);
    }

    public Object getPriority() {
        Object object = this.zzmfc.zzbqy().zzbxz().getValue();
        if (object instanceof Long) {
            return (double)((Long)object).longValue();
        }
        return object;
    }

    public String toString() {
        String string = this.zzmfd.getKey();
        String string2 = String.valueOf(this.zzmfc.zzbqy().getValue(true));
        return new StringBuilder(33 + String.valueOf(string).length() + String.valueOf(string2).length()).append("DataSnapshot { key = ").append(string).append(", value = ").append(string2).append(" }").toString();
    }

    static /* synthetic */ DatabaseReference zza(DataSnapshot dataSnapshot) {
        return dataSnapshot.zzmfd;
    }
}

