/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import android.text.TextUtils;
import com.google.android.gms.internal.zzebp;
import com.google.android.gms.internal.zzeca;
import com.google.android.gms.internal.zzecd;
import com.google.android.gms.internal.zzedg;
import com.google.android.gms.internal.zzedh;
import com.google.android.gms.internal.zzekk;
import com.google.android.gms.internal.zzekm;
import com.google.android.gms.internal.zzeko;
import com.google.firebase.FirebaseApp;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.Logger;
import com.google.firebase.database.zzg;
import java.util.HashMap;
import java.util.Map;

public class FirebaseDatabase {
    private static final Map<String, Map<zzedg, FirebaseDatabase>> zzmft = new HashMap<String, Map<zzedg, FirebaseDatabase>>();
    private final FirebaseApp zzmfu;
    private final zzedg zzmfv;
    private final zzebp zzmfw;
    private zzecd zzmfx;

    public static FirebaseDatabase getInstance() {
        FirebaseApp firebaseApp = FirebaseApp.getInstance();
        if (firebaseApp == null) {
            throw new DatabaseException("You must call FirebaseApp.initialize() first.");
        }
        return FirebaseDatabase.getInstance(firebaseApp, firebaseApp.getOptions().getDatabaseUrl());
    }

    public static FirebaseDatabase getInstance(String string) {
        FirebaseApp firebaseApp = FirebaseApp.getInstance();
        if (firebaseApp == null) {
            throw new DatabaseException("You must call FirebaseApp.initialize() first.");
        }
        return FirebaseDatabase.getInstance(firebaseApp, string);
    }

    public static FirebaseDatabase getInstance(FirebaseApp firebaseApp) {
        return FirebaseDatabase.getInstance(firebaseApp, firebaseApp.getOptions().getDatabaseUrl());
    }

    public static synchronized FirebaseDatabase getInstance(FirebaseApp firebaseApp, String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new DatabaseException("Failed to get FirebaseDatabase instance: Specify DatabaseURL within FirebaseApp or from your getInstance() call.");
        }
        Map<zzedg, FirebaseDatabase> map = zzmft.get(firebaseApp.getName());
        if (map == null) {
            map = new HashMap<zzedg, FirebaseDatabase>();
            zzmft.put(firebaseApp.getName(), map);
        }
        zzekk zzekk2 = zzekm.zzpo(string);
        if (!zzekk2.zzmge.isEmpty()) {
            String string2 = zzekk2.zzmge.toString();
            throw new DatabaseException(new StringBuilder(113 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Specified Database URL '").append(string).append("' is invalid. It should point to the root of a Firebase Database but it includes a path: ").append(string2).toString());
        }
        FirebaseDatabase firebaseDatabase = map.get(zzekk2.zzmfv);
        if (firebaseDatabase == null) {
            zzebp zzebp2 = new zzebp();
            if (!firebaseApp.zzboy()) {
                zzebp2.zzpi(firebaseApp.getName());
            }
            zzebp2.zzd(firebaseApp);
            firebaseDatabase = new FirebaseDatabase(firebaseApp, zzekk2.zzmfv, zzebp2);
            map.put(zzekk2.zzmfv, firebaseDatabase);
        }
        return firebaseDatabase;
    }

    private FirebaseDatabase(FirebaseApp firebaseApp, zzedg zzedg2, zzebp zzebp2) {
        this.zzmfu = firebaseApp;
        this.zzmfv = zzedg2;
        this.zzmfw = zzebp2;
    }

    public FirebaseApp getApp() {
        return this.zzmfu;
    }

    public DatabaseReference getReference() {
        this.zzbqx();
        return new DatabaseReference(this.zzmfx, zzeca.zzbui());
    }

    public DatabaseReference getReference(String string) {
        this.zzbqx();
        if (string == null) {
            throw new NullPointerException("Can't pass null for argument 'pathString' in FirebaseDatabase.getReference()");
        }
        zzeko.zzpt(string);
        zzeca zzeca2 = new zzeca(string);
        return new DatabaseReference(this.zzmfx, zzeca2);
    }

    public DatabaseReference getReferenceFromUrl(String string) {
        this.zzbqx();
        if (string == null) {
            throw new NullPointerException("Can't pass null for argument 'url' in FirebaseDatabase.getReferenceFromUrl()");
        }
        zzekk zzekk2 = zzekm.zzpo(string);
        if (!zzekk2.zzmfv.host.equals(this.zzmfx.zzbuq().host)) {
            String string2 = this.getReference().toString();
            throw new DatabaseException(new StringBuilder(93 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Invalid URL (").append(string).append(") passed to getReference().  URL was expected to match configured Database URL: ").append(string2).toString());
        }
        return new DatabaseReference(this.zzmfx, zzekk2.zzmge);
    }

    public void purgeOutstandingWrites() {
        this.zzbqx();
        this.zzmfx.zzo(new zzg(this));
    }

    public void goOnline() {
        this.zzbqx();
        zzedh.zzl(this.zzmfx);
    }

    public void goOffline() {
        this.zzbqx();
        zzedh.zzk(this.zzmfx);
    }

    public synchronized void setLogLevel(Logger.Level level) {
        this.zzos("setLogLevel");
        this.zzmfw.setLogLevel(level);
    }

    public synchronized void setPersistenceEnabled(boolean bl) {
        this.zzos("setPersistenceEnabled");
        this.zzmfw.setPersistenceEnabled(bl);
    }

    public synchronized void setPersistenceCacheSizeBytes(long l) {
        this.zzos("setPersistenceCacheSizeBytes");
        this.zzmfw.setPersistenceCacheSizeBytes(l);
    }

    public static String getSdkVersion() {
        return "3.0.0";
    }

    private final void zzos(String string) {
        if (this.zzmfx != null) {
            throw new DatabaseException(new StringBuilder(77 + String.valueOf(string).length()).append("Calls to ").append(string).append("() must be made before any other usage of FirebaseDatabase instance.").toString());
        }
    }

    private final synchronized void zzbqx() {
        if (this.zzmfx == null) {
            this.zzmfx = zzedh.zza(this.zzmfw, this.zzmfv, this);
        }
    }

    static /* synthetic */ zzecd zza(FirebaseDatabase firebaseDatabase) {
        return firebaseDatabase.zzmfx;
    }
}

