/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import com.google.android.gms.internal.zzebg;
import com.google.android.gms.internal.zzebr;
import com.google.android.gms.internal.zzeca;
import com.google.android.gms.internal.zzecd;
import com.google.android.gms.internal.zzeex;
import com.google.android.gms.internal.zzefc;
import com.google.android.gms.internal.zzegz;
import com.google.android.gms.internal.zzehc;
import com.google.android.gms.internal.zzehx;
import com.google.android.gms.internal.zzehy;
import com.google.android.gms.internal.zzeil;
import com.google.android.gms.internal.zzeim;
import com.google.android.gms.internal.zzeip;
import com.google.android.gms.internal.zzeiv;
import com.google.android.gms.internal.zzeiz;
import com.google.android.gms.internal.zzeja;
import com.google.android.gms.internal.zzejb;
import com.google.android.gms.internal.zzejd;
import com.google.android.gms.internal.zzejf;
import com.google.android.gms.internal.zzekm;
import com.google.android.gms.internal.zzeko;
import com.google.firebase.database.ChildEventListener;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.ValueEventListener;
import com.google.firebase.database.zzp;
import com.google.firebase.database.zzq;
import com.google.firebase.database.zzr;
import com.google.firebase.database.zzs;

public class Query {
    protected final zzecd zzmfx;
    protected final zzeca zzmge;
    private zzegz zzmgi;
    private final boolean zzmgj;

    private Query(zzecd zzecd2, zzeca zzeca2, zzegz zzegz2, boolean bl) throws DatabaseException {
        this.zzmfx = zzecd2;
        this.zzmge = zzeca2;
        this.zzmgi = zzegz2;
        this.zzmgj = bl;
        zzegz zzegz3 = zzegz2;
        zzekm.zzb(!zzegz3.zzbwn() || !zzegz3.zzbwq() || !zzegz3.zzbwt() || zzegz3.zzbwu(), "Validation of queries failed.");
    }

    Query(zzecd zzecd2, zzeca zzeca2) {
        this.zzmfx = zzecd2;
        this.zzmge = zzeca2;
        this.zzmgi = zzegz.zzmvy;
        this.zzmgj = false;
    }

    private static void zza(zzegz zzegz2) {
        if (zzegz2.zzbwv().equals(zzeip.zzbyp())) {
            zzeiv zzeiv2;
            String string = "You must use startAt(String value), endAt(String value) or equalTo(String value) in combination with orderByKey(). Other type of values or using the version with 2 parameters is not supported";
            if (zzegz2.zzbwn()) {
                zzeiv2 = zzegz2.zzbwo();
                if (zzegz2.zzbwp() != zzehy.zzbxr() || !(zzeiv2 instanceof zzejd)) {
                    throw new IllegalArgumentException(string);
                }
            }
            if (zzegz2.zzbwq()) {
                zzeiv2 = zzegz2.zzbwr();
                if (zzegz2.zzbws() != zzehy.zzbxs() || !(zzeiv2 instanceof zzejd)) {
                    throw new IllegalArgumentException(string);
                }
            }
            return;
        }
        if (zzegz2.zzbwv().equals(zzeja.zzbyt()) && (zzegz2.zzbwn() && !zzejb.zzl(zzegz2.zzbwo()) || zzegz2.zzbwq() && !zzejb.zzl(zzegz2.zzbwr()))) {
            throw new IllegalArgumentException("When using orderByPriority(), values provided to startAt(), endAt(), or equalTo() must be valid priorities.");
        }
    }

    private static void zzb(zzegz zzegz2) {
        if (zzegz2.zzbwn() && zzegz2.zzbwq() && zzegz2.zzbwt() && !zzegz2.zzbwu()) {
            throw new IllegalArgumentException("Can't combine startAt(), endAt() and limit(). Use limitToFirst() or limitToLast() instead");
        }
    }

    private final void zzbqz() {
        if (this.zzmgi.zzbwn()) {
            throw new IllegalArgumentException("Can't call equalTo() and startAt() combined");
        }
        if (this.zzmgi.zzbwq()) {
            throw new IllegalArgumentException("Can't call equalTo() and endAt() combined");
        }
    }

    private final void zzbra() {
        if (this.zzmgj) {
            throw new IllegalArgumentException("You can't combine multiple orderBy calls!");
        }
    }

    public ValueEventListener addValueEventListener(ValueEventListener valueEventListener) {
        this.zzb(new zzeex(this.zzmfx, valueEventListener, this.zzbrc()));
        return valueEventListener;
    }

    public ChildEventListener addChildEventListener(ChildEventListener childEventListener) {
        this.zzb(new zzebg(this.zzmfx, childEventListener, this.zzbrc()));
        return childEventListener;
    }

    public void addListenerForSingleValueEvent(ValueEventListener valueEventListener) {
        this.zzb(new zzeex(this.zzmfx, new zzp(this, valueEventListener), this.zzbrc()));
    }

    public void removeEventListener(ValueEventListener valueEventListener) {
        if (valueEventListener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.zza(new zzeex(this.zzmfx, valueEventListener, this.zzbrc()));
    }

    public void removeEventListener(ChildEventListener childEventListener) {
        if (childEventListener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.zza(new zzebg(this.zzmfx, childEventListener, this.zzbrc()));
    }

    private final void zza(zzebr zzebr2) {
        zzefc.zzbvj().zzj(zzebr2);
        this.zzmfx.zzo(new zzq(this, zzebr2));
    }

    private final void zzb(zzebr zzebr2) {
        zzefc.zzbvj().zzi(zzebr2);
        this.zzmfx.zzo(new zzr(this, zzebr2));
    }

    public void keepSynced(boolean bl) {
        if (!this.zzmge.isEmpty() && this.zzmge.zzbul().equals(zzehy.zzbxu())) {
            throw new DatabaseException("Can't call keepSynced() on .info paths.");
        }
        this.zzmfx.zzo(new zzs(this, bl));
    }

    public Query startAt(String string) {
        return this.startAt(string, null);
    }

    public Query startAt(double d) {
        return this.startAt(d, null);
    }

    public Query startAt(boolean bl) {
        return this.startAt(bl, null);
    }

    public Query startAt(String string, String string2) {
        zzeiv zzeiv2 = string != null ? new zzejd(string, zzeim.zzbyj()) : zzeim.zzbyj();
        return this.zza(zzeiv2, string2);
    }

    public Query startAt(double d, String string) {
        return this.zza(new zzeil(d, zzeim.zzbyj()), string);
    }

    public Query startAt(boolean bl, String string) {
        return this.zza(new zzehx(bl, zzeim.zzbyj()), string);
    }

    private final Query zza(zzeiv zzeiv2, String string) {
        zzeko.zzpu(string);
        if (!zzeiv2.zzbxy() && !zzeiv2.isEmpty()) {
            throw new IllegalArgumentException("Can only use simple values for startAt()");
        }
        if (this.zzmgi.zzbwn()) {
            throw new IllegalArgumentException("Can't call startAt() or equalTo() multiple times");
        }
        zzehy zzehy2 = string != null ? zzehy.zzpk(string) : null;
        zzegz zzegz2 = this.zzmgi.zza(zzeiv2, zzehy2);
        Query.zzb(zzegz2);
        Query.zza(zzegz2);
        return new Query(this.zzmfx, this.zzmge, zzegz2, this.zzmgj);
    }

    public Query endAt(String string) {
        return this.endAt(string, null);
    }

    public Query endAt(double d) {
        return this.endAt(d, null);
    }

    public Query endAt(boolean bl) {
        return this.endAt(bl, null);
    }

    public Query endAt(String string, String string2) {
        zzeiv zzeiv2 = string != null ? new zzejd(string, zzeim.zzbyj()) : zzeim.zzbyj();
        return this.zzb(zzeiv2, string2);
    }

    public Query endAt(double d, String string) {
        return this.zzb(new zzeil(d, zzeim.zzbyj()), string);
    }

    public Query endAt(boolean bl, String string) {
        return this.zzb(new zzehx(bl, zzeim.zzbyj()), string);
    }

    private final Query zzb(zzeiv zzeiv2, String string) {
        zzehy zzehy2;
        zzeko.zzpu(string);
        if (!zzeiv2.zzbxy() && !zzeiv2.isEmpty()) {
            throw new IllegalArgumentException("Can only use simple values for endAt()");
        }
        zzehy zzehy3 = zzehy2 = string != null ? zzehy.zzpk(string) : null;
        if (this.zzmgi.zzbwq()) {
            throw new IllegalArgumentException("Can't call endAt() or equalTo() multiple times");
        }
        zzegz zzegz2 = this.zzmgi.zzb(zzeiv2, zzehy2);
        Query.zzb(zzegz2);
        Query.zza(zzegz2);
        return new Query(this.zzmfx, this.zzmge, zzegz2, this.zzmgj);
    }

    public Query equalTo(String string) {
        this.zzbqz();
        return this.startAt(string).endAt(string);
    }

    public Query equalTo(double d) {
        this.zzbqz();
        return this.startAt(d).endAt(d);
    }

    public Query equalTo(boolean bl) {
        this.zzbqz();
        return this.startAt(bl).endAt(bl);
    }

    public Query equalTo(String string, String string2) {
        this.zzbqz();
        return this.startAt(string, string2).endAt(string, string2);
    }

    public Query equalTo(double d, String string) {
        this.zzbqz();
        return this.startAt(d, string).endAt(d, string);
    }

    public Query equalTo(boolean bl, String string) {
        this.zzbqz();
        return this.startAt(bl, string).endAt(bl, string);
    }

    public Query limitToFirst(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Limit must be a positive integer!");
        }
        if (this.zzmgi.zzbwt()) {
            throw new IllegalArgumentException("Can't call limitToLast on query with previously set limit!");
        }
        return new Query(this.zzmfx, this.zzmge, this.zzmgi.zzgj(n), this.zzmgj);
    }

    public Query limitToLast(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Limit must be a positive integer!");
        }
        if (this.zzmgi.zzbwt()) {
            throw new IllegalArgumentException("Can't call limitToLast on query with previously set limit!");
        }
        return new Query(this.zzmfx, this.zzmge, this.zzmgi.zzgk(n), this.zzmgj);
    }

    public Query orderByChild(String string) {
        if (string == null) {
            throw new NullPointerException("Key can't be null");
        }
        if (string.equals("$key") || string.equals(".key")) {
            throw new IllegalArgumentException(new StringBuilder(54 + String.valueOf(string).length()).append("Can't use '").append(string).append("' as path, please use orderByKey() instead!").toString());
        }
        if (string.equals("$priority") || string.equals(".priority")) {
            throw new IllegalArgumentException(new StringBuilder(59 + String.valueOf(string).length()).append("Can't use '").append(string).append("' as path, please use orderByPriority() instead!").toString());
        }
        if (string.equals("$value") || string.equals(".value")) {
            throw new IllegalArgumentException(new StringBuilder(56 + String.valueOf(string).length()).append("Can't use '").append(string).append("' as path, please use orderByValue() instead!").toString());
        }
        zzeko.zzps(string);
        this.zzbra();
        zzeca zzeca2 = new zzeca(string);
        if (zzeca2.size() == 0) {
            throw new IllegalArgumentException("Can't use empty path, use orderByValue() instead!");
        }
        zzeiz zzeiz2 = new zzeiz(zzeca2);
        return new Query(this.zzmfx, this.zzmge, this.zzmgi.zza(zzeiz2), true);
    }

    public Query orderByPriority() {
        this.zzbra();
        zzegz zzegz2 = this.zzmgi.zza(zzeja.zzbyt());
        Query.zza(zzegz2);
        return new Query(this.zzmfx, this.zzmge, zzegz2, true);
    }

    public Query orderByKey() {
        this.zzbra();
        zzegz zzegz2 = this.zzmgi.zza(zzeip.zzbyp());
        Query.zza(zzegz2);
        return new Query(this.zzmfx, this.zzmge, zzegz2, true);
    }

    public Query orderByValue() {
        this.zzbra();
        return new Query(this.zzmfx, this.zzmge, this.zzmgi.zza(zzejf.zzbyu()), true);
    }

    public DatabaseReference getRef() {
        return new DatabaseReference(this.zzmfx, this.zzmge);
    }

    public final zzeca zzbrb() {
        return this.zzmge;
    }

    public final zzehc zzbrc() {
        return new zzehc(this.zzmge, this.zzmgi);
    }
}

