/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import android.support.annotation.Nullable;
import com.google.android.gms.internal.zzebv;
import com.google.android.gms.internal.zzeih;
import com.google.android.gms.internal.zzein;
import com.google.android.gms.internal.zzeio;
import com.google.android.gms.internal.zzekg;
import com.google.android.gms.internal.zzekh;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.GenericTypeIndicator;
import com.google.firebase.database.zza;
import java.util.Iterator;

public class DataSnapshot {
    private final zzeih zzmet;
    private final DatabaseReference zzmeu;

    DataSnapshot(DatabaseReference databaseReference, zzeih zzeih2) {
        this.zzmet = zzeih2;
        this.zzmeu = databaseReference;
    }

    public DataSnapshot child(String string) {
        DatabaseReference databaseReference = this.zzmeu.child(string);
        zzeio zzeio2 = this.zzmet.zzbqx().zzan(new zzebv(string));
        return new DataSnapshot(databaseReference, zzeih.zzj(zzeio2));
    }

    public boolean hasChild(String string) {
        if (this.zzmeu.getParent() == null) {
            zzekg.zzps(string);
        } else {
            zzekg.zzpr(string);
        }
        return !this.zzmet.zzbqx().zzan(new zzebv(string)).isEmpty();
    }

    public boolean hasChildren() {
        return this.zzmet.zzbqx().getChildCount() > 0;
    }

    public boolean exists() {
        return !this.zzmet.zzbqx().isEmpty();
    }

    @Nullable
    public Object getValue() {
        return this.zzmet.zzbqx().getValue();
    }

    @Nullable
    public Object getValue(boolean bl) {
        return this.zzmet.zzbqx().getValue(bl);
    }

    @Nullable
    public <T> T getValue(Class<T> clazz) {
        return zzekh.zza(this.zzmet.zzbqx().getValue(), clazz);
    }

    @Nullable
    public <T> T getValue(GenericTypeIndicator<T> genericTypeIndicator) {
        return zzekh.zza(this.zzmet.zzbqx().getValue(), genericTypeIndicator);
    }

    public long getChildrenCount() {
        return this.zzmet.zzbqx().getChildCount();
    }

    public DatabaseReference getRef() {
        return this.zzmeu;
    }

    public String getKey() {
        return this.zzmeu.getKey();
    }

    public Iterable<DataSnapshot> getChildren() {
        Iterator<zzein> iterator = this.zzmet.iterator();
        return new zza(this, iterator);
    }

    public Object getPriority() {
        Object object = this.zzmet.zzbqx().zzbxx().getValue();
        if (object instanceof Long) {
            return (double)((Long)object).longValue();
        }
        return object;
    }

    public String toString() {
        String string = this.zzmeu.getKey();
        String string2 = String.valueOf(this.zzmet.zzbqx().getValue(true));
        return new StringBuilder(33 + String.valueOf(string).length() + String.valueOf(string2).length()).append("DataSnapshot { key = ").append(string).append(", value = ").append(string2).append(" }").toString();
    }

    static /* synthetic */ DatabaseReference zza(DataSnapshot dataSnapshot) {
        return dataSnapshot.zzmeu;
    }
}

