/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import com.google.android.gms.internal.zzecy;
import com.google.android.gms.internal.zzedf;
import com.google.android.gms.internal.zzedk;
import com.google.android.gms.internal.zzedn;
import com.google.android.gms.internal.zzeer;
import com.google.android.gms.internal.zzege;
import com.google.android.gms.internal.zzejg;
import com.google.android.gms.internal.zzekd;
import com.google.android.gms.internal.zzekg;
import com.google.android.gms.internal.zzekj;
import com.google.android.gms.internal.zzelq;
import com.google.android.gms.internal.zzels;
import com.google.android.gms.internal.zzelt;
import com.google.android.gms.internal.zzelv;
import com.google.android.gms.internal.zzelw;
import com.google.android.gms.tasks.Task;
import com.google.firebase.database.DatabaseError;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.FirebaseDatabase;
import com.google.firebase.database.OnDisconnect;
import com.google.firebase.database.Query;
import com.google.firebase.database.Transaction;
import com.google.firebase.database.zzc;
import com.google.firebase.database.zzd;
import com.google.firebase.database.zze;
import com.google.firebase.database.zzf;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;

public class DatabaseReference
extends Query {
    private static zzedf zzmjy;

    DatabaseReference(zzedn zzedn2, zzedk zzedk2) {
        super(zzedn2, zzedk2);
    }

    public DatabaseReference child(String string) {
        if (string == null) {
            throw new NullPointerException("Can't pass null for argument 'pathString' in child()");
        }
        if (this.zzmks.isEmpty()) {
            zzelv.zzqi(string);
        } else {
            zzelv.zzqh(string);
        }
        zzedk zzedk2 = this.zzmks.zzh(new zzedk(string));
        return new DatabaseReference(this.zzmkl, zzedk2);
    }

    public DatabaseReference push() {
        zzejg zzejg2 = zzejg.zzpz(zzels.zzbz(this.zzmkl.zzbwn()));
        return new DatabaseReference(this.zzmkl, this.zzmks.zza(zzejg2));
    }

    public Task<Void> setValue(Object object) {
        return this.zza(object, zzekj.zzc(this.zzmks, null), null);
    }

    public Task<Void> setValue(Object object, Object object2) {
        return this.zza(object, zzekj.zzc(this.zzmks, object2), null);
    }

    public void setValue(Object object, CompletionListener completionListener) {
        this.zza(object, zzekj.zzc(this.zzmks, null), completionListener);
    }

    public void setValue(Object object, Object object2, CompletionListener completionListener) {
        this.zza(object, zzekj.zzc(this.zzmks, object2), completionListener);
    }

    private final Task<Void> zza(Object object, zzekd zzekd2, CompletionListener completionListener) {
        zzelv.zzao(this.zzmks);
        zzege.zza(this.zzmks, object);
        Object object2 = zzelw.zzbw(object);
        zzelv.zzbv(object2);
        zzekd zzekd3 = zzekg.zza(object2, zzekd2);
        zzelq<Task<Void>, CompletionListener> zzelq2 = zzelt.zzb(completionListener);
        this.zzmkl.zzo(new zzc(this, zzekd3, zzelq2));
        return zzelq2.getFirst();
    }

    public Task<Void> setPriority(Object object) {
        return this.zza(zzekj.zzc(this.zzmks, object), null);
    }

    public void setPriority(Object object, CompletionListener completionListener) {
        this.zza(zzekj.zzc(this.zzmks, object), completionListener);
    }

    private final Task<Void> zza(zzekd zzekd2, CompletionListener completionListener) {
        zzelv.zzao(this.zzmks);
        zzelq<Task<Void>, CompletionListener> zzelq2 = zzelt.zzb(completionListener);
        this.zzmkl.zzo(new zzd(this, zzekd2, zzelq2));
        return zzelq2.getFirst();
    }

    public Task<Void> updateChildren(Map<String, Object> map) {
        return this.zza(map, null);
    }

    public void updateChildren(Map<String, Object> map, CompletionListener completionListener) {
        this.zza(map, completionListener);
    }

    private final Task<Void> zza(Map<String, Object> map, CompletionListener completionListener) {
        if (map == null) {
            throw new NullPointerException("Can't pass null for argument 'update' in updateChildren()");
        }
        Map<String, Object> map2 = zzelw.zzan(map);
        zzecy zzecy2 = zzecy.zzal(zzelv.zzb(this.zzmks, map2));
        zzelq<Task<Void>, CompletionListener> zzelq2 = zzelt.zzb(completionListener);
        this.zzmkl.zzo(new zze(this, zzecy2, zzelq2, map2));
        return zzelq2.getFirst();
    }

    public Task<Void> removeValue() {
        return this.setValue(null);
    }

    public void removeValue(CompletionListener completionListener) {
        this.setValue(null, completionListener);
    }

    public OnDisconnect onDisconnect() {
        zzelv.zzao(this.zzmks);
        return new OnDisconnect(this.zzmkl, this.zzmks);
    }

    public void runTransaction(Transaction.Handler handler) {
        this.runTransaction(handler, true);
    }

    public void runTransaction(Transaction.Handler handler, boolean bl) {
        if (handler == null) {
            throw new NullPointerException("Can't pass null for argument 'handler' in runTransaction()");
        }
        zzelv.zzao(this.zzmks);
        this.zzmkl.zzo(new zzf(this, handler, bl));
    }

    public static void goOffline() {
        zzeer.zzd(DatabaseReference.zzbst());
    }

    public static void goOnline() {
        zzeer.zze(DatabaseReference.zzbst());
    }

    public FirebaseDatabase getDatabase() {
        return this.zzmkl.getDatabase();
    }

    public String toString() {
        DatabaseReference databaseReference = this.getParent();
        if (databaseReference == null) {
            return this.zzmkl.toString();
        }
        try {
            String string = databaseReference.toString();
            String string2 = URLEncoder.encode(this.getKey(), "UTF-8").replace("+", "%20");
            return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("/").append(string2).toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string = String.valueOf(this.getKey());
            throw new DatabaseException(string.length() != 0 ? "Failed to URLEncode key: ".concat(string) : new String("Failed to URLEncode key: "), unsupportedEncodingException);
        }
    }

    public DatabaseReference getParent() {
        zzedk zzedk2 = this.zzmks.zzbwj();
        if (zzedk2 != null) {
            return new DatabaseReference(this.zzmkl, zzedk2);
        }
        return null;
    }

    public DatabaseReference getRoot() {
        return new DatabaseReference(this.zzmkl, new zzedk(""));
    }

    public String getKey() {
        if (this.zzmks.isEmpty()) {
            return null;
        }
        return this.zzmks.zzbwk().asString();
    }

    public boolean equals(Object object) {
        return object instanceof DatabaseReference && this.toString().equals(object.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private static synchronized zzedf zzbst() {
        if (zzmjy == null) {
            zzmjy = new zzedf();
        }
        return zzmjy;
    }

    public static interface CompletionListener {
        public void onComplete(DatabaseError var1, DatabaseReference var2);
    }
}

