/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import android.text.TextUtils;
import com.google.android.gms.internal.zzedf;
import com.google.android.gms.internal.zzedk;
import com.google.android.gms.internal.zzedn;
import com.google.android.gms.internal.zzeeq;
import com.google.android.gms.internal.zzeer;
import com.google.android.gms.internal.zzelr;
import com.google.android.gms.internal.zzelt;
import com.google.android.gms.internal.zzelv;
import com.google.firebase.FirebaseApp;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.Logger;
import com.google.firebase.database.zzg;
import java.util.HashMap;
import java.util.Map;

public class FirebaseDatabase {
    private static final Map<String, Map<zzeeq, FirebaseDatabase>> zzmkh = new HashMap<String, Map<zzeeq, FirebaseDatabase>>();
    private final FirebaseApp zzmki;
    private final zzeeq zzmkj;
    private final zzedf zzmkk;
    private zzedn zzmkl;

    public static FirebaseDatabase getInstance() {
        FirebaseApp firebaseApp = FirebaseApp.getInstance();
        if (firebaseApp == null) {
            throw new DatabaseException("You must call FirebaseApp.initialize() first.");
        }
        return FirebaseDatabase.getInstance(firebaseApp, firebaseApp.getOptions().getDatabaseUrl());
    }

    public static FirebaseDatabase getInstance(String string) {
        FirebaseApp firebaseApp = FirebaseApp.getInstance();
        if (firebaseApp == null) {
            throw new DatabaseException("You must call FirebaseApp.initialize() first.");
        }
        return FirebaseDatabase.getInstance(firebaseApp, string);
    }

    public static FirebaseDatabase getInstance(FirebaseApp firebaseApp) {
        return FirebaseDatabase.getInstance(firebaseApp, firebaseApp.getOptions().getDatabaseUrl());
    }

    public static synchronized FirebaseDatabase getInstance(FirebaseApp firebaseApp, String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new DatabaseException("Failed to get FirebaseDatabase instance: Specify DatabaseURL within FirebaseApp or from your getInstance() call.");
        }
        Map<zzeeq, FirebaseDatabase> map = zzmkh.get(firebaseApp.getName());
        if (map == null) {
            map = new HashMap<zzeeq, FirebaseDatabase>();
            zzmkh.put(firebaseApp.getName(), map);
        }
        zzelr zzelr2 = zzelt.zzqd(string);
        if (!zzelr2.zzmks.isEmpty()) {
            String string2 = zzelr2.zzmks.toString();
            throw new DatabaseException(new StringBuilder(113 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Specified Database URL '").append(string).append("' is invalid. It should point to the root of a Firebase Database but it includes a path: ").append(string2).toString());
        }
        FirebaseDatabase firebaseDatabase = map.get(zzelr2.zzmkj);
        if (firebaseDatabase == null) {
            zzedf zzedf2 = new zzedf();
            if (!firebaseApp.zzbqo()) {
                zzedf2.zzpx(firebaseApp.getName());
            }
            zzedf2.zzd(firebaseApp);
            firebaseDatabase = new FirebaseDatabase(firebaseApp, zzelr2.zzmkj, zzedf2);
            map.put(zzelr2.zzmkj, firebaseDatabase);
        }
        return firebaseDatabase;
    }

    private FirebaseDatabase(FirebaseApp firebaseApp, zzeeq zzeeq2, zzedf zzedf2) {
        this.zzmki = firebaseApp;
        this.zzmkj = zzeeq2;
        this.zzmkk = zzedf2;
    }

    public FirebaseApp getApp() {
        return this.zzmki;
    }

    public DatabaseReference getReference() {
        this.zzbsu();
        return new DatabaseReference(this.zzmkl, zzedk.zzbwe());
    }

    public DatabaseReference getReference(String string) {
        this.zzbsu();
        if (string == null) {
            throw new NullPointerException("Can't pass null for argument 'pathString' in FirebaseDatabase.getReference()");
        }
        zzelv.zzqi(string);
        zzedk zzedk2 = new zzedk(string);
        return new DatabaseReference(this.zzmkl, zzedk2);
    }

    public DatabaseReference getReferenceFromUrl(String string) {
        this.zzbsu();
        if (string == null) {
            throw new NullPointerException("Can't pass null for argument 'url' in FirebaseDatabase.getReferenceFromUrl()");
        }
        zzelr zzelr2 = zzelt.zzqd(string);
        if (!zzelr2.zzmkj.host.equals(this.zzmkl.zzbwm().host)) {
            String string2 = this.getReference().toString();
            throw new DatabaseException(new StringBuilder(93 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Invalid URL (").append(string).append(") passed to getReference().  URL was expected to match configured Database URL: ").append(string2).toString());
        }
        return new DatabaseReference(this.zzmkl, zzelr2.zzmks);
    }

    public void purgeOutstandingWrites() {
        this.zzbsu();
        this.zzmkl.zzo(new zzg(this));
    }

    public void goOnline() {
        this.zzbsu();
        zzeer.zzl(this.zzmkl);
    }

    public void goOffline() {
        this.zzbsu();
        zzeer.zzk(this.zzmkl);
    }

    public synchronized void setLogLevel(Logger.Level level) {
        this.zzph("setLogLevel");
        this.zzmkk.setLogLevel(level);
    }

    public synchronized void setPersistenceEnabled(boolean bl) {
        this.zzph("setPersistenceEnabled");
        this.zzmkk.setPersistenceEnabled(bl);
    }

    public synchronized void setPersistenceCacheSizeBytes(long l) {
        this.zzph("setPersistenceCacheSizeBytes");
        this.zzmkk.setPersistenceCacheSizeBytes(l);
    }

    public static String getSdkVersion() {
        return "3.0.0";
    }

    private final void zzph(String string) {
        if (this.zzmkl != null) {
            throw new DatabaseException(new StringBuilder(77 + String.valueOf(string).length()).append("Calls to ").append(string).append("() must be made before any other usage of FirebaseDatabase instance.").toString());
        }
    }

    private final synchronized void zzbsu() {
        if (this.zzmkl == null) {
            this.zzmkl = zzeer.zza(this.zzmkk, this.zzmkj, this);
        }
    }

    static /* synthetic */ zzedn zza(FirebaseDatabase firebaseDatabase) {
        return firebaseDatabase.zzmkl;
    }
}

