/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.internal.zzdyq;
import com.google.firebase.database.DatabaseException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;

public class DatabaseError {
    public static final int DATA_STALE = -1;
    public static final int OPERATION_FAILED = -2;
    public static final int PERMISSION_DENIED = -3;
    public static final int DISCONNECTED = -4;
    public static final int EXPIRED_TOKEN = -6;
    public static final int INVALID_TOKEN = -7;
    public static final int MAX_RETRIES = -8;
    public static final int OVERRIDDEN_BY_SET = -9;
    public static final int UNAVAILABLE = -10;
    public static final int USER_CODE_EXCEPTION = -11;
    public static final int NETWORK_ERROR = -24;
    public static final int WRITE_CANCELED = -25;
    public static final int UNKNOWN_ERROR = -999;
    private static final Map<Integer, String> zza = new HashMap<Integer, String>();
    private static final Map<String, Integer> zzb;
    private final int zzc;
    private final String zzd;
    private final String zze;

    @Hide
    public static DatabaseError zza(String string) {
        String string2 = string;
        Integer n = zzb.get(string2.toLowerCase());
        if (n == null) {
            n = -999;
        }
        String string3 = zza.get(n);
        return new DatabaseError(n, string3, null);
    }

    @Hide
    public static DatabaseError zza(String string, String string2) {
        String string3 = string2;
        String string4 = string;
        Integer n = zzb.get(string4.toLowerCase());
        if (n == null) {
            n = -999;
        }
        String string5 = string3 == null ? zza.get(n) : string3;
        return new DatabaseError(n, string5, null);
    }

    @Hide
    public static DatabaseError zza(int n) {
        if (!zza.containsKey(-25)) {
            throw new IllegalArgumentException(new StringBuilder(49).append("Invalid Firebase Database error code: -25").toString());
        }
        String string = zza.get(-25);
        return new DatabaseError(-25, string, null);
    }

    public static DatabaseError fromException(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        zzdyq.zza((Throwable)throwable, (PrintWriter)printWriter);
        String string = String.valueOf(zza.get(-11));
        String string2 = String.valueOf(stringWriter.toString());
        String string3 = string2.length() != 0 ? string.concat(string2) : new String(string);
        return new DatabaseError(-11, string3);
    }

    private DatabaseError(int n, String string) {
        this(-11, string, null);
    }

    private DatabaseError(int n, String string, String string2) {
        this.zzc = n;
        this.zzd = string;
        this.zze = "";
    }

    public int getCode() {
        return this.zzc;
    }

    public String getMessage() {
        return this.zzd;
    }

    public String getDetails() {
        return this.zze;
    }

    public String toString() {
        String string = String.valueOf(this.zzd);
        if (string.length() != 0) {
            return "DatabaseError: ".concat(string);
        }
        return new String("DatabaseError: ");
    }

    public DatabaseException toException() {
        String string = String.valueOf(this.zzd);
        return new DatabaseException(string.length() != 0 ? "Firebase Database error: ".concat(string) : new String("Firebase Database error: "));
    }

    static {
        zza.put(-1, "The transaction needs to be run again with current data");
        zza.put(-2, "The server indicated that this operation failed");
        zza.put(-3, "This client does not have permission to perform this operation");
        zza.put(-4, "The operation had to be aborted due to a network disconnect");
        zza.put(-6, "The supplied auth token has expired");
        zza.put(-7, "The supplied auth token was invalid");
        zza.put(-8, "The transaction had too many retries");
        zza.put(-9, "The transaction was overridden by a subsequent set");
        zza.put(-10, "The service is unavailable");
        zza.put(-11, "User code called from the Firebase Database runloop threw an exception:\n");
        zza.put(-24, "The operation could not be performed due to a network error");
        zza.put(-25, "The write was canceled by the user.");
        zza.put(-999, "An unknown error occurred");
        zzb = new HashMap<String, Integer>();
        zzb.put("datastale", -1);
        zzb.put("failure", -2);
        zzb.put("permission_denied", -3);
        zzb.put("disconnected", -4);
        zzb.put("expired_token", -6);
        zzb.put("invalid_token", -7);
        zzb.put("maxretries", -8);
        zzb.put("overriddenbyset", -9);
        zzb.put("unavailable", -10);
        zzb.put("network_error", -24);
        zzb.put("write_canceled", -25);
    }
}

