/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import com.google.android.gms.internal.zzegi;
import com.google.android.gms.internal.zzegp;
import com.google.android.gms.internal.zzegu;
import com.google.android.gms.internal.zzegx;
import com.google.android.gms.internal.zzeib;
import com.google.android.gms.internal.zzejo;
import com.google.android.gms.internal.zzemq;
import com.google.android.gms.internal.zzenn;
import com.google.android.gms.internal.zzenq;
import com.google.android.gms.internal.zzent;
import com.google.android.gms.internal.zzepa;
import com.google.android.gms.internal.zzepc;
import com.google.android.gms.internal.zzepd;
import com.google.android.gms.internal.zzepf;
import com.google.android.gms.internal.zzepg;
import com.google.android.gms.tasks.Task;
import com.google.firebase.database.DatabaseError;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.FirebaseDatabase;
import com.google.firebase.database.OnDisconnect;
import com.google.firebase.database.Query;
import com.google.firebase.database.Transaction;
import com.google.firebase.database.zzc;
import com.google.firebase.database.zzd;
import com.google.firebase.database.zze;
import com.google.firebase.database.zzf;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;

public class DatabaseReference
extends Query {
    private static zzegp zzc;

    DatabaseReference(zzegx zzegx2, zzegu zzegu2) {
        super(zzegx2, zzegu2);
    }

    public DatabaseReference child(String string) {
        if (string == null) {
            throw new NullPointerException("Can't pass null for argument 'pathString' in child()");
        }
        if (this.zzb.zzh()) {
            zzepf.zzb(string);
        } else {
            zzepf.zza(string);
        }
        zzegu zzegu2 = this.zzb.zza(new zzegu(string));
        return new DatabaseReference(this.zza, zzegu2);
    }

    public DatabaseReference push() {
        zzemq zzemq2 = zzemq.zza(zzepc.zza(this.zza.zze()));
        return new DatabaseReference(this.zza, this.zzb.zza(zzemq2));
    }

    public Task<Void> setValue(Object object) {
        return this.zza(object, zzent.zza(this.zzb, null), null);
    }

    public Task<Void> setValue(Object object, Object object2) {
        return this.zza(object, zzent.zza(this.zzb, object2), null);
    }

    public void setValue(Object object, CompletionListener completionListener) {
        this.zza(object, zzent.zza(this.zzb, null), completionListener);
    }

    public void setValue(Object object, Object object2, CompletionListener completionListener) {
        this.zza(object, zzent.zza(this.zzb, object2), completionListener);
    }

    private final Task<Void> zza(Object object, zzenn zzenn2, CompletionListener completionListener) {
        zzepf.zza(this.zzb);
        zzejo.zza(this.zzb, object);
        Object object2 = zzepg.zza(object);
        zzepf.zza(object2);
        zzenn zzenn3 = zzenq.zza(object2, zzenn2);
        zzepa<Task<Void>, CompletionListener> zzepa2 = zzepd.zza(completionListener);
        this.zza.zza(new zzc(this, zzenn3, zzepa2));
        return zzepa2.zza();
    }

    public Task<Void> setPriority(Object object) {
        return this.zza(zzent.zza(this.zzb, object), null);
    }

    public void setPriority(Object object, CompletionListener completionListener) {
        this.zza(zzent.zza(this.zzb, object), completionListener);
    }

    private final Task<Void> zza(zzenn zzenn2, CompletionListener completionListener) {
        zzepf.zza(this.zzb);
        zzepa<Task<Void>, CompletionListener> zzepa2 = zzepd.zza(completionListener);
        this.zza.zza(new zzd(this, zzenn2, zzepa2));
        return zzepa2.zza();
    }

    public Task<Void> updateChildren(Map<String, Object> map) {
        return this.zza(map, null);
    }

    public void updateChildren(Map<String, Object> map, CompletionListener completionListener) {
        this.zza(map, completionListener);
    }

    private final Task<Void> zza(Map<String, Object> map, CompletionListener completionListener) {
        if (map == null) {
            throw new NullPointerException("Can't pass null for argument 'update' in updateChildren()");
        }
        Map<String, Object> map2 = zzepg.zza(map);
        zzegi zzegi2 = zzegi.zzb(zzepf.zza(this.zzb, map2));
        zzepa<Task<Void>, CompletionListener> zzepa2 = zzepd.zza(completionListener);
        this.zza.zza(new zze(this, zzegi2, zzepa2, map2));
        return zzepa2.zza();
    }

    public Task<Void> removeValue() {
        return this.setValue(null);
    }

    public void removeValue(CompletionListener completionListener) {
        this.setValue(null, completionListener);
    }

    public OnDisconnect onDisconnect() {
        zzepf.zza(this.zzb);
        return new OnDisconnect(this.zza, this.zzb);
    }

    public void runTransaction(Transaction.Handler handler) {
        this.runTransaction(handler, true);
    }

    public void runTransaction(Transaction.Handler handler, boolean bl) {
        if (handler == null) {
            throw new NullPointerException("Can't pass null for argument 'handler' in runTransaction()");
        }
        zzepf.zza(this.zzb);
        this.zza.zza(new zzf(this, handler, bl));
    }

    public static void goOffline() {
        zzeib.zza(DatabaseReference.zzc());
    }

    public static void goOnline() {
        zzeib.zzb(DatabaseReference.zzc());
    }

    public FirebaseDatabase getDatabase() {
        return this.zza.zzc();
    }

    public String toString() {
        DatabaseReference databaseReference = this.getParent();
        if (databaseReference == null) {
            return this.zza.toString();
        }
        try {
            String string = databaseReference.toString();
            String string2 = URLEncoder.encode(this.getKey(), "UTF-8").replace("+", "%20");
            return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("/").append(string2).toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string = String.valueOf(this.getKey());
            throw new DatabaseException(string.length() != 0 ? "Failed to URLEncode key: ".concat(string) : new String("Failed to URLEncode key: "), unsupportedEncodingException);
        }
    }

    public DatabaseReference getParent() {
        zzegu zzegu2 = this.zzb.zzf();
        if (zzegu2 != null) {
            return new DatabaseReference(this.zza, zzegu2);
        }
        return null;
    }

    public DatabaseReference getRoot() {
        return new DatabaseReference(this.zza, new zzegu(""));
    }

    public String getKey() {
        if (this.zzb.zzh()) {
            return null;
        }
        return this.zzb.zzg().zze();
    }

    public boolean equals(Object object) {
        return object instanceof DatabaseReference && this.toString().equals(object.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private static synchronized zzegp zzc() {
        if (zzc == null) {
            zzc = new zzegp();
        }
        return zzc;
    }

    public static interface CompletionListener {
        public void onComplete(DatabaseError var1, DatabaseReference var2);
    }
}

