/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.internal.zzegg;
import com.google.android.gms.internal.zzegr;
import com.google.android.gms.internal.zzegu;
import com.google.android.gms.internal.zzegx;
import com.google.android.gms.internal.zzejp;
import com.google.android.gms.internal.zzeju;
import com.google.android.gms.internal.zzelr;
import com.google.android.gms.internal.zzelu;
import com.google.android.gms.internal.zzemp;
import com.google.android.gms.internal.zzemq;
import com.google.android.gms.internal.zzend;
import com.google.android.gms.internal.zzene;
import com.google.android.gms.internal.zzenh;
import com.google.android.gms.internal.zzenn;
import com.google.android.gms.internal.zzenr;
import com.google.android.gms.internal.zzens;
import com.google.android.gms.internal.zzent;
import com.google.android.gms.internal.zzenv;
import com.google.android.gms.internal.zzenx;
import com.google.android.gms.internal.zzepd;
import com.google.android.gms.internal.zzepf;
import com.google.firebase.database.ChildEventListener;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.ValueEventListener;
import com.google.firebase.database.zzp;
import com.google.firebase.database.zzq;
import com.google.firebase.database.zzr;
import com.google.firebase.database.zzs;

public class Query {
    @Hide
    protected final zzegx zza;
    @Hide
    protected final zzegu zzb;
    @Hide
    private zzelr zzc;
    private final boolean zzd;

    private Query(zzegx zzegx2, zzegu zzegu2, zzelr zzelr2, boolean bl) throws DatabaseException {
        this.zza = zzegx2;
        this.zzb = zzegu2;
        this.zzc = zzelr2;
        this.zzd = bl;
        zzelr zzelr3 = zzelr2;
        zzepd.zza(!zzelr3.zza() || !zzelr3.zzd() || !zzelr3.zzg() || zzelr3.zzh(), "Validation of queries failed.");
    }

    Query(zzegx zzegx2, zzegu zzegu2) {
        this.zza = zzegx2;
        this.zzb = zzegu2;
        this.zzc = zzelr.zza;
        this.zzd = false;
    }

    private static void zza(zzelr zzelr2) {
        if (zzelr2.zzj().equals(zzenh.zzc())) {
            zzenn zzenn2;
            String string = "You must use startAt(String value), endAt(String value) or equalTo(String value) in combination with orderByKey(). Other type of values or using the version with 2 parameters is not supported";
            if (zzelr2.zza()) {
                zzenn2 = zzelr2.zzb();
                if (zzelr2.zzc() != zzemq.zza() || !(zzenn2 instanceof zzenv)) {
                    throw new IllegalArgumentException(string);
                }
            }
            if (zzelr2.zzd()) {
                zzenn2 = zzelr2.zze();
                if (zzelr2.zzf() != zzemq.zzb() || !(zzenn2 instanceof zzenv)) {
                    throw new IllegalArgumentException(string);
                }
            }
            return;
        }
        if (zzelr2.zzj().equals(zzens.zzc()) && (zzelr2.zza() && !zzent.zza(zzelr2.zzb()) || zzelr2.zzd() && !zzent.zza(zzelr2.zze()))) {
            throw new IllegalArgumentException("When using orderByPriority(), values provided to startAt(), endAt(), or equalTo() must be valid priorities.");
        }
    }

    private static void zzb(zzelr zzelr2) {
        if (zzelr2.zza() && zzelr2.zzd() && zzelr2.zzg() && !zzelr2.zzh()) {
            throw new IllegalArgumentException("Can't combine startAt(), endAt() and limit(). Use limitToFirst() or limitToLast() instead");
        }
    }

    private final void zzc() {
        if (this.zzc.zza()) {
            throw new IllegalArgumentException("Can't call equalTo() and startAt() combined");
        }
        if (this.zzc.zzd()) {
            throw new IllegalArgumentException("Can't call equalTo() and endAt() combined");
        }
    }

    private final void zzd() {
        if (this.zzd) {
            throw new IllegalArgumentException("You can't combine multiple orderBy calls!");
        }
    }

    public ValueEventListener addValueEventListener(ValueEventListener valueEventListener) {
        this.zzb(new zzejp(this.zza, valueEventListener, this.zzb()));
        return valueEventListener;
    }

    public ChildEventListener addChildEventListener(ChildEventListener childEventListener) {
        this.zzb(new zzegg(this.zza, childEventListener, this.zzb()));
        return childEventListener;
    }

    public void addListenerForSingleValueEvent(ValueEventListener valueEventListener) {
        this.zzb(new zzejp(this.zza, new zzp(this, valueEventListener), this.zzb()));
    }

    public void removeEventListener(ValueEventListener valueEventListener) {
        if (valueEventListener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.zza(new zzejp(this.zza, valueEventListener, this.zzb()));
    }

    public void removeEventListener(ChildEventListener childEventListener) {
        if (childEventListener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.zza(new zzegg(this.zza, childEventListener, this.zzb()));
    }

    private final void zza(zzegr zzegr2) {
        zzeju.zza().zzc(zzegr2);
        this.zza.zza(new zzq(this, zzegr2));
    }

    private final void zzb(zzegr zzegr2) {
        zzeju.zza().zzb(zzegr2);
        this.zza.zza(new zzr(this, zzegr2));
    }

    public void keepSynced(boolean bl) {
        if (!this.zzb.zzh() && this.zzb.zzd().equals(zzemq.zzd())) {
            throw new DatabaseException("Can't call keepSynced() on .info paths.");
        }
        this.zza.zza(new zzs(this, bl));
    }

    public Query startAt(String string) {
        return this.startAt(string, null);
    }

    public Query startAt(double d) {
        return this.startAt(d, null);
    }

    public Query startAt(boolean bl) {
        return this.startAt(bl, null);
    }

    public Query startAt(String string, String string2) {
        zzenn zzenn2 = string != null ? new zzenv(string, zzene.zzj()) : zzene.zzj();
        return this.zza(zzenn2, string2);
    }

    public Query startAt(double d, String string) {
        return this.zza(new zzend(d, zzene.zzj()), string);
    }

    public Query startAt(boolean bl, String string) {
        return this.zza(new zzemp(bl, zzene.zzj()), string);
    }

    private final Query zza(zzenn zzenn2, String string) {
        zzepf.zzc(string);
        if (!zzenn2.zze() && !zzenn2.r_()) {
            throw new IllegalArgumentException("Can only use simple values for startAt()");
        }
        if (this.zzc.zza()) {
            throw new IllegalArgumentException("Can't call startAt() or equalTo() multiple times");
        }
        zzemq zzemq2 = string != null ? zzemq.zza(string) : null;
        zzelr zzelr2 = this.zzc.zza(zzenn2, zzemq2);
        Query.zzb(zzelr2);
        Query.zza(zzelr2);
        return new Query(this.zza, this.zzb, zzelr2, this.zzd);
    }

    public Query endAt(String string) {
        return this.endAt(string, null);
    }

    public Query endAt(double d) {
        return this.endAt(d, null);
    }

    public Query endAt(boolean bl) {
        return this.endAt(bl, null);
    }

    public Query endAt(String string, String string2) {
        zzenn zzenn2 = string != null ? new zzenv(string, zzene.zzj()) : zzene.zzj();
        return this.zzb(zzenn2, string2);
    }

    public Query endAt(double d, String string) {
        return this.zzb(new zzend(d, zzene.zzj()), string);
    }

    public Query endAt(boolean bl, String string) {
        return this.zzb(new zzemp(bl, zzene.zzj()), string);
    }

    private final Query zzb(zzenn zzenn2, String string) {
        zzemq zzemq2;
        zzepf.zzc(string);
        if (!zzenn2.zze() && !zzenn2.r_()) {
            throw new IllegalArgumentException("Can only use simple values for endAt()");
        }
        zzemq zzemq3 = zzemq2 = string != null ? zzemq.zza(string) : null;
        if (this.zzc.zzd()) {
            throw new IllegalArgumentException("Can't call endAt() or equalTo() multiple times");
        }
        zzelr zzelr2 = this.zzc.zzb(zzenn2, zzemq2);
        Query.zzb(zzelr2);
        Query.zza(zzelr2);
        return new Query(this.zza, this.zzb, zzelr2, this.zzd);
    }

    public Query equalTo(String string) {
        this.zzc();
        return this.startAt(string).endAt(string);
    }

    public Query equalTo(double d) {
        this.zzc();
        return this.startAt(d).endAt(d);
    }

    public Query equalTo(boolean bl) {
        this.zzc();
        return this.startAt(bl).endAt(bl);
    }

    public Query equalTo(String string, String string2) {
        this.zzc();
        return this.startAt(string, string2).endAt(string, string2);
    }

    public Query equalTo(double d, String string) {
        this.zzc();
        return this.startAt(d, string).endAt(d, string);
    }

    public Query equalTo(boolean bl, String string) {
        this.zzc();
        return this.startAt(bl, string).endAt(bl, string);
    }

    public Query limitToFirst(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Limit must be a positive integer!");
        }
        if (this.zzc.zzg()) {
            throw new IllegalArgumentException("Can't call limitToLast on query with previously set limit!");
        }
        return new Query(this.zza, this.zzb, this.zzc.zza(n), this.zzd);
    }

    public Query limitToLast(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Limit must be a positive integer!");
        }
        if (this.zzc.zzg()) {
            throw new IllegalArgumentException("Can't call limitToLast on query with previously set limit!");
        }
        return new Query(this.zza, this.zzb, this.zzc.zzb(n), this.zzd);
    }

    public Query orderByChild(String string) {
        if (string == null) {
            throw new NullPointerException("Key can't be null");
        }
        if (string.equals("$key") || string.equals(".key")) {
            throw new IllegalArgumentException(new StringBuilder(54 + String.valueOf(string).length()).append("Can't use '").append(string).append("' as path, please use orderByKey() instead!").toString());
        }
        if (string.equals("$priority") || string.equals(".priority")) {
            throw new IllegalArgumentException(new StringBuilder(59 + String.valueOf(string).length()).append("Can't use '").append(string).append("' as path, please use orderByPriority() instead!").toString());
        }
        if (string.equals("$value") || string.equals(".value")) {
            throw new IllegalArgumentException(new StringBuilder(56 + String.valueOf(string).length()).append("Can't use '").append(string).append("' as path, please use orderByValue() instead!").toString());
        }
        zzepf.zza(string);
        this.zzd();
        zzegu zzegu2 = new zzegu(string);
        if (zzegu2.zzi() == 0) {
            throw new IllegalArgumentException("Can't use empty path, use orderByValue() instead!");
        }
        zzenr zzenr2 = new zzenr(zzegu2);
        return new Query(this.zza, this.zzb, this.zzc.zza(zzenr2), true);
    }

    public Query orderByPriority() {
        this.zzd();
        zzelr zzelr2 = this.zzc.zza(zzens.zzc());
        Query.zza(zzelr2);
        return new Query(this.zza, this.zzb, zzelr2, true);
    }

    public Query orderByKey() {
        this.zzd();
        zzelr zzelr2 = this.zzc.zza(zzenh.zzc());
        Query.zza(zzelr2);
        return new Query(this.zza, this.zzb, zzelr2, true);
    }

    public Query orderByValue() {
        this.zzd();
        return new Query(this.zza, this.zzb, this.zzc.zza(zzenx.zzc()), true);
    }

    public DatabaseReference getRef() {
        return new DatabaseReference(this.zza, this.zzb);
    }

    @Hide
    public final zzegu zza() {
        return this.zzb;
    }

    @Hide
    public final zzelu zzb() {
        return new zzelu(this.zzb, this.zzc);
    }
}

