/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import com.google.android.gms.internal.zzegi;
import com.google.android.gms.internal.zzegp;
import com.google.android.gms.internal.zzegu;
import com.google.android.gms.internal.zzegx;
import com.google.android.gms.internal.zzeib;
import com.google.android.gms.internal.zzejo;
import com.google.android.gms.internal.zzemq;
import com.google.android.gms.internal.zzenn;
import com.google.android.gms.internal.zzenq;
import com.google.android.gms.internal.zzent;
import com.google.android.gms.internal.zzepa;
import com.google.android.gms.internal.zzepc;
import com.google.android.gms.internal.zzepd;
import com.google.android.gms.internal.zzepf;
import com.google.android.gms.internal.zzepg;
import com.google.android.gms.tasks.Task;
import com.google.firebase.database.DatabaseError;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.FirebaseDatabase;
import com.google.firebase.database.OnDisconnect;
import com.google.firebase.database.Query;
import com.google.firebase.database.Transaction;
import com.google.firebase.database.zzc;
import com.google.firebase.database.zzd;
import com.google.firebase.database.zze;
import com.google.firebase.database.zzf;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;

public class DatabaseReference
extends Query {
    private static zzegp zzmwg;

    DatabaseReference(zzegx zzegx2, zzegu zzegu2) {
        super(zzegx2, zzegu2);
    }

    public DatabaseReference child(String string) {
        if (string == null) {
            throw new NullPointerException("Can't pass null for argument 'pathString' in child()");
        }
        if (this.zzmxa.isEmpty()) {
            zzepf.zzqo(string);
        } else {
            zzepf.zzqn(string);
        }
        zzegu zzegu2 = this.zzmxa.zzh(new zzegu(string));
        return new DatabaseReference(this.zzmwt, zzegu2);
    }

    public DatabaseReference push() {
        zzemq zzemq2 = zzemq.zzqf(zzepc.zzca(this.zzmwt.zzbyw()));
        return new DatabaseReference(this.zzmwt, this.zzmxa.zza(zzemq2));
    }

    public Task<Void> setValue(Object object) {
        return this.zza(object, zzent.zzc(this.zzmxa, null), null);
    }

    public Task<Void> setValue(Object object, Object object2) {
        return this.zza(object, zzent.zzc(this.zzmxa, object2), null);
    }

    public void setValue(Object object, CompletionListener completionListener) {
        this.zza(object, zzent.zzc(this.zzmxa, null), completionListener);
    }

    public void setValue(Object object, Object object2, CompletionListener completionListener) {
        this.zza(object, zzent.zzc(this.zzmxa, object2), completionListener);
    }

    private final Task<Void> zza(Object object, zzenn zzenn2, CompletionListener completionListener) {
        zzepf.zzao(this.zzmxa);
        zzejo.zza(this.zzmxa, object);
        Object object2 = zzepg.zzca(object);
        zzepf.zzbz(object2);
        zzenn zzenn3 = zzenq.zza(object2, zzenn2);
        zzepa<Task<Void>, CompletionListener> zzepa2 = zzepd.zzb(completionListener);
        this.zzmwt.zzp(new zzc(this, zzenn3, zzepa2));
        return zzepa2.getFirst();
    }

    public Task<Void> setPriority(Object object) {
        return this.zza(zzent.zzc(this.zzmxa, object), null);
    }

    public void setPriority(Object object, CompletionListener completionListener) {
        this.zza(zzent.zzc(this.zzmxa, object), completionListener);
    }

    private final Task<Void> zza(zzenn zzenn2, CompletionListener completionListener) {
        zzepf.zzao(this.zzmxa);
        zzepa<Task<Void>, CompletionListener> zzepa2 = zzepd.zzb(completionListener);
        this.zzmwt.zzp(new zzd(this, zzenn2, zzepa2));
        return zzepa2.getFirst();
    }

    public Task<Void> updateChildren(Map<String, Object> map) {
        return this.zza(map, null);
    }

    public void updateChildren(Map<String, Object> map, CompletionListener completionListener) {
        this.zza(map, completionListener);
    }

    private final Task<Void> zza(Map<String, Object> map, CompletionListener completionListener) {
        if (map == null) {
            throw new NullPointerException("Can't pass null for argument 'update' in updateChildren()");
        }
        Map<String, Object> map2 = zzepg.zzap(map);
        zzegi zzegi2 = zzegi.zzan(zzepf.zzb(this.zzmxa, map2));
        zzepa<Task<Void>, CompletionListener> zzepa2 = zzepd.zzb(completionListener);
        this.zzmwt.zzp(new zze(this, zzegi2, zzepa2, map2));
        return zzepa2.getFirst();
    }

    public Task<Void> removeValue() {
        return this.setValue(null);
    }

    public void removeValue(CompletionListener completionListener) {
        this.setValue(null, completionListener);
    }

    public OnDisconnect onDisconnect() {
        zzepf.zzao(this.zzmxa);
        return new OnDisconnect(this.zzmwt, this.zzmxa);
    }

    public void runTransaction(Transaction.Handler handler) {
        this.runTransaction(handler, true);
    }

    public void runTransaction(Transaction.Handler handler, boolean bl) {
        if (handler == null) {
            throw new NullPointerException("Can't pass null for argument 'handler' in runTransaction()");
        }
        zzepf.zzao(this.zzmxa);
        this.zzmwt.zzp(new zzf(this, handler, bl));
    }

    public static void goOffline() {
        zzeib.zzd(DatabaseReference.zzbvc());
    }

    public static void goOnline() {
        zzeib.zze(DatabaseReference.zzbvc());
    }

    public FirebaseDatabase getDatabase() {
        return this.zzmwt.getDatabase();
    }

    public String toString() {
        DatabaseReference databaseReference = this.getParent();
        if (databaseReference == null) {
            return this.zzmwt.toString();
        }
        try {
            String string = databaseReference.toString();
            String string2 = URLEncoder.encode(this.getKey(), "UTF-8").replace("+", "%20");
            return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("/").append(string2).toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string = String.valueOf(this.getKey());
            throw new DatabaseException(string.length() != 0 ? "Failed to URLEncode key: ".concat(string) : new String("Failed to URLEncode key: "), unsupportedEncodingException);
        }
    }

    public DatabaseReference getParent() {
        zzegu zzegu2 = this.zzmxa.zzbys();
        if (zzegu2 != null) {
            return new DatabaseReference(this.zzmwt, zzegu2);
        }
        return null;
    }

    public DatabaseReference getRoot() {
        return new DatabaseReference(this.zzmwt, new zzegu(""));
    }

    public String getKey() {
        if (this.zzmxa.isEmpty()) {
            return null;
        }
        return this.zzmxa.zzbyt().asString();
    }

    public boolean equals(Object object) {
        return object instanceof DatabaseReference && this.toString().equals(object.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private static synchronized zzegp zzbvc() {
        if (zzmwg == null) {
            zzmwg = new zzegp();
        }
        return zzmwg;
    }

    public static interface CompletionListener {
        public void onComplete(DatabaseError var1, DatabaseReference var2);
    }
}

